/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Coverage", propOrder={"issuerIdentifier", "issuerReference", "bin", "period", "type", "planholderIdentifier", "planholderReference", "beneficiaryIdentifier", "beneficiaryReference", "relationship", "identifier", "group", "plan", "subPlan", "dependent", "sequence", "exception", "school", "network", "contract"})
public class Coverage
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier issuerIdentifier;
    protected Reference issuerReference;
    protected String bin;
    protected Period period;
    protected Coding type;
    protected Identifier planholderIdentifier;
    protected Reference planholderReference;
    protected Identifier beneficiaryIdentifier;
    protected Reference beneficiaryReference;
    @XmlElement(required=true)
    protected Coding relationship;
    protected List<Identifier> identifier;
    protected String group;
    protected String plan;
    protected String subPlan;
    protected PositiveInt dependent;
    protected PositiveInt sequence;
    protected List<Coding> exception;
    protected String school;
    protected String network;
    protected List<Reference> contract;

    public Identifier getIssuerIdentifier() {
        return this.issuerIdentifier;
    }

    public void setIssuerIdentifier(Identifier value) {
        this.issuerIdentifier = value;
    }

    public Reference getIssuerReference() {
        return this.issuerReference;
    }

    public void setIssuerReference(Reference value) {
        this.issuerReference = value;
    }

    public String getBin() {
        return this.bin;
    }

    public void setBin(String value) {
        this.bin = value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public Coding getType() {
        return this.type;
    }

    public void setType(Coding value) {
        this.type = value;
    }

    public Identifier getPlanholderIdentifier() {
        return this.planholderIdentifier;
    }

    public void setPlanholderIdentifier(Identifier value) {
        this.planholderIdentifier = value;
    }

    public Reference getPlanholderReference() {
        return this.planholderReference;
    }

    public void setPlanholderReference(Reference value) {
        this.planholderReference = value;
    }

    public Identifier getBeneficiaryIdentifier() {
        return this.beneficiaryIdentifier;
    }

    public void setBeneficiaryIdentifier(Identifier value) {
        this.beneficiaryIdentifier = value;
    }

    public Reference getBeneficiaryReference() {
        return this.beneficiaryReference;
    }

    public void setBeneficiaryReference(Reference value) {
        this.beneficiaryReference = value;
    }

    public Coding getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Coding value) {
        this.relationship = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String value) {
        this.group = value;
    }

    public String getPlan() {
        return this.plan;
    }

    public void setPlan(String value) {
        this.plan = value;
    }

    public String getSubPlan() {
        return this.subPlan;
    }

    public void setSubPlan(String value) {
        this.subPlan = value;
    }

    public PositiveInt getDependent() {
        return this.dependent;
    }

    public void setDependent(PositiveInt value) {
        this.dependent = value;
    }

    public PositiveInt getSequence() {
        return this.sequence;
    }

    public void setSequence(PositiveInt value) {
        this.sequence = value;
    }

    public List<Coding> getException() {
        if (this.exception == null) {
            this.exception = new ArrayList<Coding>();
        }
        return this.exception;
    }

    public String getSchool() {
        return this.school;
    }

    public void setSchool(String value) {
        this.school = value;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String value) {
        this.network = value;
    }

    public List<Reference> getContract() {
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        return this.contract;
    }

    public Coverage withIssuerIdentifier(Identifier value) {
        this.setIssuerIdentifier(value);
        return this;
    }

    public Coverage withIssuerReference(Reference value) {
        this.setIssuerReference(value);
        return this;
    }

    public Coverage withBin(String value) {
        this.setBin(value);
        return this;
    }

    public Coverage withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public Coverage withType(Coding value) {
        this.setType(value);
        return this;
    }

    public Coverage withPlanholderIdentifier(Identifier value) {
        this.setPlanholderIdentifier(value);
        return this;
    }

    public Coverage withPlanholderReference(Reference value) {
        this.setPlanholderReference(value);
        return this;
    }

    public Coverage withBeneficiaryIdentifier(Identifier value) {
        this.setBeneficiaryIdentifier(value);
        return this;
    }

    public Coverage withBeneficiaryReference(Reference value) {
        this.setBeneficiaryReference(value);
        return this;
    }

    public Coverage withRelationship(Coding value) {
        this.setRelationship(value);
        return this;
    }

    public Coverage withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Coverage withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Coverage withGroup(String value) {
        this.setGroup(value);
        return this;
    }

    public Coverage withPlan(String value) {
        this.setPlan(value);
        return this;
    }

    public Coverage withSubPlan(String value) {
        this.setSubPlan(value);
        return this;
    }

    public Coverage withDependent(PositiveInt value) {
        this.setDependent(value);
        return this;
    }

    public Coverage withSequence(PositiveInt value) {
        this.setSequence(value);
        return this;
    }

    public Coverage withException(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getException().add(value);
            }
        }
        return this;
    }

    public Coverage withException(Collection<Coding> values) {
        if (values != null) {
            this.getException().addAll(values);
        }
        return this;
    }

    public Coverage withSchool(String value) {
        this.setSchool(value);
        return this;
    }

    public Coverage withNetwork(String value) {
        this.setNetwork(value);
        return this;
    }

    public Coverage withContract(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getContract().add(value);
            }
        }
        return this;
    }

    public Coverage withContract(Collection<Reference> values) {
        if (values != null) {
            this.getContract().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Coverage withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Coverage withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Coverage withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Coverage withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Coverage withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Coverage withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Coverage withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Coverage that = (Coverage)object;
        Identifier lhsIssuerIdentifier = this.getIssuerIdentifier();
        Identifier rhsIssuerIdentifier = that.getIssuerIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "issuerIdentifier", lhsIssuerIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "issuerIdentifier", rhsIssuerIdentifier), lhsIssuerIdentifier, rhsIssuerIdentifier, this.issuerIdentifier != null, that.issuerIdentifier != null)) {
            return false;
        }
        Reference lhsIssuerReference = this.getIssuerReference();
        Reference rhsIssuerReference = that.getIssuerReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "issuerReference", lhsIssuerReference), (ObjectLocator)LocatorUtils.property(thatLocator, "issuerReference", rhsIssuerReference), lhsIssuerReference, rhsIssuerReference, this.issuerReference != null, that.issuerReference != null)) {
            return false;
        }
        String lhsBin = this.getBin();
        String rhsBin = that.getBin();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "bin", lhsBin), (ObjectLocator)LocatorUtils.property(thatLocator, "bin", rhsBin), lhsBin, rhsBin, this.bin != null, that.bin != null)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "period", lhsPeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "period", rhsPeriod), lhsPeriod, rhsPeriod, this.period != null, that.period != null)) {
            return false;
        }
        Coding lhsType = this.getType();
        Coding rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        Identifier lhsPlanholderIdentifier = this.getPlanholderIdentifier();
        Identifier rhsPlanholderIdentifier = that.getPlanholderIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "planholderIdentifier", lhsPlanholderIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "planholderIdentifier", rhsPlanholderIdentifier), lhsPlanholderIdentifier, rhsPlanholderIdentifier, this.planholderIdentifier != null, that.planholderIdentifier != null)) {
            return false;
        }
        Reference lhsPlanholderReference = this.getPlanholderReference();
        Reference rhsPlanholderReference = that.getPlanholderReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "planholderReference", lhsPlanholderReference), (ObjectLocator)LocatorUtils.property(thatLocator, "planholderReference", rhsPlanholderReference), lhsPlanholderReference, rhsPlanholderReference, this.planholderReference != null, that.planholderReference != null)) {
            return false;
        }
        Identifier lhsBeneficiaryIdentifier = this.getBeneficiaryIdentifier();
        Identifier rhsBeneficiaryIdentifier = that.getBeneficiaryIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "beneficiaryIdentifier", lhsBeneficiaryIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "beneficiaryIdentifier", rhsBeneficiaryIdentifier), lhsBeneficiaryIdentifier, rhsBeneficiaryIdentifier, this.beneficiaryIdentifier != null, that.beneficiaryIdentifier != null)) {
            return false;
        }
        Reference lhsBeneficiaryReference = this.getBeneficiaryReference();
        Reference rhsBeneficiaryReference = that.getBeneficiaryReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "beneficiaryReference", lhsBeneficiaryReference), (ObjectLocator)LocatorUtils.property(thatLocator, "beneficiaryReference", rhsBeneficiaryReference), lhsBeneficiaryReference, rhsBeneficiaryReference, this.beneficiaryReference != null, that.beneficiaryReference != null)) {
            return false;
        }
        Coding lhsRelationship = this.getRelationship();
        Coding rhsRelationship = that.getRelationship();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "relationship", lhsRelationship), (ObjectLocator)LocatorUtils.property(thatLocator, "relationship", rhsRelationship), lhsRelationship, rhsRelationship, this.relationship != null, that.relationship != null)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        String lhsGroup = this.getGroup();
        String rhsGroup = that.getGroup();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "group", lhsGroup), (ObjectLocator)LocatorUtils.property(thatLocator, "group", rhsGroup), lhsGroup, rhsGroup, this.group != null, that.group != null)) {
            return false;
        }
        String lhsPlan = this.getPlan();
        String rhsPlan = that.getPlan();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "plan", lhsPlan), (ObjectLocator)LocatorUtils.property(thatLocator, "plan", rhsPlan), lhsPlan, rhsPlan, this.plan != null, that.plan != null)) {
            return false;
        }
        String lhsSubPlan = this.getSubPlan();
        String rhsSubPlan = that.getSubPlan();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subPlan", lhsSubPlan), (ObjectLocator)LocatorUtils.property(thatLocator, "subPlan", rhsSubPlan), lhsSubPlan, rhsSubPlan, this.subPlan != null, that.subPlan != null)) {
            return false;
        }
        PositiveInt lhsDependent = this.getDependent();
        PositiveInt rhsDependent = that.getDependent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dependent", lhsDependent), (ObjectLocator)LocatorUtils.property(thatLocator, "dependent", rhsDependent), lhsDependent, rhsDependent, this.dependent != null, that.dependent != null)) {
            return false;
        }
        PositiveInt lhsSequence = this.getSequence();
        PositiveInt rhsSequence = that.getSequence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "sequence", lhsSequence), (ObjectLocator)LocatorUtils.property(thatLocator, "sequence", rhsSequence), lhsSequence, rhsSequence, this.sequence != null, that.sequence != null)) {
            return false;
        }
        List<Coding> lhsException = this.exception != null && !this.exception.isEmpty() ? this.getException() : null;
        List<Coding> rhsException = that.exception != null && !that.exception.isEmpty() ? that.getException() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "exception", lhsException), (ObjectLocator)LocatorUtils.property(thatLocator, "exception", rhsException), lhsException, rhsException, this.exception != null && !this.exception.isEmpty(), that.exception != null && !that.exception.isEmpty())) {
            return false;
        }
        String lhsSchool = this.getSchool();
        String rhsSchool = that.getSchool();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "school", lhsSchool), (ObjectLocator)LocatorUtils.property(thatLocator, "school", rhsSchool), lhsSchool, rhsSchool, this.school != null, that.school != null)) {
            return false;
        }
        String lhsNetwork = this.getNetwork();
        String rhsNetwork = that.getNetwork();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "network", lhsNetwork), (ObjectLocator)LocatorUtils.property(thatLocator, "network", rhsNetwork), lhsNetwork, rhsNetwork, this.network != null, that.network != null)) {
            return false;
        }
        List<Reference> lhsContract = this.contract != null && !this.contract.isEmpty() ? this.getContract() : null;
        List<Reference> rhsContract = that.contract != null && !that.contract.isEmpty() ? that.getContract() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contract", lhsContract), (ObjectLocator)LocatorUtils.property(thatLocator, "contract", rhsContract), lhsContract, rhsContract, this.contract != null && !this.contract.isEmpty(), that.contract != null && !that.contract.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIssuerIdentifier = this.getIssuerIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "issuerIdentifier", theIssuerIdentifier), currentHashCode, theIssuerIdentifier, this.issuerIdentifier != null);
        Reference theIssuerReference = this.getIssuerReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "issuerReference", theIssuerReference), currentHashCode, theIssuerReference, this.issuerReference != null);
        String theBin = this.getBin();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "bin", theBin), currentHashCode, theBin, this.bin != null);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "period", thePeriod), currentHashCode, thePeriod, this.period != null);
        Coding theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        Identifier thePlanholderIdentifier = this.getPlanholderIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "planholderIdentifier", thePlanholderIdentifier), currentHashCode, thePlanholderIdentifier, this.planholderIdentifier != null);
        Reference thePlanholderReference = this.getPlanholderReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "planholderReference", thePlanholderReference), currentHashCode, thePlanholderReference, this.planholderReference != null);
        Identifier theBeneficiaryIdentifier = this.getBeneficiaryIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "beneficiaryIdentifier", theBeneficiaryIdentifier), currentHashCode, theBeneficiaryIdentifier, this.beneficiaryIdentifier != null);
        Reference theBeneficiaryReference = this.getBeneficiaryReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "beneficiaryReference", theBeneficiaryReference), currentHashCode, theBeneficiaryReference, this.beneficiaryReference != null);
        Coding theRelationship = this.getRelationship();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "relationship", theRelationship), currentHashCode, theRelationship, this.relationship != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theGroup = this.getGroup();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "group", theGroup), currentHashCode, theGroup, this.group != null);
        String thePlan = this.getPlan();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "plan", thePlan), currentHashCode, thePlan, this.plan != null);
        String theSubPlan = this.getSubPlan();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subPlan", theSubPlan), currentHashCode, theSubPlan, this.subPlan != null);
        PositiveInt theDependent = this.getDependent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dependent", theDependent), currentHashCode, theDependent, this.dependent != null);
        PositiveInt theSequence = this.getSequence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "sequence", theSequence), currentHashCode, theSequence, this.sequence != null);
        List<Coding> theException = this.exception != null && !this.exception.isEmpty() ? this.getException() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "exception", theException), currentHashCode, theException, this.exception != null && !this.exception.isEmpty());
        String theSchool = this.getSchool();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "school", theSchool), currentHashCode, theSchool, this.school != null);
        String theNetwork = this.getNetwork();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "network", theNetwork), currentHashCode, theNetwork, this.network != null);
        List<Reference> theContract = this.contract != null && !this.contract.isEmpty() ? this.getContract() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contract", theContract), currentHashCode, theContract, this.contract != null && !this.contract.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIssuerIdentifier = this.getIssuerIdentifier();
        strategy.appendField(locator, (Object)this, "issuerIdentifier", buffer, theIssuerIdentifier, this.issuerIdentifier != null);
        Reference theIssuerReference = this.getIssuerReference();
        strategy.appendField(locator, (Object)this, "issuerReference", buffer, theIssuerReference, this.issuerReference != null);
        String theBin = this.getBin();
        strategy.appendField(locator, (Object)this, "bin", buffer, theBin, this.bin != null);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, thePeriod, this.period != null);
        Coding theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        Identifier thePlanholderIdentifier = this.getPlanholderIdentifier();
        strategy.appendField(locator, (Object)this, "planholderIdentifier", buffer, thePlanholderIdentifier, this.planholderIdentifier != null);
        Reference thePlanholderReference = this.getPlanholderReference();
        strategy.appendField(locator, (Object)this, "planholderReference", buffer, thePlanholderReference, this.planholderReference != null);
        Identifier theBeneficiaryIdentifier = this.getBeneficiaryIdentifier();
        strategy.appendField(locator, (Object)this, "beneficiaryIdentifier", buffer, theBeneficiaryIdentifier, this.beneficiaryIdentifier != null);
        Reference theBeneficiaryReference = this.getBeneficiaryReference();
        strategy.appendField(locator, (Object)this, "beneficiaryReference", buffer, theBeneficiaryReference, this.beneficiaryReference != null);
        Coding theRelationship = this.getRelationship();
        strategy.appendField(locator, (Object)this, "relationship", buffer, theRelationship, this.relationship != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theGroup = this.getGroup();
        strategy.appendField(locator, (Object)this, "group", buffer, theGroup, this.group != null);
        String thePlan = this.getPlan();
        strategy.appendField(locator, (Object)this, "plan", buffer, thePlan, this.plan != null);
        String theSubPlan = this.getSubPlan();
        strategy.appendField(locator, (Object)this, "subPlan", buffer, theSubPlan, this.subPlan != null);
        PositiveInt theDependent = this.getDependent();
        strategy.appendField(locator, (Object)this, "dependent", buffer, theDependent, this.dependent != null);
        PositiveInt theSequence = this.getSequence();
        strategy.appendField(locator, (Object)this, "sequence", buffer, theSequence, this.sequence != null);
        List<Coding> theException = this.exception != null && !this.exception.isEmpty() ? this.getException() : null;
        strategy.appendField(locator, (Object)this, "exception", buffer, theException, this.exception != null && !this.exception.isEmpty());
        String theSchool = this.getSchool();
        strategy.appendField(locator, (Object)this, "school", buffer, theSchool, this.school != null);
        String theNetwork = this.getNetwork();
        strategy.appendField(locator, (Object)this, "network", buffer, theNetwork, this.network != null);
        List<Reference> theContract = this.contract != null && !this.contract.isEmpty() ? this.getContract() : null;
        strategy.appendField(locator, (Object)this, "contract", buffer, theContract, this.contract != null && !this.contract.isEmpty());
        return buffer;
    }
}

