/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Code;
import org.hl7.fhir.ConceptMapDependsOn;
import org.hl7.fhir.ConceptMapEquivalence;
import org.hl7.fhir.Extension;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ConceptMap.Target", propOrder={"system", "version", "code", "equivalence", "comments", "dependsOn", "product"})
public class ConceptMapTarget
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected Uri system;
    protected String version;
    protected Code code;
    @XmlElement(required=true)
    protected ConceptMapEquivalence equivalence;
    protected String comments;
    protected List<ConceptMapDependsOn> dependsOn;
    protected List<ConceptMapDependsOn> product;

    public Uri getSystem() {
        return this.system;
    }

    public void setSystem(Uri value) {
        this.system = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code value) {
        this.code = value;
    }

    public ConceptMapEquivalence getEquivalence() {
        return this.equivalence;
    }

    public void setEquivalence(ConceptMapEquivalence value) {
        this.equivalence = value;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String value) {
        this.comments = value;
    }

    public List<ConceptMapDependsOn> getDependsOn() {
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<ConceptMapDependsOn>();
        }
        return this.dependsOn;
    }

    public List<ConceptMapDependsOn> getProduct() {
        if (this.product == null) {
            this.product = new ArrayList<ConceptMapDependsOn>();
        }
        return this.product;
    }

    public ConceptMapTarget withSystem(Uri value) {
        this.setSystem(value);
        return this;
    }

    public ConceptMapTarget withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public ConceptMapTarget withCode(Code value) {
        this.setCode(value);
        return this;
    }

    public ConceptMapTarget withEquivalence(ConceptMapEquivalence value) {
        this.setEquivalence(value);
        return this;
    }

    public ConceptMapTarget withComments(String value) {
        this.setComments(value);
        return this;
    }

    public ConceptMapTarget withDependsOn(ConceptMapDependsOn ... values) {
        if (values != null) {
            for (ConceptMapDependsOn value : values) {
                this.getDependsOn().add(value);
            }
        }
        return this;
    }

    public ConceptMapTarget withDependsOn(Collection<ConceptMapDependsOn> values) {
        if (values != null) {
            this.getDependsOn().addAll(values);
        }
        return this;
    }

    public ConceptMapTarget withProduct(ConceptMapDependsOn ... values) {
        if (values != null) {
            for (ConceptMapDependsOn value : values) {
                this.getProduct().add(value);
            }
        }
        return this;
    }

    public ConceptMapTarget withProduct(Collection<ConceptMapDependsOn> values) {
        if (values != null) {
            this.getProduct().addAll(values);
        }
        return this;
    }

    @Override
    public ConceptMapTarget withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConceptMapTarget withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConceptMapTarget withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConceptMapTarget withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConceptMapTarget withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConceptMapTarget that = (ConceptMapTarget)object;
        Uri lhsSystem = this.getSystem();
        Uri rhsSystem = that.getSystem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "system", lhsSystem), (ObjectLocator)LocatorUtils.property(thatLocator, "system", rhsSystem), lhsSystem, rhsSystem, this.system != null, that.system != null)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "version", lhsVersion), (ObjectLocator)LocatorUtils.property(thatLocator, "version", rhsVersion), lhsVersion, rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        Code lhsCode = this.getCode();
        Code rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        ConceptMapEquivalence lhsEquivalence = this.getEquivalence();
        ConceptMapEquivalence rhsEquivalence = that.getEquivalence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "equivalence", lhsEquivalence), (ObjectLocator)LocatorUtils.property(thatLocator, "equivalence", rhsEquivalence), lhsEquivalence, rhsEquivalence, this.equivalence != null, that.equivalence != null)) {
            return false;
        }
        String lhsComments = this.getComments();
        String rhsComments = that.getComments();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "comments", lhsComments), (ObjectLocator)LocatorUtils.property(thatLocator, "comments", rhsComments), lhsComments, rhsComments, this.comments != null, that.comments != null)) {
            return false;
        }
        List<ConceptMapDependsOn> lhsDependsOn = this.dependsOn != null && !this.dependsOn.isEmpty() ? this.getDependsOn() : null;
        List<ConceptMapDependsOn> rhsDependsOn = that.dependsOn != null && !that.dependsOn.isEmpty() ? that.getDependsOn() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dependsOn", lhsDependsOn), (ObjectLocator)LocatorUtils.property(thatLocator, "dependsOn", rhsDependsOn), lhsDependsOn, rhsDependsOn, this.dependsOn != null && !this.dependsOn.isEmpty(), that.dependsOn != null && !that.dependsOn.isEmpty())) {
            return false;
        }
        List<ConceptMapDependsOn> lhsProduct = this.product != null && !this.product.isEmpty() ? this.getProduct() : null;
        List<ConceptMapDependsOn> rhsProduct = that.product != null && !that.product.isEmpty() ? that.getProduct() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "product", lhsProduct), (ObjectLocator)LocatorUtils.property(thatLocator, "product", rhsProduct), lhsProduct, rhsProduct, this.product != null && !this.product.isEmpty(), that.product != null && !that.product.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theSystem = this.getSystem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "system", theSystem), currentHashCode, theSystem, this.system != null);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "version", theVersion), currentHashCode, theVersion, this.version != null);
        Code theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        ConceptMapEquivalence theEquivalence = this.getEquivalence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "equivalence", theEquivalence), currentHashCode, theEquivalence, this.equivalence != null);
        String theComments = this.getComments();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "comments", theComments), currentHashCode, theComments, this.comments != null);
        List<ConceptMapDependsOn> theDependsOn = this.dependsOn != null && !this.dependsOn.isEmpty() ? this.getDependsOn() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dependsOn", theDependsOn), currentHashCode, theDependsOn, this.dependsOn != null && !this.dependsOn.isEmpty());
        List<ConceptMapDependsOn> theProduct = this.product != null && !this.product.isEmpty() ? this.getProduct() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "product", theProduct), currentHashCode, theProduct, this.product != null && !this.product.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theSystem = this.getSystem();
        strategy.appendField(locator, (Object)this, "system", buffer, theSystem, this.system != null);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, theVersion, this.version != null);
        Code theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        ConceptMapEquivalence theEquivalence = this.getEquivalence();
        strategy.appendField(locator, (Object)this, "equivalence", buffer, theEquivalence, this.equivalence != null);
        String theComments = this.getComments();
        strategy.appendField(locator, (Object)this, "comments", buffer, theComments, this.comments != null);
        List<ConceptMapDependsOn> theDependsOn = this.dependsOn != null && !this.dependsOn.isEmpty() ? this.getDependsOn() : null;
        strategy.appendField(locator, (Object)this, "dependsOn", buffer, theDependsOn, this.dependsOn != null && !this.dependsOn.isEmpty());
        List<ConceptMapDependsOn> theProduct = this.product != null && !this.product.isEmpty() ? this.getProduct() : null;
        strategy.appendField(locator, (Object)this, "product", buffer, theProduct, this.product != null && !this.product.isEmpty());
        return buffer;
    }
}

