/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.CompositionAttester;
import org.hl7.fhir.CompositionEvent;
import org.hl7.fhir.CompositionSection;
import org.hl7.fhir.CompositionStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Composition", propOrder={"identifier", "date", "type", "clazz", "title", "status", "confidentiality", "subject", "author", "attester", "custodian", "event", "encounter", "section"})
public class Composition
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier identifier;
    @XmlElement(required=true)
    protected DateTime date;
    @XmlElement(required=true)
    protected CodeableConcept type;
    @XmlElement(name="class")
    protected CodeableConcept clazz;
    @XmlElement(required=true)
    protected String title;
    @XmlElement(required=true)
    protected CompositionStatus status;
    protected Code confidentiality;
    @XmlElement(required=true)
    protected Reference subject;
    @XmlElement(required=true)
    protected List<Reference> author;
    protected List<CompositionAttester> attester;
    protected Reference custodian;
    protected List<CompositionEvent> event;
    protected Reference encounter;
    protected List<CompositionSection> section;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public CodeableConcept getClazz() {
        return this.clazz;
    }

    public void setClazz(CodeableConcept value) {
        this.clazz = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public CompositionStatus getStatus() {
        return this.status;
    }

    public void setStatus(CompositionStatus value) {
        this.status = value;
    }

    public Code getConfidentiality() {
        return this.confidentiality;
    }

    public void setConfidentiality(Code value) {
        this.confidentiality = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public List<CompositionAttester> getAttester() {
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttester>();
        }
        return this.attester;
    }

    public Reference getCustodian() {
        return this.custodian;
    }

    public void setCustodian(Reference value) {
        this.custodian = value;
    }

    public List<CompositionEvent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<CompositionEvent>();
        }
        return this.event;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public List<CompositionSection> getSection() {
        if (this.section == null) {
            this.section = new ArrayList<CompositionSection>();
        }
        return this.section;
    }

    public Composition withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public Composition withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public Composition withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Composition withClazz(CodeableConcept value) {
        this.setClazz(value);
        return this;
    }

    public Composition withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public Composition withStatus(CompositionStatus value) {
        this.setStatus(value);
        return this;
    }

    public Composition withConfidentiality(Code value) {
        this.setConfidentiality(value);
        return this;
    }

    public Composition withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Composition withAuthor(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAuthor().add(value);
            }
        }
        return this;
    }

    public Composition withAuthor(Collection<Reference> values) {
        if (values != null) {
            this.getAuthor().addAll(values);
        }
        return this;
    }

    public Composition withAttester(CompositionAttester ... values) {
        if (values != null) {
            for (CompositionAttester value : values) {
                this.getAttester().add(value);
            }
        }
        return this;
    }

    public Composition withAttester(Collection<CompositionAttester> values) {
        if (values != null) {
            this.getAttester().addAll(values);
        }
        return this;
    }

    public Composition withCustodian(Reference value) {
        this.setCustodian(value);
        return this;
    }

    public Composition withEvent(CompositionEvent ... values) {
        if (values != null) {
            for (CompositionEvent value : values) {
                this.getEvent().add(value);
            }
        }
        return this;
    }

    public Composition withEvent(Collection<CompositionEvent> values) {
        if (values != null) {
            this.getEvent().addAll(values);
        }
        return this;
    }

    public Composition withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Composition withSection(CompositionSection ... values) {
        if (values != null) {
            for (CompositionSection value : values) {
                this.getSection().add(value);
            }
        }
        return this;
    }

    public Composition withSection(Collection<CompositionSection> values) {
        if (values != null) {
            this.getSection().addAll(values);
        }
        return this;
    }

    @Override
    public Composition withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Composition withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Composition withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Composition withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Composition withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Composition withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Composition withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Composition withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Composition withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Composition withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Composition withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Composition that = (Composition)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        CodeableConcept lhsClazz = this.getClazz();
        CodeableConcept rhsClazz = that.getClazz();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "clazz", lhsClazz), (ObjectLocator)LocatorUtils.property(thatLocator, "clazz", rhsClazz), lhsClazz, rhsClazz, this.clazz != null, that.clazz != null)) {
            return false;
        }
        String lhsTitle = this.getTitle();
        String rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "title", lhsTitle), (ObjectLocator)LocatorUtils.property(thatLocator, "title", rhsTitle), lhsTitle, rhsTitle, this.title != null, that.title != null)) {
            return false;
        }
        CompositionStatus lhsStatus = this.getStatus();
        CompositionStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Code lhsConfidentiality = this.getConfidentiality();
        Code rhsConfidentiality = that.getConfidentiality();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "confidentiality", lhsConfidentiality), (ObjectLocator)LocatorUtils.property(thatLocator, "confidentiality", rhsConfidentiality), lhsConfidentiality, rhsConfidentiality, this.confidentiality != null, that.confidentiality != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        List<Reference> lhsAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        List<Reference> rhsAuthor = that.author != null && !that.author.isEmpty() ? that.getAuthor() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "author", lhsAuthor), (ObjectLocator)LocatorUtils.property(thatLocator, "author", rhsAuthor), lhsAuthor, rhsAuthor, this.author != null && !this.author.isEmpty(), that.author != null && !that.author.isEmpty())) {
            return false;
        }
        List<CompositionAttester> lhsAttester = this.attester != null && !this.attester.isEmpty() ? this.getAttester() : null;
        List<CompositionAttester> rhsAttester = that.attester != null && !that.attester.isEmpty() ? that.getAttester() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "attester", lhsAttester), (ObjectLocator)LocatorUtils.property(thatLocator, "attester", rhsAttester), lhsAttester, rhsAttester, this.attester != null && !this.attester.isEmpty(), that.attester != null && !that.attester.isEmpty())) {
            return false;
        }
        Reference lhsCustodian = this.getCustodian();
        Reference rhsCustodian = that.getCustodian();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "custodian", lhsCustodian), (ObjectLocator)LocatorUtils.property(thatLocator, "custodian", rhsCustodian), lhsCustodian, rhsCustodian, this.custodian != null, that.custodian != null)) {
            return false;
        }
        List<CompositionEvent> lhsEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        List<CompositionEvent> rhsEvent = that.event != null && !that.event.isEmpty() ? that.getEvent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "event", lhsEvent), (ObjectLocator)LocatorUtils.property(thatLocator, "event", rhsEvent), lhsEvent, rhsEvent, this.event != null && !this.event.isEmpty(), that.event != null && !that.event.isEmpty())) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "encounter", lhsEncounter), (ObjectLocator)LocatorUtils.property(thatLocator, "encounter", rhsEncounter), lhsEncounter, rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        List<CompositionSection> lhsSection = this.section != null && !this.section.isEmpty() ? this.getSection() : null;
        List<CompositionSection> rhsSection = that.section != null && !that.section.isEmpty() ? that.getSection() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "section", lhsSection), (ObjectLocator)LocatorUtils.property(thatLocator, "section", rhsSection), lhsSection, rhsSection, this.section != null && !this.section.isEmpty(), that.section != null && !that.section.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        CodeableConcept theClazz = this.getClazz();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "clazz", theClazz), currentHashCode, theClazz, this.clazz != null);
        String theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "title", theTitle), currentHashCode, theTitle, this.title != null);
        CompositionStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Code theConfidentiality = this.getConfidentiality();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "confidentiality", theConfidentiality), currentHashCode, theConfidentiality, this.confidentiality != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "author", theAuthor), currentHashCode, theAuthor, this.author != null && !this.author.isEmpty());
        List<CompositionAttester> theAttester = this.attester != null && !this.attester.isEmpty() ? this.getAttester() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "attester", theAttester), currentHashCode, theAttester, this.attester != null && !this.attester.isEmpty());
        Reference theCustodian = this.getCustodian();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "custodian", theCustodian), currentHashCode, theCustodian, this.custodian != null);
        List<CompositionEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "event", theEvent), currentHashCode, theEvent, this.event != null && !this.event.isEmpty());
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "encounter", theEncounter), currentHashCode, theEncounter, this.encounter != null);
        List<CompositionSection> theSection = this.section != null && !this.section.isEmpty() ? this.getSection() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "section", theSection), currentHashCode, theSection, this.section != null && !this.section.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        CodeableConcept theClazz = this.getClazz();
        strategy.appendField(locator, (Object)this, "clazz", buffer, theClazz, this.clazz != null);
        String theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, theTitle, this.title != null);
        CompositionStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Code theConfidentiality = this.getConfidentiality();
        strategy.appendField(locator, (Object)this, "confidentiality", buffer, theConfidentiality, this.confidentiality != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        strategy.appendField(locator, (Object)this, "author", buffer, theAuthor, this.author != null && !this.author.isEmpty());
        List<CompositionAttester> theAttester = this.attester != null && !this.attester.isEmpty() ? this.getAttester() : null;
        strategy.appendField(locator, (Object)this, "attester", buffer, theAttester, this.attester != null && !this.attester.isEmpty());
        Reference theCustodian = this.getCustodian();
        strategy.appendField(locator, (Object)this, "custodian", buffer, theCustodian, this.custodian != null);
        List<CompositionEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        strategy.appendField(locator, (Object)this, "event", buffer, theEvent, this.event != null && !this.event.isEmpty());
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, theEncounter, this.encounter != null);
        List<CompositionSection> theSection = this.section != null && !this.section.isEmpty() ? this.getSection() : null;
        strategy.appendField(locator, (Object)this, "section", buffer, theSection, this.section != null && !this.section.isEmpty());
        return buffer;
    }
}

