/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CompartmentDefinitionContact;
import org.hl7.fhir.CompartmentDefinitionResource;
import org.hl7.fhir.CompartmentType;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CompartmentDefinition", propOrder={"url", "name", "status", "experimental", "publisher", "contact", "date", "description", "requirements", "code", "search", "resource"})
public class CompartmentDefinition
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Uri url;
    @XmlElement(required=true)
    protected String name;
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected String publisher;
    protected List<CompartmentDefinitionContact> contact;
    protected DateTime date;
    protected String description;
    protected String requirements;
    @XmlElement(required=true)
    protected CompartmentType code;
    @XmlElement(required=true)
    protected Boolean search;
    protected List<CompartmentDefinitionResource> resource;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<CompartmentDefinitionContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<CompartmentDefinitionContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public CompartmentType getCode() {
        return this.code;
    }

    public void setCode(CompartmentType value) {
        this.code = value;
    }

    public Boolean getSearch() {
        return this.search;
    }

    public void setSearch(Boolean value) {
        this.search = value;
    }

    public List<CompartmentDefinitionResource> getResource() {
        if (this.resource == null) {
            this.resource = new ArrayList<CompartmentDefinitionResource>();
        }
        return this.resource;
    }

    public CompartmentDefinition withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public CompartmentDefinition withName(String value) {
        this.setName(value);
        return this;
    }

    public CompartmentDefinition withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public CompartmentDefinition withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public CompartmentDefinition withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public CompartmentDefinition withContact(CompartmentDefinitionContact ... values) {
        if (values != null) {
            for (CompartmentDefinitionContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public CompartmentDefinition withContact(Collection<CompartmentDefinitionContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public CompartmentDefinition withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public CompartmentDefinition withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public CompartmentDefinition withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public CompartmentDefinition withCode(CompartmentType value) {
        this.setCode(value);
        return this;
    }

    public CompartmentDefinition withSearch(Boolean value) {
        this.setSearch(value);
        return this;
    }

    public CompartmentDefinition withResource(CompartmentDefinitionResource ... values) {
        if (values != null) {
            for (CompartmentDefinitionResource value : values) {
                this.getResource().add(value);
            }
        }
        return this;
    }

    public CompartmentDefinition withResource(Collection<CompartmentDefinitionResource> values) {
        if (values != null) {
            this.getResource().addAll(values);
        }
        return this;
    }

    @Override
    public CompartmentDefinition withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public CompartmentDefinition withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public CompartmentDefinition withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public CompartmentDefinition withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CompartmentDefinition withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CompartmentDefinition withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CompartmentDefinition withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CompartmentDefinition withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public CompartmentDefinition withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public CompartmentDefinition withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public CompartmentDefinition withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        CompartmentDefinition that = (CompartmentDefinition)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "experimental", lhsExperimental), (ObjectLocator)LocatorUtils.property(thatLocator, "experimental", rhsExperimental), lhsExperimental, rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "publisher", lhsPublisher), (ObjectLocator)LocatorUtils.property(thatLocator, "publisher", rhsPublisher), lhsPublisher, rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<CompartmentDefinitionContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<CompartmentDefinitionContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contact", lhsContact), (ObjectLocator)LocatorUtils.property(thatLocator, "contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requirements", lhsRequirements), (ObjectLocator)LocatorUtils.property(thatLocator, "requirements", rhsRequirements), lhsRequirements, rhsRequirements, this.requirements != null, that.requirements != null)) {
            return false;
        }
        CompartmentType lhsCode = this.getCode();
        CompartmentType rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        Boolean lhsSearch = this.getSearch();
        Boolean rhsSearch = that.getSearch();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "search", lhsSearch), (ObjectLocator)LocatorUtils.property(thatLocator, "search", rhsSearch), lhsSearch, rhsSearch, this.search != null, that.search != null)) {
            return false;
        }
        List<CompartmentDefinitionResource> lhsResource = this.resource != null && !this.resource.isEmpty() ? this.getResource() : null;
        List<CompartmentDefinitionResource> rhsResource = that.resource != null && !that.resource.isEmpty() ? that.getResource() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "resource", lhsResource), (ObjectLocator)LocatorUtils.property(thatLocator, "resource", rhsResource), lhsResource, rhsResource, this.resource != null && !this.resource.isEmpty(), that.resource != null && !that.resource.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "experimental", theExperimental), currentHashCode, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "publisher", thePublisher), currentHashCode, thePublisher, this.publisher != null);
        List<CompartmentDefinitionContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requirements", theRequirements), currentHashCode, theRequirements, this.requirements != null);
        CompartmentType theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        Boolean theSearch = this.getSearch();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "search", theSearch), currentHashCode, theSearch, this.search != null);
        List<CompartmentDefinitionResource> theResource = this.resource != null && !this.resource.isEmpty() ? this.getResource() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "resource", theResource), currentHashCode, theResource, this.resource != null && !this.resource.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, thePublisher, this.publisher != null);
        List<CompartmentDefinitionContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, theRequirements, this.requirements != null);
        CompartmentType theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        Boolean theSearch = this.getSearch();
        strategy.appendField(locator, (Object)this, "search", buffer, theSearch, this.search != null);
        List<CompartmentDefinitionResource> theResource = this.resource != null && !this.resource.isEmpty() ? this.getResource() : null;
        strategy.appendField(locator, (Object)this, "resource", buffer, theResource, this.resource != null && !this.resource.isEmpty());
        return buffer;
    }
}

