/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeSystemConcept;
import org.hl7.fhir.CodeSystemContact;
import org.hl7.fhir.CodeSystemContentMode;
import org.hl7.fhir.CodeSystemFilter;
import org.hl7.fhir.CodeSystemProperty;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.UnsignedInt;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CodeSystem", propOrder={"url", "identifier", "version", "name", "status", "experimental", "publisher", "contact", "date", "description", "useContext", "requirements", "copyright", "caseSensitive", "valueSet", "compositional", "versionNeeded", "content", "count", "filter", "property", "concept"})
public class CodeSystem
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Uri url;
    protected Identifier identifier;
    protected String version;
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected String publisher;
    protected List<CodeSystemContact> contact;
    protected DateTime date;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected String requirements;
    protected String copyright;
    protected Boolean caseSensitive;
    protected Uri valueSet;
    protected Boolean compositional;
    protected Boolean versionNeeded;
    @XmlElement(required=true)
    protected CodeSystemContentMode content;
    protected UnsignedInt count;
    protected List<CodeSystemFilter> filter;
    protected List<CodeSystemProperty> property;
    protected List<CodeSystemConcept> concept;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<CodeSystemContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<CodeSystemContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(Boolean value) {
        this.caseSensitive = value;
    }

    public Uri getValueSet() {
        return this.valueSet;
    }

    public void setValueSet(Uri value) {
        this.valueSet = value;
    }

    public Boolean getCompositional() {
        return this.compositional;
    }

    public void setCompositional(Boolean value) {
        this.compositional = value;
    }

    public Boolean getVersionNeeded() {
        return this.versionNeeded;
    }

    public void setVersionNeeded(Boolean value) {
        this.versionNeeded = value;
    }

    public CodeSystemContentMode getContent() {
        return this.content;
    }

    public void setContent(CodeSystemContentMode value) {
        this.content = value;
    }

    public UnsignedInt getCount() {
        return this.count;
    }

    public void setCount(UnsignedInt value) {
        this.count = value;
    }

    public List<CodeSystemFilter> getFilter() {
        if (this.filter == null) {
            this.filter = new ArrayList<CodeSystemFilter>();
        }
        return this.filter;
    }

    public List<CodeSystemProperty> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<CodeSystemProperty>();
        }
        return this.property;
    }

    public List<CodeSystemConcept> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<CodeSystemConcept>();
        }
        return this.concept;
    }

    public CodeSystem withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public CodeSystem withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public CodeSystem withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public CodeSystem withName(String value) {
        this.setName(value);
        return this;
    }

    public CodeSystem withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public CodeSystem withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public CodeSystem withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public CodeSystem withContact(CodeSystemContact ... values) {
        if (values != null) {
            for (CodeSystemContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public CodeSystem withContact(Collection<CodeSystemContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public CodeSystem withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public CodeSystem withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public CodeSystem withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public CodeSystem withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public CodeSystem withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public CodeSystem withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public CodeSystem withCaseSensitive(Boolean value) {
        this.setCaseSensitive(value);
        return this;
    }

    public CodeSystem withValueSet(Uri value) {
        this.setValueSet(value);
        return this;
    }

    public CodeSystem withCompositional(Boolean value) {
        this.setCompositional(value);
        return this;
    }

    public CodeSystem withVersionNeeded(Boolean value) {
        this.setVersionNeeded(value);
        return this;
    }

    public CodeSystem withContent(CodeSystemContentMode value) {
        this.setContent(value);
        return this;
    }

    public CodeSystem withCount(UnsignedInt value) {
        this.setCount(value);
        return this;
    }

    public CodeSystem withFilter(CodeSystemFilter ... values) {
        if (values != null) {
            for (CodeSystemFilter value : values) {
                this.getFilter().add(value);
            }
        }
        return this;
    }

    public CodeSystem withFilter(Collection<CodeSystemFilter> values) {
        if (values != null) {
            this.getFilter().addAll(values);
        }
        return this;
    }

    public CodeSystem withProperty(CodeSystemProperty ... values) {
        if (values != null) {
            for (CodeSystemProperty value : values) {
                this.getProperty().add(value);
            }
        }
        return this;
    }

    public CodeSystem withProperty(Collection<CodeSystemProperty> values) {
        if (values != null) {
            this.getProperty().addAll(values);
        }
        return this;
    }

    public CodeSystem withConcept(CodeSystemConcept ... values) {
        if (values != null) {
            for (CodeSystemConcept value : values) {
                this.getConcept().add(value);
            }
        }
        return this;
    }

    public CodeSystem withConcept(Collection<CodeSystemConcept> values) {
        if (values != null) {
            this.getConcept().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystem withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public CodeSystem withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public CodeSystem withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystem withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CodeSystem withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystem withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CodeSystem withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystem withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public CodeSystem withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public CodeSystem withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public CodeSystem withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        CodeSystem that = (CodeSystem)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "version", lhsVersion), (ObjectLocator)LocatorUtils.property(thatLocator, "version", rhsVersion), lhsVersion, rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "experimental", lhsExperimental), (ObjectLocator)LocatorUtils.property(thatLocator, "experimental", rhsExperimental), lhsExperimental, rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "publisher", lhsPublisher), (ObjectLocator)LocatorUtils.property(thatLocator, "publisher", rhsPublisher), lhsPublisher, rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<CodeSystemContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<CodeSystemContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contact", lhsContact), (ObjectLocator)LocatorUtils.property(thatLocator, "contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property(thatLocator, "useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requirements", lhsRequirements), (ObjectLocator)LocatorUtils.property(thatLocator, "requirements", rhsRequirements), lhsRequirements, rhsRequirements, this.requirements != null, that.requirements != null)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "copyright", lhsCopyright), (ObjectLocator)LocatorUtils.property(thatLocator, "copyright", rhsCopyright), lhsCopyright, rhsCopyright, this.copyright != null, that.copyright != null)) {
            return false;
        }
        Boolean lhsCaseSensitive = this.getCaseSensitive();
        Boolean rhsCaseSensitive = that.getCaseSensitive();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "caseSensitive", lhsCaseSensitive), (ObjectLocator)LocatorUtils.property(thatLocator, "caseSensitive", rhsCaseSensitive), lhsCaseSensitive, rhsCaseSensitive, this.caseSensitive != null, that.caseSensitive != null)) {
            return false;
        }
        Uri lhsValueSet = this.getValueSet();
        Uri rhsValueSet = that.getValueSet();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueSet", lhsValueSet), (ObjectLocator)LocatorUtils.property(thatLocator, "valueSet", rhsValueSet), lhsValueSet, rhsValueSet, this.valueSet != null, that.valueSet != null)) {
            return false;
        }
        Boolean lhsCompositional = this.getCompositional();
        Boolean rhsCompositional = that.getCompositional();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "compositional", lhsCompositional), (ObjectLocator)LocatorUtils.property(thatLocator, "compositional", rhsCompositional), lhsCompositional, rhsCompositional, this.compositional != null, that.compositional != null)) {
            return false;
        }
        Boolean lhsVersionNeeded = this.getVersionNeeded();
        Boolean rhsVersionNeeded = that.getVersionNeeded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "versionNeeded", lhsVersionNeeded), (ObjectLocator)LocatorUtils.property(thatLocator, "versionNeeded", rhsVersionNeeded), lhsVersionNeeded, rhsVersionNeeded, this.versionNeeded != null, that.versionNeeded != null)) {
            return false;
        }
        CodeSystemContentMode lhsContent = this.getContent();
        CodeSystemContentMode rhsContent = that.getContent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "content", lhsContent), (ObjectLocator)LocatorUtils.property(thatLocator, "content", rhsContent), lhsContent, rhsContent, this.content != null, that.content != null)) {
            return false;
        }
        UnsignedInt lhsCount = this.getCount();
        UnsignedInt rhsCount = that.getCount();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "count", lhsCount), (ObjectLocator)LocatorUtils.property(thatLocator, "count", rhsCount), lhsCount, rhsCount, this.count != null, that.count != null)) {
            return false;
        }
        List<CodeSystemFilter> lhsFilter = this.filter != null && !this.filter.isEmpty() ? this.getFilter() : null;
        List<CodeSystemFilter> rhsFilter = that.filter != null && !that.filter.isEmpty() ? that.getFilter() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "filter", lhsFilter), (ObjectLocator)LocatorUtils.property(thatLocator, "filter", rhsFilter), lhsFilter, rhsFilter, this.filter != null && !this.filter.isEmpty(), that.filter != null && !that.filter.isEmpty())) {
            return false;
        }
        List<CodeSystemProperty> lhsProperty = this.property != null && !this.property.isEmpty() ? this.getProperty() : null;
        List<CodeSystemProperty> rhsProperty = that.property != null && !that.property.isEmpty() ? that.getProperty() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "property", lhsProperty), (ObjectLocator)LocatorUtils.property(thatLocator, "property", rhsProperty), lhsProperty, rhsProperty, this.property != null && !this.property.isEmpty(), that.property != null && !that.property.isEmpty())) {
            return false;
        }
        List<CodeSystemConcept> lhsConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        List<CodeSystemConcept> rhsConcept = that.concept != null && !that.concept.isEmpty() ? that.getConcept() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "concept", lhsConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "concept", rhsConcept), lhsConcept, rhsConcept, this.concept != null && !this.concept.isEmpty(), that.concept != null && !that.concept.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "version", theVersion), currentHashCode, theVersion, this.version != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "experimental", theExperimental), currentHashCode, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "publisher", thePublisher), currentHashCode, thePublisher, this.publisher != null);
        List<CodeSystemContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requirements", theRequirements), currentHashCode, theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "copyright", theCopyright), currentHashCode, theCopyright, this.copyright != null);
        Boolean theCaseSensitive = this.getCaseSensitive();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "caseSensitive", theCaseSensitive), currentHashCode, theCaseSensitive, this.caseSensitive != null);
        Uri theValueSet = this.getValueSet();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueSet", theValueSet), currentHashCode, theValueSet, this.valueSet != null);
        Boolean theCompositional = this.getCompositional();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "compositional", theCompositional), currentHashCode, theCompositional, this.compositional != null);
        Boolean theVersionNeeded = this.getVersionNeeded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "versionNeeded", theVersionNeeded), currentHashCode, theVersionNeeded, this.versionNeeded != null);
        CodeSystemContentMode theContent = this.getContent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "content", theContent), currentHashCode, theContent, this.content != null);
        UnsignedInt theCount = this.getCount();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "count", theCount), currentHashCode, theCount, this.count != null);
        List<CodeSystemFilter> theFilter = this.filter != null && !this.filter.isEmpty() ? this.getFilter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "filter", theFilter), currentHashCode, theFilter, this.filter != null && !this.filter.isEmpty());
        List<CodeSystemProperty> theProperty = this.property != null && !this.property.isEmpty() ? this.getProperty() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "property", theProperty), currentHashCode, theProperty, this.property != null && !this.property.isEmpty());
        List<CodeSystemConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "concept", theConcept), currentHashCode, theConcept, this.concept != null && !this.concept.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, theVersion, this.version != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, thePublisher, this.publisher != null);
        List<CodeSystemContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, theCopyright, this.copyright != null);
        Boolean theCaseSensitive = this.getCaseSensitive();
        strategy.appendField(locator, (Object)this, "caseSensitive", buffer, theCaseSensitive, this.caseSensitive != null);
        Uri theValueSet = this.getValueSet();
        strategy.appendField(locator, (Object)this, "valueSet", buffer, theValueSet, this.valueSet != null);
        Boolean theCompositional = this.getCompositional();
        strategy.appendField(locator, (Object)this, "compositional", buffer, theCompositional, this.compositional != null);
        Boolean theVersionNeeded = this.getVersionNeeded();
        strategy.appendField(locator, (Object)this, "versionNeeded", buffer, theVersionNeeded, this.versionNeeded != null);
        CodeSystemContentMode theContent = this.getContent();
        strategy.appendField(locator, (Object)this, "content", buffer, theContent, this.content != null);
        UnsignedInt theCount = this.getCount();
        strategy.appendField(locator, (Object)this, "count", buffer, theCount, this.count != null);
        List<CodeSystemFilter> theFilter = this.filter != null && !this.filter.isEmpty() ? this.getFilter() : null;
        strategy.appendField(locator, (Object)this, "filter", buffer, theFilter, this.filter != null && !this.filter.isEmpty());
        List<CodeSystemProperty> theProperty = this.property != null && !this.property.isEmpty() ? this.getProperty() : null;
        strategy.appendField(locator, (Object)this, "property", buffer, theProperty, this.property != null && !this.property.isEmpty());
        List<CodeSystemConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        strategy.appendField(locator, (Object)this, "concept", buffer, theConcept, this.concept != null && !this.concept.isEmpty());
        return buffer;
    }
}

