/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.ClinicalImpressionFinding;
import org.hl7.fhir.ClinicalImpressionInvestigations;
import org.hl7.fhir.ClinicalImpressionRuledOut;
import org.hl7.fhir.ClinicalImpressionStatus;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ClinicalImpression", propOrder={"patient", "assessor", "status", "date", "description", "previous", "problem", "triggerCodeableConcept", "triggerReference", "investigations", "protocol", "summary", "finding", "resolved", "ruledOut", "prognosis", "plan", "action"})
public class ClinicalImpression
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Reference patient;
    protected Reference assessor;
    @XmlElement(required=true)
    protected ClinicalImpressionStatus status;
    protected DateTime date;
    protected String description;
    protected Reference previous;
    protected List<Reference> problem;
    protected CodeableConcept triggerCodeableConcept;
    protected Reference triggerReference;
    protected List<ClinicalImpressionInvestigations> investigations;
    protected Uri protocol;
    protected String summary;
    protected List<ClinicalImpressionFinding> finding;
    protected List<CodeableConcept> resolved;
    protected List<ClinicalImpressionRuledOut> ruledOut;
    protected String prognosis;
    protected List<Reference> plan;
    protected List<Reference> action;

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getAssessor() {
        return this.assessor;
    }

    public void setAssessor(Reference value) {
        this.assessor = value;
    }

    public ClinicalImpressionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ClinicalImpressionStatus value) {
        this.status = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public Reference getPrevious() {
        return this.previous;
    }

    public void setPrevious(Reference value) {
        this.previous = value;
    }

    public List<Reference> getProblem() {
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        return this.problem;
    }

    public CodeableConcept getTriggerCodeableConcept() {
        return this.triggerCodeableConcept;
    }

    public void setTriggerCodeableConcept(CodeableConcept value) {
        this.triggerCodeableConcept = value;
    }

    public Reference getTriggerReference() {
        return this.triggerReference;
    }

    public void setTriggerReference(Reference value) {
        this.triggerReference = value;
    }

    public List<ClinicalImpressionInvestigations> getInvestigations() {
        if (this.investigations == null) {
            this.investigations = new ArrayList<ClinicalImpressionInvestigations>();
        }
        return this.investigations;
    }

    public Uri getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Uri value) {
        this.protocol = value;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String value) {
        this.summary = value;
    }

    public List<ClinicalImpressionFinding> getFinding() {
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFinding>();
        }
        return this.finding;
    }

    public List<CodeableConcept> getResolved() {
        if (this.resolved == null) {
            this.resolved = new ArrayList<CodeableConcept>();
        }
        return this.resolved;
    }

    public List<ClinicalImpressionRuledOut> getRuledOut() {
        if (this.ruledOut == null) {
            this.ruledOut = new ArrayList<ClinicalImpressionRuledOut>();
        }
        return this.ruledOut;
    }

    public String getPrognosis() {
        return this.prognosis;
    }

    public void setPrognosis(String value) {
        this.prognosis = value;
    }

    public List<Reference> getPlan() {
        if (this.plan == null) {
            this.plan = new ArrayList<Reference>();
        }
        return this.plan;
    }

    public List<Reference> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<Reference>();
        }
        return this.action;
    }

    public ClinicalImpression withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public ClinicalImpression withAssessor(Reference value) {
        this.setAssessor(value);
        return this;
    }

    public ClinicalImpression withStatus(ClinicalImpressionStatus value) {
        this.setStatus(value);
        return this;
    }

    public ClinicalImpression withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public ClinicalImpression withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ClinicalImpression withPrevious(Reference value) {
        this.setPrevious(value);
        return this;
    }

    public ClinicalImpression withProblem(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getProblem().add(value);
            }
        }
        return this;
    }

    public ClinicalImpression withProblem(Collection<Reference> values) {
        if (values != null) {
            this.getProblem().addAll(values);
        }
        return this;
    }

    public ClinicalImpression withTriggerCodeableConcept(CodeableConcept value) {
        this.setTriggerCodeableConcept(value);
        return this;
    }

    public ClinicalImpression withTriggerReference(Reference value) {
        this.setTriggerReference(value);
        return this;
    }

    public ClinicalImpression withInvestigations(ClinicalImpressionInvestigations ... values) {
        if (values != null) {
            for (ClinicalImpressionInvestigations value : values) {
                this.getInvestigations().add(value);
            }
        }
        return this;
    }

    public ClinicalImpression withInvestigations(Collection<ClinicalImpressionInvestigations> values) {
        if (values != null) {
            this.getInvestigations().addAll(values);
        }
        return this;
    }

    public ClinicalImpression withProtocol(Uri value) {
        this.setProtocol(value);
        return this;
    }

    public ClinicalImpression withSummary(String value) {
        this.setSummary(value);
        return this;
    }

    public ClinicalImpression withFinding(ClinicalImpressionFinding ... values) {
        if (values != null) {
            for (ClinicalImpressionFinding value : values) {
                this.getFinding().add(value);
            }
        }
        return this;
    }

    public ClinicalImpression withFinding(Collection<ClinicalImpressionFinding> values) {
        if (values != null) {
            this.getFinding().addAll(values);
        }
        return this;
    }

    public ClinicalImpression withResolved(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getResolved().add(value);
            }
        }
        return this;
    }

    public ClinicalImpression withResolved(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getResolved().addAll(values);
        }
        return this;
    }

    public ClinicalImpression withRuledOut(ClinicalImpressionRuledOut ... values) {
        if (values != null) {
            for (ClinicalImpressionRuledOut value : values) {
                this.getRuledOut().add(value);
            }
        }
        return this;
    }

    public ClinicalImpression withRuledOut(Collection<ClinicalImpressionRuledOut> values) {
        if (values != null) {
            this.getRuledOut().addAll(values);
        }
        return this;
    }

    public ClinicalImpression withPrognosis(String value) {
        this.setPrognosis(value);
        return this;
    }

    public ClinicalImpression withPlan(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getPlan().add(value);
            }
        }
        return this;
    }

    public ClinicalImpression withPlan(Collection<Reference> values) {
        if (values != null) {
            this.getPlan().addAll(values);
        }
        return this;
    }

    public ClinicalImpression withAction(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAction().add(value);
            }
        }
        return this;
    }

    public ClinicalImpression withAction(Collection<Reference> values) {
        if (values != null) {
            this.getAction().addAll(values);
        }
        return this;
    }

    @Override
    public ClinicalImpression withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ClinicalImpression withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ClinicalImpression withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ClinicalImpression withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClinicalImpression withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClinicalImpression withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClinicalImpression withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClinicalImpression withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ClinicalImpression withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ClinicalImpression withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ClinicalImpression withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ClinicalImpression that = (ClinicalImpression)object;
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patient", lhsPatient), (ObjectLocator)LocatorUtils.property(thatLocator, "patient", rhsPatient), lhsPatient, rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Reference lhsAssessor = this.getAssessor();
        Reference rhsAssessor = that.getAssessor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "assessor", lhsAssessor), (ObjectLocator)LocatorUtils.property(thatLocator, "assessor", rhsAssessor), lhsAssessor, rhsAssessor, this.assessor != null, that.assessor != null)) {
            return false;
        }
        ClinicalImpressionStatus lhsStatus = this.getStatus();
        ClinicalImpressionStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        Reference lhsPrevious = this.getPrevious();
        Reference rhsPrevious = that.getPrevious();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "previous", lhsPrevious), (ObjectLocator)LocatorUtils.property(thatLocator, "previous", rhsPrevious), lhsPrevious, rhsPrevious, this.previous != null, that.previous != null)) {
            return false;
        }
        List<Reference> lhsProblem = this.problem != null && !this.problem.isEmpty() ? this.getProblem() : null;
        List<Reference> rhsProblem = that.problem != null && !that.problem.isEmpty() ? that.getProblem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "problem", lhsProblem), (ObjectLocator)LocatorUtils.property(thatLocator, "problem", rhsProblem), lhsProblem, rhsProblem, this.problem != null && !this.problem.isEmpty(), that.problem != null && !that.problem.isEmpty())) {
            return false;
        }
        CodeableConcept lhsTriggerCodeableConcept = this.getTriggerCodeableConcept();
        CodeableConcept rhsTriggerCodeableConcept = that.getTriggerCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "triggerCodeableConcept", lhsTriggerCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "triggerCodeableConcept", rhsTriggerCodeableConcept), lhsTriggerCodeableConcept, rhsTriggerCodeableConcept, this.triggerCodeableConcept != null, that.triggerCodeableConcept != null)) {
            return false;
        }
        Reference lhsTriggerReference = this.getTriggerReference();
        Reference rhsTriggerReference = that.getTriggerReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "triggerReference", lhsTriggerReference), (ObjectLocator)LocatorUtils.property(thatLocator, "triggerReference", rhsTriggerReference), lhsTriggerReference, rhsTriggerReference, this.triggerReference != null, that.triggerReference != null)) {
            return false;
        }
        List<ClinicalImpressionInvestigations> lhsInvestigations = this.investigations != null && !this.investigations.isEmpty() ? this.getInvestigations() : null;
        List<ClinicalImpressionInvestigations> rhsInvestigations = that.investigations != null && !that.investigations.isEmpty() ? that.getInvestigations() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "investigations", lhsInvestigations), (ObjectLocator)LocatorUtils.property(thatLocator, "investigations", rhsInvestigations), lhsInvestigations, rhsInvestigations, this.investigations != null && !this.investigations.isEmpty(), that.investigations != null && !that.investigations.isEmpty())) {
            return false;
        }
        Uri lhsProtocol = this.getProtocol();
        Uri rhsProtocol = that.getProtocol();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "protocol", lhsProtocol), (ObjectLocator)LocatorUtils.property(thatLocator, "protocol", rhsProtocol), lhsProtocol, rhsProtocol, this.protocol != null, that.protocol != null)) {
            return false;
        }
        String lhsSummary = this.getSummary();
        String rhsSummary = that.getSummary();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "summary", lhsSummary), (ObjectLocator)LocatorUtils.property(thatLocator, "summary", rhsSummary), lhsSummary, rhsSummary, this.summary != null, that.summary != null)) {
            return false;
        }
        List<ClinicalImpressionFinding> lhsFinding = this.finding != null && !this.finding.isEmpty() ? this.getFinding() : null;
        List<ClinicalImpressionFinding> rhsFinding = that.finding != null && !that.finding.isEmpty() ? that.getFinding() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "finding", lhsFinding), (ObjectLocator)LocatorUtils.property(thatLocator, "finding", rhsFinding), lhsFinding, rhsFinding, this.finding != null && !this.finding.isEmpty(), that.finding != null && !that.finding.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsResolved = this.resolved != null && !this.resolved.isEmpty() ? this.getResolved() : null;
        List<CodeableConcept> rhsResolved = that.resolved != null && !that.resolved.isEmpty() ? that.getResolved() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "resolved", lhsResolved), (ObjectLocator)LocatorUtils.property(thatLocator, "resolved", rhsResolved), lhsResolved, rhsResolved, this.resolved != null && !this.resolved.isEmpty(), that.resolved != null && !that.resolved.isEmpty())) {
            return false;
        }
        List<ClinicalImpressionRuledOut> lhsRuledOut = this.ruledOut != null && !this.ruledOut.isEmpty() ? this.getRuledOut() : null;
        List<ClinicalImpressionRuledOut> rhsRuledOut = that.ruledOut != null && !that.ruledOut.isEmpty() ? that.getRuledOut() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "ruledOut", lhsRuledOut), (ObjectLocator)LocatorUtils.property(thatLocator, "ruledOut", rhsRuledOut), lhsRuledOut, rhsRuledOut, this.ruledOut != null && !this.ruledOut.isEmpty(), that.ruledOut != null && !that.ruledOut.isEmpty())) {
            return false;
        }
        String lhsPrognosis = this.getPrognosis();
        String rhsPrognosis = that.getPrognosis();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "prognosis", lhsPrognosis), (ObjectLocator)LocatorUtils.property(thatLocator, "prognosis", rhsPrognosis), lhsPrognosis, rhsPrognosis, this.prognosis != null, that.prognosis != null)) {
            return false;
        }
        List<Reference> lhsPlan = this.plan != null && !this.plan.isEmpty() ? this.getPlan() : null;
        List<Reference> rhsPlan = that.plan != null && !that.plan.isEmpty() ? that.getPlan() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "plan", lhsPlan), (ObjectLocator)LocatorUtils.property(thatLocator, "plan", rhsPlan), lhsPlan, rhsPlan, this.plan != null && !this.plan.isEmpty(), that.plan != null && !that.plan.isEmpty())) {
            return false;
        }
        List<Reference> lhsAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        List<Reference> rhsAction = that.action != null && !that.action.isEmpty() ? that.getAction() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "action", lhsAction), (ObjectLocator)LocatorUtils.property(thatLocator, "action", rhsAction), lhsAction, rhsAction, this.action != null && !this.action.isEmpty(), that.action != null && !that.action.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patient", thePatient), currentHashCode, thePatient, this.patient != null);
        Reference theAssessor = this.getAssessor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "assessor", theAssessor), currentHashCode, theAssessor, this.assessor != null);
        ClinicalImpressionStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        Reference thePrevious = this.getPrevious();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "previous", thePrevious), currentHashCode, thePrevious, this.previous != null);
        List<Reference> theProblem = this.problem != null && !this.problem.isEmpty() ? this.getProblem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "problem", theProblem), currentHashCode, theProblem, this.problem != null && !this.problem.isEmpty());
        CodeableConcept theTriggerCodeableConcept = this.getTriggerCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "triggerCodeableConcept", theTriggerCodeableConcept), currentHashCode, theTriggerCodeableConcept, this.triggerCodeableConcept != null);
        Reference theTriggerReference = this.getTriggerReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "triggerReference", theTriggerReference), currentHashCode, theTriggerReference, this.triggerReference != null);
        List<ClinicalImpressionInvestigations> theInvestigations = this.investigations != null && !this.investigations.isEmpty() ? this.getInvestigations() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "investigations", theInvestigations), currentHashCode, theInvestigations, this.investigations != null && !this.investigations.isEmpty());
        Uri theProtocol = this.getProtocol();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "protocol", theProtocol), currentHashCode, theProtocol, this.protocol != null);
        String theSummary = this.getSummary();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "summary", theSummary), currentHashCode, theSummary, this.summary != null);
        List<ClinicalImpressionFinding> theFinding = this.finding != null && !this.finding.isEmpty() ? this.getFinding() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "finding", theFinding), currentHashCode, theFinding, this.finding != null && !this.finding.isEmpty());
        List<CodeableConcept> theResolved = this.resolved != null && !this.resolved.isEmpty() ? this.getResolved() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "resolved", theResolved), currentHashCode, theResolved, this.resolved != null && !this.resolved.isEmpty());
        List<ClinicalImpressionRuledOut> theRuledOut = this.ruledOut != null && !this.ruledOut.isEmpty() ? this.getRuledOut() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "ruledOut", theRuledOut), currentHashCode, theRuledOut, this.ruledOut != null && !this.ruledOut.isEmpty());
        String thePrognosis = this.getPrognosis();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "prognosis", thePrognosis), currentHashCode, thePrognosis, this.prognosis != null);
        List<Reference> thePlan = this.plan != null && !this.plan.isEmpty() ? this.getPlan() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "plan", thePlan), currentHashCode, thePlan, this.plan != null && !this.plan.isEmpty());
        List<Reference> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "action", theAction), currentHashCode, theAction, this.action != null && !this.action.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, thePatient, this.patient != null);
        Reference theAssessor = this.getAssessor();
        strategy.appendField(locator, (Object)this, "assessor", buffer, theAssessor, this.assessor != null);
        ClinicalImpressionStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        Reference thePrevious = this.getPrevious();
        strategy.appendField(locator, (Object)this, "previous", buffer, thePrevious, this.previous != null);
        List<Reference> theProblem = this.problem != null && !this.problem.isEmpty() ? this.getProblem() : null;
        strategy.appendField(locator, (Object)this, "problem", buffer, theProblem, this.problem != null && !this.problem.isEmpty());
        CodeableConcept theTriggerCodeableConcept = this.getTriggerCodeableConcept();
        strategy.appendField(locator, (Object)this, "triggerCodeableConcept", buffer, theTriggerCodeableConcept, this.triggerCodeableConcept != null);
        Reference theTriggerReference = this.getTriggerReference();
        strategy.appendField(locator, (Object)this, "triggerReference", buffer, theTriggerReference, this.triggerReference != null);
        List<ClinicalImpressionInvestigations> theInvestigations = this.investigations != null && !this.investigations.isEmpty() ? this.getInvestigations() : null;
        strategy.appendField(locator, (Object)this, "investigations", buffer, theInvestigations, this.investigations != null && !this.investigations.isEmpty());
        Uri theProtocol = this.getProtocol();
        strategy.appendField(locator, (Object)this, "protocol", buffer, theProtocol, this.protocol != null);
        String theSummary = this.getSummary();
        strategy.appendField(locator, (Object)this, "summary", buffer, theSummary, this.summary != null);
        List<ClinicalImpressionFinding> theFinding = this.finding != null && !this.finding.isEmpty() ? this.getFinding() : null;
        strategy.appendField(locator, (Object)this, "finding", buffer, theFinding, this.finding != null && !this.finding.isEmpty());
        List<CodeableConcept> theResolved = this.resolved != null && !this.resolved.isEmpty() ? this.getResolved() : null;
        strategy.appendField(locator, (Object)this, "resolved", buffer, theResolved, this.resolved != null && !this.resolved.isEmpty());
        List<ClinicalImpressionRuledOut> theRuledOut = this.ruledOut != null && !this.ruledOut.isEmpty() ? this.getRuledOut() : null;
        strategy.appendField(locator, (Object)this, "ruledOut", buffer, theRuledOut, this.ruledOut != null && !this.ruledOut.isEmpty());
        String thePrognosis = this.getPrognosis();
        strategy.appendField(locator, (Object)this, "prognosis", buffer, thePrognosis, this.prognosis != null);
        List<Reference> thePlan = this.plan != null && !this.plan.isEmpty() ? this.getPlan() : null;
        strategy.appendField(locator, (Object)this, "plan", buffer, thePlan, this.plan != null && !this.plan.isEmpty());
        List<Reference> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        strategy.appendField(locator, (Object)this, "action", buffer, theAction, this.action != null && !this.action.isEmpty());
        return buffer;
    }
}

