/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ClaimResponse.Coverage", propOrder={"sequence", "focal", "coverageIdentifier", "coverageReference", "businessArrangement", "preAuthRef", "claimResponse"})
public class ClaimResponseCoverage
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected PositiveInt sequence;
    @XmlElement(required=true)
    protected Boolean focal;
    protected Identifier coverageIdentifier;
    protected Reference coverageReference;
    protected String businessArrangement;
    protected List<String> preAuthRef;
    protected Reference claimResponse;

    public PositiveInt getSequence() {
        return this.sequence;
    }

    public void setSequence(PositiveInt value) {
        this.sequence = value;
    }

    public Boolean getFocal() {
        return this.focal;
    }

    public void setFocal(Boolean value) {
        this.focal = value;
    }

    public Identifier getCoverageIdentifier() {
        return this.coverageIdentifier;
    }

    public void setCoverageIdentifier(Identifier value) {
        this.coverageIdentifier = value;
    }

    public Reference getCoverageReference() {
        return this.coverageReference;
    }

    public void setCoverageReference(Reference value) {
        this.coverageReference = value;
    }

    public String getBusinessArrangement() {
        return this.businessArrangement;
    }

    public void setBusinessArrangement(String value) {
        this.businessArrangement = value;
    }

    public List<String> getPreAuthRef() {
        if (this.preAuthRef == null) {
            this.preAuthRef = new ArrayList<String>();
        }
        return this.preAuthRef;
    }

    public Reference getClaimResponse() {
        return this.claimResponse;
    }

    public void setClaimResponse(Reference value) {
        this.claimResponse = value;
    }

    public ClaimResponseCoverage withSequence(PositiveInt value) {
        this.setSequence(value);
        return this;
    }

    public ClaimResponseCoverage withFocal(Boolean value) {
        this.setFocal(value);
        return this;
    }

    public ClaimResponseCoverage withCoverageIdentifier(Identifier value) {
        this.setCoverageIdentifier(value);
        return this;
    }

    public ClaimResponseCoverage withCoverageReference(Reference value) {
        this.setCoverageReference(value);
        return this;
    }

    public ClaimResponseCoverage withBusinessArrangement(String value) {
        this.setBusinessArrangement(value);
        return this;
    }

    public ClaimResponseCoverage withPreAuthRef(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getPreAuthRef().add(value);
            }
        }
        return this;
    }

    public ClaimResponseCoverage withPreAuthRef(Collection<String> values) {
        if (values != null) {
            this.getPreAuthRef().addAll(values);
        }
        return this;
    }

    public ClaimResponseCoverage withClaimResponse(Reference value) {
        this.setClaimResponse(value);
        return this;
    }

    @Override
    public ClaimResponseCoverage withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClaimResponseCoverage withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimResponseCoverage withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClaimResponseCoverage withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimResponseCoverage withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ClaimResponseCoverage that = (ClaimResponseCoverage)object;
        PositiveInt lhsSequence = this.getSequence();
        PositiveInt rhsSequence = that.getSequence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "sequence", lhsSequence), (ObjectLocator)LocatorUtils.property(thatLocator, "sequence", rhsSequence), lhsSequence, rhsSequence, this.sequence != null, that.sequence != null)) {
            return false;
        }
        Boolean lhsFocal = this.getFocal();
        Boolean rhsFocal = that.getFocal();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "focal", lhsFocal), (ObjectLocator)LocatorUtils.property(thatLocator, "focal", rhsFocal), lhsFocal, rhsFocal, this.focal != null, that.focal != null)) {
            return false;
        }
        Identifier lhsCoverageIdentifier = this.getCoverageIdentifier();
        Identifier rhsCoverageIdentifier = that.getCoverageIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "coverageIdentifier", lhsCoverageIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "coverageIdentifier", rhsCoverageIdentifier), lhsCoverageIdentifier, rhsCoverageIdentifier, this.coverageIdentifier != null, that.coverageIdentifier != null)) {
            return false;
        }
        Reference lhsCoverageReference = this.getCoverageReference();
        Reference rhsCoverageReference = that.getCoverageReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "coverageReference", lhsCoverageReference), (ObjectLocator)LocatorUtils.property(thatLocator, "coverageReference", rhsCoverageReference), lhsCoverageReference, rhsCoverageReference, this.coverageReference != null, that.coverageReference != null)) {
            return false;
        }
        String lhsBusinessArrangement = this.getBusinessArrangement();
        String rhsBusinessArrangement = that.getBusinessArrangement();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "businessArrangement", lhsBusinessArrangement), (ObjectLocator)LocatorUtils.property(thatLocator, "businessArrangement", rhsBusinessArrangement), lhsBusinessArrangement, rhsBusinessArrangement, this.businessArrangement != null, that.businessArrangement != null)) {
            return false;
        }
        List<String> lhsPreAuthRef = this.preAuthRef != null && !this.preAuthRef.isEmpty() ? this.getPreAuthRef() : null;
        List<String> rhsPreAuthRef = that.preAuthRef != null && !that.preAuthRef.isEmpty() ? that.getPreAuthRef() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "preAuthRef", lhsPreAuthRef), (ObjectLocator)LocatorUtils.property(thatLocator, "preAuthRef", rhsPreAuthRef), lhsPreAuthRef, rhsPreAuthRef, this.preAuthRef != null && !this.preAuthRef.isEmpty(), that.preAuthRef != null && !that.preAuthRef.isEmpty())) {
            return false;
        }
        Reference lhsClaimResponse = this.getClaimResponse();
        Reference rhsClaimResponse = that.getClaimResponse();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "claimResponse", lhsClaimResponse), (ObjectLocator)LocatorUtils.property(thatLocator, "claimResponse", rhsClaimResponse), lhsClaimResponse, rhsClaimResponse, this.claimResponse != null, that.claimResponse != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        PositiveInt theSequence = this.getSequence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "sequence", theSequence), currentHashCode, theSequence, this.sequence != null);
        Boolean theFocal = this.getFocal();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "focal", theFocal), currentHashCode, theFocal, this.focal != null);
        Identifier theCoverageIdentifier = this.getCoverageIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "coverageIdentifier", theCoverageIdentifier), currentHashCode, theCoverageIdentifier, this.coverageIdentifier != null);
        Reference theCoverageReference = this.getCoverageReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "coverageReference", theCoverageReference), currentHashCode, theCoverageReference, this.coverageReference != null);
        String theBusinessArrangement = this.getBusinessArrangement();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "businessArrangement", theBusinessArrangement), currentHashCode, theBusinessArrangement, this.businessArrangement != null);
        List<String> thePreAuthRef = this.preAuthRef != null && !this.preAuthRef.isEmpty() ? this.getPreAuthRef() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "preAuthRef", thePreAuthRef), currentHashCode, thePreAuthRef, this.preAuthRef != null && !this.preAuthRef.isEmpty());
        Reference theClaimResponse = this.getClaimResponse();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "claimResponse", theClaimResponse), currentHashCode, theClaimResponse, this.claimResponse != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        PositiveInt theSequence = this.getSequence();
        strategy.appendField(locator, (Object)this, "sequence", buffer, theSequence, this.sequence != null);
        Boolean theFocal = this.getFocal();
        strategy.appendField(locator, (Object)this, "focal", buffer, theFocal, this.focal != null);
        Identifier theCoverageIdentifier = this.getCoverageIdentifier();
        strategy.appendField(locator, (Object)this, "coverageIdentifier", buffer, theCoverageIdentifier, this.coverageIdentifier != null);
        Reference theCoverageReference = this.getCoverageReference();
        strategy.appendField(locator, (Object)this, "coverageReference", buffer, theCoverageReference, this.coverageReference != null);
        String theBusinessArrangement = this.getBusinessArrangement();
        strategy.appendField(locator, (Object)this, "businessArrangement", buffer, theBusinessArrangement, this.businessArrangement != null);
        List<String> thePreAuthRef = this.preAuthRef != null && !this.preAuthRef.isEmpty() ? this.getPreAuthRef() : null;
        strategy.appendField(locator, (Object)this, "preAuthRef", buffer, thePreAuthRef, this.preAuthRef != null && !this.preAuthRef.isEmpty());
        Reference theClaimResponse = this.getClaimResponse();
        strategy.appendField(locator, (Object)this, "claimResponse", buffer, theClaimResponse, this.claimResponse != null);
        return buffer;
    }
}

