/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.ClaimResponseAddItem;
import org.hl7.fhir.ClaimResponseCoverage;
import org.hl7.fhir.ClaimResponseError;
import org.hl7.fhir.ClaimResponseItem;
import org.hl7.fhir.ClaimResponseNote;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.Date;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Money;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.RemittanceOutcome;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ClaimResponse", propOrder={"identifier", "requestIdentifier", "requestReference", "ruleset", "originalRuleset", "created", "organizationIdentifier", "organizationReference", "requestProviderIdentifier", "requestProviderReference", "requestOrganizationIdentifier", "requestOrganizationReference", "outcome", "disposition", "payeeType", "item", "addItem", "error", "totalCost", "unallocDeductable", "totalBenefit", "paymentAdjustment", "paymentAdjustmentReason", "paymentDate", "paymentAmount", "paymentRef", "reserved", "form", "note", "coverage"})
public class ClaimResponse
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected Identifier requestIdentifier;
    protected Reference requestReference;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Identifier organizationIdentifier;
    protected Reference organizationReference;
    protected Identifier requestProviderIdentifier;
    protected Reference requestProviderReference;
    protected Identifier requestOrganizationIdentifier;
    protected Reference requestOrganizationReference;
    protected RemittanceOutcome outcome;
    protected String disposition;
    protected Coding payeeType;
    protected List<ClaimResponseItem> item;
    protected List<ClaimResponseAddItem> addItem;
    protected List<ClaimResponseError> error;
    protected Money totalCost;
    protected Money unallocDeductable;
    protected Money totalBenefit;
    protected Money paymentAdjustment;
    protected Coding paymentAdjustmentReason;
    protected Date paymentDate;
    protected Money paymentAmount;
    protected Identifier paymentRef;
    protected Coding reserved;
    protected Coding form;
    protected List<ClaimResponseNote> note;
    protected List<ClaimResponseCoverage> coverage;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Identifier getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public void setRequestIdentifier(Identifier value) {
        this.requestIdentifier = value;
    }

    public Reference getRequestReference() {
        return this.requestReference;
    }

    public void setRequestReference(Reference value) {
        this.requestReference = value;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Identifier getOrganizationIdentifier() {
        return this.organizationIdentifier;
    }

    public void setOrganizationIdentifier(Identifier value) {
        this.organizationIdentifier = value;
    }

    public Reference getOrganizationReference() {
        return this.organizationReference;
    }

    public void setOrganizationReference(Reference value) {
        this.organizationReference = value;
    }

    public Identifier getRequestProviderIdentifier() {
        return this.requestProviderIdentifier;
    }

    public void setRequestProviderIdentifier(Identifier value) {
        this.requestProviderIdentifier = value;
    }

    public Reference getRequestProviderReference() {
        return this.requestProviderReference;
    }

    public void setRequestProviderReference(Reference value) {
        this.requestProviderReference = value;
    }

    public Identifier getRequestOrganizationIdentifier() {
        return this.requestOrganizationIdentifier;
    }

    public void setRequestOrganizationIdentifier(Identifier value) {
        this.requestOrganizationIdentifier = value;
    }

    public Reference getRequestOrganizationReference() {
        return this.requestOrganizationReference;
    }

    public void setRequestOrganizationReference(Reference value) {
        this.requestOrganizationReference = value;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(RemittanceOutcome value) {
        this.outcome = value;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String value) {
        this.disposition = value;
    }

    public Coding getPayeeType() {
        return this.payeeType;
    }

    public void setPayeeType(Coding value) {
        this.payeeType = value;
    }

    public List<ClaimResponseItem> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ClaimResponseItem>();
        }
        return this.item;
    }

    public List<ClaimResponseAddItem> getAddItem() {
        if (this.addItem == null) {
            this.addItem = new ArrayList<ClaimResponseAddItem>();
        }
        return this.addItem;
    }

    public List<ClaimResponseError> getError() {
        if (this.error == null) {
            this.error = new ArrayList<ClaimResponseError>();
        }
        return this.error;
    }

    public Money getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(Money value) {
        this.totalCost = value;
    }

    public Money getUnallocDeductable() {
        return this.unallocDeductable;
    }

    public void setUnallocDeductable(Money value) {
        this.unallocDeductable = value;
    }

    public Money getTotalBenefit() {
        return this.totalBenefit;
    }

    public void setTotalBenefit(Money value) {
        this.totalBenefit = value;
    }

    public Money getPaymentAdjustment() {
        return this.paymentAdjustment;
    }

    public void setPaymentAdjustment(Money value) {
        this.paymentAdjustment = value;
    }

    public Coding getPaymentAdjustmentReason() {
        return this.paymentAdjustmentReason;
    }

    public void setPaymentAdjustmentReason(Coding value) {
        this.paymentAdjustmentReason = value;
    }

    public Date getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(Date value) {
        this.paymentDate = value;
    }

    public Money getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(Money value) {
        this.paymentAmount = value;
    }

    public Identifier getPaymentRef() {
        return this.paymentRef;
    }

    public void setPaymentRef(Identifier value) {
        this.paymentRef = value;
    }

    public Coding getReserved() {
        return this.reserved;
    }

    public void setReserved(Coding value) {
        this.reserved = value;
    }

    public Coding getForm() {
        return this.form;
    }

    public void setForm(Coding value) {
        this.form = value;
    }

    public List<ClaimResponseNote> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<ClaimResponseNote>();
        }
        return this.note;
    }

    public List<ClaimResponseCoverage> getCoverage() {
        if (this.coverage == null) {
            this.coverage = new ArrayList<ClaimResponseCoverage>();
        }
        return this.coverage;
    }

    public ClaimResponse withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public ClaimResponse withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public ClaimResponse withRequestIdentifier(Identifier value) {
        this.setRequestIdentifier(value);
        return this;
    }

    public ClaimResponse withRequestReference(Reference value) {
        this.setRequestReference(value);
        return this;
    }

    public ClaimResponse withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public ClaimResponse withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public ClaimResponse withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public ClaimResponse withOrganizationIdentifier(Identifier value) {
        this.setOrganizationIdentifier(value);
        return this;
    }

    public ClaimResponse withOrganizationReference(Reference value) {
        this.setOrganizationReference(value);
        return this;
    }

    public ClaimResponse withRequestProviderIdentifier(Identifier value) {
        this.setRequestProviderIdentifier(value);
        return this;
    }

    public ClaimResponse withRequestProviderReference(Reference value) {
        this.setRequestProviderReference(value);
        return this;
    }

    public ClaimResponse withRequestOrganizationIdentifier(Identifier value) {
        this.setRequestOrganizationIdentifier(value);
        return this;
    }

    public ClaimResponse withRequestOrganizationReference(Reference value) {
        this.setRequestOrganizationReference(value);
        return this;
    }

    public ClaimResponse withOutcome(RemittanceOutcome value) {
        this.setOutcome(value);
        return this;
    }

    public ClaimResponse withDisposition(String value) {
        this.setDisposition(value);
        return this;
    }

    public ClaimResponse withPayeeType(Coding value) {
        this.setPayeeType(value);
        return this;
    }

    public ClaimResponse withItem(ClaimResponseItem ... values) {
        if (values != null) {
            for (ClaimResponseItem value : values) {
                this.getItem().add(value);
            }
        }
        return this;
    }

    public ClaimResponse withItem(Collection<ClaimResponseItem> values) {
        if (values != null) {
            this.getItem().addAll(values);
        }
        return this;
    }

    public ClaimResponse withAddItem(ClaimResponseAddItem ... values) {
        if (values != null) {
            for (ClaimResponseAddItem value : values) {
                this.getAddItem().add(value);
            }
        }
        return this;
    }

    public ClaimResponse withAddItem(Collection<ClaimResponseAddItem> values) {
        if (values != null) {
            this.getAddItem().addAll(values);
        }
        return this;
    }

    public ClaimResponse withError(ClaimResponseError ... values) {
        if (values != null) {
            for (ClaimResponseError value : values) {
                this.getError().add(value);
            }
        }
        return this;
    }

    public ClaimResponse withError(Collection<ClaimResponseError> values) {
        if (values != null) {
            this.getError().addAll(values);
        }
        return this;
    }

    public ClaimResponse withTotalCost(Money value) {
        this.setTotalCost(value);
        return this;
    }

    public ClaimResponse withUnallocDeductable(Money value) {
        this.setUnallocDeductable(value);
        return this;
    }

    public ClaimResponse withTotalBenefit(Money value) {
        this.setTotalBenefit(value);
        return this;
    }

    public ClaimResponse withPaymentAdjustment(Money value) {
        this.setPaymentAdjustment(value);
        return this;
    }

    public ClaimResponse withPaymentAdjustmentReason(Coding value) {
        this.setPaymentAdjustmentReason(value);
        return this;
    }

    public ClaimResponse withPaymentDate(Date value) {
        this.setPaymentDate(value);
        return this;
    }

    public ClaimResponse withPaymentAmount(Money value) {
        this.setPaymentAmount(value);
        return this;
    }

    public ClaimResponse withPaymentRef(Identifier value) {
        this.setPaymentRef(value);
        return this;
    }

    public ClaimResponse withReserved(Coding value) {
        this.setReserved(value);
        return this;
    }

    public ClaimResponse withForm(Coding value) {
        this.setForm(value);
        return this;
    }

    public ClaimResponse withNote(ClaimResponseNote ... values) {
        if (values != null) {
            for (ClaimResponseNote value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public ClaimResponse withNote(Collection<ClaimResponseNote> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public ClaimResponse withCoverage(ClaimResponseCoverage ... values) {
        if (values != null) {
            for (ClaimResponseCoverage value : values) {
                this.getCoverage().add(value);
            }
        }
        return this;
    }

    public ClaimResponse withCoverage(Collection<ClaimResponseCoverage> values) {
        if (values != null) {
            this.getCoverage().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimResponse withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ClaimResponse withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ClaimResponse withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimResponse withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClaimResponse withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimResponse withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClaimResponse withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimResponse withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ClaimResponse withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ClaimResponse withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ClaimResponse withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ClaimResponse that = (ClaimResponse)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Identifier lhsRequestIdentifier = this.getRequestIdentifier();
        Identifier rhsRequestIdentifier = that.getRequestIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requestIdentifier", lhsRequestIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "requestIdentifier", rhsRequestIdentifier), lhsRequestIdentifier, rhsRequestIdentifier, this.requestIdentifier != null, that.requestIdentifier != null)) {
            return false;
        }
        Reference lhsRequestReference = this.getRequestReference();
        Reference rhsRequestReference = that.getRequestReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requestReference", lhsRequestReference), (ObjectLocator)LocatorUtils.property(thatLocator, "requestReference", rhsRequestReference), lhsRequestReference, rhsRequestReference, this.requestReference != null, that.requestReference != null)) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "ruleset", lhsRuleset), (ObjectLocator)LocatorUtils.property(thatLocator, "ruleset", rhsRuleset), lhsRuleset, rhsRuleset, this.ruleset != null, that.ruleset != null)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "originalRuleset", lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property(thatLocator, "originalRuleset", rhsOriginalRuleset), lhsOriginalRuleset, rhsOriginalRuleset, this.originalRuleset != null, that.originalRuleset != null)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "created", lhsCreated), (ObjectLocator)LocatorUtils.property(thatLocator, "created", rhsCreated), lhsCreated, rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        Identifier lhsOrganizationIdentifier = this.getOrganizationIdentifier();
        Identifier rhsOrganizationIdentifier = that.getOrganizationIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "organizationIdentifier", lhsOrganizationIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "organizationIdentifier", rhsOrganizationIdentifier), lhsOrganizationIdentifier, rhsOrganizationIdentifier, this.organizationIdentifier != null, that.organizationIdentifier != null)) {
            return false;
        }
        Reference lhsOrganizationReference = this.getOrganizationReference();
        Reference rhsOrganizationReference = that.getOrganizationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "organizationReference", lhsOrganizationReference), (ObjectLocator)LocatorUtils.property(thatLocator, "organizationReference", rhsOrganizationReference), lhsOrganizationReference, rhsOrganizationReference, this.organizationReference != null, that.organizationReference != null)) {
            return false;
        }
        Identifier lhsRequestProviderIdentifier = this.getRequestProviderIdentifier();
        Identifier rhsRequestProviderIdentifier = that.getRequestProviderIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requestProviderIdentifier", lhsRequestProviderIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "requestProviderIdentifier", rhsRequestProviderIdentifier), lhsRequestProviderIdentifier, rhsRequestProviderIdentifier, this.requestProviderIdentifier != null, that.requestProviderIdentifier != null)) {
            return false;
        }
        Reference lhsRequestProviderReference = this.getRequestProviderReference();
        Reference rhsRequestProviderReference = that.getRequestProviderReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requestProviderReference", lhsRequestProviderReference), (ObjectLocator)LocatorUtils.property(thatLocator, "requestProviderReference", rhsRequestProviderReference), lhsRequestProviderReference, rhsRequestProviderReference, this.requestProviderReference != null, that.requestProviderReference != null)) {
            return false;
        }
        Identifier lhsRequestOrganizationIdentifier = this.getRequestOrganizationIdentifier();
        Identifier rhsRequestOrganizationIdentifier = that.getRequestOrganizationIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requestOrganizationIdentifier", lhsRequestOrganizationIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "requestOrganizationIdentifier", rhsRequestOrganizationIdentifier), lhsRequestOrganizationIdentifier, rhsRequestOrganizationIdentifier, this.requestOrganizationIdentifier != null, that.requestOrganizationIdentifier != null)) {
            return false;
        }
        Reference lhsRequestOrganizationReference = this.getRequestOrganizationReference();
        Reference rhsRequestOrganizationReference = that.getRequestOrganizationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requestOrganizationReference", lhsRequestOrganizationReference), (ObjectLocator)LocatorUtils.property(thatLocator, "requestOrganizationReference", rhsRequestOrganizationReference), lhsRequestOrganizationReference, rhsRequestOrganizationReference, this.requestOrganizationReference != null, that.requestOrganizationReference != null)) {
            return false;
        }
        RemittanceOutcome lhsOutcome = this.getOutcome();
        RemittanceOutcome rhsOutcome = that.getOutcome();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "outcome", lhsOutcome), (ObjectLocator)LocatorUtils.property(thatLocator, "outcome", rhsOutcome), lhsOutcome, rhsOutcome, this.outcome != null, that.outcome != null)) {
            return false;
        }
        String lhsDisposition = this.getDisposition();
        String rhsDisposition = that.getDisposition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "disposition", lhsDisposition), (ObjectLocator)LocatorUtils.property(thatLocator, "disposition", rhsDisposition), lhsDisposition, rhsDisposition, this.disposition != null, that.disposition != null)) {
            return false;
        }
        Coding lhsPayeeType = this.getPayeeType();
        Coding rhsPayeeType = that.getPayeeType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "payeeType", lhsPayeeType), (ObjectLocator)LocatorUtils.property(thatLocator, "payeeType", rhsPayeeType), lhsPayeeType, rhsPayeeType, this.payeeType != null, that.payeeType != null)) {
            return false;
        }
        List<ClaimResponseItem> lhsItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        List<ClaimResponseItem> rhsItem = that.item != null && !that.item.isEmpty() ? that.getItem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "item", lhsItem), (ObjectLocator)LocatorUtils.property(thatLocator, "item", rhsItem), lhsItem, rhsItem, this.item != null && !this.item.isEmpty(), that.item != null && !that.item.isEmpty())) {
            return false;
        }
        List<ClaimResponseAddItem> lhsAddItem = this.addItem != null && !this.addItem.isEmpty() ? this.getAddItem() : null;
        List<ClaimResponseAddItem> rhsAddItem = that.addItem != null && !that.addItem.isEmpty() ? that.getAddItem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "addItem", lhsAddItem), (ObjectLocator)LocatorUtils.property(thatLocator, "addItem", rhsAddItem), lhsAddItem, rhsAddItem, this.addItem != null && !this.addItem.isEmpty(), that.addItem != null && !that.addItem.isEmpty())) {
            return false;
        }
        List<ClaimResponseError> lhsError = this.error != null && !this.error.isEmpty() ? this.getError() : null;
        List<ClaimResponseError> rhsError = that.error != null && !that.error.isEmpty() ? that.getError() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "error", lhsError), (ObjectLocator)LocatorUtils.property(thatLocator, "error", rhsError), lhsError, rhsError, this.error != null && !this.error.isEmpty(), that.error != null && !that.error.isEmpty())) {
            return false;
        }
        Money lhsTotalCost = this.getTotalCost();
        Money rhsTotalCost = that.getTotalCost();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "totalCost", lhsTotalCost), (ObjectLocator)LocatorUtils.property(thatLocator, "totalCost", rhsTotalCost), lhsTotalCost, rhsTotalCost, this.totalCost != null, that.totalCost != null)) {
            return false;
        }
        Money lhsUnallocDeductable = this.getUnallocDeductable();
        Money rhsUnallocDeductable = that.getUnallocDeductable();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "unallocDeductable", lhsUnallocDeductable), (ObjectLocator)LocatorUtils.property(thatLocator, "unallocDeductable", rhsUnallocDeductable), lhsUnallocDeductable, rhsUnallocDeductable, this.unallocDeductable != null, that.unallocDeductable != null)) {
            return false;
        }
        Money lhsTotalBenefit = this.getTotalBenefit();
        Money rhsTotalBenefit = that.getTotalBenefit();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "totalBenefit", lhsTotalBenefit), (ObjectLocator)LocatorUtils.property(thatLocator, "totalBenefit", rhsTotalBenefit), lhsTotalBenefit, rhsTotalBenefit, this.totalBenefit != null, that.totalBenefit != null)) {
            return false;
        }
        Money lhsPaymentAdjustment = this.getPaymentAdjustment();
        Money rhsPaymentAdjustment = that.getPaymentAdjustment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "paymentAdjustment", lhsPaymentAdjustment), (ObjectLocator)LocatorUtils.property(thatLocator, "paymentAdjustment", rhsPaymentAdjustment), lhsPaymentAdjustment, rhsPaymentAdjustment, this.paymentAdjustment != null, that.paymentAdjustment != null)) {
            return false;
        }
        Coding lhsPaymentAdjustmentReason = this.getPaymentAdjustmentReason();
        Coding rhsPaymentAdjustmentReason = that.getPaymentAdjustmentReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "paymentAdjustmentReason", lhsPaymentAdjustmentReason), (ObjectLocator)LocatorUtils.property(thatLocator, "paymentAdjustmentReason", rhsPaymentAdjustmentReason), lhsPaymentAdjustmentReason, rhsPaymentAdjustmentReason, this.paymentAdjustmentReason != null, that.paymentAdjustmentReason != null)) {
            return false;
        }
        Date lhsPaymentDate = this.getPaymentDate();
        Date rhsPaymentDate = that.getPaymentDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "paymentDate", lhsPaymentDate), (ObjectLocator)LocatorUtils.property(thatLocator, "paymentDate", rhsPaymentDate), lhsPaymentDate, rhsPaymentDate, this.paymentDate != null, that.paymentDate != null)) {
            return false;
        }
        Money lhsPaymentAmount = this.getPaymentAmount();
        Money rhsPaymentAmount = that.getPaymentAmount();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "paymentAmount", lhsPaymentAmount), (ObjectLocator)LocatorUtils.property(thatLocator, "paymentAmount", rhsPaymentAmount), lhsPaymentAmount, rhsPaymentAmount, this.paymentAmount != null, that.paymentAmount != null)) {
            return false;
        }
        Identifier lhsPaymentRef = this.getPaymentRef();
        Identifier rhsPaymentRef = that.getPaymentRef();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "paymentRef", lhsPaymentRef), (ObjectLocator)LocatorUtils.property(thatLocator, "paymentRef", rhsPaymentRef), lhsPaymentRef, rhsPaymentRef, this.paymentRef != null, that.paymentRef != null)) {
            return false;
        }
        Coding lhsReserved = this.getReserved();
        Coding rhsReserved = that.getReserved();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reserved", lhsReserved), (ObjectLocator)LocatorUtils.property(thatLocator, "reserved", rhsReserved), lhsReserved, rhsReserved, this.reserved != null, that.reserved != null)) {
            return false;
        }
        Coding lhsForm = this.getForm();
        Coding rhsForm = that.getForm();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "form", lhsForm), (ObjectLocator)LocatorUtils.property(thatLocator, "form", rhsForm), lhsForm, rhsForm, this.form != null, that.form != null)) {
            return false;
        }
        List<ClaimResponseNote> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<ClaimResponseNote> rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "note", lhsNote), (ObjectLocator)LocatorUtils.property(thatLocator, "note", rhsNote), lhsNote, rhsNote, this.note != null && !this.note.isEmpty(), that.note != null && !that.note.isEmpty())) {
            return false;
        }
        List<ClaimResponseCoverage> lhsCoverage = this.coverage != null && !this.coverage.isEmpty() ? this.getCoverage() : null;
        List<ClaimResponseCoverage> rhsCoverage = that.coverage != null && !that.coverage.isEmpty() ? that.getCoverage() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "coverage", lhsCoverage), (ObjectLocator)LocatorUtils.property(thatLocator, "coverage", rhsCoverage), lhsCoverage, rhsCoverage, this.coverage != null && !this.coverage.isEmpty(), that.coverage != null && !that.coverage.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Identifier theRequestIdentifier = this.getRequestIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requestIdentifier", theRequestIdentifier), currentHashCode, theRequestIdentifier, this.requestIdentifier != null);
        Reference theRequestReference = this.getRequestReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requestReference", theRequestReference), currentHashCode, theRequestReference, this.requestReference != null);
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "ruleset", theRuleset), currentHashCode, theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "originalRuleset", theOriginalRuleset), currentHashCode, theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "created", theCreated), currentHashCode, theCreated, this.created != null);
        Identifier theOrganizationIdentifier = this.getOrganizationIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "organizationIdentifier", theOrganizationIdentifier), currentHashCode, theOrganizationIdentifier, this.organizationIdentifier != null);
        Reference theOrganizationReference = this.getOrganizationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "organizationReference", theOrganizationReference), currentHashCode, theOrganizationReference, this.organizationReference != null);
        Identifier theRequestProviderIdentifier = this.getRequestProviderIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requestProviderIdentifier", theRequestProviderIdentifier), currentHashCode, theRequestProviderIdentifier, this.requestProviderIdentifier != null);
        Reference theRequestProviderReference = this.getRequestProviderReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requestProviderReference", theRequestProviderReference), currentHashCode, theRequestProviderReference, this.requestProviderReference != null);
        Identifier theRequestOrganizationIdentifier = this.getRequestOrganizationIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requestOrganizationIdentifier", theRequestOrganizationIdentifier), currentHashCode, theRequestOrganizationIdentifier, this.requestOrganizationIdentifier != null);
        Reference theRequestOrganizationReference = this.getRequestOrganizationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requestOrganizationReference", theRequestOrganizationReference), currentHashCode, theRequestOrganizationReference, this.requestOrganizationReference != null);
        RemittanceOutcome theOutcome = this.getOutcome();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "outcome", theOutcome), currentHashCode, theOutcome, this.outcome != null);
        String theDisposition = this.getDisposition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "disposition", theDisposition), currentHashCode, theDisposition, this.disposition != null);
        Coding thePayeeType = this.getPayeeType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "payeeType", thePayeeType), currentHashCode, thePayeeType, this.payeeType != null);
        List<ClaimResponseItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "item", theItem), currentHashCode, theItem, this.item != null && !this.item.isEmpty());
        List<ClaimResponseAddItem> theAddItem = this.addItem != null && !this.addItem.isEmpty() ? this.getAddItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "addItem", theAddItem), currentHashCode, theAddItem, this.addItem != null && !this.addItem.isEmpty());
        List<ClaimResponseError> theError = this.error != null && !this.error.isEmpty() ? this.getError() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "error", theError), currentHashCode, theError, this.error != null && !this.error.isEmpty());
        Money theTotalCost = this.getTotalCost();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "totalCost", theTotalCost), currentHashCode, theTotalCost, this.totalCost != null);
        Money theUnallocDeductable = this.getUnallocDeductable();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "unallocDeductable", theUnallocDeductable), currentHashCode, theUnallocDeductable, this.unallocDeductable != null);
        Money theTotalBenefit = this.getTotalBenefit();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "totalBenefit", theTotalBenefit), currentHashCode, theTotalBenefit, this.totalBenefit != null);
        Money thePaymentAdjustment = this.getPaymentAdjustment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "paymentAdjustment", thePaymentAdjustment), currentHashCode, thePaymentAdjustment, this.paymentAdjustment != null);
        Coding thePaymentAdjustmentReason = this.getPaymentAdjustmentReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "paymentAdjustmentReason", thePaymentAdjustmentReason), currentHashCode, thePaymentAdjustmentReason, this.paymentAdjustmentReason != null);
        Date thePaymentDate = this.getPaymentDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "paymentDate", thePaymentDate), currentHashCode, thePaymentDate, this.paymentDate != null);
        Money thePaymentAmount = this.getPaymentAmount();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "paymentAmount", thePaymentAmount), currentHashCode, thePaymentAmount, this.paymentAmount != null);
        Identifier thePaymentRef = this.getPaymentRef();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "paymentRef", thePaymentRef), currentHashCode, thePaymentRef, this.paymentRef != null);
        Coding theReserved = this.getReserved();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reserved", theReserved), currentHashCode, theReserved, this.reserved != null);
        Coding theForm = this.getForm();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "form", theForm), currentHashCode, theForm, this.form != null);
        List<ClaimResponseNote> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "note", theNote), currentHashCode, theNote, this.note != null && !this.note.isEmpty());
        List<ClaimResponseCoverage> theCoverage = this.coverage != null && !this.coverage.isEmpty() ? this.getCoverage() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "coverage", theCoverage), currentHashCode, theCoverage, this.coverage != null && !this.coverage.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Identifier theRequestIdentifier = this.getRequestIdentifier();
        strategy.appendField(locator, (Object)this, "requestIdentifier", buffer, theRequestIdentifier, this.requestIdentifier != null);
        Reference theRequestReference = this.getRequestReference();
        strategy.appendField(locator, (Object)this, "requestReference", buffer, theRequestReference, this.requestReference != null);
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, theCreated, this.created != null);
        Identifier theOrganizationIdentifier = this.getOrganizationIdentifier();
        strategy.appendField(locator, (Object)this, "organizationIdentifier", buffer, theOrganizationIdentifier, this.organizationIdentifier != null);
        Reference theOrganizationReference = this.getOrganizationReference();
        strategy.appendField(locator, (Object)this, "organizationReference", buffer, theOrganizationReference, this.organizationReference != null);
        Identifier theRequestProviderIdentifier = this.getRequestProviderIdentifier();
        strategy.appendField(locator, (Object)this, "requestProviderIdentifier", buffer, theRequestProviderIdentifier, this.requestProviderIdentifier != null);
        Reference theRequestProviderReference = this.getRequestProviderReference();
        strategy.appendField(locator, (Object)this, "requestProviderReference", buffer, theRequestProviderReference, this.requestProviderReference != null);
        Identifier theRequestOrganizationIdentifier = this.getRequestOrganizationIdentifier();
        strategy.appendField(locator, (Object)this, "requestOrganizationIdentifier", buffer, theRequestOrganizationIdentifier, this.requestOrganizationIdentifier != null);
        Reference theRequestOrganizationReference = this.getRequestOrganizationReference();
        strategy.appendField(locator, (Object)this, "requestOrganizationReference", buffer, theRequestOrganizationReference, this.requestOrganizationReference != null);
        RemittanceOutcome theOutcome = this.getOutcome();
        strategy.appendField(locator, (Object)this, "outcome", buffer, theOutcome, this.outcome != null);
        String theDisposition = this.getDisposition();
        strategy.appendField(locator, (Object)this, "disposition", buffer, theDisposition, this.disposition != null);
        Coding thePayeeType = this.getPayeeType();
        strategy.appendField(locator, (Object)this, "payeeType", buffer, thePayeeType, this.payeeType != null);
        List<ClaimResponseItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        strategy.appendField(locator, (Object)this, "item", buffer, theItem, this.item != null && !this.item.isEmpty());
        List<ClaimResponseAddItem> theAddItem = this.addItem != null && !this.addItem.isEmpty() ? this.getAddItem() : null;
        strategy.appendField(locator, (Object)this, "addItem", buffer, theAddItem, this.addItem != null && !this.addItem.isEmpty());
        List<ClaimResponseError> theError = this.error != null && !this.error.isEmpty() ? this.getError() : null;
        strategy.appendField(locator, (Object)this, "error", buffer, theError, this.error != null && !this.error.isEmpty());
        Money theTotalCost = this.getTotalCost();
        strategy.appendField(locator, (Object)this, "totalCost", buffer, theTotalCost, this.totalCost != null);
        Money theUnallocDeductable = this.getUnallocDeductable();
        strategy.appendField(locator, (Object)this, "unallocDeductable", buffer, theUnallocDeductable, this.unallocDeductable != null);
        Money theTotalBenefit = this.getTotalBenefit();
        strategy.appendField(locator, (Object)this, "totalBenefit", buffer, theTotalBenefit, this.totalBenefit != null);
        Money thePaymentAdjustment = this.getPaymentAdjustment();
        strategy.appendField(locator, (Object)this, "paymentAdjustment", buffer, thePaymentAdjustment, this.paymentAdjustment != null);
        Coding thePaymentAdjustmentReason = this.getPaymentAdjustmentReason();
        strategy.appendField(locator, (Object)this, "paymentAdjustmentReason", buffer, thePaymentAdjustmentReason, this.paymentAdjustmentReason != null);
        Date thePaymentDate = this.getPaymentDate();
        strategy.appendField(locator, (Object)this, "paymentDate", buffer, thePaymentDate, this.paymentDate != null);
        Money thePaymentAmount = this.getPaymentAmount();
        strategy.appendField(locator, (Object)this, "paymentAmount", buffer, thePaymentAmount, this.paymentAmount != null);
        Identifier thePaymentRef = this.getPaymentRef();
        strategy.appendField(locator, (Object)this, "paymentRef", buffer, thePaymentRef, this.paymentRef != null);
        Coding theReserved = this.getReserved();
        strategy.appendField(locator, (Object)this, "reserved", buffer, theReserved, this.reserved != null);
        Coding theForm = this.getForm();
        strategy.appendField(locator, (Object)this, "form", buffer, theForm, this.form != null);
        List<ClaimResponseNote> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote, this.note != null && !this.note.isEmpty());
        List<ClaimResponseCoverage> theCoverage = this.coverage != null && !this.coverage.isEmpty() ? this.getCoverage() : null;
        strategy.appendField(locator, (Object)this, "coverage", buffer, theCoverage, this.coverage != null && !this.coverage.isEmpty());
        return buffer;
    }
}

