/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.CarePlanActivityStatus;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.SimpleQuantity;
import org.hl7.fhir.String;
import org.hl7.fhir.Timing;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CarePlan.Detail", propOrder={"category", "code", "reasonCode", "reasonReference", "goal", "status", "statusReason", "prohibited", "scheduledTiming", "scheduledPeriod", "scheduledString", "location", "performer", "productCodeableConcept", "productReference", "dailyAmount", "quantity", "description"})
public class CarePlanDetail
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected CodeableConcept category;
    protected CodeableConcept code;
    protected List<CodeableConcept> reasonCode;
    protected List<Reference> reasonReference;
    protected List<Reference> goal;
    protected CarePlanActivityStatus status;
    protected CodeableConcept statusReason;
    @XmlElement(required=true)
    protected Boolean prohibited;
    protected Timing scheduledTiming;
    protected Period scheduledPeriod;
    protected String scheduledString;
    protected Reference location;
    protected List<Reference> performer;
    protected CodeableConcept productCodeableConcept;
    protected Reference productReference;
    protected SimpleQuantity dailyAmount;
    protected SimpleQuantity quantity;
    protected String description;

    public CodeableConcept getCategory() {
        return this.category;
    }

    public void setCategory(CodeableConcept value) {
        this.category = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public List<Reference> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        return this.goal;
    }

    public CarePlanActivityStatus getStatus() {
        return this.status;
    }

    public void setStatus(CarePlanActivityStatus value) {
        this.status = value;
    }

    public CodeableConcept getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(CodeableConcept value) {
        this.statusReason = value;
    }

    public Boolean getProhibited() {
        return this.prohibited;
    }

    public void setProhibited(Boolean value) {
        this.prohibited = value;
    }

    public Timing getScheduledTiming() {
        return this.scheduledTiming;
    }

    public void setScheduledTiming(Timing value) {
        this.scheduledTiming = value;
    }

    public Period getScheduledPeriod() {
        return this.scheduledPeriod;
    }

    public void setScheduledPeriod(Period value) {
        this.scheduledPeriod = value;
    }

    public String getScheduledString() {
        return this.scheduledString;
    }

    public void setScheduledString(String value) {
        this.scheduledString = value;
    }

    public Reference getLocation() {
        return this.location;
    }

    public void setLocation(Reference value) {
        this.location = value;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public CodeableConcept getProductCodeableConcept() {
        return this.productCodeableConcept;
    }

    public void setProductCodeableConcept(CodeableConcept value) {
        this.productCodeableConcept = value;
    }

    public Reference getProductReference() {
        return this.productReference;
    }

    public void setProductReference(Reference value) {
        this.productReference = value;
    }

    public SimpleQuantity getDailyAmount() {
        return this.dailyAmount;
    }

    public void setDailyAmount(SimpleQuantity value) {
        this.dailyAmount = value;
    }

    public SimpleQuantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(SimpleQuantity value) {
        this.quantity = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public CarePlanDetail withCategory(CodeableConcept value) {
        this.setCategory(value);
        return this;
    }

    public CarePlanDetail withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public CarePlanDetail withReasonCode(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonCode().add(value);
            }
        }
        return this;
    }

    public CarePlanDetail withReasonCode(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonCode().addAll(values);
        }
        return this;
    }

    public CarePlanDetail withReasonReference(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getReasonReference().add(value);
            }
        }
        return this;
    }

    public CarePlanDetail withReasonReference(Collection<Reference> values) {
        if (values != null) {
            this.getReasonReference().addAll(values);
        }
        return this;
    }

    public CarePlanDetail withGoal(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getGoal().add(value);
            }
        }
        return this;
    }

    public CarePlanDetail withGoal(Collection<Reference> values) {
        if (values != null) {
            this.getGoal().addAll(values);
        }
        return this;
    }

    public CarePlanDetail withStatus(CarePlanActivityStatus value) {
        this.setStatus(value);
        return this;
    }

    public CarePlanDetail withStatusReason(CodeableConcept value) {
        this.setStatusReason(value);
        return this;
    }

    public CarePlanDetail withProhibited(Boolean value) {
        this.setProhibited(value);
        return this;
    }

    public CarePlanDetail withScheduledTiming(Timing value) {
        this.setScheduledTiming(value);
        return this;
    }

    public CarePlanDetail withScheduledPeriod(Period value) {
        this.setScheduledPeriod(value);
        return this;
    }

    public CarePlanDetail withScheduledString(String value) {
        this.setScheduledString(value);
        return this;
    }

    public CarePlanDetail withLocation(Reference value) {
        this.setLocation(value);
        return this;
    }

    public CarePlanDetail withPerformer(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getPerformer().add(value);
            }
        }
        return this;
    }

    public CarePlanDetail withPerformer(Collection<Reference> values) {
        if (values != null) {
            this.getPerformer().addAll(values);
        }
        return this;
    }

    public CarePlanDetail withProductCodeableConcept(CodeableConcept value) {
        this.setProductCodeableConcept(value);
        return this;
    }

    public CarePlanDetail withProductReference(Reference value) {
        this.setProductReference(value);
        return this;
    }

    public CarePlanDetail withDailyAmount(SimpleQuantity value) {
        this.setDailyAmount(value);
        return this;
    }

    public CarePlanDetail withQuantity(SimpleQuantity value) {
        this.setQuantity(value);
        return this;
    }

    public CarePlanDetail withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    @Override
    public CarePlanDetail withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CarePlanDetail withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CarePlanDetail withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CarePlanDetail withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CarePlanDetail withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        CarePlanDetail that = (CarePlanDetail)object;
        CodeableConcept lhsCategory = this.getCategory();
        CodeableConcept rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "category", lhsCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "category", rhsCategory), lhsCategory, rhsCategory, this.category != null, that.category != null)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        List<CodeableConcept> lhsReasonCode = this.reasonCode != null && !this.reasonCode.isEmpty() ? this.getReasonCode() : null;
        List<CodeableConcept> rhsReasonCode = that.reasonCode != null && !that.reasonCode.isEmpty() ? that.getReasonCode() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonCode", lhsReasonCode), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonCode", rhsReasonCode), lhsReasonCode, rhsReasonCode, this.reasonCode != null && !this.reasonCode.isEmpty(), that.reasonCode != null && !that.reasonCode.isEmpty())) {
            return false;
        }
        List<Reference> lhsReasonReference = this.reasonReference != null && !this.reasonReference.isEmpty() ? this.getReasonReference() : null;
        List<Reference> rhsReasonReference = that.reasonReference != null && !that.reasonReference.isEmpty() ? that.getReasonReference() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonReference", lhsReasonReference), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonReference", rhsReasonReference), lhsReasonReference, rhsReasonReference, this.reasonReference != null && !this.reasonReference.isEmpty(), that.reasonReference != null && !that.reasonReference.isEmpty())) {
            return false;
        }
        List<Reference> lhsGoal = this.goal != null && !this.goal.isEmpty() ? this.getGoal() : null;
        List<Reference> rhsGoal = that.goal != null && !that.goal.isEmpty() ? that.getGoal() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "goal", lhsGoal), (ObjectLocator)LocatorUtils.property(thatLocator, "goal", rhsGoal), lhsGoal, rhsGoal, this.goal != null && !this.goal.isEmpty(), that.goal != null && !that.goal.isEmpty())) {
            return false;
        }
        CarePlanActivityStatus lhsStatus = this.getStatus();
        CarePlanActivityStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        CodeableConcept lhsStatusReason = this.getStatusReason();
        CodeableConcept rhsStatusReason = that.getStatusReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "statusReason", lhsStatusReason), (ObjectLocator)LocatorUtils.property(thatLocator, "statusReason", rhsStatusReason), lhsStatusReason, rhsStatusReason, this.statusReason != null, that.statusReason != null)) {
            return false;
        }
        Boolean lhsProhibited = this.getProhibited();
        Boolean rhsProhibited = that.getProhibited();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "prohibited", lhsProhibited), (ObjectLocator)LocatorUtils.property(thatLocator, "prohibited", rhsProhibited), lhsProhibited, rhsProhibited, this.prohibited != null, that.prohibited != null)) {
            return false;
        }
        Timing lhsScheduledTiming = this.getScheduledTiming();
        Timing rhsScheduledTiming = that.getScheduledTiming();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "scheduledTiming", lhsScheduledTiming), (ObjectLocator)LocatorUtils.property(thatLocator, "scheduledTiming", rhsScheduledTiming), lhsScheduledTiming, rhsScheduledTiming, this.scheduledTiming != null, that.scheduledTiming != null)) {
            return false;
        }
        Period lhsScheduledPeriod = this.getScheduledPeriod();
        Period rhsScheduledPeriod = that.getScheduledPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "scheduledPeriod", lhsScheduledPeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "scheduledPeriod", rhsScheduledPeriod), lhsScheduledPeriod, rhsScheduledPeriod, this.scheduledPeriod != null, that.scheduledPeriod != null)) {
            return false;
        }
        String lhsScheduledString = this.getScheduledString();
        String rhsScheduledString = that.getScheduledString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "scheduledString", lhsScheduledString), (ObjectLocator)LocatorUtils.property(thatLocator, "scheduledString", rhsScheduledString), lhsScheduledString, rhsScheduledString, this.scheduledString != null, that.scheduledString != null)) {
            return false;
        }
        Reference lhsLocation = this.getLocation();
        Reference rhsLocation = that.getLocation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "location", lhsLocation), (ObjectLocator)LocatorUtils.property(thatLocator, "location", rhsLocation), lhsLocation, rhsLocation, this.location != null, that.location != null)) {
            return false;
        }
        List<Reference> lhsPerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        List<Reference> rhsPerformer = that.performer != null && !that.performer.isEmpty() ? that.getPerformer() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "performer", lhsPerformer), (ObjectLocator)LocatorUtils.property(thatLocator, "performer", rhsPerformer), lhsPerformer, rhsPerformer, this.performer != null && !this.performer.isEmpty(), that.performer != null && !that.performer.isEmpty())) {
            return false;
        }
        CodeableConcept lhsProductCodeableConcept = this.getProductCodeableConcept();
        CodeableConcept rhsProductCodeableConcept = that.getProductCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "productCodeableConcept", lhsProductCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "productCodeableConcept", rhsProductCodeableConcept), lhsProductCodeableConcept, rhsProductCodeableConcept, this.productCodeableConcept != null, that.productCodeableConcept != null)) {
            return false;
        }
        Reference lhsProductReference = this.getProductReference();
        Reference rhsProductReference = that.getProductReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "productReference", lhsProductReference), (ObjectLocator)LocatorUtils.property(thatLocator, "productReference", rhsProductReference), lhsProductReference, rhsProductReference, this.productReference != null, that.productReference != null)) {
            return false;
        }
        SimpleQuantity lhsDailyAmount = this.getDailyAmount();
        SimpleQuantity rhsDailyAmount = that.getDailyAmount();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dailyAmount", lhsDailyAmount), (ObjectLocator)LocatorUtils.property(thatLocator, "dailyAmount", rhsDailyAmount), lhsDailyAmount, rhsDailyAmount, this.dailyAmount != null, that.dailyAmount != null)) {
            return false;
        }
        SimpleQuantity lhsQuantity = this.getQuantity();
        SimpleQuantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "quantity", lhsQuantity), (ObjectLocator)LocatorUtils.property(thatLocator, "quantity", rhsQuantity), lhsQuantity, rhsQuantity, this.quantity != null, that.quantity != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "category", theCategory), currentHashCode, theCategory, this.category != null);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        List<CodeableConcept> theReasonCode = this.reasonCode != null && !this.reasonCode.isEmpty() ? this.getReasonCode() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonCode", theReasonCode), currentHashCode, theReasonCode, this.reasonCode != null && !this.reasonCode.isEmpty());
        List<Reference> theReasonReference = this.reasonReference != null && !this.reasonReference.isEmpty() ? this.getReasonReference() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonReference", theReasonReference), currentHashCode, theReasonReference, this.reasonReference != null && !this.reasonReference.isEmpty());
        List<Reference> theGoal = this.goal != null && !this.goal.isEmpty() ? this.getGoal() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "goal", theGoal), currentHashCode, theGoal, this.goal != null && !this.goal.isEmpty());
        CarePlanActivityStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        CodeableConcept theStatusReason = this.getStatusReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "statusReason", theStatusReason), currentHashCode, theStatusReason, this.statusReason != null);
        Boolean theProhibited = this.getProhibited();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "prohibited", theProhibited), currentHashCode, theProhibited, this.prohibited != null);
        Timing theScheduledTiming = this.getScheduledTiming();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "scheduledTiming", theScheduledTiming), currentHashCode, theScheduledTiming, this.scheduledTiming != null);
        Period theScheduledPeriod = this.getScheduledPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "scheduledPeriod", theScheduledPeriod), currentHashCode, theScheduledPeriod, this.scheduledPeriod != null);
        String theScheduledString = this.getScheduledString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "scheduledString", theScheduledString), currentHashCode, theScheduledString, this.scheduledString != null);
        Reference theLocation = this.getLocation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "location", theLocation), currentHashCode, theLocation, this.location != null);
        List<Reference> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "performer", thePerformer), currentHashCode, thePerformer, this.performer != null && !this.performer.isEmpty());
        CodeableConcept theProductCodeableConcept = this.getProductCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "productCodeableConcept", theProductCodeableConcept), currentHashCode, theProductCodeableConcept, this.productCodeableConcept != null);
        Reference theProductReference = this.getProductReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "productReference", theProductReference), currentHashCode, theProductReference, this.productReference != null);
        SimpleQuantity theDailyAmount = this.getDailyAmount();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dailyAmount", theDailyAmount), currentHashCode, theDailyAmount, this.dailyAmount != null);
        SimpleQuantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "quantity", theQuantity), currentHashCode, theQuantity, this.quantity != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, theCategory, this.category != null);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        List<CodeableConcept> theReasonCode = this.reasonCode != null && !this.reasonCode.isEmpty() ? this.getReasonCode() : null;
        strategy.appendField(locator, (Object)this, "reasonCode", buffer, theReasonCode, this.reasonCode != null && !this.reasonCode.isEmpty());
        List<Reference> theReasonReference = this.reasonReference != null && !this.reasonReference.isEmpty() ? this.getReasonReference() : null;
        strategy.appendField(locator, (Object)this, "reasonReference", buffer, theReasonReference, this.reasonReference != null && !this.reasonReference.isEmpty());
        List<Reference> theGoal = this.goal != null && !this.goal.isEmpty() ? this.getGoal() : null;
        strategy.appendField(locator, (Object)this, "goal", buffer, theGoal, this.goal != null && !this.goal.isEmpty());
        CarePlanActivityStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        CodeableConcept theStatusReason = this.getStatusReason();
        strategy.appendField(locator, (Object)this, "statusReason", buffer, theStatusReason, this.statusReason != null);
        Boolean theProhibited = this.getProhibited();
        strategy.appendField(locator, (Object)this, "prohibited", buffer, theProhibited, this.prohibited != null);
        Timing theScheduledTiming = this.getScheduledTiming();
        strategy.appendField(locator, (Object)this, "scheduledTiming", buffer, theScheduledTiming, this.scheduledTiming != null);
        Period theScheduledPeriod = this.getScheduledPeriod();
        strategy.appendField(locator, (Object)this, "scheduledPeriod", buffer, theScheduledPeriod, this.scheduledPeriod != null);
        String theScheduledString = this.getScheduledString();
        strategy.appendField(locator, (Object)this, "scheduledString", buffer, theScheduledString, this.scheduledString != null);
        Reference theLocation = this.getLocation();
        strategy.appendField(locator, (Object)this, "location", buffer, theLocation, this.location != null);
        List<Reference> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        strategy.appendField(locator, (Object)this, "performer", buffer, thePerformer, this.performer != null && !this.performer.isEmpty());
        CodeableConcept theProductCodeableConcept = this.getProductCodeableConcept();
        strategy.appendField(locator, (Object)this, "productCodeableConcept", buffer, theProductCodeableConcept, this.productCodeableConcept != null);
        Reference theProductReference = this.getProductReference();
        strategy.appendField(locator, (Object)this, "productReference", buffer, theProductReference, this.productReference != null);
        SimpleQuantity theDailyAmount = this.getDailyAmount();
        strategy.appendField(locator, (Object)this, "dailyAmount", buffer, theDailyAmount, this.dailyAmount != null);
        SimpleQuantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, theQuantity, this.quantity != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        return buffer;
    }
}

