/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.BundleLink;
import org.hl7.fhir.BundleRequest;
import org.hl7.fhir.BundleResponse;
import org.hl7.fhir.BundleSearch;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Bundle.Entry", propOrder={"link", "fullUrl", "resource", "search", "request", "response"})
public class BundleEntry
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected List<BundleLink> link;
    protected Uri fullUrl;
    protected ResourceContainer resource;
    protected BundleSearch search;
    protected BundleRequest request;
    protected BundleResponse response;

    public List<BundleLink> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<BundleLink>();
        }
        return this.link;
    }

    public Uri getFullUrl() {
        return this.fullUrl;
    }

    public void setFullUrl(Uri value) {
        this.fullUrl = value;
    }

    public ResourceContainer getResource() {
        return this.resource;
    }

    public void setResource(ResourceContainer value) {
        this.resource = value;
    }

    public BundleSearch getSearch() {
        return this.search;
    }

    public void setSearch(BundleSearch value) {
        this.search = value;
    }

    public BundleRequest getRequest() {
        return this.request;
    }

    public void setRequest(BundleRequest value) {
        this.request = value;
    }

    public BundleResponse getResponse() {
        return this.response;
    }

    public void setResponse(BundleResponse value) {
        this.response = value;
    }

    public BundleEntry withLink(BundleLink ... values) {
        if (values != null) {
            for (BundleLink value : values) {
                this.getLink().add(value);
            }
        }
        return this;
    }

    public BundleEntry withLink(Collection<BundleLink> values) {
        if (values != null) {
            this.getLink().addAll(values);
        }
        return this;
    }

    public BundleEntry withFullUrl(Uri value) {
        this.setFullUrl(value);
        return this;
    }

    public BundleEntry withResource(ResourceContainer value) {
        this.setResource(value);
        return this;
    }

    public BundleEntry withSearch(BundleSearch value) {
        this.setSearch(value);
        return this;
    }

    public BundleEntry withRequest(BundleRequest value) {
        this.setRequest(value);
        return this;
    }

    public BundleEntry withResponse(BundleResponse value) {
        this.setResponse(value);
        return this;
    }

    @Override
    public BundleEntry withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public BundleEntry withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public BundleEntry withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public BundleEntry withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public BundleEntry withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        BundleEntry that = (BundleEntry)object;
        List<BundleLink> lhsLink = this.link != null && !this.link.isEmpty() ? this.getLink() : null;
        List<BundleLink> rhsLink = that.link != null && !that.link.isEmpty() ? that.getLink() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "link", lhsLink), (ObjectLocator)LocatorUtils.property(thatLocator, "link", rhsLink), lhsLink, rhsLink, this.link != null && !this.link.isEmpty(), that.link != null && !that.link.isEmpty())) {
            return false;
        }
        Uri lhsFullUrl = this.getFullUrl();
        Uri rhsFullUrl = that.getFullUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "fullUrl", lhsFullUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "fullUrl", rhsFullUrl), lhsFullUrl, rhsFullUrl, this.fullUrl != null, that.fullUrl != null)) {
            return false;
        }
        ResourceContainer lhsResource = this.getResource();
        ResourceContainer rhsResource = that.getResource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "resource", lhsResource), (ObjectLocator)LocatorUtils.property(thatLocator, "resource", rhsResource), lhsResource, rhsResource, this.resource != null, that.resource != null)) {
            return false;
        }
        BundleSearch lhsSearch = this.getSearch();
        BundleSearch rhsSearch = that.getSearch();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "search", lhsSearch), (ObjectLocator)LocatorUtils.property(thatLocator, "search", rhsSearch), lhsSearch, rhsSearch, this.search != null, that.search != null)) {
            return false;
        }
        BundleRequest lhsRequest = this.getRequest();
        BundleRequest rhsRequest = that.getRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "request", lhsRequest), (ObjectLocator)LocatorUtils.property(thatLocator, "request", rhsRequest), lhsRequest, rhsRequest, this.request != null, that.request != null)) {
            return false;
        }
        BundleResponse lhsResponse = this.getResponse();
        BundleResponse rhsResponse = that.getResponse();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "response", lhsResponse), (ObjectLocator)LocatorUtils.property(thatLocator, "response", rhsResponse), lhsResponse, rhsResponse, this.response != null, that.response != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<BundleLink> theLink = this.link != null && !this.link.isEmpty() ? this.getLink() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "link", theLink), currentHashCode, theLink, this.link != null && !this.link.isEmpty());
        Uri theFullUrl = this.getFullUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "fullUrl", theFullUrl), currentHashCode, theFullUrl, this.fullUrl != null);
        ResourceContainer theResource = this.getResource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "resource", theResource), currentHashCode, theResource, this.resource != null);
        BundleSearch theSearch = this.getSearch();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "search", theSearch), currentHashCode, theSearch, this.search != null);
        BundleRequest theRequest = this.getRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "request", theRequest), currentHashCode, theRequest, this.request != null);
        BundleResponse theResponse = this.getResponse();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "response", theResponse), currentHashCode, theResponse, this.response != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<BundleLink> theLink = this.link != null && !this.link.isEmpty() ? this.getLink() : null;
        strategy.appendField(locator, (Object)this, "link", buffer, theLink, this.link != null && !this.link.isEmpty());
        Uri theFullUrl = this.getFullUrl();
        strategy.appendField(locator, (Object)this, "fullUrl", buffer, theFullUrl, this.fullUrl != null);
        ResourceContainer theResource = this.getResource();
        strategy.appendField(locator, (Object)this, "resource", buffer, theResource, this.resource != null);
        BundleSearch theSearch = this.getSearch();
        strategy.appendField(locator, (Object)this, "search", buffer, theSearch, this.search != null);
        BundleRequest theRequest = this.getRequest();
        strategy.appendField(locator, (Object)this, "request", buffer, theRequest, this.request != null);
        BundleResponse theResponse = this.getResponse();
        strategy.appendField(locator, (Object)this, "response", buffer, theResponse, this.response != null);
        return buffer;
    }
}

