/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AppointmentParticipant;
import org.hl7.fhir.AppointmentStatus;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.UnsignedInt;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Appointment", propOrder={"identifier", "status", "serviceCategory", "serviceType", "specialty", "appointmentType", "reason", "priority", "description", "start", "end", "minutesDuration", "slot", "created", "comment", "participant"})
public class Appointment
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected AppointmentStatus status;
    protected CodeableConcept serviceCategory;
    protected List<CodeableConcept> serviceType;
    protected List<CodeableConcept> specialty;
    protected CodeableConcept appointmentType;
    protected CodeableConcept reason;
    protected UnsignedInt priority;
    protected String description;
    protected Instant start;
    protected Instant end;
    protected PositiveInt minutesDuration;
    protected List<Reference> slot;
    protected DateTime created;
    protected String comment;
    @XmlElement(required=true)
    protected List<AppointmentParticipant> participant;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public AppointmentStatus getStatus() {
        return this.status;
    }

    public void setStatus(AppointmentStatus value) {
        this.status = value;
    }

    public CodeableConcept getServiceCategory() {
        return this.serviceCategory;
    }

    public void setServiceCategory(CodeableConcept value) {
        this.serviceCategory = value;
    }

    public List<CodeableConcept> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        return this.serviceType;
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public CodeableConcept getAppointmentType() {
        return this.appointmentType;
    }

    public void setAppointmentType(CodeableConcept value) {
        this.appointmentType = value;
    }

    public CodeableConcept getReason() {
        return this.reason;
    }

    public void setReason(CodeableConcept value) {
        this.reason = value;
    }

    public UnsignedInt getPriority() {
        return this.priority;
    }

    public void setPriority(UnsignedInt value) {
        this.priority = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public Instant getStart() {
        return this.start;
    }

    public void setStart(Instant value) {
        this.start = value;
    }

    public Instant getEnd() {
        return this.end;
    }

    public void setEnd(Instant value) {
        this.end = value;
    }

    public PositiveInt getMinutesDuration() {
        return this.minutesDuration;
    }

    public void setMinutesDuration(PositiveInt value) {
        this.minutesDuration = value;
    }

    public List<Reference> getSlot() {
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        return this.slot;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public List<AppointmentParticipant> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipant>();
        }
        return this.participant;
    }

    public Appointment withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Appointment withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Appointment withStatus(AppointmentStatus value) {
        this.setStatus(value);
        return this;
    }

    public Appointment withServiceCategory(CodeableConcept value) {
        this.setServiceCategory(value);
        return this;
    }

    public Appointment withServiceType(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getServiceType().add(value);
            }
        }
        return this;
    }

    public Appointment withServiceType(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getServiceType().addAll(values);
        }
        return this;
    }

    public Appointment withSpecialty(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialty().add(value);
            }
        }
        return this;
    }

    public Appointment withSpecialty(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialty().addAll(values);
        }
        return this;
    }

    public Appointment withAppointmentType(CodeableConcept value) {
        this.setAppointmentType(value);
        return this;
    }

    public Appointment withReason(CodeableConcept value) {
        this.setReason(value);
        return this;
    }

    public Appointment withPriority(UnsignedInt value) {
        this.setPriority(value);
        return this;
    }

    public Appointment withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public Appointment withStart(Instant value) {
        this.setStart(value);
        return this;
    }

    public Appointment withEnd(Instant value) {
        this.setEnd(value);
        return this;
    }

    public Appointment withMinutesDuration(PositiveInt value) {
        this.setMinutesDuration(value);
        return this;
    }

    public Appointment withSlot(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSlot().add(value);
            }
        }
        return this;
    }

    public Appointment withSlot(Collection<Reference> values) {
        if (values != null) {
            this.getSlot().addAll(values);
        }
        return this;
    }

    public Appointment withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public Appointment withComment(String value) {
        this.setComment(value);
        return this;
    }

    public Appointment withParticipant(AppointmentParticipant ... values) {
        if (values != null) {
            for (AppointmentParticipant value : values) {
                this.getParticipant().add(value);
            }
        }
        return this;
    }

    public Appointment withParticipant(Collection<AppointmentParticipant> values) {
        if (values != null) {
            this.getParticipant().addAll(values);
        }
        return this;
    }

    @Override
    public Appointment withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Appointment withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Appointment withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Appointment withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Appointment withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Appointment withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Appointment withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Appointment withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Appointment withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Appointment withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Appointment withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Appointment that = (Appointment)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        AppointmentStatus lhsStatus = this.getStatus();
        AppointmentStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        CodeableConcept lhsServiceCategory = this.getServiceCategory();
        CodeableConcept rhsServiceCategory = that.getServiceCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "serviceCategory", lhsServiceCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "serviceCategory", rhsServiceCategory), lhsServiceCategory, rhsServiceCategory, this.serviceCategory != null, that.serviceCategory != null)) {
            return false;
        }
        List<CodeableConcept> lhsServiceType = this.serviceType != null && !this.serviceType.isEmpty() ? this.getServiceType() : null;
        List<CodeableConcept> rhsServiceType = that.serviceType != null && !that.serviceType.isEmpty() ? that.getServiceType() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "serviceType", lhsServiceType), (ObjectLocator)LocatorUtils.property(thatLocator, "serviceType", rhsServiceType), lhsServiceType, rhsServiceType, this.serviceType != null && !this.serviceType.isEmpty(), that.serviceType != null && !that.serviceType.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        List<CodeableConcept> rhsSpecialty = that.specialty != null && !that.specialty.isEmpty() ? that.getSpecialty() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "specialty", lhsSpecialty), (ObjectLocator)LocatorUtils.property(thatLocator, "specialty", rhsSpecialty), lhsSpecialty, rhsSpecialty, this.specialty != null && !this.specialty.isEmpty(), that.specialty != null && !that.specialty.isEmpty())) {
            return false;
        }
        CodeableConcept lhsAppointmentType = this.getAppointmentType();
        CodeableConcept rhsAppointmentType = that.getAppointmentType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "appointmentType", lhsAppointmentType), (ObjectLocator)LocatorUtils.property(thatLocator, "appointmentType", rhsAppointmentType), lhsAppointmentType, rhsAppointmentType, this.appointmentType != null, that.appointmentType != null)) {
            return false;
        }
        CodeableConcept lhsReason = this.getReason();
        CodeableConcept rhsReason = that.getReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reason", lhsReason), (ObjectLocator)LocatorUtils.property(thatLocator, "reason", rhsReason), lhsReason, rhsReason, this.reason != null, that.reason != null)) {
            return false;
        }
        UnsignedInt lhsPriority = this.getPriority();
        UnsignedInt rhsPriority = that.getPriority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "priority", lhsPriority), (ObjectLocator)LocatorUtils.property(thatLocator, "priority", rhsPriority), lhsPriority, rhsPriority, this.priority != null, that.priority != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        Instant lhsStart = this.getStart();
        Instant rhsStart = that.getStart();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "start", lhsStart), (ObjectLocator)LocatorUtils.property(thatLocator, "start", rhsStart), lhsStart, rhsStart, this.start != null, that.start != null)) {
            return false;
        }
        Instant lhsEnd = this.getEnd();
        Instant rhsEnd = that.getEnd();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "end", lhsEnd), (ObjectLocator)LocatorUtils.property(thatLocator, "end", rhsEnd), lhsEnd, rhsEnd, this.end != null, that.end != null)) {
            return false;
        }
        PositiveInt lhsMinutesDuration = this.getMinutesDuration();
        PositiveInt rhsMinutesDuration = that.getMinutesDuration();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "minutesDuration", lhsMinutesDuration), (ObjectLocator)LocatorUtils.property(thatLocator, "minutesDuration", rhsMinutesDuration), lhsMinutesDuration, rhsMinutesDuration, this.minutesDuration != null, that.minutesDuration != null)) {
            return false;
        }
        List<Reference> lhsSlot = this.slot != null && !this.slot.isEmpty() ? this.getSlot() : null;
        List<Reference> rhsSlot = that.slot != null && !that.slot.isEmpty() ? that.getSlot() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "slot", lhsSlot), (ObjectLocator)LocatorUtils.property(thatLocator, "slot", rhsSlot), lhsSlot, rhsSlot, this.slot != null && !this.slot.isEmpty(), that.slot != null && !that.slot.isEmpty())) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "created", lhsCreated), (ObjectLocator)LocatorUtils.property(thatLocator, "created", rhsCreated), lhsCreated, rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        String lhsComment = this.getComment();
        String rhsComment = that.getComment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "comment", lhsComment), (ObjectLocator)LocatorUtils.property(thatLocator, "comment", rhsComment), lhsComment, rhsComment, this.comment != null, that.comment != null)) {
            return false;
        }
        List<AppointmentParticipant> lhsParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        List<AppointmentParticipant> rhsParticipant = that.participant != null && !that.participant.isEmpty() ? that.getParticipant() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "participant", lhsParticipant), (ObjectLocator)LocatorUtils.property(thatLocator, "participant", rhsParticipant), lhsParticipant, rhsParticipant, this.participant != null && !this.participant.isEmpty(), that.participant != null && !that.participant.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        AppointmentStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        CodeableConcept theServiceCategory = this.getServiceCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "serviceCategory", theServiceCategory), currentHashCode, theServiceCategory, this.serviceCategory != null);
        List<CodeableConcept> theServiceType = this.serviceType != null && !this.serviceType.isEmpty() ? this.getServiceType() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "serviceType", theServiceType), currentHashCode, theServiceType, this.serviceType != null && !this.serviceType.isEmpty());
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "specialty", theSpecialty), currentHashCode, theSpecialty, this.specialty != null && !this.specialty.isEmpty());
        CodeableConcept theAppointmentType = this.getAppointmentType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "appointmentType", theAppointmentType), currentHashCode, theAppointmentType, this.appointmentType != null);
        CodeableConcept theReason = this.getReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reason", theReason), currentHashCode, theReason, this.reason != null);
        UnsignedInt thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "priority", thePriority), currentHashCode, thePriority, this.priority != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        Instant theStart = this.getStart();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "start", theStart), currentHashCode, theStart, this.start != null);
        Instant theEnd = this.getEnd();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "end", theEnd), currentHashCode, theEnd, this.end != null);
        PositiveInt theMinutesDuration = this.getMinutesDuration();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "minutesDuration", theMinutesDuration), currentHashCode, theMinutesDuration, this.minutesDuration != null);
        List<Reference> theSlot = this.slot != null && !this.slot.isEmpty() ? this.getSlot() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "slot", theSlot), currentHashCode, theSlot, this.slot != null && !this.slot.isEmpty());
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "created", theCreated), currentHashCode, theCreated, this.created != null);
        String theComment = this.getComment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "comment", theComment), currentHashCode, theComment, this.comment != null);
        List<AppointmentParticipant> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "participant", theParticipant), currentHashCode, theParticipant, this.participant != null && !this.participant.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        AppointmentStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        CodeableConcept theServiceCategory = this.getServiceCategory();
        strategy.appendField(locator, (Object)this, "serviceCategory", buffer, theServiceCategory, this.serviceCategory != null);
        List<CodeableConcept> theServiceType = this.serviceType != null && !this.serviceType.isEmpty() ? this.getServiceType() : null;
        strategy.appendField(locator, (Object)this, "serviceType", buffer, theServiceType, this.serviceType != null && !this.serviceType.isEmpty());
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        strategy.appendField(locator, (Object)this, "specialty", buffer, theSpecialty, this.specialty != null && !this.specialty.isEmpty());
        CodeableConcept theAppointmentType = this.getAppointmentType();
        strategy.appendField(locator, (Object)this, "appointmentType", buffer, theAppointmentType, this.appointmentType != null);
        CodeableConcept theReason = this.getReason();
        strategy.appendField(locator, (Object)this, "reason", buffer, theReason, this.reason != null);
        UnsignedInt thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, thePriority, this.priority != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        Instant theStart = this.getStart();
        strategy.appendField(locator, (Object)this, "start", buffer, theStart, this.start != null);
        Instant theEnd = this.getEnd();
        strategy.appendField(locator, (Object)this, "end", buffer, theEnd, this.end != null);
        PositiveInt theMinutesDuration = this.getMinutesDuration();
        strategy.appendField(locator, (Object)this, "minutesDuration", buffer, theMinutesDuration, this.minutesDuration != null);
        List<Reference> theSlot = this.slot != null && !this.slot.isEmpty() ? this.getSlot() : null;
        strategy.appendField(locator, (Object)this, "slot", buffer, theSlot, this.slot != null && !this.slot.isEmpty());
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, theCreated, this.created != null);
        String theComment = this.getComment();
        strategy.appendField(locator, (Object)this, "comment", buffer, theComment, this.comment != null);
        List<AppointmentParticipant> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        strategy.appendField(locator, (Object)this, "participant", buffer, theParticipant, this.participant != null && !this.participant.isEmpty());
        return buffer;
    }
}

