/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AllergyIntoleranceCategory;
import org.hl7.fhir.AllergyIntoleranceCriticality;
import org.hl7.fhir.AllergyIntoleranceReaction;
import org.hl7.fhir.AllergyIntoleranceStatus;
import org.hl7.fhir.AllergyIntoleranceType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AllergyIntolerance", propOrder={"identifier", "status", "type", "category", "criticality", "substance", "patient", "recordedDate", "recorder", "reporter", "onset", "lastOccurence", "note", "reaction"})
public class AllergyIntolerance
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected AllergyIntoleranceStatus status;
    protected AllergyIntoleranceType type;
    protected AllergyIntoleranceCategory category;
    protected AllergyIntoleranceCriticality criticality;
    @XmlElement(required=true)
    protected CodeableConcept substance;
    @XmlElement(required=true)
    protected Reference patient;
    protected DateTime recordedDate;
    protected Reference recorder;
    protected Reference reporter;
    protected DateTime onset;
    protected DateTime lastOccurence;
    protected List<Annotation> note;
    protected List<AllergyIntoleranceReaction> reaction;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public AllergyIntoleranceStatus getStatus() {
        return this.status;
    }

    public void setStatus(AllergyIntoleranceStatus value) {
        this.status = value;
    }

    public AllergyIntoleranceType getType() {
        return this.type;
    }

    public void setType(AllergyIntoleranceType value) {
        this.type = value;
    }

    public AllergyIntoleranceCategory getCategory() {
        return this.category;
    }

    public void setCategory(AllergyIntoleranceCategory value) {
        this.category = value;
    }

    public AllergyIntoleranceCriticality getCriticality() {
        return this.criticality;
    }

    public void setCriticality(AllergyIntoleranceCriticality value) {
        this.criticality = value;
    }

    public CodeableConcept getSubstance() {
        return this.substance;
    }

    public void setSubstance(CodeableConcept value) {
        this.substance = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public DateTime getRecordedDate() {
        return this.recordedDate;
    }

    public void setRecordedDate(DateTime value) {
        this.recordedDate = value;
    }

    public Reference getRecorder() {
        return this.recorder;
    }

    public void setRecorder(Reference value) {
        this.recorder = value;
    }

    public Reference getReporter() {
        return this.reporter;
    }

    public void setReporter(Reference value) {
        this.reporter = value;
    }

    public DateTime getOnset() {
        return this.onset;
    }

    public void setOnset(DateTime value) {
        this.onset = value;
    }

    public DateTime getLastOccurence() {
        return this.lastOccurence;
    }

    public void setLastOccurence(DateTime value) {
        this.lastOccurence = value;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public List<AllergyIntoleranceReaction> getReaction() {
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReaction>();
        }
        return this.reaction;
    }

    public AllergyIntolerance withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public AllergyIntolerance withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public AllergyIntolerance withStatus(AllergyIntoleranceStatus value) {
        this.setStatus(value);
        return this;
    }

    public AllergyIntolerance withType(AllergyIntoleranceType value) {
        this.setType(value);
        return this;
    }

    public AllergyIntolerance withCategory(AllergyIntoleranceCategory value) {
        this.setCategory(value);
        return this;
    }

    public AllergyIntolerance withCriticality(AllergyIntoleranceCriticality value) {
        this.setCriticality(value);
        return this;
    }

    public AllergyIntolerance withSubstance(CodeableConcept value) {
        this.setSubstance(value);
        return this;
    }

    public AllergyIntolerance withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public AllergyIntolerance withRecordedDate(DateTime value) {
        this.setRecordedDate(value);
        return this;
    }

    public AllergyIntolerance withRecorder(Reference value) {
        this.setRecorder(value);
        return this;
    }

    public AllergyIntolerance withReporter(Reference value) {
        this.setReporter(value);
        return this;
    }

    public AllergyIntolerance withOnset(DateTime value) {
        this.setOnset(value);
        return this;
    }

    public AllergyIntolerance withLastOccurence(DateTime value) {
        this.setLastOccurence(value);
        return this;
    }

    public AllergyIntolerance withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public AllergyIntolerance withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public AllergyIntolerance withReaction(AllergyIntoleranceReaction ... values) {
        if (values != null) {
            for (AllergyIntoleranceReaction value : values) {
                this.getReaction().add(value);
            }
        }
        return this;
    }

    public AllergyIntolerance withReaction(Collection<AllergyIntoleranceReaction> values) {
        if (values != null) {
            this.getReaction().addAll(values);
        }
        return this;
    }

    @Override
    public AllergyIntolerance withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public AllergyIntolerance withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public AllergyIntolerance withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public AllergyIntolerance withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public AllergyIntolerance withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public AllergyIntolerance withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public AllergyIntolerance withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public AllergyIntolerance withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public AllergyIntolerance withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public AllergyIntolerance withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public AllergyIntolerance withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        AllergyIntolerance that = (AllergyIntolerance)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        AllergyIntoleranceStatus lhsStatus = this.getStatus();
        AllergyIntoleranceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        AllergyIntoleranceType lhsType = this.getType();
        AllergyIntoleranceType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        AllergyIntoleranceCategory lhsCategory = this.getCategory();
        AllergyIntoleranceCategory rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "category", lhsCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "category", rhsCategory), lhsCategory, rhsCategory, this.category != null, that.category != null)) {
            return false;
        }
        AllergyIntoleranceCriticality lhsCriticality = this.getCriticality();
        AllergyIntoleranceCriticality rhsCriticality = that.getCriticality();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "criticality", lhsCriticality), (ObjectLocator)LocatorUtils.property(thatLocator, "criticality", rhsCriticality), lhsCriticality, rhsCriticality, this.criticality != null, that.criticality != null)) {
            return false;
        }
        CodeableConcept lhsSubstance = this.getSubstance();
        CodeableConcept rhsSubstance = that.getSubstance();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "substance", lhsSubstance), (ObjectLocator)LocatorUtils.property(thatLocator, "substance", rhsSubstance), lhsSubstance, rhsSubstance, this.substance != null, that.substance != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patient", lhsPatient), (ObjectLocator)LocatorUtils.property(thatLocator, "patient", rhsPatient), lhsPatient, rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        DateTime lhsRecordedDate = this.getRecordedDate();
        DateTime rhsRecordedDate = that.getRecordedDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "recordedDate", lhsRecordedDate), (ObjectLocator)LocatorUtils.property(thatLocator, "recordedDate", rhsRecordedDate), lhsRecordedDate, rhsRecordedDate, this.recordedDate != null, that.recordedDate != null)) {
            return false;
        }
        Reference lhsRecorder = this.getRecorder();
        Reference rhsRecorder = that.getRecorder();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "recorder", lhsRecorder), (ObjectLocator)LocatorUtils.property(thatLocator, "recorder", rhsRecorder), lhsRecorder, rhsRecorder, this.recorder != null, that.recorder != null)) {
            return false;
        }
        Reference lhsReporter = this.getReporter();
        Reference rhsReporter = that.getReporter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reporter", lhsReporter), (ObjectLocator)LocatorUtils.property(thatLocator, "reporter", rhsReporter), lhsReporter, rhsReporter, this.reporter != null, that.reporter != null)) {
            return false;
        }
        DateTime lhsOnset = this.getOnset();
        DateTime rhsOnset = that.getOnset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "onset", lhsOnset), (ObjectLocator)LocatorUtils.property(thatLocator, "onset", rhsOnset), lhsOnset, rhsOnset, this.onset != null, that.onset != null)) {
            return false;
        }
        DateTime lhsLastOccurence = this.getLastOccurence();
        DateTime rhsLastOccurence = that.getLastOccurence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "lastOccurence", lhsLastOccurence), (ObjectLocator)LocatorUtils.property(thatLocator, "lastOccurence", rhsLastOccurence), lhsLastOccurence, rhsLastOccurence, this.lastOccurence != null, that.lastOccurence != null)) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "note", lhsNote), (ObjectLocator)LocatorUtils.property(thatLocator, "note", rhsNote), lhsNote, rhsNote, this.note != null && !this.note.isEmpty(), that.note != null && !that.note.isEmpty())) {
            return false;
        }
        List<AllergyIntoleranceReaction> lhsReaction = this.reaction != null && !this.reaction.isEmpty() ? this.getReaction() : null;
        List<AllergyIntoleranceReaction> rhsReaction = that.reaction != null && !that.reaction.isEmpty() ? that.getReaction() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reaction", lhsReaction), (ObjectLocator)LocatorUtils.property(thatLocator, "reaction", rhsReaction), lhsReaction, rhsReaction, this.reaction != null && !this.reaction.isEmpty(), that.reaction != null && !that.reaction.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        AllergyIntoleranceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        AllergyIntoleranceType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        AllergyIntoleranceCategory theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "category", theCategory), currentHashCode, theCategory, this.category != null);
        AllergyIntoleranceCriticality theCriticality = this.getCriticality();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "criticality", theCriticality), currentHashCode, theCriticality, this.criticality != null);
        CodeableConcept theSubstance = this.getSubstance();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "substance", theSubstance), currentHashCode, theSubstance, this.substance != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patient", thePatient), currentHashCode, thePatient, this.patient != null);
        DateTime theRecordedDate = this.getRecordedDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "recordedDate", theRecordedDate), currentHashCode, theRecordedDate, this.recordedDate != null);
        Reference theRecorder = this.getRecorder();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "recorder", theRecorder), currentHashCode, theRecorder, this.recorder != null);
        Reference theReporter = this.getReporter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reporter", theReporter), currentHashCode, theReporter, this.reporter != null);
        DateTime theOnset = this.getOnset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "onset", theOnset), currentHashCode, theOnset, this.onset != null);
        DateTime theLastOccurence = this.getLastOccurence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "lastOccurence", theLastOccurence), currentHashCode, theLastOccurence, this.lastOccurence != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "note", theNote), currentHashCode, theNote, this.note != null && !this.note.isEmpty());
        List<AllergyIntoleranceReaction> theReaction = this.reaction != null && !this.reaction.isEmpty() ? this.getReaction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reaction", theReaction), currentHashCode, theReaction, this.reaction != null && !this.reaction.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        AllergyIntoleranceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        AllergyIntoleranceType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        AllergyIntoleranceCategory theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, theCategory, this.category != null);
        AllergyIntoleranceCriticality theCriticality = this.getCriticality();
        strategy.appendField(locator, (Object)this, "criticality", buffer, theCriticality, this.criticality != null);
        CodeableConcept theSubstance = this.getSubstance();
        strategy.appendField(locator, (Object)this, "substance", buffer, theSubstance, this.substance != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, thePatient, this.patient != null);
        DateTime theRecordedDate = this.getRecordedDate();
        strategy.appendField(locator, (Object)this, "recordedDate", buffer, theRecordedDate, this.recordedDate != null);
        Reference theRecorder = this.getRecorder();
        strategy.appendField(locator, (Object)this, "recorder", buffer, theRecorder, this.recorder != null);
        Reference theReporter = this.getReporter();
        strategy.appendField(locator, (Object)this, "reporter", buffer, theReporter, this.reporter != null);
        DateTime theOnset = this.getOnset();
        strategy.appendField(locator, (Object)this, "onset", buffer, theOnset, this.onset != null);
        DateTime theLastOccurence = this.getLastOccurence();
        strategy.appendField(locator, (Object)this, "lastOccurence", buffer, theLastOccurence, this.lastOccurence != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote, this.note != null && !this.note.isEmpty());
        List<AllergyIntoleranceReaction> theReaction = this.reaction != null && !this.reaction.isEmpty() ? this.getReaction() : null;
        strategy.appendField(locator, (Object)this, "reaction", buffer, theReaction, this.reaction != null && !this.reaction.isEmpty());
        return buffer;
    }
}

