/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.InstantiationContext;
import org.hl7.cql.model.SimpleType;

public abstract class DataType {
    private DataType baseType;
    public static final SimpleType ANY = new SimpleType("System.Any");

    public DataType() {
        this(null);
    }

    public DataType(DataType baseType) {
        this.baseType = baseType == null ? ANY : baseType;
    }

    public DataType getBaseType() {
        return this.baseType;
    }

    public String toLabel() {
        return this.toString();
    }

    public boolean isSubTypeOf(DataType other) {
        DataType currentType = this;
        while (currentType != null) {
            if (currentType.equals(other)) {
                return true;
            }
            currentType = currentType.baseType;
        }
        return false;
    }

    public boolean isSuperTypeOf(DataType other) {
        while (other != null) {
            if (this.equals(other)) {
                return true;
            }
            other = other.baseType;
        }
        return false;
    }

    public DataType getCommonSuperTypeOf(DataType other) {
        DataType currentType = this;
        while (currentType != null) {
            if (currentType.isSuperTypeOf(other)) {
                return currentType;
            }
            currentType = currentType.baseType;
        }
        return null;
    }

    public boolean isCompatibleWith(DataType other) {
        if (other instanceof ChoiceType) {
            for (DataType choice : ((ChoiceType)other).getTypes()) {
                if (!this.isSubTypeOf(choice)) continue;
                return true;
            }
        }
        return this.equals(other);
    }

    public abstract boolean isGeneric();

    public abstract boolean isInstantiable(DataType var1, InstantiationContext var2);

    public abstract DataType instantiate(InstantiationContext var1);
}

