/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorEntry;
import org.cqframework.cql.cql2elm.model.OperatorResolution;
import org.hl7.cql.model.DataType;

public class OperatorMap {
    private Map<String, OperatorEntry> operators = new HashMap<String, OperatorEntry>();

    public boolean containsOperator(Operator operator) {
        OperatorEntry entry = this.getEntry(operator.getName());
        return entry.containsOperator(operator);
    }

    public void addOperator(Operator operator) {
        OperatorEntry entry = this.getEntry(operator.getName());
        entry.addOperator(operator);
    }

    private OperatorEntry getEntry(String operatorName) {
        if (operatorName == null || operatorName.equals("")) {
            throw new IllegalArgumentException("operatorName is null or empty.");
        }
        OperatorEntry entry = this.operators.get(operatorName);
        if (entry == null) {
            entry = new OperatorEntry(operatorName);
            this.operators.put(operatorName, entry);
        }
        return entry;
    }

    public boolean supportsOperator(String libraryName, String operatorName, DataType ... signature) {
        CallContext call = new CallContext(libraryName, operatorName, false, false, signature);
        try {
            OperatorResolution resolution = this.resolveOperator(call, null);
            if (resolution == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isPointType(DataType type) {
        return this.supportsOperator("System", "LessOrEqual", type, type) && this.supportsOperator("System", "Successor", type);
    }

    public OperatorResolution resolveOperator(CallContext callContext, ConversionMap conversionMap) {
        OperatorEntry entry = this.getEntry(callContext.getOperatorName());
        List<OperatorResolution> results = entry.resolve(callContext, this, conversionMap);
        OperatorResolution result = null;
        if (results != null) {
            int lowestScore = Integer.MAX_VALUE;
            ArrayList<OperatorResolution> lowestScoringResults = new ArrayList<OperatorResolution>();
            for (OperatorResolution resolution : results) {
                Iterator<DataType> operands = resolution.getOperator().getSignature().getOperandTypes().iterator();
                Iterator<DataType> callOperands = callContext.getSignature().getOperandTypes().iterator();
                Iterator<Conversion> conversions = resolution.hasConversions() ? resolution.getConversions().iterator() : null;
                int score = ConversionMap.ConversionScore.ExactMatch.score();
                while (operands.hasNext()) {
                    DataType operand = operands.next();
                    DataType callOperand = callOperands.next();
                    Conversion conversion = conversions != null ? conversions.next() : null;
                    score += ConversionMap.getConversionScore(callOperand, operand, conversion);
                }
                resolution.setScore(score);
                if (score < lowestScore) {
                    lowestScore = score;
                    lowestScoringResults.clear();
                    lowestScoringResults.add(resolution);
                    continue;
                }
                if (score != lowestScore) continue;
                lowestScoringResults.add(resolution);
            }
            if (lowestScoringResults.size() > 1) {
                if (callContext.getMustResolve()) {
                    StringBuilder message = new StringBuilder("Call to operator ").append(callContext.getOperatorName()).append(callContext.getSignature()).append(" is ambiguous with: ");
                    for (OperatorResolution resolution : lowestScoringResults) {
                        message.append("\n  - ").append(resolution.getOperator().getName()).append(resolution.getOperator().getSignature());
                    }
                    throw new IllegalArgumentException(message.toString());
                }
                return null;
            }
            result = (OperatorResolution)lowestScoringResults.get(0);
        }
        return result;
    }
}

