/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import org.cqframework.cql.cql2elm.model.Signature;
import org.hl7.cql.model.DataType;
import org.hl7.elm.r1.AccessModifier;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.OperandDef;

public class Operator {
    private String libraryName;
    private AccessModifier accessLevel = AccessModifier.PUBLIC;
    private String name;
    private Signature signature;
    private DataType resultType;

    public static Operator fromFunctionDef(FunctionDef functionDef) {
        ArrayList<DataType> operandTypes = new ArrayList<DataType>();
        for (OperandDef operand : functionDef.getOperand()) {
            operandTypes.add(operand.getResultType());
        }
        return new Operator(functionDef.getName(), new Signature(operandTypes.toArray(new DataType[operandTypes.size()])), functionDef.getResultType()).withAccessLevel(functionDef.getAccessLevel());
    }

    public Operator(String name, Signature signature, DataType resultType) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name is null or empty");
        }
        if (signature == null) {
            throw new IllegalArgumentException("signature is null");
        }
        this.name = name;
        this.signature = signature;
        this.resultType = resultType;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        if (libraryName == null || libraryName.equals("")) {
            throw new IllegalArgumentException("libraryName is null.");
        }
        this.libraryName = libraryName;
    }

    public AccessModifier getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(AccessModifier accessLevel) {
        this.accessLevel = accessLevel;
    }

    public Operator withAccessLevel(AccessModifier accessLevel) {
        this.setAccessLevel(accessLevel);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public DataType getResultType() {
        return this.resultType;
    }
}

