/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.InstantiationContextImpl;
import org.cqframework.cql.cql2elm.model.InstantiationResult;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorMap;
import org.cqframework.cql.cql2elm.model.Signature;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.TypeParameter;

public class GenericOperator
extends Operator {
    private List<TypeParameter> typeParameters = new ArrayList<TypeParameter>();

    public GenericOperator(String name, Signature signature, DataType resultType, TypeParameter ... typeParameters) {
        super(name, signature, resultType);
        for (TypeParameter typeParameter : typeParameters) {
            this.typeParameters.add(typeParameter);
        }
    }

    public Iterable<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public InstantiationResult instantiate(Signature callSignature, OperatorMap operatorMap, ConversionMap conversionMap, boolean allowPromotionAndDemotion) {
        return this.instantiate(callSignature, null, operatorMap, conversionMap, allowPromotionAndDemotion);
    }

    public InstantiationResult instantiate(Signature callSignature, Map<TypeParameter, DataType> parameters, OperatorMap operatorMap, ConversionMap conversionMap, boolean allowPromotionAndDemotion) {
        HashMap<TypeParameter, DataType> typeMap = new HashMap<TypeParameter, DataType>();
        for (TypeParameter typeParameter : this.typeParameters) {
            typeMap.put(typeParameter, null);
        }
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                typeMap.put((TypeParameter)entry.getKey(), (DataType)entry.getValue());
            }
        }
        InstantiationContextImpl context = new InstantiationContextImpl(typeMap, operatorMap, conversionMap, allowPromotionAndDemotion);
        Boolean bl = this.getSignature().isInstantiable(callSignature, context);
        if (bl.booleanValue()) {
            Operator result = new Operator(this.getName(), this.getSignature().instantiate(context), this.getResultType().instantiate(context));
            result.setAccessLevel(this.getAccessLevel());
            result.setLibraryName(this.getLibraryName());
            return new InstantiationResult(this, result, context.getConversionScore());
        }
        return new InstantiationResult(this, null, context.getConversionScore());
    }
}

