/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.commons.lang3.text.translate.UnicodeUnescaper;

public class StringEscapeUtils {
    private static final String[][] CQL_CTRL_CHARS_ESCAPE = new String[][]{{"\n", "\\n"}, {"\t", "\\t"}, {"\f", "\\f"}, {"\r", "\\r"}};
    private static final String[][] CQL_CTRL_CHARS_UNESCAPE = EntityArrays.invert(CQL_CTRL_CHARS_ESCAPE);
    public static final CharSequenceTranslator ESACPE_CQL = new LookupTranslator({"\"", "\\\""}, {"\\", "\\\\"}, {"'", "\\'"}).with(new LookupTranslator(StringEscapeUtils.CQL_CTRL_CHARS_ESCAPE())).with(JavaUnicodeEscaper.outsideOf(32, 127));
    public static final CharSequenceTranslator UNESCAPE_CQL = new AggregateTranslator(new UnicodeUnescaper(), new LookupTranslator(StringEscapeUtils.CQL_CTRL_CHARS_UNESCAPE()), new LookupTranslator({"\\\\", "\\"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\`", "`"}, {"\\/", "/"}, {"\\", ""}));

    public static String[][] CQL_CTRL_CHARS_ESCAPE() {
        return (String[][])CQL_CTRL_CHARS_ESCAPE.clone();
    }

    public static String[][] CQL_CTRL_CHARS_UNESCAPE() {
        return (String[][])CQL_CTRL_CHARS_UNESCAPE.clone();
    }

    public static final String escapeCql(String input) {
        return ESACPE_CQL.translate(input);
    }

    public static final String unescapeCql(String input) {
        return UNESCAPE_CQL.translate(input);
    }
}

