/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.NamespaceIterator;

public class TinyTreeEventIterator
implements EventIterator,
LocationProvider {
    private int startNodeNr;
    private int currentNodeNr;
    private int pendingEndEvents = 0;
    private boolean startAtDocument = false;
    private TinyTree tree;
    private PipelineConfiguration pipe;
    private NamespaceBinding[] nsBuffer = new NamespaceBinding[10];

    public TinyTreeEventIterator(TinyNodeImpl startNode, PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.pipe.setLocationProvider(this);
        int kind = startNode.getNodeKind();
        if (kind != 9 && kind != 1) {
            throw new IllegalArgumentException("TinyTreeEventIterator must start at a document or element node");
        }
        this.currentNodeNr = this.startNodeNr = startNode.nodeNr;
        this.tree = startNode.tree;
        this.pendingEndEvents = 0;
        this.startAtDocument = kind == 9;
    }

    public PullEvent next() throws XPathException {
        boolean atEnd;
        short nextDepth;
        if (this.startNodeNr < 0) {
            return null;
        }
        short thisDepth = this.tree.depth[this.currentNodeNr];
        boolean lastNode = this.currentNodeNr + 1 >= this.tree.numberOfNodes;
        short s2 = nextDepth = lastNode ? (short)0 : this.tree.depth[this.currentNodeNr + 1];
        if (nextDepth < this.tree.depth[this.startNodeNr]) {
            nextDepth = this.tree.depth[this.startNodeNr];
        }
        boolean bl = atEnd = thisDepth <= this.tree.depth[this.startNodeNr] && this.currentNodeNr != this.startNodeNr;
        if (atEnd && this.pendingEndEvents == 1) {
            --this.pendingEndEvents;
            this.startNodeNr = -1;
            if (this.startAtDocument) {
                return EndDocumentEvent.getInstance();
            }
            return EndElementEvent.getInstance();
        }
        if (this.pendingEndEvents > 0) {
            --this.pendingEndEvents;
            return EndElementEvent.getInstance();
        }
        byte kind = this.tree.nodeKind[this.currentNodeNr];
        switch (kind) {
            case 9: {
                this.pendingEndEvents = thisDepth - nextDepth + 1;
                ++this.currentNodeNr;
                return StartDocumentEvent.getInstance();
            }
            case 1: {
                this.pendingEndEvents = thisDepth - nextDepth + 1;
                StartElementEvent see = new StartElementEvent(this.pipe);
                see.setElementName(new CodedName(this.tree.nameCode[this.currentNodeNr], this.tree.getNamePool()));
                see.setTypeCode(this.tree.getConfiguration().getSchemaType(this.tree.getTypeAnnotation(this.currentNodeNr)));
                see.setLocationId(this.currentNodeNr);
                int index = this.tree.alpha[this.currentNodeNr];
                if (index >= 0) {
                    while (index < this.tree.numberOfAttributes && this.tree.attParent[index] == this.currentNodeNr) {
                        see.addAttribute(this.tree.getAttributeNode(index++));
                    }
                }
                if (this.currentNodeNr == this.startNodeNr) {
                    ArrayList<NamespaceBinding> list = new ArrayList<NamespaceBinding>();
                    Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(this.tree.getNode(this.currentNodeNr));
                    while (iter.hasNext()) {
                        list.add(iter.next());
                    }
                    see.setLocalNamespaces(list.toArray(new NamespaceBinding[list.size()]));
                } else {
                    see.setLocalNamespaces(TinyElementImpl.getDeclaredNamespaces(this.tree, this.currentNodeNr, this.nsBuffer));
                }
                ++this.currentNodeNr;
                return see;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.pendingEndEvents = thisDepth - nextDepth;
                return this.tree.getNode(this.currentNodeNr++);
            }
            case 12: {
                ++this.currentNodeNr;
                return this.next();
            }
        }
        throw new IllegalStateException("Unknown node kind " + this.tree.nodeKind[this.currentNodeNr]);
    }

    public boolean isFlatSequence() {
        return true;
    }

    public String getSystemId(long locationId) {
        return this.tree.getSystemId((int)locationId);
    }

    public int getLineNumber(long locationId) {
        return this.tree.getLineNumber((int)locationId);
    }

    public int getColumnNumber(long locationId) {
        return this.tree.getColumnNumber((int)locationId);
    }
}

