/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.RuleTarget;

public final class Rule
implements Serializable {
    private Pattern pattern;
    private RuleTarget action;
    private int precedence;
    private int minImportPrecedence;
    private double priority;
    private Rule next;
    private int sequence;
    private boolean alwaysMatches;
    private int rank;

    public Rule(Pattern p, RuleTarget o, int prec, int min2, double prio, int seq) {
        this.pattern = p;
        this.action = o;
        this.precedence = prec;
        this.minImportPrecedence = min2;
        this.priority = prio;
        this.next = null;
        this.sequence = seq;
    }

    public Rule(Rule r) {
        this.pattern = r.pattern;
        this.action = r.action;
        this.precedence = r.precedence;
        this.minImportPrecedence = r.minImportPrecedence;
        this.priority = r.priority;
        this.sequence = r.sequence;
        this.next = r.next == null ? null : new Rule(r.next);
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setAction(RuleTarget action) {
        this.action = action;
    }

    public RuleTarget getAction() {
        return this.action;
    }

    public Rule getNext() {
        return this.next;
    }

    public void setNext(Rule next) {
        this.next = next;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setAlwaysMatches(boolean matches) {
        this.alwaysMatches = matches;
    }

    public boolean isAlwaysMatches() {
        return this.alwaysMatches;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public int compareRank(Rule other) {
        return this.rank - other.rank;
    }

    public int compareComputedRank(Rule other) {
        if (this.precedence == other.precedence) {
            if (this.priority == other.priority) {
                return 0;
            }
            if (this.priority < other.priority) {
                return -1;
            }
            return 1;
        }
        if (this.precedence < other.precedence) {
            return -1;
        }
        return 1;
    }
}

