/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLGeneralIncorporate;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Whitespace;

public class StylesheetModule {
    private XSLStylesheet sourceElement;
    private int precedence;
    private int minImportPrecedence;
    private StylesheetModule importer;
    boolean wasIncluded;
    private int inputTypeAnnotations = 0;
    protected List<Declaration> topLevel = new ArrayList<Declaration>();

    public StylesheetModule(XSLStylesheet sourceElement, int precedence) {
        this.sourceElement = sourceElement;
        this.precedence = precedence;
    }

    public void setImporter(StylesheetModule importer) {
        this.importer = importer;
    }

    public StylesheetModule getImporter() {
        return this.importer;
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this.importer.getPrincipalStylesheetModule();
    }

    public XSLStylesheet getSourceElement() {
        return this.sourceElement;
    }

    public int getPrecedence() {
        return this.wasIncluded ? this.importer.getPrecedence() : this.precedence;
    }

    public void setWasIncluded() {
        this.wasIncluded = true;
    }

    public void setMinImportPrecedence(int min2) {
        this.minImportPrecedence = min2;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void spliceIncludes() throws XPathException {
        Object child;
        boolean foundNonImport = false;
        this.topLevel = new ArrayList<Declaration>(50);
        this.minImportPrecedence = this.precedence;
        StyleElement previousElement = this.sourceElement;
        AxisIterator kids = this.sourceElement.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                previousElement.compileError("No character data is allowed between top-level elements", "XTSE0120");
                continue;
            }
            if (child instanceof DataElement) {
                foundNonImport = true;
                continue;
            }
            previousElement = (StyleElement)child;
            if (child instanceof XSLGeneralIncorporate) {
                XSLGeneralIncorporate xslinc = (XSLGeneralIncorporate)child;
                xslinc.processAttributes();
                if (xslinc.isImport()) {
                    if (foundNonImport && !this.sourceElement.isXslt30Processor()) {
                        xslinc.compileError("xsl:import elements must come first", "XTSE0200");
                    }
                } else {
                    foundNonImport = true;
                }
                xslinc.validateInstruction();
                int errors = this.sourceElement.getPreparedStylesheet().getErrorCount();
                StylesheetModule inc = xslinc.getIncludedStylesheet(this, this.precedence);
                if (inc == null) {
                    return;
                }
                errors = this.sourceElement.getPreparedStylesheet().getErrorCount() - errors;
                if (errors > 0) {
                    xslinc.compileError("Reported " + errors + (errors == 1 ? " error" : " errors") + " in " + (xslinc.isImport() ? "imported" : "included") + " stylesheet module", "XTSE0165");
                }
                if (xslinc.isImport()) {
                    this.precedence = inc.getPrecedence() + 1;
                } else {
                    this.precedence = inc.getPrecedence();
                    inc.setMinImportPrecedence(this.minImportPrecedence);
                    inc.setWasIncluded();
                }
                List<Declaration> incchildren = inc.topLevel;
                for (int j = 0; j < incchildren.size(); ++j) {
                    Declaration decl = incchildren.get(j);
                    int last = this.topLevel.size() - 1;
                    if (last < 0 || decl.getPrecedence() >= this.topLevel.get(last).getPrecedence()) {
                        this.topLevel.add(decl);
                        continue;
                    }
                    while (last >= 0 && decl.getPrecedence() < this.topLevel.get(last).getPrecedence()) {
                        --last;
                    }
                    this.topLevel.add(last + 1, decl);
                }
                continue;
            }
            foundNonImport = true;
            Declaration decl = new Declaration(this, (StyleElement)child);
            this.topLevel.add(decl);
        }
    }

    public int getInputTypeAnnotations() {
        return this.inputTypeAnnotations;
    }

    public void setInputTypeAnnotations(int annotations) throws XPathException {
        this.inputTypeAnnotations |= annotations;
        if (this.inputTypeAnnotations == 3) {
            this.getPrincipalStylesheetModule().compileError("One stylesheet module specifies input-type-annotations='strip', another specifies input-type-annotations='preserve'", "XTSE0265");
        }
    }
}

