/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.CaseVariants;
import net.sf.saxon.regex.Categories;
import net.sf.saxon.regex.GeneralUnicodeString;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.RESyntaxException;
import net.sf.saxon.regex.UnicodeBlocks;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntComplementPredicate;
import net.sf.saxon.z.IntExceptPredicate;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntRangeSet;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSetPredicate;
import net.sf.saxon.z.IntSingletonSet;
import net.sf.saxon.z.IntUnionPredicate;
import net.sf.saxon.z.IntUniversalSet;
import net.sf.saxon.z.IntValuePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RECompiler {
    ArrayList<Operation> instructions = new ArrayList(20);
    UnicodeString pattern;
    int len;
    int idx;
    int parens;
    static final int NODE_NORMAL = 0;
    static final int NODE_NULLABLE = 1;
    static final int NODE_TOPLEVEL = 2;
    static final int bracketUnbounded = -1;
    int bracketMin;
    int bracketOpt;
    boolean isXPath = true;
    boolean isXPath30 = true;
    boolean isXSD11 = false;
    IntHashSet captures = new IntHashSet();
    REFlags reFlags;
    List<String> warnings;

    public void setFlags(REFlags flags) {
        this.reFlags = flags;
        this.isXPath = flags.isAllowsXPath20Extensions();
        this.isXPath30 = flags.isAllowsXPath30Extensions();
        this.isXSD11 = flags.isAllowsXSD11Syntax();
    }

    private void insertNode(Operation node, int insertAt) {
        this.instructions.add(insertAt, node);
    }

    private void warning(String s2) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>(4);
        }
        this.warnings.add(s2);
    }

    public List<String> getWarnings() {
        if (this.warnings == null) {
            return Collections.emptyList();
        }
        return this.warnings;
    }

    void setNextOfEnd(int node, int pointTo) {
        int next = this.instructions.get((int)node).next;
        while (next != 0 && node < this.instructions.size()) {
            if (node == pointTo) {
                pointTo = this.instructions.size();
            }
            next = this.instructions.get((int)(node += next)).next;
        }
        if (node < this.instructions.size()) {
            int offset;
            this.instructions.get((int)node).next = offset = pointTo - node;
        }
    }

    void internalError() throws Error {
        throw new Error("Internal error!");
    }

    void syntaxError(String s2) throws RESyntaxException {
        throw new RESyntaxException(s2, this.idx);
    }

    void bracket() throws RESyntaxException {
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != 123) {
            this.internalError();
        }
        if (this.idx >= this.len || !RECompiler.isAsciiDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        StringBuffer number = new StringBuffer();
        while (this.idx < this.len && RECompiler.isAsciiDigit(this.pattern.charAt(this.idx))) {
            number.append((char)this.pattern.charAt(this.idx++));
        }
        try {
            this.bracketMin = Integer.parseInt(number.toString());
        }
        catch (NumberFormatException e) {
            this.syntaxError("Expected valid number");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == 125) {
            ++this.idx;
            this.bracketOpt = 0;
            return;
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != 44) {
            this.syntaxError("Expected comma");
        }
        if (this.idx >= this.len) {
            this.syntaxError("Expected comma or right bracket");
        }
        if (this.pattern.charAt(this.idx) == 125) {
            ++this.idx;
            this.bracketOpt = -1;
            return;
        }
        if (this.idx >= this.len || !RECompiler.isAsciiDigit(this.pattern.charAt(this.idx))) {
            this.syntaxError("Expected digit");
        }
        number.setLength(0);
        while (this.idx < this.len && RECompiler.isAsciiDigit(this.pattern.charAt(this.idx))) {
            number.append((char)this.pattern.charAt(this.idx++));
        }
        try {
            this.bracketOpt = Integer.parseInt(number.toString()) - this.bracketMin;
        }
        catch (NumberFormatException e) {
            this.syntaxError("Expected valid number");
        }
        if (this.bracketOpt < 0) {
            this.syntaxError("Bad range");
        }
        if (this.idx >= this.len || this.pattern.charAt(this.idx++) != 125) {
            this.syntaxError("Missing close brace");
        }
    }

    private static boolean isAsciiDigit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    IntPredicate escape(boolean inSquareBrackets) throws RESyntaxException {
        if (this.pattern.charAt(this.idx) != 92) {
            this.internalError();
        }
        if (this.idx + 1 == this.len) {
            this.syntaxError("Escape terminates string");
        }
        this.idx += 2;
        int escapeChar = this.pattern.charAt(this.idx - 1);
        switch (escapeChar) {
            case 110: {
                return new IntValuePredicate(10);
            }
            case 114: {
                return new IntValuePredicate(13);
            }
            case 116: {
                return new IntValuePredicate(9);
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 124: 
            case 125: {
                return new IntValuePredicate(escapeChar);
            }
            case 36: {
                if (this.isXPath) {
                    return new IntValuePredicate(escapeChar);
                }
                this.syntaxError("In XSD, '$' must not be escaped");
            }
            case 115: {
                return Categories.ESCAPE_s;
            }
            case 83: {
                return Categories.ESCAPE_S;
            }
            case 105: {
                return Categories.ESCAPE_i;
            }
            case 73: {
                return Categories.ESCAPE_I;
            }
            case 99: {
                return Categories.ESCAPE_c;
            }
            case 67: {
                return Categories.ESCAPE_C;
            }
            case 100: {
                return Categories.ESCAPE_d;
            }
            case 68: {
                return Categories.ESCAPE_D;
            }
            case 119: {
                return Categories.ESCAPE_w;
            }
            case 87: {
                return Categories.ESCAPE_W;
            }
            case 80: 
            case 112: {
                UnicodeString block;
                int close;
                if (this.idx == this.len) {
                    this.syntaxError("Expected '{' after \\" + escapeChar);
                }
                if (this.pattern.charAt(this.idx) != 123) {
                    this.syntaxError("Expected '{' after \\" + escapeChar);
                }
                if ((close = this.pattern.indexOf(125, this.idx++)) == -1) {
                    this.syntaxError("No closing '}' after \\" + escapeChar);
                }
                if ((block = this.pattern.substring(this.idx, close)).length() == 1 || block.length() == 2) {
                    IntPredicate primary = Categories.getCategory(block.toString());
                    if (primary == null) {
                        this.syntaxError("Unknown character category " + block.toString());
                    }
                    this.idx = close + 1;
                    if (escapeChar == 112) {
                        return primary;
                    }
                    return this.makeComplement(primary);
                }
                if (block.toString().startsWith("Is")) {
                    String blockName = block.toString().substring(2);
                    IntSet uniBlock = UnicodeBlocks.getBlock(blockName);
                    if (uniBlock == null) {
                        if (this.reFlags.isAllowUnknownBlockNames()) {
                            this.warning("Unknown Unicode block: " + blockName);
                            this.idx = close + 1;
                            return new IntSetPredicate(IntUniversalSet.getInstance());
                        }
                        this.syntaxError("Unknown Unicode block: " + blockName);
                    }
                    this.idx = close + 1;
                    IntSetPredicate primary = new IntSetPredicate(uniBlock);
                    if (escapeChar == 112) {
                        return primary;
                    }
                    return this.makeComplement(primary);
                }
                this.syntaxError("Unknown character category: " + block);
            }
            case 48: {
                this.syntaxError("Octal escapes not allowed");
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (inSquareBrackets) {
                    this.syntaxError("Backreference not allowed within character class");
                    break;
                }
                if (this.isXPath) {
                    int backRef2;
                    int c1;
                    int backRef = escapeChar - 48;
                    while (this.idx < this.len && (c1 = "0123456789".indexOf(this.pattern.charAt(this.idx))) >= 0 && (backRef2 = backRef * 10 + c1) <= this.parens - 1) {
                        backRef = backRef2;
                        ++this.idx;
                    }
                    if (!this.captures.contains(backRef)) {
                        String explanation = backRef > this.parens - 1 ? "(no such group)" : "(group not yet closed)";
                        this.syntaxError("invalid backreference \\" + backRef + " " + explanation);
                    }
                    return new BackReference(backRef);
                }
                this.syntaxError("digit not allowed after \\");
            }
        }
        this.syntaxError("Escape character '" + (char)escapeChar + "' not allowed");
        return null;
    }

    IntPredicate parseCharacterClass() throws RESyntaxException {
        if (this.pattern.charAt(this.idx) != 91) {
            this.internalError();
        }
        if (this.idx + 1 >= this.len || this.pattern.charAt(++this.idx) == 93) {
            this.syntaxError("Missing ']'");
        }
        boolean positive = true;
        boolean definingRange = false;
        int rangeStart = -1;
        IntRangeSet range = new IntRangeSet();
        IntPredicate addend = null;
        IntPredicate subtrahend = null;
        if (this.thereFollows("^")) {
            if (this.thereFollows("^-[")) {
                this.syntaxError("Nothing before subtraction operator");
            } else if (this.thereFollows("^]")) {
                this.syntaxError("Empty negative character group");
            } else {
                positive = false;
                ++this.idx;
            }
        } else if (this.thereFollows("-[")) {
            this.syntaxError("Nothing before subtraction operator");
        }
        block5: while (this.idx < this.len && this.pattern.charAt(this.idx) != 93) {
            int[] variants;
            int ch = this.pattern.charAt(this.idx);
            int simpleChar = -1;
            switch (ch) {
                case 91: {
                    this.syntaxError("Unescaped '[' within square brackets");
                    break;
                }
                case 92: {
                    IntPredicate cc = this.escape(true);
                    if (cc instanceof IntValuePredicate) {
                        simpleChar = ((IntValuePredicate)cc).getTarget();
                        break;
                    }
                    if (definingRange) {
                        this.syntaxError("Multi-character escape cannot follow '-'");
                        continue block5;
                    }
                    if (addend == null) {
                        addend = cc;
                        continue block5;
                    }
                    addend = this.makeUnion(addend, cc);
                    continue block5;
                }
                case 45: {
                    if (this.thereFollows("-[")) {
                        ++this.idx;
                        subtrahend = this.parseCharacterClass();
                        if (this.thereFollows("]")) break;
                        this.syntaxError("Expected closing ']' after subtraction");
                        break;
                    }
                    if (this.thereFollows("-]")) {
                        simpleChar = 45;
                        ++this.idx;
                        break;
                    }
                    if (rangeStart >= 0) {
                        definingRange = true;
                        ++this.idx;
                        continue block5;
                    }
                    if (definingRange) {
                        this.syntaxError("Bad range");
                        break;
                    }
                    if (this.thereFollows("--") && !this.thereFollows("--[")) {
                        this.syntaxError("Unescaped hyphen as start of range");
                        break;
                    }
                    if (!(this.isXSD11 || this.pattern.charAt(this.idx - 1) == 91 || this.pattern.charAt(this.idx - 1) == 94 || this.thereFollows("]") || this.thereFollows("-["))) {
                        this.syntaxError("In XSD 1.0, hyphen is allowed only at the beginning or end of a positive character group");
                        break;
                    }
                    simpleChar = 45;
                    ++this.idx;
                    break;
                }
                default: {
                    simpleChar = ch;
                    ++this.idx;
                }
            }
            if (definingRange) {
                int rangeEnd = simpleChar;
                if (rangeStart > rangeEnd) {
                    this.syntaxError("Bad character range: start > end");
                }
                range.addRange(rangeStart, rangeEnd);
                if (this.reFlags.isCaseIndependent()) {
                    if (rangeStart == 97 && rangeEnd == 122) {
                        range.addRange(65, 90);
                        for (int v = 0; v < CaseVariants.ROMAN_VARIANTS.length; ++v) {
                            range.add(CaseVariants.ROMAN_VARIANTS[v]);
                        }
                    } else if (rangeStart == 65 && rangeEnd == 90) {
                        range.addRange(97, 122);
                        for (int v = 0; v < CaseVariants.ROMAN_VARIANTS.length; ++v) {
                            range.add(CaseVariants.ROMAN_VARIANTS[v]);
                        }
                    } else {
                        for (int k = rangeStart; k <= rangeEnd; ++k) {
                            int[] variants2;
                            for (int variant : variants2 = CaseVariants.getCaseVariants(k)) {
                                range.add(variant);
                            }
                        }
                    }
                }
                definingRange = false;
                rangeStart = -1;
                continue;
            }
            if (this.thereFollows("-")) {
                if (this.thereFollows("-[")) {
                    range.add(simpleChar);
                    continue;
                }
                if (this.thereFollows("-]")) {
                    range.add(simpleChar);
                    continue;
                }
                if (this.thereFollows("--[")) {
                    range.add(simpleChar);
                    continue;
                }
                if (this.thereFollows("--")) {
                    this.syntaxError("Unescaped hyphen cannot act as end of range");
                    continue;
                }
                rangeStart = simpleChar;
                continue;
            }
            range.add(simpleChar);
            if (!this.reFlags.isCaseIndependent()) continue;
            for (int variant : variants = CaseVariants.getCaseVariants(simpleChar)) {
                range.add(variant);
            }
        }
        if (this.idx == this.len) {
            this.syntaxError("Unterminated character class");
        }
        ++this.idx;
        IntPredicate result = new IntSetPredicate(range);
        if (addend != null) {
            result = this.makeUnion(result, addend);
        }
        if (!positive) {
            result = this.makeComplement(result);
        }
        if (subtrahend != null) {
            result = this.makeDifference(result, subtrahend);
        }
        return result;
    }

    private boolean thereFollows(String s2) {
        return this.idx + s2.length() <= this.len && this.pattern.substring(this.idx, this.idx + s2.length()).toString().equals(s2);
    }

    private IntPredicate makeUnion(IntPredicate p1, IntPredicate p2) {
        if (p1 instanceof IntSetPredicate && ((IntSetPredicate)p1).getIntSet().isEmpty()) {
            return p2;
        }
        if (p2 instanceof IntSetPredicate && ((IntSetPredicate)p2).getIntSet().isEmpty()) {
            return p1;
        }
        return new IntUnionPredicate(p1, p2);
    }

    private IntPredicate makeDifference(IntPredicate p1, IntPredicate p2) {
        return new IntExceptPredicate(p1, p2);
    }

    private IntPredicate makeComplement(IntPredicate p1) {
        if (p1 instanceof IntComplementPredicate) {
            return ((IntComplementPredicate)p1).getOperand();
        }
        return new IntComplementPredicate(p1);
    }

    private int emitCharacterClass(IntPredicate range) {
        Operation.OpCharClass node = new Operation.OpCharClass();
        node.predicate = range;
        return this.appendNode(node);
    }

    /*
     * Unable to fully structure code
     */
    int atom() throws RESyntaxException {
        node = new Operation.OpAtom();
        lenAtom = 0;
        fsb = new FastStringBuffer(64);
        block9: while (this.idx < this.len) {
            if (this.idx + 1 >= this.len) ** GOTO lbl-1000
            c = this.pattern.charAt(this.idx + 1);
            if (this.pattern.charAt(this.idx) == 92) {
                idxEscape = this.idx;
                this.escape(false);
                if (this.idx < this.len) {
                    c = this.pattern.charAt(this.idx);
                }
                this.idx = idxEscape;
            }
            switch (c) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (lenAtom != 0) break block9;
                }
                default: lbl-1000:
                // 2 sources

                {
                    switch (this.pattern.charAt(this.idx)) {
                        case 40: 
                        case 41: 
                        case 46: 
                        case 91: 
                        case 93: 
                        case 124: {
                            break block9;
                        }
                        case 42: 
                        case 43: 
                        case 63: 
                        case 123: {
                            if (lenAtom != 0) break block9;
                            this.syntaxError("No expression before quantifier");
                            break block9;
                        }
                        case 92: {
                            idxBeforeEscape = this.idx;
                            charClass = this.escape(false);
                            if (charClass instanceof BackReference || !(charClass instanceof IntValuePredicate)) {
                                this.idx = idxBeforeEscape;
                                break block9;
                            }
                            fsb.appendWideChar(((IntValuePredicate)charClass).getTarget());
                            ++lenAtom;
                            continue block9;
                        }
                        case 36: 
                        case 94: {
                            if (this.isXPath) break block9;
                        }
                        default: {
                            fsb.appendWideChar(this.pattern.charAt(this.idx++));
                            ++lenAtom;
                            continue block9;
                        }
                    }
                }
            }
        }
        if (fsb.length() == 0) {
            this.internalError();
        }
        node.atom = UnicodeString.makeUnicodeString(fsb.condense());
        return this.appendNode(node);
    }

    private int appendNode(Operation node) {
        this.instructions.add(node);
        return this.instructions.size() - 1;
    }

    int terminal(int[] flags) throws RESyntaxException {
        switch (this.pattern.charAt(this.idx)) {
            case 36: {
                if (!this.isXPath) break;
                flags[0] = flags[0] | 1;
                ++this.idx;
                Operation.OpEOL eol = new Operation.OpEOL();
                return this.appendNode(eol);
            }
            case 94: {
                if (!this.isXPath) break;
                flags[0] = flags[0] | 1;
                ++this.idx;
                Operation.OpBOL bol = new Operation.OpBOL();
                return this.appendNode(bol);
            }
            case 46: {
                ++this.idx;
                IntPredicate predicate = this.reFlags.isSingleLine() ? new IntPredicate(){

                    public boolean matches(int value) {
                        return true;
                    }
                } : new IntPredicate(){

                    public boolean matches(int value) {
                        return value != 10 && value != 13;
                    }
                };
                Operation.OpCharClass dot = new Operation.OpCharClass();
                dot.predicate = predicate;
                return this.appendNode(dot);
            }
            case 91: {
                IntPredicate range = this.parseCharacterClass();
                Operation.OpCharClass cc = new Operation.OpCharClass();
                cc.predicate = range;
                return this.appendNode(cc);
            }
            case 40: {
                return this.expr(flags);
            }
            case 41: {
                this.syntaxError("Unexpected close paren");
            }
            case 124: {
                this.internalError();
            }
            case 93: {
                this.syntaxError("Mismatched class");
            }
            case 0: {
                this.syntaxError("Unexpected end of input");
            }
            case 42: 
            case 43: 
            case 63: 
            case 123: {
                this.syntaxError("No expression before quantifier");
            }
            case 92: {
                int idxBeforeEscape = this.idx;
                IntPredicate esc = this.escape(false);
                if (esc instanceof BackReference) {
                    int backreference = ((BackReference)esc).getTarget();
                    if (this.parens <= backreference) {
                        this.syntaxError("Bad backreference");
                    }
                    flags[0] = flags[0] | 1;
                    Operation.OpBackReference back = new Operation.OpBackReference();
                    back.groupNr = backreference;
                    return this.appendNode(back);
                }
                if (esc instanceof IntSingletonSet) {
                    this.idx = idxBeforeEscape;
                    flags[0] = flags[0] & 0xFFFFFFFE;
                    break;
                }
                flags[0] = flags[0] & 0xFFFFFFFE;
                return this.emitCharacterClass(esc);
            }
        }
        flags[0] = flags[0] & 0xFFFFFFFE;
        return this.atom();
    }

    int piece(int[] flags) throws RESyntaxException {
        int idxBeforeTerminal = this.idx;
        int[] terminalFlags = new int[]{0};
        int ret = this.terminal(terminalFlags);
        flags[0] = flags[0] | terminalFlags[0];
        if (this.idx >= this.len) {
            return ret;
        }
        boolean greedy = true;
        int quantifierType = this.pattern.charAt(this.idx);
        switch (quantifierType) {
            case 42: 
            case 63: {
                flags[0] = flags[0] | 1;
            }
            case 43: {
                ++this.idx;
            }
            case 123: {
                Operation op;
                if (quantifierType == 123) {
                    this.bracket();
                    if (this.bracketMin == 0) {
                        flags[0] = flags[0] | 1;
                    }
                }
                if ((op = this.instructions.get(ret)) instanceof Operation.OpBOL || op instanceof Operation.OpEOL) {
                    if (quantifierType == 63 || quantifierType == 42 || quantifierType == 123 && this.bracketMin == 0) {
                        this.instructions.set(ret, new Operation.OpNothing());
                    } else {
                        quantifierType = 0;
                    }
                }
                if ((terminalFlags[0] & 1) == 0) break;
                if (quantifierType == 63) {
                    quantifierType = 0;
                    break;
                }
                if (quantifierType == 43) {
                    quantifierType = 42;
                    break;
                }
                if (quantifierType != 123) break;
                quantifierType = 42;
            }
        }
        if (this.idx < this.len && this.pattern.charAt(this.idx) == 63) {
            if (!this.isXPath) {
                this.syntaxError("Reluctant quantifiers are not allowed in XSD");
            }
            ++this.idx;
            greedy = false;
        }
        if (greedy) {
            switch (quantifierType) {
                case 123: {
                    int bracketEnd = this.idx;
                    int bracketMin = this.bracketMin;
                    int bracketOpt = this.bracketOpt;
                    int pos = ret;
                    for (int c = 0; c < bracketMin; ++c) {
                        this.idx = idxBeforeTerminal;
                        int n = pos;
                        pos = this.terminal(terminalFlags);
                        this.setNextOfEnd(n, pos);
                    }
                    if (bracketOpt == -1) {
                        this.idx = bracketEnd;
                        Operation.OpStar op = new Operation.OpStar();
                        this.insertNode(op, pos);
                        this.setNextOfEnd(pos + 1, pos);
                        break;
                    }
                    if (bracketOpt > 0) {
                        int[] opt = new int[bracketOpt + 1];
                        Operation.OpMaybe op = new Operation.OpMaybe();
                        this.insertNode(op, pos);
                        opt[0] = pos;
                        for (int c = 1; c < bracketOpt; ++c) {
                            op = new Operation.OpMaybe();
                            opt[c] = this.appendNode(op);
                            this.idx = idxBeforeTerminal;
                            this.terminal(terminalFlags);
                        }
                        int end = opt[bracketOpt] = this.appendNode(new Operation.OpNothing());
                        for (int c = 0; c < bracketOpt; ++c) {
                            this.setNextOfEnd(opt[c], end);
                            this.setNextOfEnd(opt[c] + 1, opt[c + 1]);
                        }
                    } else {
                        while (this.instructions.size() > pos) {
                            this.instructions.remove(this.instructions.size() - 1);
                        }
                        Operation.OpNothing nothing = new Operation.OpNothing();
                        this.appendNode(nothing);
                    }
                    this.idx = bracketEnd;
                    break;
                }
                case 63: {
                    Operation.OpMaybe maybe = new Operation.OpMaybe();
                    this.insertNode(maybe, ret);
                    Operation.OpNothing nothing = new Operation.OpNothing();
                    int n = this.appendNode(nothing);
                    this.setNextOfEnd(ret, n);
                    this.setNextOfEnd(ret + 1, n);
                    break;
                }
                case 42: {
                    Operation.OpStar star = new Operation.OpStar();
                    this.insertNode(star, ret);
                    this.setNextOfEnd(ret + 1, ret);
                    break;
                }
                case 43: {
                    Operation.OpContinue continu = new Operation.OpContinue();
                    this.insertNode(continu, ret);
                    Operation.OpPlus plus = new Operation.OpPlus();
                    int n = this.appendNode(plus);
                    this.setNextOfEnd(ret + 1, n);
                    this.setNextOfEnd(n, ret);
                    break;
                }
            }
        } else {
            switch (quantifierType) {
                case 63: {
                    Operation.OpReluctantMaybe reluctantMaybe = new Operation.OpReluctantMaybe();
                    this.insertNode(reluctantMaybe, ret);
                    int n = this.appendNode(new Operation.OpNothing());
                    this.setNextOfEnd(ret, n);
                    this.setNextOfEnd(ret + 1, n);
                    break;
                }
                case 42: {
                    Operation.OpReluctantStar reluctantStar = new Operation.OpReluctantStar();
                    this.insertNode(reluctantStar, ret);
                    this.setNextOfEnd(ret + 1, ret);
                    break;
                }
                case 43: {
                    this.insertNode(new Operation.OpContinue(), ret);
                    int n = this.appendNode(new Operation.OpReluctantPlus());
                    this.setNextOfEnd(n, ret);
                    this.setNextOfEnd(ret + 1, n);
                    break;
                }
                case 123: {
                    int bracketEnd = this.idx;
                    int bracketMin = this.bracketMin;
                    int bracketOpt = this.bracketOpt;
                    int pos = ret;
                    for (int c = 0; c < bracketMin; ++c) {
                        this.idx = idxBeforeTerminal;
                        int n = pos;
                        pos = this.terminal(terminalFlags);
                        this.setNextOfEnd(n, pos);
                    }
                    if (bracketOpt == -1) {
                        this.idx = bracketEnd;
                        this.insertNode(new Operation.OpReluctantStar(), pos);
                        this.setNextOfEnd(pos + 1, pos);
                        break;
                    }
                    if (bracketOpt > 0) {
                        int[] opt = new int[bracketOpt + 1];
                        this.insertNode(new Operation.OpReluctantMaybe(), pos);
                        opt[0] = pos;
                        for (int c = 1; c < bracketOpt; ++c) {
                            opt[c] = this.appendNode(new Operation.OpReluctantMaybe());
                            this.idx = idxBeforeTerminal;
                            this.terminal(terminalFlags);
                        }
                        int end = opt[bracketOpt] = this.appendNode(new Operation.OpNothing());
                        for (int c = 0; c < bracketOpt; ++c) {
                            this.setNextOfEnd(opt[c], end);
                            this.setNextOfEnd(opt[c] + 1, opt[c + 1]);
                        }
                    } else {
                        while (this.instructions.size() > pos) {
                            this.instructions.remove(this.instructions.size() - 1);
                        }
                        this.appendNode(new Operation.OpNothing());
                    }
                    this.idx = bracketEnd;
                    break;
                }
            }
        }
        return ret;
    }

    int branch(int[] compilerFlags) throws RESyntaxException {
        int ret = -1;
        int chain = -1;
        int[] quantifierFlags = new int[1];
        boolean nullable = true;
        while (this.idx < this.len && this.pattern.charAt(this.idx) != 124 && this.pattern.charAt(this.idx) != 41) {
            quantifierFlags[0] = 0;
            int node = this.piece(quantifierFlags);
            if (quantifierFlags[0] == 0) {
                nullable = false;
            }
            if (chain != -1) {
                this.setNextOfEnd(chain, node);
            }
            chain = node;
            if (ret != -1) continue;
            ret = node;
        }
        if (ret == -1) {
            Operation.OpNothing nothing = new Operation.OpNothing();
            ret = this.appendNode(nothing);
        }
        if (nullable) {
            compilerFlags[0] = compilerFlags[0] | 1;
        }
        return ret;
    }

    int expr(int[] compilerFlags) throws RESyntaxException {
        int currentNode;
        int end;
        int paren = -1;
        int ret = -1;
        int closeParens = this.parens;
        if ((compilerFlags[0] & 2) == 0 && this.pattern.charAt(this.idx) == 40) {
            if (this.idx + 2 < this.len && this.pattern.charAt(this.idx + 1) == 63 && this.pattern.charAt(this.idx + 2) == 58) {
                if (!this.isXPath30) {
                    this.syntaxError("Non-capturing groups allowed only in XPath3.0");
                }
                paren = 2;
                this.idx += 3;
                ret = this.appendNode(new Operation.OpOpenCluster());
            } else {
                paren = 1;
                ++this.idx;
                ret = this.appendNode(new Operation.OpOpen(this.parens++));
            }
        }
        compilerFlags[0] = compilerFlags[0] & 0xFFFFFFFD;
        boolean open = false;
        int branch = this.branch(compilerFlags);
        if (ret == -1) {
            ret = branch;
        } else {
            this.setNextOfEnd(ret, branch);
        }
        while (this.idx < this.len && this.pattern.charAt(this.idx) == 124) {
            if (!open) {
                Operation.OpBranch op = new Operation.OpBranch();
                this.insertNode(op, branch);
                open = true;
            }
            ++this.idx;
            int n = branch;
            branch = this.appendNode(new Operation.OpBranch());
            this.setNextOfEnd(n, branch);
            this.branch(compilerFlags);
        }
        if (paren > 0) {
            if (this.idx < this.len && this.pattern.charAt(this.idx) == 41) {
                ++this.idx;
            } else {
                this.syntaxError("Missing close paren");
            }
            if (paren == 1) {
                end = this.appendNode(new Operation.OpClose(closeParens));
                this.captures.add(closeParens);
            } else {
                end = this.appendNode(new Operation.OpCloseCluster());
            }
        } else {
            end = this.appendNode(new Operation.OpEndProgram());
        }
        this.setNextOfEnd(ret, end);
        int nextNodeOffset = this.instructions.get((int)currentNode).next;
        for (currentNode = ret; nextNodeOffset != 0 && currentNode < this.instructions.size(); currentNode += nextNodeOffset) {
            if (this.instructions.get(currentNode) instanceof Operation.OpBranch) {
                this.setNextOfEnd(currentNode + 1, end);
            }
            nextNodeOffset = this.instructions.get((int)currentNode).next;
        }
        return ret;
    }

    public REProgram compile(UnicodeString pattern) throws RESyntaxException {
        this.pattern = pattern;
        this.len = pattern.length();
        this.idx = 0;
        this.parens = 1;
        boolean nullable = false;
        if (this.reFlags.isLiteral()) {
            int ret = this.literalAtom();
            Operation.OpEndProgram endNode = new Operation.OpEndProgram();
            int end = this.appendNode(endNode);
            this.setNextOfEnd(ret, end);
        } else {
            if (this.reFlags.isAllowWhitespace()) {
                FastStringBuffer sb = new FastStringBuffer(pattern.length());
                int nesting = 0;
                boolean astral = false;
                boolean escaped = false;
                for (int i = 0; i < pattern.length(); ++i) {
                    int ch = pattern.charAt(i);
                    if (ch > 65535) {
                        astral = true;
                    }
                    if (ch == 92 && !escaped) {
                        escaped = true;
                        sb.appendWideChar(ch);
                        continue;
                    }
                    if (ch == 91 && !escaped) {
                        ++nesting;
                        escaped = false;
                        sb.appendWideChar(ch);
                        continue;
                    }
                    if (ch == 93 && !escaped) {
                        --nesting;
                        escaped = false;
                        sb.appendWideChar(ch);
                        continue;
                    }
                    if (nesting == 0 && Whitespace.isWhitespace(ch)) continue;
                    escaped = false;
                    sb.appendWideChar(ch);
                }
                pattern = astral ? new GeneralUnicodeString(sb) : new BMPString(sb);
                this.pattern = pattern;
                this.len = pattern.length();
            }
            int[] compilerFlags = new int[]{2};
            this.expr(compilerFlags);
            boolean bl = nullable = (compilerFlags[0] & 1) != 0;
            if (this.idx != this.len) {
                if (pattern.charAt(this.idx) == 41) {
                    this.syntaxError("Unmatched close paren");
                }
                this.syntaxError("Unexpected input remains");
            }
        }
        Operation[] ops = new Operation[this.instructions.size()];
        for (int i = 0; i < this.instructions.size(); ++i) {
            Operation op = this.instructions.get(i);
            op.next = op.next == 0 ? -1 : (op.next += i);
            ops[i] = op;
        }
        REProgram program = new REProgram(ops, this.parens, this.reFlags);
        if (this.reFlags.isDebug()) {
            program.display(System.err);
        }
        program.setNullable(nullable);
        return program;
    }

    int literalAtom() {
        Operation.OpAtom node = new Operation.OpAtom();
        node.atom = this.pattern;
        return this.appendNode(node);
    }

    class BackReference
    extends IntValuePredicate {
        public BackReference(int number) {
            super(number);
        }
    }
}

