/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.z.IntPredicate;

public abstract class Operation {
    public int next;
    public static final int ACTION_ADVANCE_TO_NEXT = 1;
    public static final int ACTION_RETURN = 2;
    public static final int ACTION_ADVANCE_TO_FOLLOWING = 3;
    public static final int ACTION_ADVANCE_TO_NEXT_NEXT = 4;

    abstract int exec(REMatcher var1, int var2, int var3);

    public int nextAction(int idx) {
        if (idx == -1) {
            return 2;
        }
        return 1;
    }

    public static class OpCharClass
    extends Operation {
        IntPredicate predicate;

        public int exec(REMatcher matcher, int node, int idx) {
            UnicodeString search = matcher.search;
            if (search.isEnd(idx)) {
                return -1;
            }
            if (!this.predicate.matches(search.charAt(idx))) {
                return -1;
            }
            return idx + 1;
        }

        public String toString() {
            return "CHAR_CLASS (" + this.predicate.getClass() + ") ";
        }
    }

    public static class OpReluctantMaybe
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            if (matcher.beenHereBefore(idx, node)) {
                return -1;
            }
            int idxNew = matcher.matchNodes(this.next, idx);
            if (idxNew != -1) {
                return idxNew;
            }
            return matcher.matchNodes(node + 1, this.next, idx);
        }

        public int nextAction(int idx) {
            return 2;
        }

        public String toString() {
            return "RELUCTANT_MAYBE";
        }
    }

    public static class OpReluctantPlus
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            return matcher.matchNodes(matcher.instructions[this.next].next, idx);
        }

        public int nextAction(int idx) {
            if (idx == -1) {
                return 1;
            }
            return 2;
        }

        public String toString() {
            return "RELUCTANT_PLUS";
        }
    }

    public static class OpReluctantStar
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            if (matcher.beenHereBefore(idx, node)) {
                return -1;
            }
            int idxNew = matcher.matchNodes(this.next, idx);
            if (idxNew != -1) {
                return idxNew;
            }
            return matcher.matchNodes(node + 1, this.next, idx);
        }

        public int nextAction(int idx) {
            return 2;
        }

        public String toString() {
            return "RELUCTANT_STAR";
        }
    }

    public static class OpContinue
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            return idx;
        }

        public int nextAction(int idx) {
            return 3;
        }

        public String toString() {
            return "CONTINUE";
        }
    }

    public static class OpNothing
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            return idx;
        }

        public int nextAction(int idx) {
            return 1;
        }

        public String toString() {
            return "NOTHING";
        }
    }

    public static class OpGoTo
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            return idx;
        }

        public int nextAction(int idx) {
            return 1;
        }

        public String toString() {
            return "GOTO";
        }
    }

    public static class OpBackReference
    extends Operation {
        public int groupNr;

        public int exec(REMatcher matcher, int node, int idx) {
            int s2 = matcher.startBackref[this.groupNr];
            int e = matcher.endBackref[this.groupNr];
            if (s2 == -1 || e == -1) {
                return -1;
            }
            if (s2 == e) {
                return idx;
            }
            UnicodeString search = matcher.search;
            int l = e - s2;
            if (search.isEnd(idx + l - 1)) {
                return -1;
            }
            if (matcher.program.flags.isCaseIndependent()) {
                for (int i = 0; i < l; ++i) {
                    if (matcher.equalCaseBlind(search.charAt(idx++), search.charAt(s2 + i))) continue;
                    return -1;
                }
            } else {
                for (int i = 0; i < l; ++i) {
                    if (search.charAt(idx++) == search.charAt(s2 + i)) continue;
                    return -1;
                }
            }
            return idx;
        }

        public String toString() {
            return "BACKREF " + this.groupNr;
        }
    }

    public static class OpCloseCluster
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            return idx;
        }

        public int nextAction(int idx) {
            return 1;
        }

        public String toString() {
            return "CLOSE_CLUSTER";
        }
    }

    public static class OpClose
    extends Operation {
        public int groupNr;

        public OpClose(int groupNr) {
            this.groupNr = groupNr;
        }

        public int exec(REMatcher matcher, int node, int idx) {
            int idxNew;
            if ((matcher.program.optimizationFlags & 1) != 0) {
                matcher.endBackref[this.groupNr] = idx;
            }
            if ((idxNew = matcher.matchNodes(this.next, idx)) != -1) {
                if (this.groupNr >= matcher.parenCount) {
                    matcher.parenCount = this.groupNr + 1;
                }
                if (matcher.getParenEnd(this.groupNr) == -1) {
                    matcher.setParenEnd(this.groupNr, idx);
                }
            }
            return idxNew;
        }

        public int nextAction(int idx) {
            return 2;
        }

        public String toString() {
            return "CLOSE_GROUP " + this.groupNr;
        }
    }

    public static class OpOpenCluster
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            return idx;
        }

        public int nextAction(int idx) {
            return 1;
        }

        public String toString() {
            return "OPEN_CLUSTER";
        }
    }

    public static class OpOpen
    extends Operation {
        public int groupNr;

        public OpOpen(int group) {
            this.groupNr = group;
        }

        public int exec(REMatcher matcher, int node, int idx) {
            int idxNew;
            if ((matcher.program.optimizationFlags & 1) != 0) {
                matcher.startBackref[this.groupNr] = idx;
            }
            if ((idxNew = matcher.matchNodes(this.next, idx)) != -1) {
                if (this.groupNr >= matcher.parenCount) {
                    matcher.parenCount = this.groupNr + 1;
                }
                if (matcher.getParenStart(this.groupNr) == -1) {
                    matcher.setParenStart(this.groupNr, idx);
                }
            }
            return idxNew;
        }

        public int nextAction(int idx) {
            return 2;
        }

        public String toString() {
            return "OPEN_GROUP " + this.groupNr;
        }
    }

    public static class OpMaybe
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            if (matcher.beenHereBefore(idx, node)) {
                return -1;
            }
            return matcher.matchNodes(node + 1, idx);
        }

        public int nextAction(int idx) {
            if (idx == -1) {
                return 1;
            }
            return 2;
        }

        public String toString() {
            return "MAYBE";
        }
    }

    public static class OpConfidentPlus
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            if (matcher.beenHereBefore(idx, node)) {
                return -1;
            }
            Operation term = matcher.instructions[node - 1];
            int newIdx;
            while ((newIdx = term.exec(matcher, node - 1, idx)) != -1) {
                idx = newIdx;
            }
            return idx;
        }

        public int nextAction(int idx) {
            return 1;
        }

        public String toString() {
            return "CONFIDENT_PLUS";
        }
    }

    public static class OpPlus
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            return matcher.matchNodes(this.next, idx);
        }

        public int nextAction(int idx) {
            if (idx == -1) {
                return 4;
            }
            return 2;
        }

        public String toString() {
            return "PLUS";
        }
    }

    public static class OpConfidentStar
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            if (matcher.beenHereBefore(idx, node)) {
                return -1;
            }
            Operation term = matcher.instructions[node + 1];
            int newIdx;
            while ((newIdx = term.exec(matcher, node + 1, idx)) != -1) {
                idx = newIdx;
            }
            return idx;
        }

        public int nextAction(int idx) {
            return 1;
        }

        public String toString() {
            return "CONFIDENT_STAR";
        }
    }

    public static class OpStar
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            if (matcher.beenHereBefore(idx, node)) {
                return -1;
            }
            return matcher.matchNodes(node + 1, idx);
        }

        public int nextAction(int idx) {
            if (idx == -1) {
                return 1;
            }
            return 2;
        }

        public String toString() {
            return "STAR";
        }
    }

    public static class OpAtom
    extends Operation {
        public UnicodeString atom;

        public int exec(REMatcher matcher, int node, int idx) {
            UnicodeString search = matcher.search;
            if (search.isEnd(idx)) {
                return -1;
            }
            if (search.isEnd(this.atom.length() + idx - 1)) {
                return -1;
            }
            if (matcher.program.flags.isCaseIndependent()) {
                for (int i = 0; i < this.atom.length(); ++i) {
                    if (matcher.equalCaseBlind(search.charAt(idx++), this.atom.charAt(i))) continue;
                    return -1;
                }
            } else {
                for (int i = 0; i < this.atom.length(); ++i) {
                    if (search.charAt(idx++) == this.atom.charAt(i)) continue;
                    return -1;
                }
            }
            return idx;
        }

        public String toString() {
            return "ATOM \"" + this.atom.toString() + "\"";
        }
    }

    public static class OpBranch
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            do {
                int idxNew;
                if ((idxNew = matcher.matchNodes(node + 1, idx)) == -1) continue;
                return idxNew;
            } while ((node = matcher.instructions[node].next) != -1 && matcher.program.instructions[node] instanceof OpBranch);
            return -1;
        }

        public int nextAction(int idx) {
            return 2;
        }

        public String toString() {
            return "BRANCH";
        }
    }

    public static class OpEOL
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            UnicodeString search = matcher.search;
            if (matcher.program.flags.isMultiLine()) {
                if (search.isEnd(0) || search.isEnd(idx) || matcher.isNewline(idx)) {
                    return idx;
                }
                return -1;
            }
            if (search.isEnd(0) || search.isEnd(idx)) {
                return idx;
            }
            return -1;
        }

        public String toString() {
            return "EOL";
        }
    }

    public static class OpBOL
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            if (idx != 0) {
                if (matcher.program.flags.isMultiLine() && matcher.isNewline(idx - 1) && !matcher.search.isEnd(idx)) {
                    return idx;
                }
                return -1;
            }
            return idx;
        }

        public String toString() {
            return "BOL";
        }
    }

    public static class OpEndProgram
    extends Operation {
        public int exec(REMatcher matcher, int node, int idx) {
            if (matcher.anchoredMatch) {
                return matcher.search.isEnd(idx) ? idx : -1;
            }
            matcher.setParenEnd(0, idx);
            return idx;
        }

        public int nextAction(int idx) {
            return 2;
        }

        public String toString() {
            return "END";
        }
    }
}

