/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntToIntHashMap;

public class ARegexIterator
implements RegexIterator {
    private UnicodeString theString;
    private UnicodeString regex;
    private REMatcher matcher;
    private UnicodeString current;
    private UnicodeString next;
    private int position = 0;
    private int prevEnd = 0;
    private IntToIntHashMap nestingTable = null;

    public ARegexIterator(UnicodeString string, UnicodeString regex, REMatcher matcher) {
        this.theString = string;
        this.regex = regex;
        this.matcher = matcher;
        this.next = null;
    }

    public Item next() throws XPathException {
        try {
            if (this.next == null && this.prevEnd >= 0) {
                if (this.matcher.match(this.theString, this.prevEnd)) {
                    int start = this.matcher.getParenStart(0);
                    int end = this.matcher.getParenEnd(0);
                    if (this.prevEnd == start) {
                        this.next = null;
                        this.current = this.theString.substring(start, end);
                        this.prevEnd = end;
                    } else {
                        this.current = this.theString.substring(this.prevEnd, start);
                        this.next = this.theString.substring(start, end);
                    }
                } else {
                    if (this.prevEnd >= this.theString.length()) {
                        this.current = null;
                        this.position = -1;
                        this.prevEnd = -1;
                        return null;
                    }
                    this.current = this.theString.substring(this.prevEnd, this.theString.length());
                    this.next = null;
                    this.prevEnd = -1;
                }
            } else if (this.prevEnd >= 0) {
                this.current = this.next;
                this.next = null;
                this.prevEnd = this.matcher.getParenEnd(0);
            } else {
                this.current = null;
                this.position = -1;
                return null;
            }
            ++this.position;
            return this.currentStringValue();
        }
        catch (StackOverflowError e) {
            XPathException xe = new XPathException("Stack overflow (excessive recursion) during regular expression evaluation");
            xe.setErrorCode("SXRE0001");
            throw xe;
        }
    }

    private StringValue currentStringValue() {
        if (this.current instanceof BMPString) {
            return StringValue.makeStringValue(((BMPString)this.current).getCharSequence());
        }
        return StringValue.makeStringValue(this.current.toString());
    }

    public Item current() {
        return this.currentStringValue();
    }

    public int position() {
        return this.position;
    }

    public void close() {
    }

    public SequenceIterator getAnother() {
        return new ARegexIterator(this.theString, this.regex, new REMatcher(this.matcher.getProgram()));
    }

    public int getProperties() {
        return 0;
    }

    public boolean isMatching() {
        return this.next == null && this.prevEnd >= 0;
    }

    public String getRegexGroup(int number) {
        if (!this.isMatching()) {
            return null;
        }
        if (number >= this.matcher.getParenCount() || number < 0) {
            return "";
        }
        UnicodeString us = this.matcher.getParen(number);
        return us == null ? "" : us.toString();
    }

    public SequenceIterator getRegexGroupIterator() {
        int c = this.matcher.getParenCount() - 1;
        if (c == 0) {
            return EmptyIterator.getInstance();
        }
        Item[] groups = new StringValue[c];
        for (int i = 1; i <= groups.length; ++i) {
            groups[i - 1] = StringValue.makeStringValue(this.matcher.getParen(i).toString());
        }
        return new ArrayIterator(groups);
    }

    public void processMatchingSubstring(XPathContext context, RegexIterator.OnGroup action) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        int c = this.matcher.getParenCount() - 1;
        if (c == 0) {
            out.characters(this.current.toString(), 0, 0);
        } else {
            IntHashMap actions = new IntHashMap(c);
            for (int i = 1; i <= c; ++i) {
                int start = this.matcher.getParenStart(i) - this.matcher.getParenStart(0);
                if (start == -1) continue;
                int end = this.matcher.getParenEnd(i) - this.matcher.getParenStart(0);
                if (start < end) {
                    ArrayList<Integer> s2 = (ArrayList<Integer>)actions.get(start);
                    if (s2 == null) {
                        s2 = new ArrayList<Integer>(4);
                        actions.put(start, s2);
                    }
                    s2.add(i);
                    ArrayList<Integer> e = (ArrayList<Integer>)actions.get(end);
                    if (e == null) {
                        e = new ArrayList<Integer>(4);
                        actions.put(end, e);
                    }
                    e.add(0, -i);
                    continue;
                }
                if (this.nestingTable == null) {
                    this.computeNestingTable();
                }
                int parentGroup = this.nestingTable.get(i);
                ArrayList<Integer> s3 = (ArrayList<Integer>)actions.get(start);
                if (s3 == null) {
                    s3 = new ArrayList<Integer>(4);
                    actions.put(start, s3);
                    s3.add(i);
                    s3.add(-i);
                    continue;
                }
                int pos = s3.size();
                for (int e = 0; e < s3.size(); ++e) {
                    if ((Integer)s3.get(e) != -parentGroup) continue;
                    pos = e;
                    break;
                }
                s3.add(pos, -i);
                s3.add(pos, i);
            }
            FastStringBuffer buff = new FastStringBuffer(this.current.length());
            for (int i = 0; i < this.current.length() + 1; ++i) {
                List events = (List)actions.get(i);
                if (events != null) {
                    if (buff.length() > 0) {
                        out.characters(buff, 0, 0);
                        buff.setLength(0);
                    }
                    for (Integer group : events) {
                        if (group > 0) {
                            action.onGroupStart(context, group);
                            continue;
                        }
                        action.onGroupEnd(context, -group.intValue());
                    }
                }
                if (i >= this.current.length()) continue;
                buff.appendWideChar(this.current.charAt(i));
            }
            if (buff.length() > 0) {
                out.characters(buff, 0, 0);
            }
        }
    }

    public RegexIterator getSnapShot(XPathContext context) throws XPathException {
        ARegexIterator regexItr = new ARegexIterator(this.theString, this.regex, this.matcher);
        regexItr.position = this.position;
        regexItr.current = this.current;
        regexItr.nestingTable = this.nestingTable;
        regexItr.prevEnd = this.prevEnd;
        return regexItr;
    }

    private void computeNestingTable() {
        this.nestingTable = new IntToIntHashMap(16);
        UnicodeString s2 = this.regex;
        int[] stack = new int[s2.length()];
        int tos = 0;
        int group = 1;
        int inBrackets = 0;
        stack[tos++] = 0;
        for (int i = 0; i < s2.length(); ++i) {
            int ch = s2.charAt(i);
            if (ch == 39) {
                ++i;
                continue;
            }
            if (ch == 91) {
                ++inBrackets;
                continue;
            }
            if (ch == 93) {
                --inBrackets;
                continue;
            }
            if (ch == 40 && s2.charAt(i + 1) != 63 && inBrackets == 0) {
                this.nestingTable.put(group, stack[tos - 1]);
                stack[tos++] = group++;
                continue;
            }
            if (ch != 41 || inBrackets != 0) continue;
            --tos;
        }
    }
}

