/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public abstract class NodeTest
implements ItemType,
Serializable {
    public boolean matches(Item item, XPathContext context) {
        return this.matchesItem(item, false, context.getConfiguration());
    }

    public boolean matchesItem(Item item, boolean allowURIPromotion, Configuration config) {
        return item instanceof NodeInfo && this.matches((NodeInfo)item);
    }

    public ItemType getSuperType(TypeHierarchy th) {
        return AnyNodeTest.getInstance();
    }

    public ItemType getPrimitiveItemType() {
        int p = this.getPrimitiveType();
        if (p == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(p);
    }

    public int getPrimitiveType() {
        return 0;
    }

    public int getFingerprint() {
        return -1;
    }

    public boolean isAtomicType() {
        return false;
    }

    public boolean isPlainType() {
        return false;
    }

    public AtomicType getAtomizedItemType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public boolean isAtomizable() {
        return true;
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        return this.matches(tree.getNode(nodeNr));
    }

    public abstract boolean matches(int var1, NodeName var2, int var3);

    public boolean matches(NodeInfo node) {
        return this.matches(node.getNodeKind(), new NameOfNode(node), node.getTypeAnnotation());
    }

    public int getNodeKindMask() {
        return 9102;
    }

    public SchemaType getContentType() {
        int m3 = this.getNodeKindMask();
        switch (m3) {
            case 512: {
                return AnyType.getInstance();
            }
            case 2: {
                return AnyType.getInstance();
            }
            case 4: {
                return AnySimpleType.getInstance();
            }
            case 256: {
                return BuiltInAtomicType.STRING;
            }
            case 8: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 128: {
                return BuiltInAtomicType.STRING;
            }
            case 8192: {
                return BuiltInAtomicType.STRING;
            }
        }
        return AnyType.getInstance();
    }

    public IntSet getRequiredNodeNames() {
        return IntUniversalSet.getInstance();
    }

    public boolean isNillable() {
        return true;
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
    }
}

