/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.CurrentItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GroupVariableReference;
import net.sf.saxon.expr.HomogeneityChecker;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SingleItemFilter;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.instruct.ApplyImports;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExpressionParser;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.sort.ConditionalSorter;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.om.Chain;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonClosure;
import net.sf.saxon.value.SingletonItem;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionTool {
    public static final int UNDECIDED = -1;
    public static final int NO_EVALUATION_NEEDED = 0;
    public static final int EVALUATE_VARIABLE = 1;
    public static final int MAKE_CLOSURE = 3;
    public static final int MAKE_MEMO_CLOSURE = 4;
    public static final int RETURN_EMPTY_SEQUENCE = 5;
    public static final int EVALUATE_AND_MATERIALIZE_VARIABLE = 6;
    public static final int CALL_EVALUATE_ITEM = 7;
    public static final int ITERATE_AND_MATERIALIZE = 8;
    public static final int PROCESS = 9;
    public static final int LAZY_TAIL_EXPRESSION = 10;
    public static final int SHARED_APPEND_EXPRESSION = 11;
    public static final int MAKE_INDEXED_VARIABLE = 12;
    public static final int MAKE_SINGLETON_CLOSURE = 13;
    public static final int EVALUATE_SUPPLIED_PARAMETER = 14;

    private ExpressionTool() {
    }

    public static Expression make(String expression, StaticContext env, Container container, int start, int terminator, int lineNumber, CodeInjector codeInjector) throws XPathException {
        ExpressionParser parser = env.getConfiguration().newExpressionParser("XP", false, env.getXPathLanguageLevel());
        parser.setDefaultContainer(container);
        if (codeInjector != null) {
            parser.setCodeInjector(codeInjector);
        }
        if (terminator == -1) {
            terminator = 0;
        }
        Expression exp = parser.parse(expression, start, terminator, lineNumber, env);
        exp = ExpressionVisitor.make(env, exp.getExecutable()).simplify(exp);
        return exp;
    }

    public static void copyLocationInfo(Expression from, Expression to) {
        if (from != null && to != null) {
            if (to.getLocationId() == -1) {
                to.setLocationId(from.getLocationId());
            }
            to.setContainer(from.getContainer());
        }
    }

    public static Expression unsorted(Optimizer opt, Expression exp, boolean retainAllNodes) throws XPathException {
        if (exp instanceof Literal) {
            return exp;
        }
        return exp.unordered(retainAllNodes);
    }

    public static Expression unsortedIfHomogeneous(Optimizer opt, Expression exp) throws XPathException {
        if (exp instanceof Literal) {
            return exp;
        }
        if (exp.getItemType(opt.getConfiguration().getTypeHierarchy()) instanceof AnyItemType) {
            return exp;
        }
        return exp.unordered(false);
    }

    public static int lazyEvaluationMode(Expression exp) {
        if (exp instanceof Literal) {
            return 0;
        }
        if (exp instanceof VariableReference) {
            return 1;
        }
        if (exp instanceof SuppliedParameterReference) {
            return 14;
        }
        if ((exp.getDependencies() & 0x6D) != 0) {
            return ExpressionTool.eagerEvaluationMode(exp);
        }
        if (exp instanceof ErrorExpression) {
            return 7;
        }
        if (!Cardinality.allowsMany(exp.getCardinality())) {
            return ExpressionTool.eagerEvaluationMode(exp);
        }
        if (exp instanceof TailExpression) {
            TailExpression tail = (TailExpression)exp;
            Expression base = tail.getBaseExpression();
            if (base instanceof VariableReference) {
                return 10;
            }
            return 3;
        }
        if (exp instanceof Block && ((Block)exp).isCandidateForSharedAppend()) {
            return 11;
        }
        return 3;
    }

    public static int eagerEvaluationMode(Expression exp) {
        if (exp instanceof Literal && !(((Literal)exp).getValue() instanceof Closure)) {
            return 0;
        }
        if (exp instanceof VariableReference) {
            return 6;
        }
        int m3 = exp.getImplementationMethod();
        if ((m3 & 1) != 0) {
            return 7;
        }
        if ((m3 & 2) != 0) {
            return 8;
        }
        return 9;
    }

    public static Sequence evaluate(Expression exp, int evaluationMode, XPathContext context, int ref) throws XPathException {
        switch (evaluationMode) {
            case 0: {
                return ((Literal)exp).getValue();
            }
            case 1: {
                return ((VariableReference)exp).evaluateVariable(context);
            }
            case 14: {
                return ((SuppliedParameterReference)exp).evaluateVariable(context);
            }
            case 3: {
                return Closure.make(exp, context, ref);
            }
            case 4: {
                return Closure.make(exp, context, ref == 1 ? 10 : ref);
            }
            case 13: {
                return new SingletonClosure(exp, context);
            }
            case 5: {
                return EmptySequence.getInstance();
            }
            case 6: {
                Sequence v = ((VariableReference)exp).evaluateVariable(context);
                if (v instanceof Closure) {
                    return SequenceExtent.makeSequenceExtent(v.iterate());
                }
                return v;
            }
            case 7: {
                Item item = exp.evaluateItem(context);
                if (item == null) {
                    return EmptySequence.getInstance();
                }
                return item;
            }
            case -1: 
            case 8: {
                if (ref == 10000) {
                    return context.getConfiguration().makeSequenceExtent(exp, ref, context);
                }
                return SequenceExtent.makeSequenceExtent(exp.iterate(context));
            }
            case 9: {
                Controller controller = context.getController();
                SequenceReceiver saved = context.getReceiver();
                SequenceOutputter seq = controller.allocateSequenceOutputter(20);
                seq.getPipelineConfiguration().setHostLanguage(exp.getHostLanguage());
                context.setReceiver(seq);
                seq.open();
                exp.process(context);
                seq.close();
                context.setReceiver(saved);
                Sequence val = seq.getSequence();
                seq.reset();
                return val;
            }
            case 10: {
                TailExpression tail = (TailExpression)exp;
                VariableReference vr = (VariableReference)tail.getBaseExpression();
                Sequence base = ExpressionTool.evaluate(vr, 1, context, ref);
                if (base instanceof MemoClosure) {
                    SequenceIterator<? extends Item> it = base.iterate();
                    base = SequenceTool.toGroundedValue(it);
                }
                if (base instanceof IntegerRange) {
                    long end;
                    long start = ((IntegerRange)base).getStart() + (long)tail.getStart() - 1L;
                    if (start == (end = ((IntegerRange)base).getEnd())) {
                        return Int64Value.makeIntegerValue(end);
                    }
                    if (start > end) {
                        return EmptySequence.getInstance();
                    }
                    return new IntegerRange(start, end);
                }
                if (base instanceof SequenceExtent) {
                    return new SequenceExtent((SequenceExtent)base, tail.getStart() - 1, ((SequenceExtent)base).getLength() - tail.getStart() + 1).reduce();
                }
                return Closure.make(tail, context, ref);
            }
            case 11: {
                if (exp instanceof Block) {
                    Block block = (Block)exp;
                    Expression[] children = block.getChildren();
                    ArrayList<GroundedValue> subsequences = new ArrayList<GroundedValue>(children.length);
                    for (Expression child : children) {
                        if (Cardinality.allowsMany(child.getCardinality())) {
                            subsequences.add(SequenceTool.toGroundedValue(child.iterate(context)));
                            continue;
                        }
                        Item j = child.evaluateItem(context);
                        if (j == null) continue;
                        subsequences.add(j instanceof GroundedValue ? (GroundedValue)((Object)j) : new SingletonItem<Item>(j));
                    }
                    return new Chain(subsequences);
                }
                return SequenceExtent.makeSequenceExtent(exp.iterate(context));
            }
            case 12: {
                return context.getConfiguration().obtainOptimizer().makeIndexedValue(exp.iterate(context));
            }
        }
        throw new IllegalArgumentException("Unknown evaluation mode " + evaluationMode);
    }

    public static Sequence lazyEvaluate(Expression exp, XPathContext context, int ref) throws XPathException {
        int evaluationMode = ExpressionTool.lazyEvaluationMode(exp);
        return ExpressionTool.evaluate(exp, evaluationMode, context, ref);
    }

    public static Sequence eagerEvaluate(Expression exp, XPathContext context) throws XPathException {
        int evaluationMode = ExpressionTool.eagerEvaluationMode(exp);
        return ExpressionTool.evaluate(exp, evaluationMode, context, 10);
    }

    public static int markTailFunctionCalls(Expression exp, StructuredQName qName, int arity) {
        return exp.markTailFunctionCalls(qName, arity);
    }

    public static String indent(int level) {
        FastStringBuffer fsb = new FastStringBuffer(level);
        for (int i = 0; i < level; ++i) {
            fsb.append("  ");
        }
        return fsb.toString();
    }

    public static boolean containsLocalParam(Expression exp) {
        return ExpressionTool.contains(exp, true, new ExpressionPredicate(){

            public boolean matches(Expression e) {
                return e instanceof LocalParamSetter;
            }
        });
    }

    public static boolean containsGroupVariableReference(Expression exp) {
        return ExpressionTool.contains(exp, false, new ExpressionPredicate(){

            public boolean matches(Expression e) {
                return e instanceof GroupVariableReference;
            }
        });
    }

    public static boolean contains(Expression exp, boolean sameFocusOnly, ExpressionPredicate predicate) {
        if (predicate.matches(exp)) {
            return true;
        }
        Iterator<SubExpressionInfo> iter = exp.iterateSubExpressionInfo();
        while (iter.hasNext()) {
            SubExpressionInfo info = iter.next();
            if (!info.hasSameFocus && sameFocusOnly || !ExpressionTool.contains(info.expression, sameFocusOnly, predicate)) continue;
            return true;
        }
        return false;
    }

    public static int allocateSlots(Expression exp, int nextFree, SlotManager frame) {
        if (exp instanceof Assignation) {
            ((Assignation)exp).setSlotNumber(nextFree);
            int count = ((Assignation)exp).getRequiredSlots();
            nextFree += count;
            if (frame != null) {
                frame.allocateSlotNumber(((Assignation)exp).getVariableQName());
                if (count == 2) {
                    frame.allocateSlotNumber(((ForExpression)exp).getPositionVariableName());
                }
            }
        }
        if (exp instanceof ForEachGroup) {
            ForEachGroup feg = (ForEachGroup)exp;
            if (feg.getGroupBinding() != null) {
                feg.getGroupBinding().setSlotNumber(nextFree++);
            }
            if (feg.getKeyBinding() != null) {
                feg.getKeyBinding().setSlotNumber(nextFree++);
            }
        }
        if (exp instanceof FLWORExpression) {
            for (Clause c : ((FLWORExpression)exp).getClauseList()) {
                for (LocalVariableBinding b : c.getRangeVariables()) {
                    b.setSlotNumber(nextFree++);
                    frame.allocateSlotNumber(b.getVariableQName());
                }
            }
        }
        if (exp instanceof VariableReference) {
            VariableReference var = (VariableReference)exp;
            Binding binding = var.getBinding();
            if (exp instanceof LocalVariableReference) {
                ((LocalVariableReference)var).setSlotNumber(binding.getLocalSlotNumber());
            }
            if (binding instanceof Assignation && binding.getLocalSlotNumber() < 0) {
                Assignation decl = (Assignation)binding;
                String msg = "*** Internal Saxon error: local variable encountered whose binding has been deleted";
                System.err.println(msg);
                System.err.println("Variable name: " + decl.getVariableName());
                System.err.println("Line number of reference: " + var.getLineNumber() + " in " + var.getSystemId());
                System.err.println("Line number of declaration: " + decl.getLineNumber() + " in " + decl.getSystemId());
                System.err.println("DECLARATION:");
                try {
                    decl.explain(System.err);
                }
                catch (Exception err) {
                    // empty catch block
                }
                throw new IllegalStateException(msg);
            }
        }
        if (exp instanceof PatternSponsor) {
            nextFree = ((PatternSponsor)exp).getPattern().allocateSlots(frame, nextFree);
        } else {
            Iterator<Expression> children = exp.iterateSubExpressions();
            while (children.hasNext()) {
                Expression child = children.next();
                nextFree = ExpressionTool.allocateSlots(child, nextFree, frame);
            }
        }
        return nextFree;
    }

    public static boolean effectiveBooleanValue(SequenceIterator<? extends Item> iterator) throws XPathException {
        Item first = iterator.next();
        if (first == null) {
            return false;
        }
        if (first instanceof NodeInfo) {
            iterator.close();
            return true;
        }
        if (first instanceof AtomicValue) {
            if (first instanceof BooleanValue) {
                if (iterator.next() != null) {
                    ExpressionTool.ebvError("a sequence of two or more items starting with a boolean");
                }
                return ((BooleanValue)first).getBooleanValue();
            }
            if (first instanceof StringValue) {
                if (iterator.next() != null) {
                    ExpressionTool.ebvError("a sequence of two or more items starting with a string");
                }
                return !((StringValue)first).isZeroLength();
            }
            if (first instanceof NumericValue) {
                NumericValue n;
                if (iterator.next() != null) {
                    ExpressionTool.ebvError("a sequence of two or more items starting with a numeric value");
                }
                return (n = (NumericValue)first).compareTo(0L) != 0 && !n.isNaN();
            }
            ExpressionTool.ebvError("a sequence starting with an atomic value other than a boolean, number, string, or URI");
            return false;
        }
        if (first instanceof FunctionItem) {
            ExpressionTool.ebvError("a sequence starting with a function item");
            return false;
        }
        if (first instanceof ObjectValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("a sequence of two or more items starting with an external object value");
            }
            return true;
        }
        ExpressionTool.ebvError("a sequence starting with an item of unknown kind");
        return false;
    }

    public static boolean effectiveBooleanValue(Item item) throws XPathException {
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            return ((BooleanValue)item).getBooleanValue();
        }
        if (item instanceof StringValue) {
            return !((StringValue)item).isZeroLength();
        }
        if (item instanceof NumericValue) {
            NumericValue n = (NumericValue)item;
            return n.compareTo(0L) != 0 && !n.isNaN();
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).getObject() != null;
        }
        ExpressionTool.ebvError("an item other than a boolean, number, string, or URI");
        return false;
    }

    public static void ebvError(String reason) throws XPathException {
        XPathException err = new XPathException("Effective boolean value is not defined for " + reason);
        err.setErrorCode("FORG0006");
        err.setIsTypeError(true);
        throw err;
    }

    public static boolean dependsOnFocus(Expression exp) {
        return (exp.getDependencies() & 0x1E) != 0;
    }

    public static boolean dependsOnVariable(Expression exp, final Binding[] bindingList) {
        return bindingList != null && bindingList.length != 0 && ExpressionTool.contains(exp, false, new ExpressionPredicate(){

            public boolean matches(Expression e) {
                if (e instanceof VariableReference) {
                    for (Binding binding : bindingList) {
                        if (((VariableReference)e).getBinding() != binding) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public static void gatherReferencedVariables(Expression e, List<Binding> list) {
        if (e instanceof VariableReference) {
            Binding binding = ((VariableReference)e).getBinding();
            if (!list.contains(binding)) {
                list.add(binding);
            }
        } else {
            Iterator<Expression> children = e.iterateSubExpressions();
            while (children.hasNext()) {
                Expression child = children.next();
                ExpressionTool.gatherReferencedVariables(child, list);
            }
        }
    }

    public static boolean refersToVariableOrFunction(Expression exp) {
        return ExpressionTool.contains(exp, false, new ExpressionPredicate(){

            public boolean matches(Expression e) {
                return e instanceof VariableReference || e instanceof UserFunctionCall || e instanceof Binding || e instanceof CallTemplate || e instanceof ApplyTemplates || e instanceof ApplyImports;
            }
        });
    }

    public static boolean callsFunction(Expression exp, final StructuredQName qName) {
        return ExpressionTool.contains(exp, false, new ExpressionPredicate(){

            public boolean matches(Expression e) {
                return e instanceof FunctionCall && ((FunctionCall)e).getFunctionName().equals(qName);
            }
        });
    }

    public static void gatherCalledFunctions(Expression e, List<UserFunction> list) {
        if (e instanceof UserFunctionCall) {
            UserFunction function = ((UserFunctionCall)e).getFunction();
            if (!list.contains(function)) {
                list.add(function);
            }
        } else {
            Iterator<Expression> children = e.iterateSubExpressions();
            while (children.hasNext()) {
                Expression child = children.next();
                ExpressionTool.gatherCalledFunctions(child, list);
            }
        }
    }

    public static void gatherCalledFunctionNames(Expression e, List list) {
        if (e instanceof UserFunctionCall) {
            StructuredQName name = ((UserFunctionCall)e).getFunctionName();
            int arity = ((UserFunctionCall)e).getNumberOfArguments();
            String key = name.getClarkName() + "/" + arity;
            if (!list.contains(key)) {
                list.add(key);
            }
        } else {
            Iterator<Expression> children = e.iterateSubExpressions();
            while (children.hasNext()) {
                Expression child = children.next();
                ExpressionTool.gatherCalledFunctionNames(child, list);
            }
        }
    }

    public static void resetPropertiesWithinSubtree(Expression exp) {
        exp.resetLocalStaticProperties();
        Iterator<Expression> children = exp.iterateSubExpressions();
        while (children.hasNext()) {
            Expression child = children.next();
            ExpressionTool.resetPropertiesWithinSubtree(child);
        }
    }

    public static Expression resolveCallsToCurrentFunction(Expression exp, Configuration config) throws XPathException {
        if (ExpressionTool.callsFunction(exp, Current.FN_CURRENT)) {
            LetExpression let = new LetExpression();
            let.setVariableQName(new StructuredQName("saxon", "http://saxon.sf.net/", "current" + exp.hashCode()));
            let.setRequiredType(SequenceType.SINGLE_ITEM);
            let.setSequence(new CurrentItemExpression());
            PromotionOffer offer = new PromotionOffer(config.obtainOptimizer());
            offer.action = 14;
            offer.containingExpression = let;
            exp = exp.promote(offer, null);
            let.setAction(exp);
            return let;
        }
        return exp;
    }

    public static void gatherVariableReferences(Expression exp, Binding binding, List<VariableReference> list) {
        if (exp instanceof VariableReference && ((VariableReference)exp).getBinding() == binding) {
            list.add((VariableReference)exp);
        } else {
            Iterator<Expression> iter = exp.iterateSubExpressions();
            while (iter.hasNext()) {
                ExpressionTool.gatherVariableReferences(iter.next(), binding, list);
            }
        }
    }

    public static boolean replaceSelectedSubexpressions(Expression exp, ExpressionSelector selector, Expression replacement) {
        boolean found = false;
        Iterator<Expression> iter = exp.iterateSubExpressions();
        while (iter.hasNext()) {
            Expression child = iter.next();
            if (selector.matches(child)) {
                found |= exp.replaceSubExpression(child, replacement);
                continue;
            }
            found |= ExpressionTool.replaceSelectedSubexpressions(child, selector, replacement);
        }
        if (found) {
            exp.resetLocalStaticProperties();
        }
        return found;
    }

    public static boolean replaceVariableReferences(Expression exp, final Binding binding, Expression replacement) {
        ExpressionSelector selector = new ExpressionSelector(){

            public boolean matches(Expression child) {
                return child instanceof VariableReference && ((VariableReference)child).getBinding() == binding;
            }
        };
        return ExpressionTool.replaceSelectedSubexpressions(exp, selector, replacement);
    }

    public static int getReferenceCount(Expression exp, Binding binding, boolean inLoop) {
        int rcount = 0;
        if (exp instanceof VariableReference && ((VariableReference)exp).getBinding() == binding) {
            if (((VariableReference)exp).isFiltered()) {
                return 10000;
            }
            rcount += inLoop ? 10 : 1;
        } else {
            if ((exp.getDependencies() & 0x80) == 0) {
                return 0;
            }
            Iterator<SubExpressionInfo> iter = exp.iterateSubExpressionInfo();
            while (iter.hasNext()) {
                SubExpressionInfo info = iter.next();
                Expression child = info.expression;
                boolean childLoop = inLoop || info.isEvaluatedRepeatedly;
                if ((rcount += ExpressionTool.getReferenceCount(child, binding, childLoop)) < 10000) continue;
                break;
            }
        }
        return rcount;
    }

    public static int expressionSize(Expression exp) {
        int total = 1;
        Iterator<Expression> iter = exp.iterateSubExpressions();
        while (iter.hasNext()) {
            total += ExpressionTool.expressionSize(iter.next());
        }
        return total;
    }

    public static void rebindVariableReferences(Expression exp, Binding oldBinding, Binding newBinding) {
        if (exp instanceof VariableReference) {
            if (((VariableReference)exp).getBinding() == oldBinding) {
                ((VariableReference)exp).fixup(newBinding);
            }
        } else {
            Iterator<Expression> iter = exp.iterateSubExpressions();
            while (iter.hasNext()) {
                Expression e = iter.next();
                ExpressionTool.rebindVariableReferences(e, oldBinding, newBinding);
            }
        }
    }

    public static Expression makePathExpression(Expression start, Expression step, boolean sortAndDeduplicate) {
        SlashExpression stepPath;
        if (start instanceof RootExpression && step instanceof ParentNodeExpression) {
            return Literal.makeEmptySequence();
        }
        SlashExpression expr = new SlashExpression(start, step);
        if (step instanceof SlashExpression && ExpressionTool.isFilteredAxisPath((stepPath = (SlashExpression)step).getControllingExpression()) && ExpressionTool.isFilteredAxisPath(stepPath.getControlledExpression())) {
            expr.setStartExpression(ExpressionTool.makePathExpression(start, stepPath.getControllingExpression(), false));
            expr.setStepExpression(stepPath.getControlledExpression());
        }
        if (sortAndDeduplicate) {
            return new HomogeneityChecker(expr);
        }
        return expr;
    }

    private static boolean isFilteredAxisPath(Expression exp) {
        return ExpressionTool.unfilteredExpression(exp) instanceof AxisExpression;
    }

    public static Expression unfilteredExpression(Expression exp) {
        if (exp instanceof FilterExpression) {
            return ExpressionTool.unfilteredExpression(((FilterExpression)exp).getControllingExpression());
        }
        if (exp instanceof SingleItemFilter) {
            return ExpressionTool.unfilteredExpression(((SingleItemFilter)exp).getBaseExpression());
        }
        return exp;
    }

    private static Expression removeSorting(Expression exp) {
        if (exp instanceof DocumentSorter) {
            return ((DocumentSorter)exp).getBaseExpression();
        }
        if (exp instanceof ConditionalSorter) {
            return ((ConditionalSorter)exp).getDocumentSorter().getBaseExpression();
        }
        if (exp instanceof HomogeneityChecker) {
            return ((HomogeneityChecker)exp).getBaseExpression();
        }
        return exp;
    }

    public static Expression tryToFactorOutDot(Expression exp, ItemType contextItemType) {
        if (exp instanceof ContextItemExpression) {
            return null;
        }
        if (exp instanceof LetExpression && ((LetExpression)exp).getSequence() instanceof ContextItemExpression) {
            Expression action = ((LetExpression)exp).getAction();
            boolean changed = ExpressionTool.factorOutDot(action, (LetExpression)exp);
            if (changed) {
                exp.resetLocalStaticProperties();
            }
            return exp;
        }
        if ((exp.getDependencies() & 0x12) != 0) {
            LetExpression let = new LetExpression();
            let.setVariableQName(new StructuredQName("saxon", "http://saxon.sf.net/", "dot" + exp.hashCode()));
            let.setRequiredType(SequenceType.makeSequenceType(contextItemType, 16384));
            let.setSequence(new ContextItemExpression());
            let.setAction(exp);
            boolean changed = ExpressionTool.factorOutDot(exp, let);
            if (changed) {
                return let;
            }
            return exp;
        }
        return null;
    }

    public static boolean factorOutDot(Expression exp, Binding variable) {
        boolean changed = false;
        if ((exp.getDependencies() & 0x12) != 0) {
            Iterator<SubExpressionInfo> iter = exp.iterateSubExpressionInfo();
            while (iter.hasNext()) {
                VariableReference ref;
                SubExpressionInfo info = iter.next();
                if (!info.hasSameFocus) continue;
                Expression child = info.expression;
                if (child instanceof ContextItemExpression) {
                    ref = new VariableReference(variable);
                    ExpressionTool.copyLocationInfo(child, ref);
                    exp.replaceSubExpression(child, ref);
                    changed = true;
                    continue;
                }
                if (child instanceof ParentNodeExpression || child instanceof AxisExpression || child instanceof RootExpression) {
                    ref = new VariableReference(variable);
                    ExpressionTool.copyLocationInfo(child, ref);
                    Expression path = ExpressionTool.makePathExpression(ref, child, false);
                    exp.replaceSubExpression(child, path);
                    changed = true;
                    continue;
                }
                changed |= ExpressionTool.factorOutDot(child, variable);
            }
        }
        if (changed) {
            exp.resetLocalStaticProperties();
        }
        return changed;
    }

    public static boolean isAllowedInUpdatingContext(Expression exp) {
        return exp.isUpdatingExpression() || exp.isVacuousExpression();
    }

    public static void replaceNthSubexpression(Expression target, int n, Expression replacement) {
        int i = 0;
        Iterator<Expression> iter = target.iterateSubExpressions();
        while (iter.hasNext()) {
            boolean found;
            Expression sub = iter.next();
            if (i++ != n || !(found = target.replaceSubExpression(sub, replacement))) continue;
            return;
        }
        throw new IllegalStateException("Failed to replace subexpression of " + target.getClass() + " with " + replacement.toString());
    }

    public static String getCurrentDirectory() {
        String dir;
        try {
            dir = System.getProperty("user.dir");
        }
        catch (Exception geterr) {
            return null;
        }
        if (!dir.endsWith("/")) {
            dir = dir + '/';
        }
        URI currentDirectoryURL = new File(dir).toURI();
        return currentDirectoryURL.toString();
    }

    public static URI getBaseURI(StaticContext env, SourceLocator locator, boolean fail) throws XPathException {
        URI expressionBaseURI;
        block6: {
            expressionBaseURI = null;
            String base = null;
            try {
                base = env.getBaseURI();
                if (base == null) {
                    base = ExpressionTool.getCurrentDirectory();
                }
                if (base != null) {
                    expressionBaseURI = new URI(base);
                }
            }
            catch (URISyntaxException e) {
                String esc = EscapeURI.iriToUri(base).toString();
                try {
                    expressionBaseURI = new URI(esc);
                }
                catch (URISyntaxException e2) {
                    expressionBaseURI = null;
                }
                if (expressionBaseURI != null || !fail) break block6;
                XPathException err = new XPathException("The base URI " + Err.wrap(env.getBaseURI(), 7) + " is not a valid URI");
                err.setLocator(locator);
                throw err;
            }
        }
        return expressionBaseURI;
    }

    public static String parenthesize(Expression exp) {
        if (exp.iterateSubExpressions().hasNext()) {
            return "(" + exp.toString() + ")";
        }
        return exp.toString();
    }

    public static interface ExpressionSelector {
        public boolean matches(Expression var1);
    }

    public static interface ExpressionPredicate {
        public boolean matches(Expression var1);
    }
}

