/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.regex.Categories;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntUnionPredicate;

public class NumberFormatter
implements Serializable {
    private ArrayList<UnicodeString> formatTokens;
    private ArrayList<UnicodeString> punctuationTokens;
    private boolean startsWithPunctuation;
    private static IntPredicate alphanumeric = new IntUnionPredicate(Categories.getCategory("N"), Categories.getCategory("L"));

    public void prepare(String format) {
        if (format.length() == 0) {
            format = "1";
        }
        this.formatTokens = new ArrayList(10);
        this.punctuationTokens = new ArrayList(10);
        UnicodeString uFormat = UnicodeString.makeUnicodeString(format);
        int len = uFormat.length();
        int i = 0;
        boolean first = true;
        this.startsWithPunctuation = true;
        while (i < len) {
            int c = uFormat.charAt(i);
            int t = i;
            while (NumberFormatter.isLetterOrDigit(c) && ++i != len) {
                c = uFormat.charAt(i);
            }
            if (i > t) {
                UnicodeString tok = uFormat.substring(t, i);
                this.formatTokens.add(tok);
                if (first) {
                    this.punctuationTokens.add(UnicodeString.makeUnicodeString("."));
                    this.startsWithPunctuation = false;
                    first = false;
                }
            }
            if (i == len) break;
            t = i;
            c = uFormat.charAt(i);
            while (!NumberFormatter.isLetterOrDigit(c)) {
                first = false;
                if (++i == len) break;
                c = uFormat.charAt(i);
            }
            if (i <= t) continue;
            UnicodeString sep = uFormat.substring(t, i);
            this.punctuationTokens.add(sep);
        }
        if (this.formatTokens.isEmpty()) {
            this.formatTokens.add(UnicodeString.makeUnicodeString("1"));
            if (this.punctuationTokens.size() == 1) {
                this.punctuationTokens.add(this.punctuationTokens.get(0));
            }
        }
    }

    public static boolean isLetterOrDigit(int c) {
        if (c <= 127) {
            return c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122;
        }
        return alphanumeric.matches(c);
    }

    public CharSequence format(List numbers, int groupSize, String groupSeparator, String letterValue, String ordinal, Numberer numberer) {
        FastStringBuffer sb = new FastStringBuffer(16);
        int num = 0;
        int tok = 0;
        if (this.startsWithPunctuation) {
            sb.append(this.punctuationTokens.get(tok));
        }
        while (num < numbers.size()) {
            String s2;
            Object o;
            if (num > 0) {
                if (tok == 0 && this.startsWithPunctuation) {
                    sb.append(".");
                } else {
                    sb.append(this.punctuationTokens.get(tok));
                }
            }
            if ((o = numbers.get(num++)) instanceof Long) {
                long nr = (Long)o;
                RegularGroupFormatter rgf = new RegularGroupFormatter(groupSize, groupSeparator, UnicodeString.EMPTY_STRING);
                s2 = numberer.format(nr, this.formatTokens.get(tok), rgf, letterValue, ordinal);
            } else {
                s2 = o.toString();
            }
            sb.append(s2);
            if (++tok != this.formatTokens.size()) continue;
            --tok;
        }
        if (this.punctuationTokens.size() > this.formatTokens.size()) {
            sb.append(this.punctuationTokens.get(this.punctuationTokens.size() - 1));
        }
        return sb.condense();
    }
}

