/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.NumberFormatter;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberInstruction
extends Expression {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression select = null;
    private Expression value = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression ordinal = null;
    private Expression startAt = null;
    private Expression lang = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private boolean hasVariablesInPatterns;
    private boolean backwardsCompatible;

    public NumberInstruction(Configuration config, Expression select, int level, Pattern count, Pattern from, Expression value, Expression format, Expression groupSize, Expression groupSeparator, Expression letterValue, Expression ordinal, Expression startAt, Expression lang, NumberFormatter formatter, Numberer numberer, boolean hasVariablesInPatterns, boolean backwardsCompatible) {
        this.select = select;
        this.level = level;
        this.count = count;
        this.from = from;
        this.value = value;
        this.format = format;
        this.groupSize = groupSize;
        this.groupSeparator = groupSeparator;
        this.letterValue = letterValue;
        this.ordinal = ordinal;
        this.startAt = startAt;
        this.lang = lang;
        this.formatter = formatter;
        this.numberer = numberer;
        this.hasVariablesInPatterns = hasVariablesInPatterns;
        this.backwardsCompatible = backwardsCompatible;
        TypeHierarchy th = config.getTypeHierarchy();
        if (this.value != null && !this.value.getItemType(th).isPlainType()) {
            this.value = Atomizer.makeAtomizer(this.value);
        }
        Iterator<Expression> kids = this.iterateSubExpressions();
        while (kids.hasNext()) {
            Expression child = kids.next();
            this.adoptChildExpression(child);
        }
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.value = visitor.simplify(this.value);
        this.format = visitor.simplify(this.format);
        this.groupSize = visitor.simplify(this.groupSize);
        this.groupSeparator = visitor.simplify(this.groupSeparator);
        this.letterValue = visitor.simplify(this.letterValue);
        this.ordinal = visitor.simplify(this.ordinal);
        this.startAt = visitor.simplify(this.startAt);
        this.lang = visitor.simplify(this.lang);
        if (this.count != null) {
            this.count = this.count.simplify(visitor);
        }
        if (this.from != null) {
            this.from = this.from.simplify(visitor);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.typeCheck(this.select, contextItemType);
        } else if (this.value == null) {
            XPathException err = null;
            if (contextItemType == null || contextItemType.itemType == null) {
                err = new XPathException("xsl:number requires a select attribute, a value attribute, or a context item");
            } else if (contextItemType.itemType.isPlainType()) {
                err = new XPathException("xsl:number requires the context item to be a node, but it is an atomic value");
            }
            if (err != null) {
                err.setIsTypeError(true);
                err.setErrorCode("XTTE0990");
                err.setLocator(this);
                throw err;
            }
        }
        if (this.value != null) {
            this.value = visitor.typeCheck(this.value, contextItemType);
        }
        if (this.format != null) {
            this.format = visitor.typeCheck(this.format, contextItemType);
        }
        if (this.groupSize != null) {
            this.groupSize = visitor.typeCheck(this.groupSize, contextItemType);
        }
        if (this.groupSeparator != null) {
            this.groupSeparator = visitor.typeCheck(this.groupSeparator, contextItemType);
        }
        if (this.letterValue != null) {
            this.letterValue = visitor.typeCheck(this.letterValue, contextItemType);
        }
        if (this.ordinal != null) {
            this.ordinal = visitor.typeCheck(this.ordinal, contextItemType);
        }
        if (this.startAt != null) {
            this.startAt = visitor.typeCheck(this.startAt, contextItemType);
        }
        if (this.lang != null) {
            this.lang = visitor.typeCheck(this.lang, contextItemType);
        }
        if (this.count != null) {
            visitor.typeCheck(new PatternSponsor(this.count), contextItemType);
        }
        if (this.from != null) {
            visitor.typeCheck(new PatternSponsor(this.from), contextItemType);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.optimize(this.select, contextItemType);
        }
        if (this.value != null) {
            this.value = visitor.optimize(this.value, contextItemType);
        }
        if (this.format != null) {
            this.format = visitor.optimize(this.format, contextItemType);
        }
        if (this.groupSize != null) {
            this.groupSize = visitor.optimize(this.groupSize, contextItemType);
        }
        if (this.groupSeparator != null) {
            this.groupSeparator = visitor.optimize(this.groupSeparator, contextItemType);
        }
        if (this.letterValue != null) {
            this.letterValue = visitor.optimize(this.letterValue, contextItemType);
        }
        if (this.ordinal != null) {
            this.ordinal = visitor.optimize(this.ordinal, contextItemType);
        }
        if (this.startAt != null) {
            this.startAt = visitor.optimize(this.startAt, contextItemType);
        }
        if (this.lang != null) {
            this.lang = visitor.optimize(this.lang, contextItemType);
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> sub = new ArrayList<Expression>(9);
        if (this.select != null) {
            sub.add(this.select);
        }
        if (this.value != null) {
            sub.add(this.value);
        }
        if (this.format != null) {
            sub.add(this.format);
        }
        if (this.groupSize != null) {
            sub.add(this.groupSize);
        }
        if (this.groupSeparator != null) {
            sub.add(this.groupSeparator);
        }
        if (this.letterValue != null) {
            sub.add(this.letterValue);
        }
        if (this.ordinal != null) {
            sub.add(this.ordinal);
        }
        if (this.startAt != null) {
            sub.add(this.startAt);
        }
        if (this.lang != null) {
            sub.add(this.lang);
        }
        if (this.count != null) {
            sub.add(new PatternSponsor(this.count));
        }
        if (this.from != null) {
            sub.add(new PatternSponsor(this.from));
        }
        return sub.iterator();
    }

    @Override
    public Expression copy() {
        return new NumberInstruction(this.getExecutable().getConfiguration(), this.copy(this.select), this.level, this.count, this.from, this.copy(this.value), this.copy(this.format), this.copy(this.groupSize), this.copy(this.groupSeparator), this.copy(this.letterValue), this.copy(this.ordinal), this.copy(this.startAt), this.copy(this.lang), this.formatter, this.numberer, this.hasVariablesInPatterns, this.backwardsCompatible);
    }

    private Expression copy(Expression exp) {
        return exp == null ? null : exp.copy();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.value == original) {
            this.value = replacement;
            found = true;
        }
        if (this.format == original) {
            this.format = replacement;
            found = true;
        }
        if (this.groupSize == original) {
            this.groupSize = replacement;
            found = true;
        }
        if (this.groupSeparator == original) {
            this.groupSeparator = replacement;
            found = true;
        }
        if (this.letterValue == original) {
            this.letterValue = replacement;
            found = true;
        }
        if (this.ordinal == original) {
            this.ordinal = replacement;
            found = true;
        }
        if (this.startAt == original) {
            this.startAt = replacement;
            found = true;
        }
        if (this.lang == original) {
            this.lang = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int getIntrinsicDependencies() {
        return this.select == null ? 2 : 0;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (this.select != null) {
            this.select = this.doPromotion(this.select, offer);
        }
        if (this.value != null) {
            this.value = this.doPromotion(this.value, offer);
        }
        if (this.format != null) {
            this.format = this.doPromotion(this.format, offer);
        }
        if (this.groupSize != null) {
            this.groupSize = this.doPromotion(this.groupSize, offer);
        }
        if (this.groupSeparator != null) {
            this.groupSeparator = this.doPromotion(this.groupSeparator, offer);
        }
        if (this.letterValue != null) {
            this.letterValue = this.doPromotion(this.letterValue, offer);
        }
        if (this.ordinal != null) {
            this.ordinal = this.doPromotion(this.ordinal, offer);
        }
        if (this.startAt != null) {
            this.startAt = this.doPromotion(this.startAt, offer);
        }
        if (this.lang != null) {
            this.lang = this.doPromotion(this.lang, offer);
        }
        if (this.count != null) {
            this.count.promote(offer, this);
        }
        if (this.from != null) {
            this.from.promote(offer, this);
        }
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        NumberFormatter nf;
        String letterVal;
        long startValue;
        long value = -1L;
        List<Object> vec = null;
        ConversionRules rules = context.getConfiguration().getConversionRules();
        String startAv = this.startAt.evaluateAsString(context).toString();
        try {
            startValue = Integer.parseInt(startAv);
        }
        catch (NumberFormatException e) {
            XPathException err = new XPathException("Value of start-at attribute must be an integer", "XTDE0030");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        --startValue;
        if (this.value != null) {
            AtomicValue val;
            SequenceIterator<? extends Item> iter = this.value.iterate(context);
            vec = new ArrayList<String>(4);
            while ((val = (AtomicValue)iter.next()) != null && (!this.backwardsCompatible || vec.isEmpty())) {
                try {
                    NumericValue num = val instanceof NumericValue ? (NumericValue)val : NumberFn.convert(val, context.getConfiguration());
                    if (num.isNaN()) {
                        throw new XPathException("NaN");
                    }
                    if ((num = num.round(0)).compareTo(Int64Value.MAX_LONG) > 0) {
                        BigInteger bi = ((BigIntegerValue)Converter.convert(num, BuiltInAtomicType.INTEGER, rules).asAtomic()).asBigInteger();
                        if (startValue != 0L) {
                            bi = bi.add(BigInteger.valueOf(startValue));
                        }
                        vec.add(bi);
                        continue;
                    }
                    if (num.compareTo(Int64Value.ZERO) < 0) {
                        throw new XPathException("The numbers to be formatted must not be negative");
                    }
                    long i = ((NumericValue)Converter.convert(num, BuiltInAtomicType.INTEGER, rules).asAtomic()).longValue();
                    vec.add(i += startValue);
                }
                catch (XPathException err) {
                    if (this.backwardsCompatible) {
                        vec.add("NaN");
                        continue;
                    }
                    vec.add(val.getStringValue());
                    XPathException e = new XPathException("Cannot convert supplied value to an integer. " + err.getMessage());
                    e.setErrorCode("XTDE0980");
                    e.setLocator(this);
                    e.setXPathContext(context);
                    throw e;
                }
            }
            if (this.backwardsCompatible && vec.isEmpty()) {
                vec.add("NaN");
            }
        } else {
            NodeInfo source;
            if (this.select != null) {
                source = (NodeInfo)this.select.evaluateItem(context);
            } else {
                Item item = context.getContextItem();
                if (!(item instanceof NodeInfo)) {
                    XPathException err = new XPathException("context item for xsl:number must be a node");
                    err.setErrorCode("XTTE0990");
                    err.setIsTypeError(true);
                    err.setXPathContext(context);
                    err.setLocator(this);
                    throw err;
                }
                source = (NodeInfo)item;
            }
            if (this.level == 3) {
                value = Navigator.getNumberSimple(source, context);
                value += startValue;
            } else if (this.level == 0) {
                value = Navigator.getNumberSingle(source, this.count, this.from, context);
                if (value == 0L) {
                    vec = Collections.emptyList();
                } else {
                    value += startValue;
                }
            } else if (this.level == 2) {
                value = Navigator.getNumberAny(this, source, this.count, this.from, context, this.hasVariablesInPatterns);
                if (value == 0L) {
                    vec = Collections.emptyList();
                } else {
                    value += startValue;
                }
            } else if (this.level == 1) {
                vec = new ArrayList();
                for (long n : Navigator.getNumberMulti(source, this.count, this.from, context)) {
                    vec.add(n + startValue);
                }
            }
        }
        int gpsize = 0;
        String gpseparator = "";
        String ordinalVal = null;
        if (this.groupSize != null) {
            String g2 = this.groupSize.evaluateAsString(context).toString();
            try {
                gpsize = Integer.parseInt(g2);
            }
            catch (NumberFormatException err) {
                XPathException e = new XPathException("grouping-size must be numeric");
                e.setXPathContext(context);
                e.setErrorCode("XTDE0030");
                e.setLocator(this);
                throw e;
            }
        }
        if (this.groupSeparator != null) {
            gpseparator = this.groupSeparator.evaluateAsString(context).toString();
        }
        if (this.ordinal != null) {
            ordinalVal = this.ordinal.evaluateAsString(context).toString();
        }
        if (vec == null && this.format == null && gpsize == 0 && this.lang == null) {
            return new StringValue("" + value);
        }
        Numberer numb = this.numberer;
        if (numb == null) {
            String language = this.lang.evaluateAsString(context).toString();
            ValidationFailure vf = StringConverter.STRING_TO_LANGUAGE.validate(language);
            if (vf != null) {
                throw new XPathException("The lang attribute of xsl:number must be a valid language code", "XTDE0030");
            }
            numb = context.getConfiguration().makeNumberer(language, null);
        }
        if (this.letterValue == null) {
            letterVal = "";
        } else {
            letterVal = this.letterValue.evaluateAsString(context).toString();
            if (!"alphabetic".equals(letterVal) && !"traditional".equals(letterVal)) {
                XPathException e = new XPathException("letter-value must be \"traditional\" or \"alphabetic\"");
                e.setXPathContext(context);
                e.setErrorCode("XTDE0030");
                e.setLocator(this);
                throw e;
            }
        }
        if (vec == null) {
            vec = new ArrayList(1);
            vec.add(value);
        }
        if (this.formatter == null) {
            nf = new NumberFormatter();
            nf.prepare(this.format.evaluateAsString(context).toString());
        } else {
            nf = this.formatter;
        }
        CharSequence s2 = nf.format(vec, gpsize, gpseparator, letterVal, ordinalVal, numb);
        return new StringValue(s2);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("xslNumber");
        out.emitAttribute("level", this.level == 2 ? "any" : (this.level == 0 ? "single" : "multi"));
        if (this.count != null) {
            out.emitAttribute("count", this.count.toString());
        }
        if (this.from != null) {
            out.emitAttribute("from", this.from.toString());
        }
        if (this.select != null) {
            out.startSubsidiaryElement("select");
            this.select.explain(out);
            out.endSubsidiaryElement();
        }
        if (this.value != null) {
            out.startSubsidiaryElement("value");
            this.value.explain(out);
            out.endSubsidiaryElement();
        }
        if (this.format != null) {
            out.startSubsidiaryElement("format");
            this.format.explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

