/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Platform;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.PullEventSource;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Debugger;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.ExpressionParser;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.IntegratedFunctionLibrary;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.java.JavaPlatform;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CollationURIResolver;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.LocalizerFactory;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.SourceResolver;
import net.sf.saxon.lib.StandardCollationURIResolver;
import net.sf.saxon.lib.StandardCollectionURIResolver;
import net.sf.saxon.lib.StandardEntityResolver;
import net.sf.saxon.lib.StandardEnvironmentVariableResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.lib.StaticQueryContextFactory;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NotationSet;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.PatternParser20;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.serialize.charcode.CharacterSetFactory;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trace.XSLTTraceCodeInjector;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.DynamicLoader;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.DocumentNumberAllocator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringToDouble11;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Serializable,
SourceResolver,
NotationSet {
    private static final Platform platform = Configuration.makePlatform();
    public static final Class<? extends Configuration> configurationClass = Configuration.makeConfigurationClass();
    public static final String softwareEdition = Configuration.setSoftwareEdition();
    private transient Object apiProcessor = null;
    private transient CharacterSetFactory characterSetFactory;
    private CollationMap collationMap = new CollationMap(this);
    private CollationURIResolver collationResolver = new StandardCollationURIResolver();
    protected CollectionURIResolver collectionResolver = new StandardCollectionURIResolver();
    private EnvironmentVariableResolver environmentVariableResolver = new StandardEnvironmentVariableResolver();
    private String defaultCollection = null;
    private ParseOptions defaultParseOptions = new ParseOptions();
    private transient StaticQueryContext defaultStaticQueryContext;
    private CompilerInfo defaultXsltCompilerInfo = new CompilerInfo();
    private DocumentNumberAllocator documentNumberAllocator = new DocumentNumberAllocator();
    private transient Debugger debugger = null;
    private String defaultLanguage = Locale.getDefault().getLanguage();
    private String defaultCountry = Locale.getDefault().getCountry();
    private Properties defaultSerializationProperties = new Properties();
    private int domLevel = 3;
    private transient DynamicLoader dynamicLoader = new DynamicLoader();
    private Set<String> enabledProperties = new HashSet<String>();
    private List<ExternalObjectModel> externalObjectModels = new ArrayList<ExternalObjectModel>(4);
    private DocumentPool globalDocumentPool = new DocumentPool();
    private int hostLanguage = 50;
    private IntegratedFunctionLibrary integratedFunctionLibrary = new IntegratedFunctionLibrary();
    private transient LocalizerFactory localizerFactory;
    private ModuleURIResolver moduleURIResolver = null;
    private StaticQueryContextFactory staticQueryContextFactory = new StaticQueryContextFactory();
    private NamePool namePool = new NamePool();
    protected int optimizationLevel = 10;
    protected Optimizer optimizer = null;
    private SchemaURIResolver schemaURIResolver = null;
    private SerializerFactory serializerFactory = new SerializerFactory(this);
    private volatile ConcurrentLinkedQueue<XMLReader> sourceParserPool = new ConcurrentLinkedQueue();
    private volatile ConcurrentLinkedQueue<XMLReader> styleParserPool = new ConcurrentLinkedQueue();
    private String sourceParserClass;
    private transient SourceResolver sourceResolver = this;
    private transient PrintStream standardErrorOutput = System.err;
    private ModuleURIResolver standardModuleURIResolver = StandardModuleURIResolver.getInstance();
    private String styleParserClass;
    private StandardURIResolver systemURIResolver = new StandardURIResolver(this);
    private transient XPathContext theConversionContext = null;
    private ConversionRules theConversionRules = null;
    private transient TraceListener traceListener = null;
    private String traceListenerClass = null;
    protected transient TypeHierarchy typeHierarchy;
    private transient URIResolver uriResolver;
    protected VendorFunctionLibrary vendorFunctionLibrary;
    protected int xsdVersion = 10;
    private int xmlVersion = 10;
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XML10 = 10;
    public static final int XML11 = 11;
    public static final int XSLT = 50;
    public static final int XQUERY = 51;
    public static final int XML_SCHEMA = 52;
    public static final int JAVA_APPLICATION = 53;
    public static final int XPATH = 54;
    public static final int XSD10 = 10;
    public static final int XSD11 = 11;
    private static LexicalHandler dummyLexicalHandler = new DefaultHandler2();

    public static InputStream locateResource(String filename, List<String> messages, List<ClassLoader> loaders) {
        URL url;
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception err) {
            messages.add("Failed to getContextClassLoader() - continuing\n");
        }
        InputStream in = null;
        if (loader != null && (in = loader.getResourceAsStream(filename)) == null) {
            messages.add("Cannot read " + filename + " file located using ClassLoader " + loader + " - continuing\n");
        }
        if (in == null && (loader = Configuration.class.getClassLoader()) != null && (in = loader.getResourceAsStream(filename)) == null) {
            messages.add("Cannot read " + filename + " file located using ClassLoader " + loader + " - continuing\n");
        }
        if (in == null && (url = ClassLoader.getSystemResource(filename)) != null) {
            try {
                in = url.openStream();
            }
            catch (IOException ioe) {
                messages.add("IO error " + ioe.getMessage() + " reading " + filename + " located using getSystemResource(): using defaults");
                in = null;
            }
        }
        loaders.add(loader);
        return in;
    }

    public static Configuration readConfiguration(Source source) throws XPathException {
        Configuration tempConfig = Configuration.newConfiguration();
        return tempConfig.readConfigurationFile(source);
    }

    protected Configuration readConfigurationFile(Source source) throws XPathException {
        return new ConfigurationReader().makeConfiguration(source);
    }

    public Configuration() {
        this.init();
    }

    public static Configuration newConfiguration() {
        try {
            return configurationClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot instantiate a Configuration", e);
        }
    }

    protected void init() {
        platform.initialize(this);
        this.defaultXsltCompilerInfo.setURIResolver(this.getSystemURIResolver());
        StandardEntityResolver resolver = new StandardEntityResolver();
        resolver.setConfiguration(this);
        this.defaultParseOptions.setEntityResolver(resolver);
        this.internalSetBooleanProperty("http://saxon.sf.net/feature/preferJaxpParser", true);
        this.internalSetBooleanProperty("http://saxon.sf.net/feature/allow-external-functions", true);
    }

    public static Configuration makeLicensedConfiguration(ClassLoader classLoader, String className) throws RuntimeException {
        if (className == null) {
            className = "com.saxonica.config.ProfessionalConfiguration";
        }
        try {
            Class<?> theClass;
            ClassLoader loader = classLoader;
            if (loader == null) {
                try {
                    loader = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception err) {
                    System.err.println("Failed to getContextClassLoader() - continuing");
                }
            }
            if (loader != null) {
                try {
                    theClass = loader.loadClass(className);
                }
                catch (Exception ex) {
                    theClass = Class.forName(className);
                }
            } else {
                theClass = Class.forName(className);
            }
            return (Configuration)theClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Configuration makeSchemaAwareConfiguration(ClassLoader loader, String className) {
        return Configuration.makeLicensedConfiguration(loader, className);
    }

    public String getEditionCode() {
        return "HE";
    }

    public void setProcessor(Object processor) {
        this.apiProcessor = processor;
    }

    public Object getProcessor() {
        return this.apiProcessor;
    }

    public String getProductTitle() {
        return "Saxon-" + this.getEditionCode() + " " + Version.getProductVersion() + platform.getPlatformSuffix() + " from Saxonica";
    }

    public void checkLicensedFeature(int feature, String name) throws LicenseException {
        String require = feature == 8 ? "PE" : "EE";
        String message = "Requested feature (" + name + ") requires Saxon-" + require;
        if (!softwareEdition.equals("HE")) {
            message = message + ". You are using Saxon-" + softwareEdition + " software, but the Configuration is an instance of " + this.getClass().getName() + "; to use this feature you need to create an instance of " + (feature == 8 ? "com.saxonica.config.ProfessionalConfiguration" : "com.saxonica.config.EnterpriseConfiguration");
        }
        throw new LicenseException(message, 6);
    }

    public boolean isLicensedFeature(int feature) {
        return false;
    }

    public boolean isSchemaAware(int language) {
        return false;
    }

    public void displayLicenseMessage() {
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int hostLanguage) {
        this.hostLanguage = hostLanguage;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public void setDynamicLoader(DynamicLoader dynamicLoader) {
        this.dynamicLoader = dynamicLoader;
    }

    public DynamicLoader getDynamicLoader() {
        return this.dynamicLoader;
    }

    public Class getClass(String className, boolean tracing, ClassLoader classLoader) throws XPathException {
        return this.dynamicLoader.getClass(className, tracing ? this.standardErrorOutput : null, classLoader);
    }

    public Object getInstance(String className, ClassLoader classLoader) throws XPathException {
        return this.dynamicLoader.getInstance(className, this.isTiming() ? this.standardErrorOutput : null, classLoader);
    }

    public URIResolver getURIResolver() {
        if (this.uriResolver == null) {
            return this.systemURIResolver;
        }
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
        if (resolver instanceof StandardURIResolver) {
            ((StandardURIResolver)resolver).setConfiguration(this);
        }
        this.defaultXsltCompilerInfo.setURIResolver(resolver);
    }

    public void setParameterizedURIResolver() {
        this.getSystemURIResolver().setRecognizeQueryParameters(true);
    }

    public StandardURIResolver getSystemURIResolver() {
        return this.systemURIResolver;
    }

    public URIResolver makeURIResolver(String className) throws TransformerException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (obj instanceof StandardURIResolver) {
            ((StandardURIResolver)obj).setConfiguration(this);
        }
        if (obj instanceof URIResolver) {
            return (URIResolver)obj;
        }
        throw new XPathException("Class " + className + " is not a URIResolver");
    }

    public ErrorListener getErrorListener() {
        ErrorListener listener = this.defaultParseOptions.getErrorListener();
        if (listener == null) {
            listener = new StandardErrorListener();
            ((StandardErrorListener)listener).setErrorOutput(this.standardErrorOutput);
            ((StandardErrorListener)listener).setRecoveryPolicy(this.defaultXsltCompilerInfo.getRecoveryPolicy());
            this.defaultParseOptions.setErrorListener(listener);
        }
        return listener;
    }

    public void setErrorListener(ErrorListener listener) {
        this.defaultParseOptions.setErrorListener(listener);
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(err);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            err.setHasBeenReported(true);
        }
    }

    public void setStandardErrorOutput(PrintStream out) {
        this.standardErrorOutput = out;
    }

    public PrintStream getStandardErrorOutput() {
        if (this.standardErrorOutput == null) {
            this.standardErrorOutput = System.err;
        }
        return this.standardErrorOutput;
    }

    public void setXMLVersion(int version) {
        this.xmlVersion = version;
        this.theConversionRules = null;
    }

    public int getXMLVersion() {
        return this.xmlVersion;
    }

    public ParseOptions getParseOptions() {
        return this.defaultParseOptions;
    }

    public NameChecker getNameChecker() {
        return this.getConversionRules().getNameChecker();
    }

    public void setConversionRules(ConversionRules rules) {
        this.theConversionRules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversionRules getConversionRules() {
        if (this.theConversionRules == null) {
            Configuration configuration = this;
            synchronized (configuration) {
                ConversionRules cv = new ConversionRules();
                cv.setNameChecker(this.xmlVersion == 10 ? Name10Checker.getInstance() : Name11Checker.getInstance());
                cv.setStringToDoubleConverter(this.xsdVersion == 10 ? StringToDouble.getInstance() : StringToDouble11.getInstance());
                cv.setNotationSet(this);
                if (this.xsdVersion == 10) {
                    cv.setURIChecker(StandardURIChecker.getInstance());
                }
                cv.setAllowYearZero(this.xsdVersion != 10);
                this.theConversionRules = cv;
                return this.theConversionRules;
            }
        }
        return this.theConversionRules;
    }

    public int getXsdVersion() {
        return this.xsdVersion;
    }

    public XPathContext getConversionContext() {
        if (this.theConversionContext == null) {
            this.theConversionContext = new EarlyEvaluationContext(this, new CollationMap(this));
        }
        return this.theConversionContext;
    }

    public int getTreeModel() {
        return this.defaultParseOptions.getModel().getSymbolicValue();
    }

    public void setTreeModel(int treeModel) {
        this.defaultParseOptions.setModel(TreeModel.getTreeModel(treeModel));
    }

    public boolean isLineNumbering() {
        return this.defaultParseOptions.isLineNumbering();
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.defaultParseOptions.setLineNumbering(lineNumbering);
    }

    public void setXIncludeAware(boolean state) {
        this.defaultParseOptions.setXIncludeAware(state);
    }

    public boolean isXIncludeAware() {
        return this.defaultParseOptions.isXIncludeAware();
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public TraceListener makeTraceListener() throws XPathException {
        if (this.traceListener != null) {
            return this.traceListener;
        }
        if (this.traceListenerClass != null) {
            try {
                return this.makeTraceListener(this.traceListenerClass);
            }
            catch (ClassCastException e) {
                throw new XPathException(e);
            }
        }
        return null;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
        this.setCompileWithTracing(traceListener != null);
        this.internalSetBooleanProperty("http://saxon.sf.net/feature/allow-multithreading", false);
    }

    public void setTraceListenerClass(String className) {
        if (className == null) {
            this.traceListenerClass = null;
            this.setCompileWithTracing(false);
        } else {
            try {
                this.makeTraceListener(className);
            }
            catch (XPathException err) {
                throw new IllegalArgumentException(className + ": " + err.getMessage());
            }
            this.traceListenerClass = className;
            this.setCompileWithTracing(true);
        }
    }

    public String getTraceListenerClass() {
        return this.traceListenerClass;
    }

    public boolean isCompileWithTracing() {
        return this.getBooleanProperty("http://saxon.sf.net/feature/compile-with-tracing");
    }

    public void setCompileWithTracing(boolean trace) {
        this.internalSetBooleanProperty("http://saxon.sf.net/feature/compile-with-tracing", trace);
        if (this.defaultXsltCompilerInfo != null) {
            if (trace) {
                this.defaultXsltCompilerInfo.setCodeInjector(new XSLTTraceCodeInjector());
            } else {
                this.defaultXsltCompilerInfo.setCodeInjector(null);
            }
        }
        if (this.defaultStaticQueryContext != null) {
            if (trace) {
                this.defaultStaticQueryContext.setCodeInjector(new TraceCodeInjector());
            } else {
                this.defaultStaticQueryContext.setCodeInjector(null);
            }
        }
    }

    public TraceListener makeTraceListener(String className) throws XPathException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (obj instanceof TraceListener) {
            return (TraceListener)obj;
        }
        throw new XPathException("Class " + className + " is not a TraceListener");
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition function) {
        this.integratedFunctionLibrary.registerFunction(function);
    }

    public IntegratedFunctionLibrary getIntegratedFunctionLibrary() {
        return this.integratedFunctionLibrary;
    }

    public VendorFunctionLibrary getVendorFunctionLibrary() {
        if (this.vendorFunctionLibrary == null) {
            this.vendorFunctionLibrary = new VendorFunctionLibrary();
        }
        return this.vendorFunctionLibrary;
    }

    public void addExtensionBinders(FunctionLibraryList list) {
    }

    public UserFunction newUserFunction(boolean memoFunction) {
        return new UserFunction();
    }

    public void setCollationURIResolver(CollationURIResolver resolver) {
        this.collationResolver = resolver;
    }

    public CollationURIResolver getCollationURIResolver() {
        return this.collationResolver;
    }

    public CollationMap getCollationMap() {
        return this.collationMap;
    }

    public void setDefaultCollection(String uri) {
        this.defaultCollection = uri;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public void setCollectionURIResolver(CollectionURIResolver resolver) {
        this.collectionResolver = resolver;
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionResolver;
    }

    public void setLocalizerFactory(LocalizerFactory factory) {
        this.localizerFactory = factory;
    }

    public LocalizerFactory getLocalizerFactory() {
        return this.localizerFactory;
    }

    public void setDefaultLanguage(String language) {
        this.defaultLanguage = language;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultCountry(String country) {
        this.defaultCountry = country;
    }

    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public Numberer makeNumberer(String language, String country) {
        if (this.localizerFactory == null) {
            return new Numberer_en();
        }
        Numberer numberer = this.localizerFactory.getNumberer(language, country);
        if (numberer == null) {
            numberer = new Numberer_en();
        }
        return numberer;
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.moduleURIResolver = resolver;
    }

    public void setModuleURIResolver(String className) throws TransformerException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (!(obj instanceof ModuleURIResolver)) {
            throw new XPathException("Class " + className + " is not a ModuleURIResolver");
        }
        this.setModuleURIResolver((ModuleURIResolver)obj);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public ModuleURIResolver getStandardModuleURIResolver() {
        return this.standardModuleURIResolver;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public CompilerInfo getDefaultXsltCompilerInfo() {
        return this.defaultXsltCompilerInfo;
    }

    public StaticQueryContext getDefaultStaticQueryContext() {
        if (this.defaultStaticQueryContext == null) {
            this.defaultStaticQueryContext = new StaticQueryContext(this, true);
        }
        return this.defaultStaticQueryContext;
    }

    public int getRecoveryPolicy() {
        return this.defaultXsltCompilerInfo.getRecoveryPolicy();
    }

    public void setRecoveryPolicy(int recoveryPolicy) {
        this.defaultXsltCompilerInfo.setRecoveryPolicy(recoveryPolicy);
    }

    public String getMessageEmitterClass() {
        return this.defaultXsltCompilerInfo.getMessageReceiverClassName();
    }

    public void setMessageEmitterClass(String messageReceiverClassName) {
        this.defaultXsltCompilerInfo.setMessageReceiverClassName(messageReceiverClassName);
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String sourceParserClass) {
        this.sourceParserClass = sourceParserClass;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String parser) {
        this.styleParserClass = parser;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.defaultXsltCompilerInfo.getOutputURIResolver();
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.defaultXsltCompilerInfo.setOutputURIResolver(outputURIResolver);
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this.serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public CharacterSetFactory getCharacterSetFactory() {
        if (this.characterSetFactory == null) {
            this.characterSetFactory = new CharacterSetFactory();
        }
        return this.characterSetFactory;
    }

    public void setDefaultSerializationProperties(Properties props) {
        this.defaultSerializationProperties = props;
    }

    public Properties getDefaultSerializationProperties() {
        return this.defaultSerializationProperties;
    }

    public void processResultDocument(ResultDocument instruction, Expression content, XPathContext context) throws XPathException {
        instruction.processInstruction(content, context);
    }

    public boolean isTiming() {
        return this.enabledProperties.contains("http://saxon.sf.net/feature/timing");
    }

    public void setTiming(boolean timing) {
        if (timing) {
            this.enabledProperties.add("http://saxon.sf.net/feature/timing");
        } else {
            this.enabledProperties.remove("http://saxon.sf.net/feature/timing");
        }
    }

    public boolean isVersionWarning() {
        return this.defaultXsltCompilerInfo.isVersionWarning();
    }

    public void setVersionWarning(boolean warn) {
        this.defaultXsltCompilerInfo.setVersionWarning(warn);
    }

    public boolean isAllowStreamabilityExtensions() {
        return this.enabledProperties.contains("http://saxon.sf.net/feature/allow-streamability-extensions");
    }

    public boolean isValidation() {
        return this.defaultParseOptions.getDTDValidationMode() == 1 || this.defaultParseOptions.getDTDValidationMode() == 2;
    }

    public void setValidation(boolean validation) {
        this.defaultParseOptions.setDTDValidationMode(validation ? 1 : 4);
    }

    public FilterFactory makeDocumentProjector(PathMap.PathMapRoot map) {
        throw new UnsupportedOperationException("Document projection requires Saxon-EE");
    }

    public int getSchemaValidationMode() {
        return this.defaultParseOptions.getSchemaValidationMode();
    }

    public void setSchemaValidationMode(int validationMode) {
        switch (validationMode) {
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                if (this.isLicensedFeature(1)) break;
                validationMode = 4;
                break;
            }
            case 1: {
                this.checkLicensedFeature(1, "strict validation");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation mode " + validationMode);
            }
        }
        this.defaultParseOptions.setSchemaValidationMode(validationMode);
    }

    public void setValidationWarnings(boolean warn) {
        this.defaultParseOptions.setContinueAfterValidationErrors(warn);
    }

    public boolean isValidationWarnings() {
        return this.defaultParseOptions.isContinueAfterValidationErrors();
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.defaultParseOptions.setExpandAttributeDefaults(expand);
    }

    public boolean isExpandAttributeDefaults() {
        return this.defaultParseOptions.isExpandAttributeDefaults();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setNamePool(NamePool targetNamePool) {
        this.namePool = targetNamePool;
    }

    public TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchy(this);
        }
        return this.typeHierarchy;
    }

    public DocumentNumberAllocator getDocumentNumberAllocator() {
        return this.documentNumberAllocator;
    }

    public void setDocumentNumberAllocator(DocumentNumberAllocator allocator) {
        this.documentNumberAllocator = allocator;
    }

    public boolean isCompatible(Configuration other) {
        return this.namePool == other.namePool && this.documentNumberAllocator == other.documentNumberAllocator;
    }

    public DocumentPool getGlobalDocumentPool() {
        return this.globalDocumentPool;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.defaultParseOptions.getStripSpace() == 2;
    }

    public void setStripsAllWhiteSpace(boolean stripsAllWhiteSpace) {
        if (stripsAllWhiteSpace) {
            this.defaultParseOptions.setStripSpace(2);
        }
    }

    public void setStripsWhiteSpace(int kind) {
        this.defaultParseOptions.setStripSpace(kind);
    }

    public int getStripsWhiteSpace() {
        return this.defaultParseOptions.getStripSpace();
    }

    public XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        XMLReader parser;
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ConcurrentLinkedQueue();
        }
        if ((parser = this.sourceParserPool.poll()) != null) {
            return parser;
        }
        parser = this.getSourceParserClass() != null ? this.makeParser(this.getSourceParserClass()) : Configuration.loadParser();
        if (this.isTiming()) {
            this.reportParserDetails(parser);
        }
        try {
            Sender.configureParser(parser);
        }
        catch (XPathException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        if (this.isValidation()) {
            try {
                parser.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException err) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return parser;
    }

    private void reportParserDetails(XMLReader reader) {
        String name = reader.getClass().getName();
        this.standardErrorOutput.println("Using parser " + name);
    }

    public synchronized void reuseSourceParser(XMLReader parser) {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ConcurrentLinkedQueue();
        }
        try {
            try {
                parser.setContentHandler(null);
                if (parser.getEntityResolver() == this.defaultParseOptions.getEntityResolver()) {
                    parser.setEntityResolver(null);
                }
                parser.setDTDHandler(null);
                parser.setErrorHandler(null);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
            }
            catch (SAXNotRecognizedException err) {
            }
            catch (SAXNotSupportedException err) {
                // empty catch block
            }
            this.sourceParserPool.offer(parser);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static XMLReader loadParser() {
        return platform.loadParser();
    }

    public synchronized XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        XMLReader parser;
        if (this.styleParserPool == null) {
            this.styleParserPool = new ConcurrentLinkedQueue();
        }
        if ((parser = this.styleParserPool.poll()) != null) {
            return parser;
        }
        if (this.getStyleParserClass() != null) {
            parser = this.makeParser(this.getStyleParserClass());
        } else {
            parser = Configuration.loadParser();
            StandardEntityResolver resolver = new StandardEntityResolver();
            resolver.setConfiguration(this);
            parser.setEntityResolver(resolver);
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException e) {
            throw new TransformerFactoryConfigurationError(e);
        }
        catch (SAXNotSupportedException e) {
            throw new TransformerFactoryConfigurationError(e);
        }
        return parser;
    }

    public synchronized void reuseStyleParser(XMLReader parser) {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ConcurrentLinkedQueue();
        }
        try {
            try {
                parser.setContentHandler(null);
                parser.setDTDHandler(null);
                parser.setErrorHandler(null);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
            }
            catch (SAXNotRecognizedException err) {
            }
            catch (SAXNotSupportedException err) {
                // empty catch block
            }
            this.styleParserPool.offer(parser);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadSchema(String absoluteURI) throws SchemaException {
        this.readSchema(this.makePipelineConfiguration(), "", absoluteURI, null);
    }

    public String readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, String expected) throws SchemaException {
        this.needEnterpriseEdition();
        return null;
    }

    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, Collection<String> schemaLocations, String expected) throws SchemaException {
        this.needEnterpriseEdition();
    }

    public String readInlineSchema(NodeInfo root, String expected, ErrorListener errorListener) throws SchemaException {
        this.needEnterpriseEdition();
        return null;
    }

    protected void needEnterpriseEdition() {
        throw new UnsupportedOperationException("You need the Enterprise Edition of Saxon (with an EnterpriseConfiguration) for this operation");
    }

    public void addSchemaSource(Source schemaSource) throws SchemaException {
        this.addSchemaSource(schemaSource, this.getErrorListener());
    }

    public void addSchemaSource(Source schemaSource, ErrorListener errorListener) throws SchemaException {
        this.needEnterpriseEdition();
    }

    public void addSchemaForBuiltInNamespace(String namespace) {
    }

    public boolean isSchemaAvailable(String targetNamespace) {
        return false;
    }

    public void clearSchemaCache() {
    }

    public Set getImportedNamespaces() {
        return Collections.EMPTY_SET;
    }

    public void sealNamespace(String namespace) {
    }

    public Collection<GlobalParam> getDeclaredSchemaParameters() {
        return null;
    }

    public Iterator<? extends SchemaType> getExtensionsOfType(SchemaType type) {
        Set e = Collections.emptySet();
        return e.iterator();
    }

    public void importComponents(Source source) throws XPathException {
        this.needEnterpriseEdition();
    }

    public void exportComponents(Receiver out) throws XPathException {
        this.needEnterpriseEdition();
    }

    public FunctionItem getSchemaAsFunctionItem() {
        return null;
    }

    public FunctionItem getSchemaComponentAsFunctionItem(String kind, QNameValue name) throws XPathException {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(int fingerprint) {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(StructuredQName qName) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int fingerprint) {
        return null;
    }

    public SchemaType getSchemaType(int fingerprint) {
        if (fingerprint < 1023) {
            return BuiltInType.getSchemaType(fingerprint);
        }
        return null;
    }

    @Override
    public boolean isDeclaredNotation(String uri, String local) {
        return false;
    }

    protected ExternalObjectType getExternalObjectType(int fingerprint) {
        if (this.getNamePool().getURI(fingerprint).equals("http://saxon.sf.net/java-type")) {
            try {
                Class namedClass = this.dynamicLoader.getClass(this.getNamePool().getLocalName(fingerprint), null, null);
                if (namedClass == null) {
                    return null;
                }
                return new ExternalObjectType(namedClass, this);
            }
            catch (XPathException err) {
                return null;
            }
        }
        return null;
    }

    public void checkTypeDerivationIsOK(SchemaType derived, SchemaType base, int block) throws SchemaException {
    }

    public Receiver getDocumentValidator(Receiver receiver, String systemId, ParseOptions validationOptions) {
        return receiver;
    }

    public SequenceReceiver getElementValidator(SequenceReceiver receiver, ParseOptions validationOptions, int locationId) throws XPathException {
        return receiver;
    }

    public SimpleType validateAttribute(int nameCode, CharSequence value, int validation) throws ValidationException {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public Receiver getAnnotationStripper(Receiver destination) {
        return destination;
    }

    public XMLReader makeParser(String className) throws TransformerFactoryConfigurationError {
        Object obj;
        try {
            obj = this.dynamicLoader.getInstance(className, null);
        }
        catch (XPathException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        if (obj instanceof XMLReader) {
            return (XMLReader)obj;
        }
        throw new TransformerFactoryConfigurationError("Class " + className + " is not a SAX2 XMLReader");
    }

    public ExpressionParser newExpressionParser(String language, boolean updating, DecimalValue languageVersion) {
        if ("XQ".equals(language)) {
            if (updating) {
                throw new UnsupportedOperationException("XQuery Update is supported only in Saxon-EE");
            }
            if (DecimalValue.THREE.equals(languageVersion) || DecimalValue.ONE_POINT_ONE.equals(languageVersion)) {
                throw new UnsupportedOperationException("XQuery 3.0 extensions are supported only in Saxon-PE");
            }
            if (DecimalValue.ONE.equals(languageVersion)) {
                return new QueryParser();
            }
            throw new IllegalArgumentException("Unknown XQuery version " + languageVersion);
        }
        if ("XP".equals(language)) {
            if (DecimalValue.THREE.equals(languageVersion)) {
                throw new UnsupportedOperationException("XPath 3.0 extensions are supported only in Saxon-PE");
            }
            if (DecimalValue.TWO.equals(languageVersion)) {
                return new ExpressionParser();
            }
            throw new IllegalArgumentException("Unknown XPath version " + languageVersion);
        }
        if ("PATTERN".equals(language)) {
            if (DecimalValue.THREE.equals(languageVersion)) {
                throw new UnsupportedOperationException("XSLT 3.0 extensions are supported only in Saxon-PE");
            }
            return new PatternParser20();
        }
        throw new IllegalArgumentException("Unknown expression language " + language);
    }

    public Expression makeOuterForExpression() {
        throw new UnsupportedOperationException("'allowing empty' requires Saxon-PE or -EE");
    }

    public static Locale getLocale(String lang) {
        String country;
        String language;
        int hyphen = lang.indexOf("-");
        if (hyphen < 1) {
            language = lang;
            country = "";
        } else {
            language = lang.substring(1, hyphen);
            country = lang.substring(hyphen + 1);
        }
        return new Locale(language, country);
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public SlotManager makeSlotManager() {
        if (this.debugger == null) {
            return new SlotManager();
        }
        return this.debugger.makeSlotManager();
    }

    public Receiver makeStreamingTransformer(XPathContext context, Mode mode) throws XPathException {
        throw new XPathException("Streaming is only available in Saxon-EE");
    }

    public Optimizer obtainOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer(this);
            this.optimizer.setOptimizationLevel(this.optimizationLevel);
            assert (this.optimizer != null);
            return this.optimizer;
        }
        return this.optimizer;
    }

    public Sequence makeClosure(Expression expression, int ref, XPathContext context) throws XPathException {
        Closure seq = new Closure();
        if (ref > 1) {
            seq = new MemoClosure();
        }
        return seq;
    }

    public Sequence makeSequenceExtent(Expression expression, int ref, XPathContext context) throws XPathException {
        return SequenceExtent.makeSequenceExtent(expression.iterate(context));
    }

    public StyleNodeFactory makeStyleNodeFactory() {
        return new StyleNodeFactory(this);
    }

    public void registerExternalObjectModel(ExternalObjectModel model) {
        if (this.externalObjectModels == null) {
            this.externalObjectModels = new ArrayList<ExternalObjectModel>(4);
        }
        if (!this.externalObjectModels.contains(model)) {
            this.externalObjectModels.add(model);
        }
    }

    public ExternalObjectModel getExternalObjectModel(String uri) {
        for (ExternalObjectModel model : this.externalObjectModels) {
            if (!model.getIdentifyingURI().equals(uri)) continue;
            return model;
        }
        return null;
    }

    public ExternalObjectModel getExternalObjectModel(Class nodeClass) {
        for (ExternalObjectModel model : this.externalObjectModels) {
            PJConverter converter = model.getPJConverter(nodeClass);
            if (converter == null) continue;
            return model;
        }
        return null;
    }

    public List<ExternalObjectModel> getExternalObjectModels() {
        return this.externalObjectModels;
    }

    public NodeInfo unravel(Source source) {
        List<ExternalObjectModel> externalObjectModels = this.getExternalObjectModels();
        for (ExternalObjectModel model : externalObjectModels) {
            NodeInfo node = model.unravel(source, this);
            if (node == null) continue;
            if (node.getConfiguration() != this) {
                throw new IllegalArgumentException("Externally supplied Node belongs to the wrong Configuration");
            }
            return node;
        }
        if (source instanceof NodeInfo) {
            if (((NodeInfo)source).getConfiguration() != this) {
                throw new IllegalArgumentException("Externally supplied NodeInfo belongs to the wrong Configuration");
            }
            return (NodeInfo)source;
        }
        throw new IllegalArgumentException("A source of class " + source.getClass() + " is not recognized by any registered object model");
    }

    public void setDOMLevel(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException("DOM Level must be 2 or 3");
        }
        this.domLevel = level;
    }

    public int getDOMLevel() {
        return this.domLevel;
    }

    public void setStaticQueryContextFactory(StaticQueryContextFactory factory) {
        this.staticQueryContextFactory = factory;
    }

    public StaticQueryContext newStaticQueryContext() {
        return this.staticQueryContextFactory.newStaticQueryContext(this);
    }

    public PendingUpdateList newPendingUpdateList() {
        throw new UnsupportedOperationException("XQuery update is supported only in Saxon-EE");
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = new PipelineConfiguration(this);
        pipe.setURIResolver(this.getURIResolver());
        pipe.setSchemaURIResolver(this.getSchemaURIResolver());
        pipe.setHostLanguage(this.getHostLanguage());
        pipe.setParseOptions(new ParseOptions(this.defaultParseOptions));
        return pipe;
    }

    public static Configuration getConfiguration(XPathContext context) {
        return context.getConfiguration();
    }

    public void setSourceResolver(SourceResolver resolver) {
        this.sourceResolver = resolver;
    }

    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    @Override
    public Source resolveSource(Source source, Configuration config) throws XPathException {
        if (source instanceof AugmentedSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return source;
        }
        if (source instanceof SAXSource) {
            return source;
        }
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof NodeInfo) {
            return source;
        }
        if (source instanceof PullSource) {
            return source;
        }
        if (source instanceof PullEventSource) {
            return source;
        }
        return null;
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        ParseOptions options;
        if (source == null) {
            throw new NullPointerException("source");
        }
        Source src2 = this.resolveSource(source, this);
        if (src2 == null) {
            throw new XPathException("Unknown source class " + source.getClass().getName());
        }
        Source underlyingSource = source = src2;
        if (source instanceof AugmentedSource) {
            options = ((AugmentedSource)source).getParseOptions();
            underlyingSource = ((AugmentedSource)source).getContainedSource();
        } else {
            options = new ParseOptions();
        }
        source = underlyingSource;
        return this.buildDocument(source, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentInfo buildDocument(Source source, ParseOptions parseOptions) throws XPathException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        boolean finallyClose = false;
        try {
            ParseOptions options = new ParseOptions(parseOptions);
            Source src2 = this.resolveSource(source, this);
            if (src2 == null) {
                throw new XPathException("Unknown source class " + source.getClass().getName());
            }
            source = src2;
            if (source instanceof AugmentedSource) {
                options.merge(((AugmentedSource)source).getParseOptions());
            }
            options.applyDefaults(this);
            finallyClose = options.isPleaseCloseAfterUse();
            TreeModel treeModel = options.getModel();
            boolean lineNumbering = options.isLineNumbering();
            PipelineConfiguration pipe = this.makePipelineConfiguration();
            Builder builder = treeModel.makeBuilder(pipe);
            builder.setTiming(this.isTiming());
            builder.setLineNumbering(lineNumbering);
            builder.setPipelineConfiguration(pipe);
            Sender.send(source, new NamespaceReducer(builder), options);
            NodeInfo newdoc = builder.getCurrentRoot();
            if (!(newdoc instanceof DocumentInfo)) {
                throw new XPathException("Source object represents a node other than a document node");
            }
            builder.reset();
            DocumentInfo documentInfo = (DocumentInfo)newdoc;
            return documentInfo;
        }
        finally {
            if (finallyClose) {
                ParseOptions.close(source);
            }
        }
    }

    public Receiver makeEmitter(String clarkName, Properties props) throws XPathException {
        Object handler;
        int brace = clarkName.indexOf(125);
        String localName = clarkName.substring(brace + 1);
        int colon = localName.indexOf(58);
        String className = localName.substring(colon + 1);
        try {
            handler = this.dynamicLoader.getInstance(className, null);
        }
        catch (XPathException e) {
            throw new XPathException("Cannot create user-supplied output method. " + e.getMessage(), "SXCH0004");
        }
        if (handler instanceof Receiver) {
            return (Receiver)handler;
        }
        if (handler instanceof ContentHandler) {
            ContentHandlerProxy emitter = new ContentHandlerProxy();
            emitter.setUnderlyingContentHandler((ContentHandler)handler);
            emitter.setOutputProperties(props);
            return emitter;
        }
        throw new XPathException("Output method " + className + " is neither a Receiver nor a SAX2 ContentHandler");
    }

    public NodeInfo makeUnconstructedElement(ElementCreator instr, XPathContext context) throws XPathException {
        throw new XPathException("Lazy element construction requires Saxon-PE");
    }

    public DocumentInfo makeUnconstructedDocument(DocumentInstr instr, XPathContext context) throws XPathException {
        throw new XPathException("Lazy document construction requires Saxon-PE");
    }

    public int getSiblingPosition(NodeInfo node, NodeTest nodeTest, int max) throws XPathException {
        AxisIterator prev = node.iterateAxis((byte)11, nodeTest);
        int count = 1;
        do {
            Object n;
            if ((n = prev.next()) != null) continue;
            return count;
        } while (++count <= max);
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfigurationProperty(String name, Object value) {
        if (name.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            this.internalSetBooleanProperty(name, value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/allow-multithreading")) {
            this.internalSetBooleanProperty(name, value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            if (!(value instanceof CollationURIResolver)) {
                throw new IllegalArgumentException("COLLATION_URI_RESOLVER value must be an instance of net.sf.saxon.lib.CollationURIResolver");
            }
            this.setCollationURIResolver((CollationURIResolver)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver-class")) {
            this.setCollationURIResolver((CollationURIResolver)this.instantiateClassName(name, value, CollationURIResolver.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            if (!(value instanceof CollectionURIResolver)) {
                throw new IllegalArgumentException("COLLECTION_URI_RESOLVER value must be an instance of net.sf.saxon.lib.CollectionURIResolver");
            }
            this.setCollectionURIResolver((CollectionURIResolver)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver-class")) {
            this.setCollectionURIResolver((CollectionURIResolver)this.instantiateClassName(name, value, CollectionURIResolver.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/compile-with-tracing")) {
            boolean b = this.requireBoolean("COMPILE_WITH_TRACING", value);
            this.setCompileWithTracing(b);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/defaultCollation")) {
            this.getCollationMap().setDefaultCollationName(value.toString());
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/defaultCollection")) {
            this.setDefaultCollection(value.toString());
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/defaultCountry")) {
            this.setDefaultCountry(value.toString());
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/defaultLanguage")) {
            this.setDefaultLanguage(value.toString());
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/validation")) {
            boolean b = this.requireBoolean(name, value);
            this.setValidation(b);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/dtd-validation-recoverable")) {
            boolean b = this.requireBoolean(name, value);
            if (b) {
                this.defaultParseOptions.setDTDValidationMode(2);
                return;
            } else {
                this.defaultParseOptions.setDTDValidationMode(this.isValidation() ? 1 : 4);
            }
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/entityResolverClass")) {
            if ("".equals(value)) {
                this.defaultParseOptions.setEntityResolver(null);
                return;
            } else {
                this.defaultParseOptions.setEntityResolver((EntityResolver)this.instantiateClassName(name, value, EntityResolver.class));
            }
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/environmentVariableResolver")) {
            if (!(value instanceof EnvironmentVariableResolver)) {
                throw new IllegalArgumentException("ENVIRONMENT_VARIABLE_RESOLVER value must be an instance of net.sf.saxon.lib.EnvironmentVariableResolver");
            }
            this.environmentVariableResolver = (EnvironmentVariableResolver)value;
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/environmentVariableResolverClass")) {
            this.environmentVariableResolver = (EnvironmentVariableResolver)this.instantiateClassName(name, value, EnvironmentVariableResolver.class);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/errorListenerClass")) {
            this.setErrorListener((ErrorListener)this.instantiateClassName(name, value, ErrorListener.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/expandAttributeDefaults")) {
            boolean b = this.requireBoolean(name, value);
            this.setExpandAttributeDefaults(b);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/ignoreSAXSourceParser")) {
            this.internalSetBooleanProperty(name, value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/lazyConstructionMode")) {
            this.internalSetBooleanProperty(name, value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/linenumbering")) {
            boolean b = this.requireBoolean(name, value);
            this.setLineNumbering(b);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("MESSAGE_EMITTER_CLASS class must be a String");
            }
            this.setMessageEmitterClass((String)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/moduleURIResolver")) {
            if (!(value instanceof ModuleURIResolver)) {
                throw new IllegalArgumentException("MODULE_URI_RESOLVER value must be an instance of net.sf.saxon.lib.ModuleURIResolver");
            }
            this.setModuleURIResolver((ModuleURIResolver)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/moduleURIResolverClass")) {
            this.setModuleURIResolver((ModuleURIResolver)this.instantiateClassName(name, value, ModuleURIResolver.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/namePool")) {
            if (!(value instanceof NamePool)) {
                throw new IllegalArgumentException("NAME_POOL value must be an instance of net.sf.saxon.om.NamePool");
            }
            this.setNamePool((NamePool)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/optimizationLevel")) {
            String s2 = this.requireString(name, value);
            try {
                this.optimizationLevel = Integer.parseInt(s2);
                if (this.optimizationLevel < 0 || this.optimizationLevel > 10) {
                    throw new IllegalArgumentException("OPTIMIZATION_LEVEL must be in the range 0 to 10");
                }
                if (this.optimizer != null) {
                    this.optimizer.setOptimizationLevel(this.optimizationLevel);
                }
                if (this.optimizationLevel >= 10) return;
                this.internalSetBooleanProperty("http://saxon.sf.net/feature/generateByteCode", false);
                return;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("OPTIMIZATION_LEVEL value must be a number represented as a string");
            }
        }
        if (name.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            if (!(value instanceof OutputURIResolver)) {
                throw new IllegalArgumentException("OUTPUT_URI_RESOLVER value must be an instance of net.sf.saxon.lib.OutputURIResolver");
            }
            this.setOutputURIResolver((OutputURIResolver)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/outputURIResolverClass")) {
            this.setOutputURIResolver((OutputURIResolver)this.instantiateClassName(name, value, OutputURIResolver.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/preEvaluateDocFunction")) {
            this.internalSetBooleanProperty(name, value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/preferJaxpParser")) {
            this.internalSetBooleanProperty(name, value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            boolean b = this.requireBoolean(name, value);
            this.getSystemURIResolver().setRecognizeQueryParameters(b);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("RECOVERY_POLICY value must be an Integer");
            }
            this.setRecoveryPolicy((Integer)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/recoveryPolicyName")) {
            int rval;
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("RECOVERY_POLICY_NAME value must be a String");
            }
            if (value.equals("recoverSilently")) {
                rval = 0;
            } else if (value.equals("recoverWithWarnings")) {
                rval = 1;
            } else {
                if (!value.equals("doNotRecover")) throw new IllegalArgumentException("Unrecognized value of RECOVERY_POLICY_NAME = '" + value + "': must be 'recoverSilently', 'recoverWithWarnings', or 'doNotRecover'");
                rval = 2;
            }
            this.setRecoveryPolicy(rval);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/serializerFactoryClass")) {
            this.setSerializerFactory((SerializerFactory)this.instantiateClassName(name, value, OutputURIResolver.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/schemaURIResolver")) {
            if (!(value instanceof SchemaURIResolver)) {
                throw new IllegalArgumentException("SCHEMA_URI_RESOLVER value must be an instance of net.sf.saxon.lib.SchemaURIResolver");
            }
            this.setSchemaURIResolver((SchemaURIResolver)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/schemaURIResolverClass")) {
            this.setSchemaURIResolver((SchemaURIResolver)this.instantiateClassName(name, value, SchemaURIResolver.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/schema-validation")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION must be an integer");
            }
            this.setSchemaValidationMode((Integer)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/schema-validation-mode")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION_MODE must be a string");
            }
            this.setSchemaValidationMode(Validation.getCode((String)value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("SOURCE_PARSER_CLASS class must be a String");
            }
            this.setSourceParserClass((String)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/sourceResolverClass")) {
            this.setSourceResolver((SourceResolver)this.instantiateClassName(name, value, SourceResolver.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/standardErrorOutputFile")) {
            try {
                boolean append = true;
                boolean autoFlush = true;
                this.setStandardErrorOutput(new PrintStream(new FileOutputStream((String)value, append), autoFlush));
                return;
            }
            catch (FileNotFoundException fnf) {
                throw new IllegalArgumentException(fnf);
            }
        }
        if (name.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            int ival;
            String s3 = this.requireString(name, value);
            if (s3.equals("all")) {
                ival = 2;
            } else if (s3.equals("none")) {
                ival = 0;
            } else {
                if (!s3.equals("ignorable")) throw new IllegalArgumentException("Unrecognized value STRIP_WHITESPACE = '" + value + "': must be 'all', 'none', or 'ignorable'");
                ival = 1;
            }
            this.setStripsWhiteSpace(ival);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/styleParserClass")) {
            this.setStyleParserClass(this.requireString(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/timing")) {
            this.setTiming(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            this.internalSetBooleanProperty("http://saxon.sf.net/feature/trace-external-functions", value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/trace-optimizer-decisions")) {
            this.internalSetBooleanProperty(name, value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/traceListener")) {
            if (!(value instanceof TraceListener)) {
                throw new IllegalArgumentException("TRACE_LISTENER is of wrong class");
            }
            this.setTraceListener((TraceListener)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/traceListenerClass")) {
            this.setTraceListenerClass(this.requireString(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/treeModel")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("Tree model must be an Integer");
            }
            this.setTreeModel((Integer)value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/treeModelName")) {
            String s4 = this.requireString(name, value);
            if (s4.equals("tinyTree")) {
                this.setTreeModel(1);
                return;
            } else if (s4.equals("tinyTreeCondensed")) {
                this.setTreeModel(2);
                return;
            } else if (s4.equals("linkedTree")) {
                this.setTreeModel(0);
                return;
            } else if (s4.equals("jdom")) {
                this.setTreeModel(3);
                return;
            } else {
                if (!s4.equals("jdom2")) throw new IllegalArgumentException("Unrecognized value TREE_MODEL_NAME = '" + value + "': must be linkedTree|tinyTree|tinyTreeCondensed");
                this.setTreeModel(4);
            }
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/uriResolverClass")) {
            this.setURIResolver((URIResolver)this.instantiateClassName(name, value, URIResolver.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/use-pi-disable-output-escaping")) {
            this.internalSetBooleanProperty(name, value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/use-typed-value-cache")) {
            this.internalSetBooleanProperty(name, value);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/useXsiSchemaLocation")) {
            this.defaultParseOptions.setUseXsiSchemaLocation(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/validation-comments")) {
            this.defaultParseOptions.setAddCommentsAfterValidationErrors(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/validation-warnings")) {
            this.setValidationWarnings(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/version-warning")) {
            this.setVersionWarning(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xinclude-aware")) {
            this.setXIncludeAware(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryAllowUpdate")) {
            this.getDefaultStaticQueryContext().setUpdatingEnabled(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryConstructionMode")) {
            this.getDefaultStaticQueryContext().setConstructionMode(Validation.getCode(value.toString()));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryDefaultElementNamespace")) {
            this.getDefaultStaticQueryContext().setDefaultElementNamespace(value.toString());
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace")) {
            this.getDefaultStaticQueryContext().setDefaultFunctionNamespace(value.toString());
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryEmptyLeast")) {
            this.getDefaultStaticQueryContext().setEmptyLeast(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryInheritNamespaces")) {
            this.getDefaultStaticQueryContext().setInheritNamespaces(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryPreserveBoundarySpace")) {
            this.getDefaultStaticQueryContext().setPreserveBoundarySpace(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryPreserveNamespaces")) {
            this.getDefaultStaticQueryContext().setPreserveNamespaces(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryRequiredContextItemType")) {
            ExpressionParser parser = new ExpressionParser();
            parser.setLanguage(2, DecimalValue.THREE);
            try {
                SequenceType type = parser.parseSequenceType(value.toString(), new IndependentContext(this));
                this.getDefaultStaticQueryContext().setRequiredContextItemType(type.getPrimaryType());
                return;
            }
            catch (XPathException err) {
                throw new IllegalArgumentException(err);
            }
        }
        if (name.equals("http://saxon.sf.net/feature/xquerySchemaAware")) {
            this.getDefaultStaticQueryContext().setSchemaAware(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryStaticErrorListenerClass")) {
            this.getDefaultStaticQueryContext().setErrorListener((ErrorListener)this.instantiateClassName(name, value, ErrorListener.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryVersion")) {
            DecimalValue version;
            if ("1.1".equals(value)) {
                value = "3.0";
            }
            try {
                version = (DecimalValue)DecimalValue.makeDecimalValue(value.toString(), true);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("XQuery version");
            }
            this.getDefaultStaticQueryContext().setLanguageVersion(version);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xml-version") || name.equals("http://saxon.sf.bet/feature/xml-version")) {
            String s5 = this.requireString(name, value);
            if (!s5.equals("1.0") && !s5.equals("1.1")) {
                throw new IllegalArgumentException("XML_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            this.setXMLVersion(s5.equals("1.0") ? 10 : 11);
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xsd-version")) {
            String s6 = this.requireString(name, value);
            if (!s6.equals("1.0") && !s6.equals("1.1")) {
                throw new IllegalArgumentException("XSD_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            this.xsdVersion = value.equals("1.0") ? 10 : 11;
            this.theConversionRules = null;
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/initialMode")) {
            String s7 = this.requireString(name, value);
            this.getDefaultXsltCompilerInfo().setDefaultInitialMode(StructuredQName.fromClarkName(s7));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/initialTemplate")) {
            String s8 = this.requireString(name, value);
            this.getDefaultXsltCompilerInfo().setDefaultInitialTemplate(StructuredQName.fromClarkName(s8));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/xsltSchemaAware")) {
            this.getDefaultXsltCompilerInfo().setSchemaAware(this.requireBoolean(name, value));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/stylesheetErrorListener")) {
            this.getDefaultXsltCompilerInfo().setErrorListener((ErrorListener)this.instantiateClassName(name, value, ErrorListener.class));
            return;
        }
        if (name.equals("http://saxon.sf.net/feature/stylesheetURIResolver")) {
            this.getDefaultXsltCompilerInfo().setURIResolver((URIResolver)this.instantiateClassName(name, value, URIResolver.class));
            return;
        }
        if (!name.equals("http://saxon.sf.net/feature/xsltVersion")) throw new IllegalArgumentException("Unknown configuration option " + name);
        try {
            if ("2.1".equals(value)) {
                value = "3.0";
            }
            ConversionResult vn = DecimalValue.makeDecimalValue(this.requireString(name, value), true);
            DecimalValue dv = (DecimalValue)vn.asAtomic();
            this.getDefaultXsltCompilerInfo().setXsltVersion(dv);
            return;
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException("XSLT version must be a decimal number");
        }
    }

    protected boolean requireBoolean(String propertyName, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if ("true".equals(value) || "on".equals(value) || "yes".equals(value) || "1".equals(value)) {
                return true;
            }
            if ("false".equals(value) || "off".equals(value) || "no".equals(value) || "0".equals(value)) {
                return false;
            }
            throw new IllegalArgumentException(propertyName + " must be 'true' or 'false' (or on|off, yes|no, 1|0)");
        }
        throw new IllegalArgumentException(propertyName + " must be a boolean (or a string representing a boolean)");
    }

    protected void internalSetBooleanProperty(String propertyName, Object value) {
        boolean b = this.requireBoolean(propertyName, value);
        if (b) {
            this.enabledProperties.add(propertyName);
        } else {
            this.enabledProperties.remove(propertyName);
        }
    }

    public boolean getBooleanProperty(String propertyName) {
        return this.enabledProperties.contains(propertyName);
    }

    public void setBooleanProperty(String propertyName, boolean value) {
        this.setConfigurationProperty(propertyName, value);
    }

    protected String requireString(String propertyName, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("The value of " + propertyName + " must be a string");
    }

    protected Object instantiateClassName(String propertyName, Object value, Class requiredClass) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(propertyName + " must be a String");
        }
        try {
            Object obj = this.getInstance((String)value, null);
            if (!requiredClass.isAssignableFrom(obj.getClass())) {
                throw new IllegalArgumentException("Error in " + propertyName + ": Class " + value + " does not implement " + requiredClass.getName());
            }
            return obj;
        }
        catch (XPathException err) {
            throw new IllegalArgumentException("Cannot use " + value + " as the value of " + propertyName + ". " + err.getMessage());
        }
    }

    public Object getConfigurationProperty(String name) {
        if (name.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/allow-multithreading")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            return this.getCollationURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver-class")) {
            return this.getCollationURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            return this.getCollectionURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver-class")) {
            return this.getCollectionURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/generateByteCode")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/compile-with-tracing")) {
            return this.isCompileWithTracing();
        }
        if (name.equals("http://saxon.sf.net/feature/defaultCollation")) {
            return this.getCollationMap().getDefaultCollationName();
        }
        if (name.equals("http://saxon.sf.net/feature/defaultCollection")) {
            return this.getDefaultCollection();
        }
        if (name.equals("http://saxon.sf.net/feature/defaultCountry")) {
            return this.getDefaultCountry();
        }
        if (name.equals("http://saxon.sf.net/feature/defaultLanguage")) {
            return this.getDefaultLanguage();
        }
        if (name.equals("http://saxon.sf.net/feature/validation")) {
            return this.isValidation();
        }
        if (name.equals("http://saxon.sf.net/feature/dtd-validation-recoverable")) {
            return this.defaultParseOptions.getDTDValidationMode() == 2;
        }
        if (name.equals("http://saxon.sf.net/feature/errorListenerClass")) {
            return this.getErrorListener().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/entityResolverClass")) {
            EntityResolver er = this.defaultParseOptions.getEntityResolver();
            if (er == null) {
                return "";
            }
            return er.getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/environmentVariableResolver")) {
            return this.environmentVariableResolver;
        }
        if (name.equals("http://saxon.sf.net/feature/environmentVariableResolverClass")) {
            return this.environmentVariableResolver.getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/expandAttributeDefaults")) {
            return this.isExpandAttributeDefaults();
        }
        if (name.equals("http://saxon.sf.net/feature/ignoreSAXSourceParser")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/lazyConstructionMode")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/linenumbering")) {
            return this.isLineNumbering();
        }
        if (name.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            return this.getMessageEmitterClass();
        }
        if (name.equals("http://saxon.sf.net/feature/moduleURIResolver")) {
            return this.getModuleURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/moduleURIResolverClass")) {
            return this.getModuleURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/namePool")) {
            return this.getNamePool();
        }
        if (name.equals("http://saxon.sf.net/feature/optimizationLevel")) {
            return "" + this.optimizationLevel;
        }
        if (name.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            return this.getOutputURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/outputURIResolverClass")) {
            return this.getOutputURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/preEvaluateDocFunction")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/preferJaxpParser")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            return this.getSystemURIResolver().queryParametersAreRecognized();
        }
        if (name.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            return this.getRecoveryPolicy();
        }
        if (name.equals("http://saxon.sf.net/feature/recoveryPolicyName")) {
            switch (this.getRecoveryPolicy()) {
                case 0: {
                    return "recoverSilently";
                }
                case 1: {
                    return "recoverWithWarnings";
                }
                case 2: {
                    return "doNotRecover";
                }
            }
            throw new IllegalStateException();
        }
        if (name.equals("http://saxon.sf.net/feature/schemaURIResolver")) {
            return this.getSchemaURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/schemaURIResolverClass")) {
            return this.getSchemaURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/schema-validation")) {
            return this.getSchemaValidationMode();
        }
        if (name.equals("http://saxon.sf.net/feature/schema-validation-mode")) {
            return Validation.toString(this.getSchemaValidationMode());
        }
        if (name.equals("http://saxon.sf.net/feature/serializerFactoryClass")) {
            return this.getSerializerFactory().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            return this.getSourceParserClass();
        }
        if (name.equals("http://saxon.sf.net/feature/sourceResolverClass")) {
            return this.getSourceResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            int s2 = this.getStripsWhiteSpace();
            if (s2 == 2) {
                return "all";
            }
            if (s2 == 1) {
                return "ignorable";
            }
            return "none";
        }
        if (name.equals("http://saxon.sf.net/feature/styleParserClass")) {
            return this.getStyleParserClass();
        }
        if (name.equals("http://saxon.sf.net/feature/timing")) {
            return this.isTiming();
        }
        if (name.equals("http://saxon.sf.net/feature/traceListener")) {
            return this.traceListener;
        }
        if (name.equals("http://saxon.sf.net/feature/traceListenerClass")) {
            return this.traceListenerClass;
        }
        if (name.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/trace-optimizer-decisions")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/treeModel")) {
            return this.getTreeModel();
        }
        if (name.equals("http://saxon.sf.net/feature/treeModelName")) {
            switch (this.getTreeModel()) {
                default: {
                    return "tinyTree";
                }
                case 2: {
                    return "tinyTreeCondensed";
                }
                case 0: 
            }
            return "linkedTree";
        }
        if (name.equals("http://saxon.sf.net/feature/uriResolverClass")) {
            return this.getURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/use-pi-disable-output-escaping")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/use-typed-value-cache")) {
            return this.getBooleanProperty(name);
        }
        if (name.equals("http://saxon.sf.net/feature/useXsiSchemaLocation")) {
            return this.defaultParseOptions.isUseXsiSchemaLocation();
        }
        if (name.equals("http://saxon.sf.net/feature/validation-comments")) {
            return this.defaultParseOptions.isAddCommentsAfterValidationErrors();
        }
        if (name.equals("http://saxon.sf.net/feature/validation-warnings")) {
            return this.isValidationWarnings();
        }
        if (name.equals("http://saxon.sf.net/feature/version-warning")) {
            return this.isVersionWarning();
        }
        if (name.equals("http://saxon.sf.net/feature/xinclude-aware")) {
            return this.isXIncludeAware();
        }
        if (name.equals("http://saxon.sf.net/feature/xml-version")) {
            return this.getXMLVersion() == 10 ? "1.0" : "1.1";
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryAllowUpdate")) {
            return this.getDefaultStaticQueryContext().isUpdatingEnabled();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryConstructionMode")) {
            return this.getDefaultStaticQueryContext().getConstructionMode();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryDefaultElementNamespace")) {
            return this.getDefaultStaticQueryContext().getDefaultElementNamespace();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace")) {
            return this.getDefaultStaticQueryContext().getDefaultFunctionNamespace();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryEmptyLeast")) {
            return this.getDefaultStaticQueryContext().isEmptyLeast();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryInheritNamespaces")) {
            return this.getDefaultStaticQueryContext().isInheritNamespaces();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryPreserveBoundarySpace")) {
            return this.getDefaultStaticQueryContext().isPreserveBoundarySpace();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryPreserveNamespaces")) {
            return this.getDefaultStaticQueryContext().isPreserveNamespaces();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryRequiredContextItemType")) {
            return this.getDefaultStaticQueryContext().getRequiredContextItemType();
        }
        if (name.equals("http://saxon.sf.net/feature/xquerySchemaAware")) {
            return this.getDefaultStaticQueryContext().isSchemaAware();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryStaticErrorListenerClass")) {
            return this.getDefaultStaticQueryContext().getErrorListener().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryVersion")) {
            return this.getDefaultStaticQueryContext().getLanguageVersion();
        }
        if (name.equals("http://saxon.sf.net/feature/xsd-version")) {
            return this.xsdVersion == 10 ? "1.0" : "1.1";
        }
        if (name.equals("http://saxon.sf.net/feature/initialMode")) {
            return this.getDefaultXsltCompilerInfo().getDefaultInitialMode().getClarkName();
        }
        if (name.equals("http://saxon.sf.net/feature/initialTemplate")) {
            return this.getDefaultXsltCompilerInfo().getDefaultInitialTemplate().getClarkName();
        }
        if (name.equals("http://saxon.sf.net/feature/xsltSchemaAware")) {
            return this.defaultXsltCompilerInfo.isSchemaAware();
        }
        if (name.equals("http://saxon.sf.net/feature/stylesheetErrorListener")) {
            return this.getDefaultXsltCompilerInfo().getErrorListener().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/stylesheetURIResolver")) {
            return this.getDefaultXsltCompilerInfo().getURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/xsltVersion")) {
            return this.getDefaultXsltCompilerInfo().getXsltVersion().toString();
        }
        throw new IllegalArgumentException("Unknown attribute " + name);
    }

    public boolean isGenerateByteCode(int hostLanguage) {
        return this.getBooleanProperty("http://saxon.sf.net/feature/generateByteCode") && this.isLicensedFeature(hostLanguage == 50 ? 2 : 4);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.standardErrorOutput != System.err) {
            this.standardErrorOutput.close();
        }
    }

    public static Platform makePlatform() {
        JavaPlatform platformChoice = new JavaPlatform();
        return platformChoice;
    }

    public static Class<? extends Configuration> makeConfigurationClass() {
        Class<Configuration> configClass = Configuration.class;
        return configClass;
    }

    public static String setSoftwareEdition() {
        String softwareEditionTemp = "HE";
        return softwareEditionTemp;
    }

    public static class LicenseFeature {
        public static final int SCHEMA_VALIDATION = 1;
        public static final int ENTERPRISE_XSLT = 2;
        public static final int ENTERPRISE_XQUERY = 4;
        public static final int PROFESSIONAL_EDITION = 8;
    }
}

