/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.rdf;

import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(RDFUtil.class);
    private static final Map<String, Integer> VALID_ENTITY_NAMES;

    public static StreamRDF createRDFWriter(Writer writer, Lang lang) {
        WriterOutputStream wos = new WriterOutputStream(writer, Charset.defaultCharset());
        return StreamRDFWriter.getWriterStream((OutputStream)wos, (Lang)lang);
    }

    public static StreamRDF createRDFReader(Reader reader, Lang lang) {
        ReaderInputStream ris = new ReaderInputStream(reader, Charset.defaultCharset());
        return StreamRDFWriter.getWriterStream(null, (Lang)lang);
    }

    public static Triple triple(String tripleAsTurtle) {
        Model m3 = ModelFactory.createDefaultModel();
        m3.read((Reader)new StringReader(tripleAsTurtle), "urn:x-base:", "TURTLE");
        return ((Statement)m3.listStatements().next()).asTriple();
    }

    static {
        HashMap validEntityNames = new HashMap(1448);
        VALID_ENTITY_NAMES = Collections.unmodifiableMap(validEntityNames);
    }
}

