/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.lang.ref.SoftReference;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class DateUtils {
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final String PATTERN_INTEGER_DATE = "yyyyMMdd";
    private static final String[] DEFAULT_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;

    private DateUtils() {
    }

    public static Date parseDate(String theDateValue) {
        DateUtils.notNull(theDateValue, "Date value");
        String v = theDateValue;
        if (v.length() > 1 && v.startsWith("'") && v.endsWith("'")) {
            v = v.substring(1, v.length() - 1);
        }
        for (String dateFormat : DEFAULT_PATTERNS) {
            SimpleDateFormat dateParser = DateFormatHolder.formatFor(dateFormat);
            dateParser.set2DigitYearStart(DEFAULT_TWO_DIGIT_YEAR_START);
            ParsePosition pos = new ParsePosition(0);
            Date result = dateParser.parse(v, pos);
            if (pos.getIndex() == 0) continue;
            return result;
        }
        return null;
    }

    public static Date getHighestInstantFromDate(Date theDateValue) {
        return DateUtils.getInstantFromDateWithTimezone(theDateValue, TimeZone.getTimeZone("GMT+11:30"));
    }

    public static Date getLowestInstantFromDate(Date theDateValue) {
        return DateUtils.getInstantFromDateWithTimezone(theDateValue, TimeZone.getTimeZone("GMT-11:30"));
    }

    public static Date getInstantFromDateWithTimezone(Date theDateValue, TimeZone theTimezone) {
        Calendar cal = org.apache.commons.lang3.time.DateUtils.toCalendar(theDateValue);
        cal.setTimeZone(theTimezone);
        cal = org.apache.commons.lang3.time.DateUtils.truncate(cal, 5);
        return cal.getTime();
    }

    public static int convertDatetoDayInteger(Date theDateValue) {
        DateUtils.notNull(theDateValue, "Date value");
        SimpleDateFormat format = new SimpleDateFormat(PATTERN_INTEGER_DATE);
        String theDateString = format.format(theDateValue);
        return Integer.parseInt(theDateString);
    }

    public static String convertDateToIso8601String(Date theDateValue) {
        DateUtils.notNull(theDateValue, "Date value");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        return format.format(theDateValue);
    }

    public static String formatDate(Date date) {
        DateUtils.notNull(date, "Date");
        DateUtils.notNull(PATTERN_RFC1123, "Pattern");
        SimpleDateFormat formatter = DateFormatHolder.formatFor(PATTERN_RFC1123);
        return formatter.format(date);
    }

    public static <T> T notNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        return argument;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
    }

    static final class DateFormatHolder {
        private static final ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> THREADLOCAL_FORMATS = ThreadLocal.withInitial(() -> new SoftReference(new HashMap()));

        DateFormatHolder() {
        }

        static SimpleDateFormat formatFor(String pattern) {
            SimpleDateFormat format;
            SoftReference<Map<String, SimpleDateFormat>> ref = THREADLOCAL_FORMATS.get();
            Map<String, SimpleDateFormat> formats = ref.get();
            if (formats == null) {
                formats = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(formats));
            }
            if ((format = formats.get(pattern)) == null) {
                format = new SimpleDateFormat(pattern, Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                formats.put(pattern, format);
            }
            return format;
        }
    }
}

