/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(ClasspathUtil.class);

    public static String loadResource(String theClasspath) {
        Function<InputStream, InputStream> streamTransform = t -> t;
        return ClasspathUtil.loadResource(theClasspath, streamTransform);
    }

    @Nonnull
    public static InputStream loadResourceAsStream(String theClasspath) {
        InputStream retVal = ClasspathUtil.class.getResourceAsStream(theClasspath);
        if (retVal == null) {
            throw new InternalErrorException("Unable to find classpath resource: " + theClasspath);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String loadResource(String theClasspath, Function<InputStream, InputStream> theStreamTransform) {
        String string;
        InputStream stream = ClasspathUtil.class.getResourceAsStream(theClasspath);
        if (stream == null) {
            throw new IOException("Unable to find classpath resource: " + theClasspath);
        }
        try {
            InputStream newStream = theStreamTransform.apply(stream);
            string = IOUtils.toString(newStream, Charsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new InternalErrorException(e);
            }
        }
        stream.close();
        return string;
    }

    @Nonnull
    public static String loadCompressedResource(String theClasspath) {
        Function<InputStream, InputStream> streamTransform = t -> {
            try {
                return new GZIPInputStream((InputStream)t);
            }
            catch (IOException e) {
                throw new InternalErrorException(e);
            }
        };
        return ClasspathUtil.loadResource(theClasspath, streamTransform);
    }

    @Nonnull
    public static <T extends IBaseResource> T loadResource(FhirContext theCtx, Class<T> theType, String theClasspath) {
        String raw = ClasspathUtil.loadResource(theClasspath);
        return EncodingEnum.detectEncodingNoDefault(raw).newParser(theCtx).parseResource(theType, raw);
    }

    public static void close(InputStream theInput) {
        try {
            if (theInput != null) {
                theInput.close();
            }
        }
        catch (IOException e) {
            ourLog.debug("Closing InputStream threw exception", e);
        }
    }

    public static Function<InputStream, InputStream> withBom() {
        return t -> new BOMInputStream((InputStream)t);
    }

    public static byte[] loadResourceAsByteArray(String theClasspath) {
        InputStream stream = ClasspathUtil.loadResourceAsStream(theClasspath);
        try {
            byte[] byArray = IOUtils.toByteArray(stream);
            return byArray;
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        finally {
            ClasspathUtil.close(stream);
        }
    }
}

