/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class StringParam
extends BaseParam
implements IQueryParameterType {
    private boolean myContains;
    private boolean myExact;
    private String myValue;

    public StringParam() {
    }

    public StringParam(String theValue) {
        this.setValue(theValue);
    }

    public StringParam(String theValue, boolean theExact) {
        this.setValue(theValue);
        this.setExact(theExact);
    }

    @Override
    String doGetQueryParameterQualifier() {
        if (this.isExact()) {
            return ":exact";
        }
        if (this.isContains()) {
            return ":contains";
        }
        return null;
    }

    @Override
    String doGetValueAsQueryToken(FhirContext theContext) {
        return ParameterUtil.escape(this.myValue);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.myExact).append(this.myContains).append(this.myValue).append(this.getMissing()).toHashCode();
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        if (":exact".equals(theQualifier)) {
            this.setExact(true);
        } else {
            this.setExact(false);
        }
        if (":contains".equals(theQualifier)) {
            this.setContains(true);
        } else {
            this.setContains(false);
        }
        this.myValue = ParameterUtil.unescape(theValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringParam)) {
            return false;
        }
        StringParam other = (StringParam)obj;
        EqualsBuilder eb = new EqualsBuilder();
        eb.append(this.myExact, other.myExact);
        eb.append(this.myContains, other.myContains);
        eb.append(this.myValue, other.myValue);
        eb.append(this.getMissing(), other.getMissing());
        return eb.isEquals();
    }

    public String getValue() {
        return this.myValue;
    }

    public StringParam setValue(String theValue) {
        this.myValue = theValue;
        return this;
    }

    public StringDt getValueAsStringDt() {
        return new StringDt(this.myValue);
    }

    public String getValueNotNull() {
        return StringUtils.defaultString(this.myValue);
    }

    public boolean isContains() {
        return this.myContains;
    }

    public StringParam setContains(boolean theContains) {
        this.myContains = theContains;
        if (this.myContains) {
            this.setExact(false);
            this.setMissing(null);
        }
        return this;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty(this.myValue);
    }

    public boolean isExact() {
        return this.myExact;
    }

    public StringParam setExact(boolean theExact) {
        this.myExact = theExact;
        if (this.myExact) {
            this.setContains(false);
            this.setMissing(null);
        }
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("value", this.getValue());
        if (this.myExact) {
            builder.append("exact", this.myExact);
        }
        if (this.myContains) {
            builder.append("contains", this.myContains);
        }
        if (this.getMissing() != null) {
            builder.append("missing", this.getMissing());
        }
        return builder.toString();
    }
}

