/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.BaseParser;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IJsonLikeParser;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.ParseLocation;
import ca.uhn.fhir.parser.ParserState;
import ca.uhn.fhir.parser.json.JsonLikeArray;
import ca.uhn.fhir.parser.json.JsonLikeObject;
import ca.uhn.fhir.parser.json.JsonLikeStructure;
import ca.uhn.fhir.parser.json.JsonLikeValue;
import ca.uhn.fhir.parser.json.JsonLikeWriter;
import ca.uhn.fhir.parser.json.jackson.JacksonStructure;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.util.ElementUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.WordUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseDecimalDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseIntegerDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.INarrative;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonParser
extends BaseParser
implements IJsonLikeParser {
    private static final Logger ourLog = LoggerFactory.getLogger(HeldExtension.class);
    private FhirContext myContext;
    private boolean myPrettyPrint;

    public JsonParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler) {
        super(theContext, theParserErrorHandler);
        this.myContext = theContext;
    }

    private boolean addToHeldComments(int valueIdx, List<String> theCommentsToAdd, ArrayList<ArrayList<String>> theListToAddTo) {
        if (theCommentsToAdd.size() > 0) {
            theListToAddTo.ensureCapacity(valueIdx);
            while (theListToAddTo.size() <= valueIdx) {
                theListToAddTo.add(null);
            }
            if (theListToAddTo.get(valueIdx) == null) {
                theListToAddTo.set(valueIdx, new ArrayList());
            }
            theListToAddTo.get(valueIdx).addAll(theCommentsToAdd);
            return true;
        }
        return false;
    }

    private boolean addToHeldExtensions(int valueIdx, List<? extends IBaseExtension<?, ?>> ext, ArrayList<ArrayList<HeldExtension>> list, boolean theIsModifier, BaseParser.CompositeChildElement theChildElem, BaseParser.CompositeChildElement theParent, BaseParser.EncodeContext theEncodeContext, boolean theContainedResource, IBase theContainingElement) {
        boolean retVal = false;
        if (ext.size() > 0) {
            Boolean encodeExtension = null;
            for (IBaseExtension<?, ?> next : ext) {
                if (encodeExtension == null) {
                    encodeExtension = this.isEncodeExtension(theParent, theEncodeContext, theContainedResource, theContainingElement);
                }
                if (!encodeExtension.booleanValue()) continue;
                HeldExtension extension = new HeldExtension(next, theIsModifier, theChildElem, theParent);
                list.ensureCapacity(valueIdx);
                while (list.size() <= valueIdx) {
                    list.add(null);
                }
                ArrayList<HeldExtension> extensionList = list.get(valueIdx);
                if (extensionList == null) {
                    extensionList = new ArrayList();
                    list.set(valueIdx, extensionList);
                }
                extensionList.add(extension);
                retVal = true;
            }
        }
        return retVal;
    }

    private void addToHeldIds(int theValueIdx, ArrayList<String> theListToAddTo, String theId) {
        theListToAddTo.ensureCapacity(theValueIdx);
        while (theListToAddTo.size() <= theValueIdx) {
            theListToAddTo.add(null);
        }
        if (theListToAddTo.get(theValueIdx) == null) {
            theListToAddTo.set(theValueIdx, theId);
        }
    }

    private void beginArray(JsonLikeWriter theEventWriter, String arrayName) throws IOException {
        theEventWriter.beginArray(arrayName);
    }

    private void beginObject(JsonLikeWriter theEventWriter, String arrayName) throws IOException {
        theEventWriter.beginObject(arrayName);
    }

    private JsonLikeWriter createJsonWriter(Writer theWriter) throws IOException {
        JacksonStructure jsonStructure = new JacksonStructure();
        return jsonStructure.getJsonLikeWriter(theWriter);
    }

    public void doEncodeResourceToJsonLikeWriter(IBaseResource theResource, JsonLikeWriter theEventWriter, BaseParser.EncodeContext theEncodeContext) throws IOException {
        if (this.myPrettyPrint) {
            theEventWriter.setPrettyPrint(this.myPrettyPrint);
        }
        theEventWriter.init();
        RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(theResource);
        this.encodeResourceToJsonStreamWriter(resDef, theResource, theEventWriter, null, false, theEncodeContext);
        theEventWriter.flush();
    }

    @Override
    protected void doEncodeResourceToWriter(IBaseResource theResource, Writer theWriter, BaseParser.EncodeContext theEncodeContext) throws IOException {
        JsonLikeWriter eventWriter = this.createJsonWriter(theWriter);
        this.doEncodeResourceToJsonLikeWriter(theResource, eventWriter, theEncodeContext);
        eventWriter.close();
    }

    @Override
    public <T extends IBaseResource> T doParseResource(Class<T> theResourceType, Reader theReader) {
        JacksonStructure jsonStructure = new JacksonStructure();
        jsonStructure.load(theReader);
        T retVal = this.doParseResource(theResourceType, jsonStructure);
        return retVal;
    }

    public <T extends IBaseResource> T doParseResource(Class<T> theResourceType, JsonLikeStructure theJsonStructure) {
        JsonLikeObject object = theJsonStructure.getRootObject();
        JsonLikeValue resourceTypeObj = object.get("resourceType");
        if (resourceTypeObj == null || !resourceTypeObj.isString() || StringUtils.isBlank(resourceTypeObj.getAsString())) {
            throw new DataFormatException("Invalid JSON content detected, missing required element: 'resourceType'");
        }
        String resourceType = resourceTypeObj.getAsString();
        ParserState<T> state = ParserState.getPreResourceInstance(this, theResourceType, this.myContext, true, this.getErrorHandler());
        state.enteringNewElement(null, resourceType);
        this.parseChildren(object, state);
        state.endingElement();
        state.endingElement();
        IBaseResource retVal = (IBaseResource)state.getObject();
        return (T)retVal;
    }

    private void encodeChildElementToStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, IBase theNextValue, BaseRuntimeElementDefinition<?> theChildDef, String theChildName, boolean theContainedResource, BaseParser.CompositeChildElement theChildElem, boolean theForceEmpty, BaseParser.EncodeContext theEncodeContext) throws IOException {
        switch (theChildDef.getChildType()) {
            case ID_DATATYPE: {
                String encodedValue;
                IIdType value = (IIdType)theNextValue;
                String string = encodedValue = "id".equals(theChildName) ? value.getIdPart() : value.getValue();
                if (StringUtils.isBlank(encodedValue)) break;
                if (theChildName != null) {
                    JsonParser.write(theEventWriter, theChildName, encodedValue);
                    break;
                }
                theEventWriter.write(encodedValue);
                break;
            }
            case PRIMITIVE_DATATYPE: {
                final IPrimitiveType value = (IPrimitiveType)theNextValue;
                String valueStr = value.getValueAsString();
                if (StringUtils.isBlank(valueStr)) {
                    if (!theForceEmpty) break;
                    theEventWriter.writeNull();
                    break;
                }
                Object valueObj = value.getValue();
                if (valueObj instanceof String) {
                    if (theChildName != null) {
                        theEventWriter.write(theChildName, valueStr);
                        break;
                    }
                    theEventWriter.write(valueStr);
                    break;
                }
                if (valueObj instanceof Long) {
                    if (theChildName != null) {
                        theEventWriter.write(theChildName, (Long)valueObj);
                        break;
                    }
                    theEventWriter.write((Long)valueObj);
                    break;
                }
                if (value instanceof IBaseIntegerDatatype) {
                    if (theChildName != null) {
                        this.write(theEventWriter, theChildName, (Integer)((IBaseIntegerDatatype)value).getValue());
                        break;
                    }
                    theEventWriter.write(((Integer)((IBaseIntegerDatatype)value).getValue()).intValue());
                    break;
                }
                if (value instanceof IBaseDecimalDatatype) {
                    BigDecimal decimalValue = (BigDecimal)((IBaseDecimalDatatype)value).getValue();
                    decimalValue = new BigDecimal(decimalValue.toString()){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public String toString() {
                            return value.getValueAsString();
                        }
                    };
                    if (theChildName != null) {
                        this.write(theEventWriter, theChildName, decimalValue);
                        break;
                    }
                    theEventWriter.write(decimalValue);
                    break;
                }
                if (value instanceof IBaseBooleanDatatype) {
                    if (theChildName != null) {
                        this.write(theEventWriter, theChildName, (Boolean)((IBaseBooleanDatatype)value).getValue());
                        break;
                    }
                    Boolean booleanValue = (Boolean)((IBaseBooleanDatatype)value).getValue();
                    if (booleanValue == null) break;
                    theEventWriter.write((boolean)booleanValue);
                    break;
                }
                if (theChildName != null) {
                    JsonParser.write(theEventWriter, theChildName, valueStr);
                    break;
                }
                theEventWriter.write(valueStr);
                break;
            }
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                if (theChildName != null) {
                    theEventWriter.beginObject(theChildName);
                } else {
                    theEventWriter.beginObject();
                }
                this.encodeCompositeElementToStreamWriter(theResDef, theResource, theNextValue, theEventWriter, theContainedResource, theChildElem, theEncodeContext);
                theEventWriter.endObject();
                break;
            }
            case CONTAINED_RESOURCE_LIST: 
            case CONTAINED_RESOURCES: {
                List<IBaseResource> containedResources = this.getContainedResources().getContainedResources();
                if (containedResources.size() <= 0) break;
                this.beginArray(theEventWriter, theChildName);
                for (IBaseResource next : containedResources) {
                    IIdType resourceId = this.getContainedResources().getResourceId(next);
                    String value = resourceId.getValue();
                    this.encodeResourceToJsonStreamWriter(theResDef, next, theEventWriter, null, true, this.fixContainedResourceId(value), theEncodeContext);
                }
                theEventWriter.endArray();
                break;
            }
            case PRIMITIVE_XHTML_HL7ORG: 
            case PRIMITIVE_XHTML: {
                if (!this.isSuppressNarratives()) {
                    IPrimitiveType dt = (IPrimitiveType)theNextValue;
                    if (theChildName != null) {
                        JsonParser.write(theEventWriter, theChildName, dt.getValueAsString());
                        break;
                    }
                    theEventWriter.write(dt.getValueAsString());
                    break;
                }
                if (theChildName != null) break;
                theEventWriter.writeNull();
                break;
            }
            case RESOURCE: {
                IBaseResource resource = (IBaseResource)theNextValue;
                RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resource);
                theEncodeContext.pushPath(def.getName(), true);
                this.encodeResourceToJsonStreamWriter(def, resource, theEventWriter, theChildName, theContainedResource, theEncodeContext);
                theEncodeContext.popPath();
                break;
            }
            default: {
                throw new IllegalStateException("Should not have this state here: " + theChildDef.getChildType().name());
            }
        }
    }

    private void encodeCompositeElementChildrenToStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, IBase theElement, JsonLikeWriter theEventWriter, boolean theContainedResource, BaseParser.CompositeChildElement theParent, BaseParser.EncodeContext theEncodeContext) throws IOException {
        String elementId = this.getCompositeElementId(theElement);
        if (StringUtils.isNotBlank(elementId)) {
            JsonParser.write(theEventWriter, "id", elementId);
        }
        boolean haveWrittenExtensions = false;
        for (BaseParser.CompositeChildElement nextChildElem : super.compositeChildIterator(theElement, theContainedResource, theParent, theEncodeContext)) {
            BaseRuntimeChildDefinition nextChild = nextChildElem.getDef();
            if (nextChildElem.getDef().getElementName().equals("extension") || nextChildElem.getDef().getElementName().equals("modifierExtension") || nextChild instanceof RuntimeChildDeclaredExtensionDefinition) {
                if (haveWrittenExtensions) continue;
                this.extractAndWriteExtensionsAsDirectChild(theElement, theEventWriter, this.myContext.getElementDefinition(theElement.getClass()), theResDef, theResource, nextChildElem, theParent, theEncodeContext, theContainedResource);
                haveWrittenExtensions = true;
                continue;
            }
            if (nextChild instanceof RuntimeChildNarrativeDefinition) {
                INarrative narr;
                INarrativeGenerator gen = this.myContext.getNarrativeGenerator();
                if (gen != null && (narr = theResource instanceof IResource ? ((IResource)theResource).getText() : (theResource instanceof IDomainResource ? ((IDomainResource)theResource).getText() : null)) != null && narr.isEmpty()) {
                    gen.populateResourceNarrative(this.myContext, theResource);
                    if (!narr.isEmpty()) {
                        RuntimeChildNarrativeDefinition child = (RuntimeChildNarrativeDefinition)nextChild;
                        String childName = nextChild.getChildNameByDatatype(child.getDatatype());
                        BaseRuntimeElementDefinition<?> type = child.getChildByName(childName);
                        this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, narr, type, childName, theContainedResource, nextChildElem, false, theEncodeContext);
                        continue;
                    }
                }
            } else if (nextChild instanceof RuntimeChildContainedResources) {
                String childName = nextChild.getValidChildNames().iterator().next();
                BaseRuntimeElementDefinition<?> child = nextChild.getChildByName(childName);
                this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, null, child, childName, theContainedResource, nextChildElem, false, theEncodeContext);
                continue;
            }
            List<IBase> values = nextChild.getAccessor().getValues(theElement);
            if ((values = this.preProcessValues(nextChild, theResource, values, nextChildElem, theEncodeContext)) == null || values.isEmpty()) continue;
            String currentChildName = null;
            boolean inArray = false;
            ArrayList<ArrayList<HeldExtension>> extensions = new ArrayList<ArrayList<HeldExtension>>(0);
            ArrayList<ArrayList<HeldExtension>> modifierExtensions = new ArrayList<ArrayList<HeldExtension>>(0);
            ArrayList<ArrayList<String>> comments = new ArrayList<ArrayList<String>>(0);
            ArrayList<String> ids = new ArrayList<String>(0);
            int valueIdx = 0;
            for (IBase nextValue : values) {
                boolean primitive;
                BaseParser.ChildNameAndDef childNameAndDef;
                if ((nextValue == null || nextValue.isEmpty()) && (!(nextValue instanceof BaseContainedDt) || theContainedResource || this.getContainedResources().isEmpty()) || (childNameAndDef = super.getChildNameAndDef(nextChild, nextValue)) == null) continue;
                String nextChildSpecificName = childNameAndDef.getChildName();
                String nextChildGenericName = nextChild.getElementName();
                theEncodeContext.pushPath(nextChildGenericName, false);
                BaseRuntimeElementDefinition<?> childDef = childNameAndDef.getChildDef();
                boolean bl = primitive = childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_DATATYPE;
                if ((childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCES || childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) && theContainedResource) continue;
                boolean force = false;
                if (primitive) {
                    String elementId2;
                    if (nextValue instanceof ISupportsUndeclaredExtensions) {
                        List<ExtensionDt> ext = ((ISupportsUndeclaredExtensions)nextValue).getUndeclaredExtensions();
                        force |= this.addToHeldExtensions(valueIdx, ext, extensions, false, nextChildElem, theParent, theEncodeContext, theContainedResource, theElement);
                        ext = ((ISupportsUndeclaredExtensions)nextValue).getUndeclaredModifierExtensions();
                        force |= this.addToHeldExtensions(valueIdx, ext, modifierExtensions, true, nextChildElem, theParent, theEncodeContext, theContainedResource, theElement);
                    } else {
                        List<? extends IBaseExtension<?, ?>> ext;
                        Object element;
                        if (nextValue instanceof IBaseHasExtensions) {
                            element = (IBaseHasExtensions)nextValue;
                            ext = element.getExtension();
                            force |= this.addToHeldExtensions(valueIdx, ext, extensions, false, nextChildElem, theParent, theEncodeContext, theContainedResource, theElement);
                        }
                        if (nextValue instanceof IBaseHasModifierExtensions) {
                            element = (IBaseHasModifierExtensions)((Object)nextValue);
                            ext = element.getModifierExtension();
                            force |= this.addToHeldExtensions(valueIdx, ext, modifierExtensions, true, nextChildElem, theParent, theEncodeContext, theContainedResource, theElement);
                        }
                    }
                    if (nextValue.hasFormatComment()) {
                        force |= this.addToHeldComments(valueIdx, nextValue.getFormatCommentsPre(), comments);
                        force |= this.addToHeldComments(valueIdx, nextValue.getFormatCommentsPost(), comments);
                    }
                    if (StringUtils.isNotBlank(elementId2 = this.getCompositeElementId(nextValue))) {
                        force = true;
                        this.addToHeldIds(valueIdx, ids, elementId2);
                    }
                }
                if (currentChildName == null || !currentChildName.equals(nextChildSpecificName)) {
                    if (inArray) {
                        theEventWriter.endArray();
                    }
                    BaseRuntimeChildDefinition replacedParentDefinition = nextChild.getReplacedParentDefinition();
                    if (this.isMultipleCardinality(nextChild.getMax()) || replacedParentDefinition != null && this.isMultipleCardinality(replacedParentDefinition.getMax())) {
                        this.beginArray(theEventWriter, nextChildSpecificName);
                        inArray = true;
                        this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, nextValue, childDef, null, theContainedResource, nextChildElem, force, theEncodeContext);
                    } else if (!(nextChild instanceof RuntimeChildNarrativeDefinition) || !theContainedResource) {
                        this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, nextValue, childDef, nextChildSpecificName, theContainedResource, nextChildElem, false, theEncodeContext);
                    }
                    currentChildName = nextChildSpecificName;
                } else {
                    this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, nextValue, childDef, null, theContainedResource, nextChildElem, force, theEncodeContext);
                }
                ++valueIdx;
                theEncodeContext.popPath();
            }
            if (inArray) {
                theEventWriter.endArray();
            }
            if (extensions.isEmpty() && modifierExtensions.isEmpty() && comments.isEmpty()) continue;
            if (inArray) {
                this.beginArray(theEventWriter, '_' + currentChildName);
            } else {
                this.beginObject(theEventWriter, '_' + currentChildName);
            }
            for (int i = 0; i < valueIdx; ++i) {
                ArrayList nextComments;
                boolean haveContent = false;
                List heldExts = Collections.emptyList();
                List heldModExts = Collections.emptyList();
                if (extensions.size() > i && extensions.get(i) != null && !((ArrayList)extensions.get(i)).isEmpty()) {
                    haveContent = true;
                    heldExts = (List)extensions.get(i);
                }
                if (modifierExtensions.size() > i && modifierExtensions.get(i) != null && !((ArrayList)modifierExtensions.get(i)).isEmpty()) {
                    haveContent = true;
                    heldModExts = (List)modifierExtensions.get(i);
                }
                if ((nextComments = comments.size() > i ? (ArrayList)comments.get(i) : null) != null && !nextComments.isEmpty()) {
                    haveContent = true;
                }
                String elementId3 = null;
                if (ids.size() > i) {
                    elementId3 = (String)ids.get(i);
                    haveContent |= StringUtils.isNotBlank(elementId3);
                }
                if (!haveContent) {
                    theEventWriter.writeNull();
                    continue;
                }
                if (inArray) {
                    theEventWriter.beginObject();
                }
                if (StringUtils.isNotBlank(elementId3)) {
                    JsonParser.write(theEventWriter, "id", elementId3);
                }
                if (nextComments != null && !nextComments.isEmpty()) {
                    this.beginArray(theEventWriter, "fhir_comments");
                    for (String next : nextComments) {
                        theEventWriter.write(next);
                    }
                    theEventWriter.endArray();
                }
                this.writeExtensionsAsDirectChild(theResource, theEventWriter, theResDef, heldExts, heldModExts, theEncodeContext, theContainedResource);
                if (!inArray) continue;
                theEventWriter.endObject();
            }
            if (inArray) {
                theEventWriter.endArray();
                continue;
            }
            theEventWriter.endObject();
        }
    }

    private boolean isMultipleCardinality(int maxCardinality) {
        return maxCardinality > 1 || maxCardinality == -1;
    }

    private void encodeCompositeElementToStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, IBase theNextValue, JsonLikeWriter theEventWriter, boolean theContainedResource, BaseParser.CompositeChildElement theParent, BaseParser.EncodeContext theEncodeContext) throws IOException, DataFormatException {
        this.writeCommentsPreAndPost(theNextValue, theEventWriter);
        this.encodeCompositeElementChildrenToStreamWriter(theResDef, theResource, theNextValue, theEventWriter, theContainedResource, theParent, theEncodeContext);
    }

    @Override
    public void encodeResourceToJsonLikeWriter(IBaseResource theResource, JsonLikeWriter theJsonLikeWriter) throws IOException, DataFormatException {
        Validate.notNull(theResource, "theResource can not be null", new Object[0]);
        Validate.notNull(theJsonLikeWriter, "theJsonLikeWriter can not be null", new Object[0]);
        if (theResource.getStructureFhirVersionEnum() != this.myContext.getVersion().getVersion()) {
            throw new IllegalArgumentException("This parser is for FHIR version " + (Object)((Object)this.myContext.getVersion().getVersion()) + " - Can not encode a structure for version " + (Object)((Object)theResource.getStructureFhirVersionEnum()));
        }
        BaseParser.EncodeContext encodeContext = new BaseParser.EncodeContext(this);
        String resourceName = this.myContext.getResourceDefinition(theResource).getName();
        encodeContext.pushPath(resourceName, true);
        this.doEncodeResourceToJsonLikeWriter(theResource, theJsonLikeWriter, encodeContext);
    }

    private void encodeResourceToJsonStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, String theObjectNameOrNull, boolean theContainedResource, BaseParser.EncodeContext theEncodeContext) throws IOException {
        IIdType resourceId = null;
        if (StringUtils.isNotBlank(theResource.getIdElement().getIdPart())) {
            resourceId = theResource.getIdElement();
            if (theResource.getIdElement().getValue().startsWith("urn:")) {
                resourceId = null;
            }
        }
        if (!theContainedResource) {
            if (!super.shouldEncodeResourceId(theResource, theEncodeContext)) {
                resourceId = null;
            } else if (theEncodeContext.getResourcePath().size() == 1 && this.getEncodeForceResourceId() != null) {
                resourceId = this.getEncodeForceResourceId();
            }
        }
        this.encodeResourceToJsonStreamWriter(theResDef, theResource, theEventWriter, theObjectNameOrNull, theContainedResource, resourceId, theEncodeContext);
    }

    private void encodeResourceToJsonStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, String theObjectNameOrNull, boolean theContainedResource, IIdType theResourceId, BaseParser.EncodeContext theEncodeContext) throws IOException {
        if (!super.shouldEncodeResource(theResDef.getName())) {
            return;
        }
        if (!theContainedResource) {
            super.containResourcesForEncoding(theResource);
        }
        RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(theResource);
        if (theObjectNameOrNull == null) {
            theEventWriter.beginObject();
        } else {
            this.beginObject(theEventWriter, theObjectNameOrNull);
        }
        JsonParser.write(theEventWriter, "resourceType", resDef.getName());
        if (theResourceId != null && theResourceId.hasIdPart()) {
            JsonParser.write(theEventWriter, "id", theResourceId.getIdPart());
            ArrayList<HeldExtension> extensions = new ArrayList<HeldExtension>(0);
            ArrayList<HeldExtension> modifierExtensions = new ArrayList<HeldExtension>(0);
            this.extractUndeclaredExtensions(theResourceId, extensions, modifierExtensions, null, null, theEncodeContext, theContainedResource);
            boolean haveExtension = false;
            if (!extensions.isEmpty()) {
                haveExtension = true;
            }
            if (theResourceId.hasFormatComment() || haveExtension) {
                this.beginObject(theEventWriter, "_id");
                if (theResourceId.hasFormatComment()) {
                    this.writeCommentsPreAndPost(theResourceId, theEventWriter);
                }
                if (haveExtension) {
                    this.writeExtensionsAsDirectChild(theResource, theEventWriter, theResDef, extensions, modifierExtensions, theEncodeContext, theContainedResource);
                }
                theEventWriter.endObject();
            }
        }
        if (theResource instanceof IResource) {
            IResource resource = (IResource)theResource;
            List<BaseCodingDt> securityLabels = JsonParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.SECURITY_LABELS);
            List<IIdType> profiles = JsonParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.PROFILES);
            profiles = super.getProfileTagsForEncoding(resource, profiles);
            TagList tags = this.getMetaTagsForEncoding(resource, theEncodeContext);
            InstantDt updated = (InstantDt)resource.getResourceMetadata().get(ResourceMetadataKeyEnum.UPDATED);
            IdDt resourceId = resource.getId();
            String versionIdPart = resourceId.getVersionIdPart();
            if (StringUtils.isBlank(versionIdPart)) {
                versionIdPart = ResourceMetadataKeyEnum.VERSION.get(resource);
            }
            List<Map.Entry<ResourceMetadataKeyEnum<?>, Object>> extensionMetadataKeys = this.getExtensionMetadataKeys(resource);
            if (super.shouldEncodeResourceMeta(resource) && !ElementUtil.isEmpty(versionIdPart, updated, securityLabels, tags, profiles) || !extensionMetadataKeys.isEmpty()) {
                this.beginObject(theEventWriter, "meta");
                if (this.shouldEncodePath(resource, "meta.versionId")) {
                    this.writeOptionalTagWithTextNode(theEventWriter, "versionId", versionIdPart);
                }
                if (this.shouldEncodePath(resource, "meta.lastUpdated")) {
                    this.writeOptionalTagWithTextNode(theEventWriter, "lastUpdated", updated);
                }
                if (profiles != null && !profiles.isEmpty()) {
                    this.beginArray(theEventWriter, "profile");
                    for (IIdType profile : profiles) {
                        if (profile == null || !StringUtils.isNotBlank(profile.getValue())) continue;
                        theEventWriter.write(profile.getValue());
                    }
                    theEventWriter.endArray();
                }
                if (!securityLabels.isEmpty()) {
                    this.beginArray(theEventWriter, "security");
                    for (BaseCodingDt securityLabel : securityLabels) {
                        theEventWriter.beginObject();
                        theEncodeContext.pushPath("security", false);
                        this.encodeCompositeElementChildrenToStreamWriter(resDef, resource, securityLabel, theEventWriter, theContainedResource, null, theEncodeContext);
                        theEncodeContext.popPath();
                        theEventWriter.endObject();
                    }
                    theEventWriter.endArray();
                }
                if (tags != null && !tags.isEmpty()) {
                    this.beginArray(theEventWriter, "tag");
                    for (Tag tag : tags) {
                        if (tag.isEmpty()) continue;
                        theEventWriter.beginObject();
                        this.writeOptionalTagWithTextNode(theEventWriter, "system", tag.getScheme());
                        this.writeOptionalTagWithTextNode(theEventWriter, "code", tag.getTerm());
                        this.writeOptionalTagWithTextNode(theEventWriter, "display", tag.getLabel());
                        theEventWriter.endObject();
                    }
                    theEventWriter.endArray();
                }
                this.addExtensionMetadata(theResDef, theResource, theContainedResource, extensionMetadataKeys, resDef, theEventWriter, theEncodeContext);
                theEventWriter.endObject();
            }
        }
        this.encodeCompositeElementToStreamWriter(theResDef, theResource, theResource, theEventWriter, theContainedResource, new BaseParser.CompositeChildElement(this, resDef, theEncodeContext), theEncodeContext);
        theEventWriter.endObject();
    }

    private void addExtensionMetadata(RuntimeResourceDefinition theResDef, IBaseResource theResource, boolean theContainedResource, List<Map.Entry<ResourceMetadataKeyEnum<?>, Object>> extensionMetadataKeys, RuntimeResourceDefinition resDef, JsonLikeWriter theEventWriter, BaseParser.EncodeContext theEncodeContext) throws IOException {
        if (extensionMetadataKeys.isEmpty()) {
            return;
        }
        ExtensionDt metaResource = new ExtensionDt();
        for (Map.Entry<ResourceMetadataKeyEnum<?>, Object> entry : extensionMetadataKeys) {
            metaResource.addUndeclaredExtension((ExtensionDt)entry.getValue());
        }
        this.encodeCompositeElementToStreamWriter(theResDef, theResource, metaResource, theEventWriter, theContainedResource, new BaseParser.CompositeChildElement(this, resDef, theEncodeContext), theEncodeContext);
    }

    private void extractAndWriteExtensionsAsDirectChild(IBase theElement, JsonLikeWriter theEventWriter, BaseRuntimeElementDefinition<?> theElementDef, RuntimeResourceDefinition theResDef, IBaseResource theResource, BaseParser.CompositeChildElement theChildElem, BaseParser.CompositeChildElement theParent, BaseParser.EncodeContext theEncodeContext, boolean theContainedResource) throws IOException {
        ArrayList<HeldExtension> extensions = new ArrayList<HeldExtension>(0);
        ArrayList<HeldExtension> modifierExtensions = new ArrayList<HeldExtension>(0);
        this.extractUndeclaredExtensions(theElement, extensions, modifierExtensions, theChildElem, theParent, theEncodeContext, theContainedResource);
        if (theElementDef != null) {
            this.extractDeclaredExtensions(theElement, theElementDef, extensions, modifierExtensions, theChildElem);
        }
        this.writeExtensionsAsDirectChild(theResource, theEventWriter, theResDef, extensions, modifierExtensions, theEncodeContext, theContainedResource);
    }

    private void extractDeclaredExtensions(IBase theResource, BaseRuntimeElementDefinition<?> resDef, List<HeldExtension> extensions, List<HeldExtension> modifierExtensions, BaseParser.CompositeChildElement theChildElem) {
        for (RuntimeChildDeclaredExtensionDefinition nextDef : resDef.getExtensionsNonModifier()) {
            for (IBase nextValue : nextDef.getAccessor().getValues(theResource)) {
                if (nextValue == null || nextValue.isEmpty()) continue;
                extensions.add(new HeldExtension(nextDef, nextValue, theChildElem));
            }
        }
        for (RuntimeChildDeclaredExtensionDefinition nextDef : resDef.getExtensionsModifier()) {
            for (IBase nextValue : nextDef.getAccessor().getValues(theResource)) {
                if (nextValue == null || nextValue.isEmpty()) continue;
                modifierExtensions.add(new HeldExtension(nextDef, nextValue, theChildElem));
            }
        }
    }

    private void extractUndeclaredExtensions(IBase theElement, List<HeldExtension> extensions, List<HeldExtension> modifierExtensions, BaseParser.CompositeChildElement theChildElem, BaseParser.CompositeChildElement theParent, BaseParser.EncodeContext theEncodeContext, boolean theContainedResource) {
        block7: {
            List<IBaseExtension<?, ?>> ext;
            Object element;
            block6: {
                if (!(theElement instanceof ISupportsUndeclaredExtensions)) break block6;
                ISupportsUndeclaredExtensions element2 = (ISupportsUndeclaredExtensions)theElement;
                List<ExtensionDt> ext2 = element2.getUndeclaredExtensions();
                for (ExtensionDt next : ext2) {
                    if (next == null || next.isEmpty()) continue;
                    extensions.add(new HeldExtension(next, false, theChildElem, theParent));
                }
                ext2 = element2.getUndeclaredModifierExtensions();
                for (ExtensionDt next : ext2) {
                    if (next == null || next.isEmpty()) continue;
                    modifierExtensions.add(new HeldExtension(next, true, theChildElem, theParent));
                }
                break block7;
            }
            if (theElement instanceof IBaseHasExtensions) {
                element = (IBaseHasExtensions)theElement;
                ext = element.getExtension();
                Boolean encodeExtension = null;
                for (IBaseExtension<?, ?> next : ext) {
                    if (next == null || ElementUtil.isEmpty(next.getValue()) && next.getExtension().isEmpty()) continue;
                    if (encodeExtension == null) {
                        encodeExtension = this.isEncodeExtension(theParent, theEncodeContext, theContainedResource, (IBase)element);
                    }
                    if (!encodeExtension.booleanValue()) continue;
                    HeldExtension extension = new HeldExtension(next, false, theChildElem, theParent);
                    extensions.add(extension);
                }
            }
            if (!(theElement instanceof IBaseHasModifierExtensions)) break block7;
            element = (IBaseHasModifierExtensions)((Object)theElement);
            ext = element.getModifierExtension();
            for (IBaseExtension<?, ?> next : ext) {
                if (next == null || next.isEmpty()) continue;
                HeldExtension extension = new HeldExtension(next, true, theChildElem, theParent);
                modifierExtensions.add(extension);
            }
        }
    }

    private boolean isEncodeExtension(BaseParser.CompositeChildElement theParent, BaseParser.EncodeContext theEncodeContext, boolean theContainedResource, IBase theElement) {
        BaseRuntimeElementDefinition<?> runtimeElementDefinition = this.myContext.getElementDefinition(theElement.getClass());
        boolean retVal = true;
        if (runtimeElementDefinition instanceof BaseRuntimeElementCompositeDefinition) {
            BaseRuntimeElementCompositeDefinition definition = (BaseRuntimeElementCompositeDefinition)runtimeElementDefinition;
            BaseRuntimeChildDefinition childDef = definition.getChildByName("extension");
            BaseParser.CompositeChildElement c = new BaseParser.CompositeChildElement(this, theParent, childDef, theEncodeContext);
            retVal = c.shouldBeEncoded(theContainedResource);
        }
        return retVal;
    }

    @Override
    public EncodingEnum getEncoding() {
        return EncodingEnum.JSON;
    }

    private JsonLikeArray grabJsonArray(JsonLikeObject theObject, String nextName, String thePosition) {
        JsonLikeValue object = theObject.get(nextName);
        if (object == null || object.isNull()) {
            return null;
        }
        if (!object.isArray()) {
            throw new DataFormatException("Syntax error parsing JSON FHIR structure: Expected ARRAY at element '" + thePosition + "', found '" + (Object)((Object)object.getJsonType()) + "'");
        }
        return object.getAsArray();
    }

    private void parseAlternates(JsonLikeValue theAlternateVal, ParserState<?> theState, String theElementName, String theAlternateName) {
        if (theAlternateVal == null || theAlternateVal.isNull()) {
            return;
        }
        if (theAlternateVal.isArray()) {
            JsonLikeArray array = theAlternateVal.getAsArray();
            if (array.size() > 1) {
                throw new DataFormatException("Unexpected array of length " + array.size() + " (expected 0 or 1) for element: " + theElementName);
            }
            if (array.size() == 0) {
                return;
            }
            this.parseAlternates(array.get(0), theState, theElementName, theAlternateName);
            return;
        }
        JsonLikeValue alternateVal = theAlternateVal;
        if (!alternateVal.isObject()) {
            this.getErrorHandler().incorrectJsonType(null, theAlternateName, JsonLikeValue.ValueType.OBJECT, null, alternateVal.getJsonType(), null);
            return;
        }
        JsonLikeObject alternate = alternateVal.getAsObject();
        for (String nextKey : alternate.keySet()) {
            JsonLikeArray array;
            boolean isModifier;
            JsonLikeValue nextVal = alternate.get(nextKey);
            if ("extension".equals(nextKey)) {
                isModifier = false;
                array = nextVal.getAsArray();
                this.parseExtension(theState, array, isModifier);
                continue;
            }
            if ("modifierExtension".equals(nextKey)) {
                isModifier = true;
                array = nextVal.getAsArray();
                this.parseExtension(theState, array, isModifier);
                continue;
            }
            if ("id".equals(nextKey)) {
                if (nextVal.isString()) {
                    theState.attributeValue("id", nextVal.getAsString());
                    continue;
                }
                this.getErrorHandler().incorrectJsonType(null, "id", JsonLikeValue.ValueType.SCALAR, JsonLikeValue.ScalarType.STRING, nextVal.getJsonType(), nextVal.getDataType());
                continue;
            }
            if (!"fhir_comments".equals(nextKey)) continue;
            this.parseFhirComments(nextVal, theState);
        }
    }

    private void parseChildren(JsonLikeObject theObject, ParserState<?> theState) {
        Set<String> keySet = theObject.keySet();
        int allUnderscoreNames = 0;
        int handledUnderscoreNames = 0;
        for (String nextName : keySet) {
            JsonLikeArray array;
            if ("resourceType".equals(nextName)) continue;
            if ("extension".equals(nextName)) {
                array = this.grabJsonArray(theObject, nextName, "extension");
                this.parseExtension(theState, array, false);
                continue;
            }
            if ("modifierExtension".equals(nextName)) {
                array = this.grabJsonArray(theObject, nextName, "modifierExtension");
                this.parseExtension(theState, array, true);
                continue;
            }
            if (nextName.equals("fhir_comments")) {
                this.parseFhirComments(theObject.get(nextName), theState);
                continue;
            }
            if (nextName.charAt(0) == '_') {
                ++allUnderscoreNames;
                continue;
            }
            JsonLikeValue nextVal = theObject.get(nextName);
            String alternateName = '_' + nextName;
            JsonLikeValue alternateVal = theObject.get(alternateName);
            if (alternateVal != null) {
                ++handledUnderscoreNames;
            }
            this.parseChildren(theState, nextName, nextVal, alternateVal, alternateName, false);
        }
        if (allUnderscoreNames > handledUnderscoreNames) {
            for (String alternateName : keySet) {
                JsonLikeValue nextValue;
                if (!alternateName.startsWith("_") || alternateName.length() <= 1 || (nextValue = theObject.get(alternateName)) == null) continue;
                if (nextValue.isObject()) {
                    String nextName = alternateName.substring(1);
                    if (theObject.get(nextName) != null) continue;
                    theState.enteringNewElement(null, nextName);
                    this.parseAlternates(nextValue, theState, alternateName, alternateName);
                    theState.endingElement();
                    continue;
                }
                this.getErrorHandler().incorrectJsonType(null, alternateName, JsonLikeValue.ValueType.OBJECT, null, nextValue.getJsonType(), null);
            }
        }
    }

    private void parseChildren(ParserState<?> theState, String theName, JsonLikeValue theJsonVal, JsonLikeValue theAlternateVal, String theAlternateName, boolean theInArray) {
        if (theName.equals("id") && !theJsonVal.isString()) {
            this.getErrorHandler().incorrectJsonType(null, "id", JsonLikeValue.ValueType.SCALAR, JsonLikeValue.ScalarType.STRING, theJsonVal.getJsonType(), theJsonVal.getDataType());
        }
        if (theJsonVal.isArray()) {
            JsonLikeArray nextArray = theJsonVal.getAsArray();
            JsonLikeValue alternateVal = theAlternateVal;
            if (alternateVal != null && !alternateVal.isArray()) {
                this.getErrorHandler().incorrectJsonType(null, theAlternateName, JsonLikeValue.ValueType.ARRAY, null, alternateVal.getJsonType(), null);
                alternateVal = null;
            }
            JsonLikeArray nextAlternateArray = JsonLikeValue.asArray(alternateVal);
            for (int i = 0; i < nextArray.size(); ++i) {
                JsonLikeValue nextObject = nextArray.get(i);
                JsonLikeValue nextAlternate = null;
                if (nextAlternateArray != null && nextAlternateArray.size() >= i + 1) {
                    nextAlternate = nextAlternateArray.get(i);
                }
                this.parseChildren(theState, theName, nextObject, nextAlternate, theAlternateName, true);
            }
        } else if (theJsonVal.isObject()) {
            if (!theInArray && theState.elementIsRepeating(theName)) {
                this.getErrorHandler().incorrectJsonType(null, theName, JsonLikeValue.ValueType.ARRAY, null, JsonLikeValue.ValueType.OBJECT, null);
            }
            theState.enteringNewElement(null, theName);
            this.parseAlternates(theAlternateVal, theState, theAlternateName, theAlternateName);
            JsonLikeObject nextObject = theJsonVal.getAsObject();
            boolean preResource = false;
            if (theState.isPreResource()) {
                JsonLikeValue resType = nextObject.get("resourceType");
                if (resType == null || !resType.isString()) {
                    throw new DataFormatException("Missing required element 'resourceType' from JSON resource object, unable to parse");
                }
                theState.enteringNewElement(null, resType.getAsString());
                preResource = true;
            }
            this.parseChildren(nextObject, theState);
            if (preResource) {
                theState.endingElement();
            }
            theState.endingElement();
        } else if (theJsonVal.isNull()) {
            theState.enteringNewElement(null, theName);
            this.parseAlternates(theAlternateVal, theState, theAlternateName, theAlternateName);
            theState.endingElement();
        } else {
            theState.enteringNewElement(null, theName);
            String asString = theJsonVal.getAsString();
            theState.attributeValue("value", asString);
            this.parseAlternates(theAlternateVal, theState, theAlternateName, theAlternateName);
            theState.endingElement();
        }
    }

    private void parseExtension(ParserState<?> theState, JsonLikeArray theValues, boolean theIsModifier) {
        int allUnderscoreNames = 0;
        int handledUnderscoreNames = 0;
        for (int i = 0; i < theValues.size(); ++i) {
            String url;
            JsonLikeObject nextExtObj = JsonLikeValue.asObject(theValues.get(i));
            JsonLikeValue jsonElement = nextExtObj.get("url");
            if (null == jsonElement || !jsonElement.isScalar()) {
                String parentElementName = theIsModifier ? "modifierExtension" : "extension";
                this.getErrorHandler().missingRequiredElement(new ParseLocation().setParentElementName(parentElementName), "url");
                url = null;
            } else {
                url = this.getExtensionUrl(jsonElement.getAsString());
            }
            theState.enteringNewElementExtension(null, url, theIsModifier, this.getServerBaseUrl());
            for (String next : nextExtObj.keySet()) {
                JsonLikeValue jsonVal;
                if ("url".equals(next)) continue;
                if ("extension".equals(next)) {
                    jsonVal = JsonLikeValue.asArray(nextExtObj.get(next));
                    this.parseExtension(theState, (JsonLikeArray)jsonVal, false);
                    continue;
                }
                if ("modifierExtension".equals(next)) {
                    jsonVal = JsonLikeValue.asArray(nextExtObj.get(next));
                    this.parseExtension(theState, (JsonLikeArray)jsonVal, true);
                    continue;
                }
                if (next.charAt(0) == '_') {
                    ++allUnderscoreNames;
                    continue;
                }
                jsonVal = nextExtObj.get(next);
                String alternateName = '_' + next;
                JsonLikeValue alternateVal = nextExtObj.get(alternateName);
                if (alternateVal != null) {
                    ++handledUnderscoreNames;
                }
                this.parseChildren(theState, next, jsonVal, alternateVal, alternateName, false);
            }
            if (allUnderscoreNames > handledUnderscoreNames) {
                for (String alternateName : nextExtObj.keySet()) {
                    JsonLikeValue nextValue;
                    if (!alternateName.startsWith("_") || alternateName.length() <= 1 || (nextValue = nextExtObj.get(alternateName)) == null) continue;
                    if (nextValue.isObject()) {
                        String nextName = alternateName.substring(1);
                        if (nextExtObj.get(nextName) != null) continue;
                        theState.enteringNewElement(null, nextName);
                        this.parseAlternates(nextValue, theState, alternateName, alternateName);
                        theState.endingElement();
                        continue;
                    }
                    this.getErrorHandler().incorrectJsonType(null, alternateName, JsonLikeValue.ValueType.OBJECT, null, nextValue.getJsonType(), null);
                }
            }
            theState.endingElement();
        }
    }

    private void parseFhirComments(JsonLikeValue theObject, ParserState<?> theState) {
        if (theObject.isArray()) {
            JsonLikeArray comments = theObject.getAsArray();
            for (int i = 0; i < comments.size(); ++i) {
                String commentText;
                JsonLikeValue nextComment = comments.get(i);
                if (!nextComment.isString() || (commentText = nextComment.getAsString()) == null) continue;
                theState.commentPre(commentText);
            }
        }
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, JsonLikeStructure theJsonLikeStructure) throws DataFormatException {
        T retVal;
        RuntimeResourceDefinition def;
        if (theResourceType != null) {
            this.myContext.getResourceDefinition(theResourceType);
        }
        if ("Bundle".equals((def = this.myContext.getResourceDefinition((IBaseResource)(retVal = this.doParseResource(theResourceType, theJsonLikeStructure)))).getName())) {
            BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
            BaseRuntimeElementCompositeDefinition entryDef = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
            List<IBase> entries = entryChild.getAccessor().getValues((IBase)retVal);
            if (entries != null) {
                for (IBase nextEntry : entries) {
                    List<IBase> entryResources;
                    IPrimitiveType value;
                    List<IBase> fullUrl;
                    BaseRuntimeChildDefinition fullUrlChild = entryDef.getChildByName("fullUrl");
                    if (fullUrlChild == null || (fullUrl = fullUrlChild.getAccessor().getValues(nextEntry)) == null || fullUrl.isEmpty() || (value = (IPrimitiveType)fullUrl.get(0)).isEmpty() || (entryResources = entryDef.getChildByName("resource").getAccessor().getValues(nextEntry)) == null || entryResources.size() <= 0) continue;
                    IBaseResource res = (IBaseResource)entryResources.get(0);
                    String versionId = res.getIdElement().getVersionIdPart();
                    res.setId(value.getValueAsString());
                    if (!StringUtils.isNotBlank(versionId) || res.getIdElement().hasVersionIdPart()) continue;
                    res.setId(res.getIdElement().withVersion(versionId));
                }
            }
        }
        return retVal;
    }

    @Override
    public IBaseResource parseResource(JsonLikeStructure theJsonLikeStructure) throws DataFormatException {
        return this.parseResource(null, theJsonLikeStructure);
    }

    @Override
    public IParser setPrettyPrint(boolean thePrettyPrint) {
        this.myPrettyPrint = thePrettyPrint;
        return this;
    }

    private void write(JsonLikeWriter theEventWriter, String theChildName, Boolean theValue) throws IOException {
        if (theValue != null) {
            theEventWriter.write(theChildName, (boolean)theValue);
        }
    }

    private void write(JsonLikeWriter theEventWriter, String theChildName, BigDecimal theDecimalValue) throws IOException {
        theEventWriter.write(theChildName, theDecimalValue);
    }

    private void write(JsonLikeWriter theEventWriter, String theChildName, Integer theValue) throws IOException {
        theEventWriter.write(theChildName, theValue.intValue());
    }

    private void writeCommentsPreAndPost(IBase theNextValue, JsonLikeWriter theEventWriter) throws IOException {
        if (theNextValue.hasFormatComment()) {
            List<String> post;
            this.beginArray(theEventWriter, "fhir_comments");
            List<String> pre = theNextValue.getFormatCommentsPre();
            if (!pre.isEmpty()) {
                for (String next : pre) {
                    theEventWriter.write(next);
                }
            }
            if (!(post = theNextValue.getFormatCommentsPost()).isEmpty()) {
                for (String next : post) {
                    theEventWriter.write(next);
                }
            }
            theEventWriter.endArray();
        }
    }

    private void writeExtensionsAsDirectChild(IBaseResource theResource, JsonLikeWriter theEventWriter, RuntimeResourceDefinition resDef, List<HeldExtension> extensions, List<HeldExtension> modifierExtensions, BaseParser.EncodeContext theEncodeContext, boolean theContainedResource) throws IOException {
        if (!extensions.isEmpty()) {
            theEncodeContext.pushPath("extension", false);
            this.beginArray(theEventWriter, "extension");
            for (HeldExtension next : extensions) {
                next.write(resDef, theResource, theEventWriter, theEncodeContext, theContainedResource);
            }
            theEventWriter.endArray();
            theEncodeContext.popPath();
        }
        if (!modifierExtensions.isEmpty()) {
            theEncodeContext.pushPath("modifierExtension", false);
            this.beginArray(theEventWriter, "modifierExtension");
            for (HeldExtension next : modifierExtensions) {
                next.write(resDef, theResource, theEventWriter, theEncodeContext, theContainedResource);
            }
            theEventWriter.endArray();
            theEncodeContext.popPath();
        }
    }

    private void writeOptionalTagWithTextNode(JsonLikeWriter theEventWriter, String theElementName, IPrimitiveDatatype<?> thePrimitive) throws IOException {
        if (thePrimitive == null) {
            return;
        }
        String str = thePrimitive.getValueAsString();
        this.writeOptionalTagWithTextNode(theEventWriter, theElementName, str);
    }

    private void writeOptionalTagWithTextNode(JsonLikeWriter theEventWriter, String theElementName, String theValue) throws IOException {
        if (StringUtils.isNotBlank(theValue)) {
            JsonParser.write(theEventWriter, theElementName, theValue);
        }
    }

    private static void write(JsonLikeWriter theWriter, String theName, String theValue) throws IOException {
        theWriter.write(theName, theValue);
    }

    private class HeldExtension
    implements Comparable<HeldExtension> {
        private BaseParser.CompositeChildElement myChildElem;
        private RuntimeChildDeclaredExtensionDefinition myDef;
        private boolean myModifier;
        private IBaseExtension<?, ?> myUndeclaredExtension;
        private IBase myValue;
        private BaseParser.CompositeChildElement myParent;

        public HeldExtension(IBaseExtension<?, ?> theUndeclaredExtension, boolean theModifier, BaseParser.CompositeChildElement theChildElem, BaseParser.CompositeChildElement theParent) {
            assert (theUndeclaredExtension != null);
            this.myUndeclaredExtension = theUndeclaredExtension;
            this.myModifier = theModifier;
            this.myChildElem = theChildElem;
            this.myParent = theParent;
        }

        public HeldExtension(RuntimeChildDeclaredExtensionDefinition theDef, IBase theValue, BaseParser.CompositeChildElement theChildElem) {
            assert (theDef != null);
            assert (theValue != null);
            this.myDef = theDef;
            this.myValue = theValue;
            this.myChildElem = theChildElem;
        }

        @Override
        public int compareTo(HeldExtension theArg0) {
            String url1 = this.myDef != null ? this.myDef.getExtensionUrl() : this.myUndeclaredExtension.getUrl();
            String url2 = theArg0.myDef != null ? theArg0.myDef.getExtensionUrl() : theArg0.myUndeclaredExtension.getUrl();
            url1 = StringUtils.defaultString(JsonParser.this.getExtensionUrl(url1));
            url2 = StringUtils.defaultString(JsonParser.this.getExtensionUrl(url2));
            return url1.compareTo(url2);
        }

        private void managePrimitiveExtension(IBase theValue, RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, BaseRuntimeElementDefinition<?> def, String childName, BaseParser.EncodeContext theEncodeContext, boolean theContainedResource) throws IOException {
            if (def.getChildType().equals((Object)BaseRuntimeElementDefinition.ChildTypeEnum.ID_DATATYPE) || def.getChildType().equals((Object)BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_DATATYPE)) {
                ArrayList extensions = new ArrayList(0);
                ArrayList modifierExtensions = new ArrayList(0);
                JsonParser.this.extractUndeclaredExtensions(theValue, extensions, modifierExtensions, this.myParent, null, theEncodeContext, theContainedResource);
                if (def != null) {
                    JsonParser.this.extractDeclaredExtensions(theValue, def, extensions, modifierExtensions, this.myParent);
                }
                boolean haveContent = false;
                if (!extensions.isEmpty() || !modifierExtensions.isEmpty()) {
                    haveContent = true;
                }
                if (haveContent) {
                    JsonParser.this.beginObject(theEventWriter, '_' + childName);
                    JsonParser.this.writeExtensionsAsDirectChild(theResource, theEventWriter, theResDef, extensions, modifierExtensions, theEncodeContext, theContainedResource);
                    theEventWriter.endObject();
                }
            }
        }

        public void write(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, BaseParser.EncodeContext theEncodeContext, boolean theContainedResource) throws IOException {
            if (this.myUndeclaredExtension != null) {
                this.writeUndeclaredExtension(theResDef, theResource, theEventWriter, this.myUndeclaredExtension, theEncodeContext, theContainedResource);
            } else {
                theEventWriter.beginObject();
                JsonParser.this.writeCommentsPreAndPost(this.myValue, theEventWriter);
                JsonParser.write(theEventWriter, "url", JsonParser.this.getExtensionUrl(this.myDef.getExtensionUrl()));
                List<? extends IBase> preProcessedValue = JsonParser.this.preProcessValues(this.myDef, theResource, Collections.singletonList(this.myValue), this.myChildElem, theEncodeContext);
                this.myValue = preProcessedValue.get(0);
                BaseRuntimeElementDefinition<?> def = this.myDef.getChildElementDefinitionByDatatype(this.myValue.getClass());
                if (def.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.RESOURCE_BLOCK) {
                    JsonParser.this.extractAndWriteExtensionsAsDirectChild(this.myValue, theEventWriter, def, theResDef, theResource, this.myChildElem, null, theEncodeContext, theContainedResource);
                } else {
                    String childName = this.myDef.getChildNameByDatatype(this.myValue.getClass());
                    JsonParser.this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, this.myValue, def, childName, false, this.myParent, false, theEncodeContext);
                    this.managePrimitiveExtension(this.myValue, theResDef, theResource, theEventWriter, def, childName, theEncodeContext, theContainedResource);
                }
                theEventWriter.endObject();
            }
        }

        private void writeUndeclaredExtension(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, IBaseExtension<?, ?> ext, BaseParser.EncodeContext theEncodeContext, boolean theContainedResource) throws IOException {
            boolean noValue;
            IBase value = ext.getValue();
            String extensionUrl = JsonParser.this.getExtensionUrl(ext.getUrl());
            theEventWriter.beginObject();
            JsonParser.this.writeCommentsPreAndPost(this.myUndeclaredExtension, theEventWriter);
            String elementId = JsonParser.this.getCompositeElementId(ext);
            if (StringUtils.isNotBlank(elementId)) {
                JsonParser.write(theEventWriter, "id", JsonParser.this.getCompositeElementId(ext));
            }
            if (StringUtils.isBlank(extensionUrl)) {
                ParseLocation loc = new ParseLocation(theEncodeContext.toString());
                JsonParser.this.getErrorHandler().missingRequiredElement(loc, "url");
            }
            JsonParser.write(theEventWriter, "url", extensionUrl);
            boolean bl = noValue = value == null || value.isEmpty();
            if (noValue && ext.getExtension().isEmpty()) {
                ParseLocation loc = new ParseLocation(theEncodeContext.toString());
                JsonParser.this.getErrorHandler().missingRequiredElement(loc, "value");
                ourLog.debug("Extension with URL[{}] has no value", (Object)extensionUrl);
            } else {
                if (!noValue && !ext.getExtension().isEmpty()) {
                    ParseLocation loc = new ParseLocation(theEncodeContext.toString());
                    JsonParser.this.getErrorHandler().extensionContainsValueAndNestedExtensions(loc);
                }
                if (!ext.getExtension().isEmpty()) {
                    if (this.myModifier) {
                        JsonParser.this.beginArray(theEventWriter, "modifierExtension");
                    } else {
                        JsonParser.this.beginArray(theEventWriter, "extension");
                    }
                    for (Object next : ext.getExtension()) {
                        this.writeUndeclaredExtension(theResDef, theResource, theEventWriter, (IBaseExtension)next, theEncodeContext, theContainedResource);
                    }
                    theEventWriter.endArray();
                }
                if (!noValue) {
                    BaseRuntimeElementDefinition<?> childDef;
                    theEncodeContext.pushPath("value", false);
                    value = JsonParser.this.preProcessValues(this.myDef, theResource, Collections.singletonList(value), this.myChildElem, theEncodeContext).get(0);
                    RuntimeChildUndeclaredExtensionDefinition extDef = JsonParser.this.myContext.getRuntimeChildUndeclaredExtensionDefinition();
                    String childName = extDef.getChildNameByDatatype(value.getClass());
                    if (childName == null) {
                        childName = "value" + WordUtils.capitalize(JsonParser.this.myContext.getElementDefinition(value.getClass()).getName());
                    }
                    if ((childDef = extDef.getChildElementDefinitionByDatatype(value.getClass())) == null) {
                        throw new ConfigurationException("Unable to encode extension, unrecognized child element type: " + value.getClass().getCanonicalName());
                    }
                    JsonParser.this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, value, childDef, childName, false, this.myParent, false, theEncodeContext);
                    this.managePrimitiveExtension(value, theResDef, theResource, theEventWriter, childDef, childName, theEncodeContext, theContainedResource);
                    theEncodeContext.popPath();
                }
            }
            theEventWriter.endObject();
        }
    }
}

