/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Include
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean myImmutable;
    private boolean myIterate;
    private String myValue;

    public Include(String theValue) {
        this.myValue = theValue;
        this.myImmutable = false;
    }

    public Include(String theValue, boolean theIterate) {
        this.myValue = theValue;
        this.myIterate = theIterate;
        this.myImmutable = false;
    }

    public Include(String theValue, boolean theIterate, boolean theImmutable) {
        this.myValue = theValue;
        this.myIterate = theIterate;
        this.myImmutable = theImmutable;
    }

    public Include asNonRecursive() {
        return new Include(this.myValue, false);
    }

    public Include asRecursive() {
        return new Include(this.myValue, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Include other = (Include)obj;
        if (this.myIterate != other.myIterate) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    public String getParamType() {
        int firstColon = this.myValue.indexOf(58);
        if (firstColon == -1 || firstColon == this.myValue.length() - 1) {
            return null;
        }
        return this.myValue.substring(0, firstColon);
    }

    public String getParamName() {
        int firstColon = this.myValue.indexOf(58);
        if (firstColon == -1 || firstColon == this.myValue.length() - 1) {
            return null;
        }
        int secondColon = this.myValue.indexOf(58, firstColon + 1);
        if (secondColon != -1) {
            return this.myValue.substring(firstColon + 1, secondColon);
        }
        return this.myValue.substring(firstColon + 1);
    }

    public String getParamTargetType() {
        int firstColon = this.myValue.indexOf(58);
        if (firstColon == -1 || firstColon == this.myValue.length() - 1) {
            return null;
        }
        int secondColon = this.myValue.indexOf(58, firstColon + 1);
        if (secondColon != -1) {
            return this.myValue.substring(secondColon + 1);
        }
        return null;
    }

    public String getValue() {
        return this.myValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myIterate ? 1231 : 1237);
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean isLocked() {
        return this.myImmutable;
    }

    public boolean isRecurse() {
        return this.myIterate;
    }

    public Include setRecurse(boolean theRecurse) {
        this.myIterate = theRecurse;
        return this;
    }

    public void setValue(String theValue) {
        if (this.myImmutable) {
            throw new IllegalStateException("Can not change the value of this include");
        }
        this.myValue = theValue;
    }

    public Include toLocked() {
        Include retVal = new Include(this.myValue, this.myIterate, true);
        return retVal;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("value", this.myValue);
        builder.append("iterate", this.myIterate);
        return builder.toString();
    }

    public Include withType(String theResourceType) {
        StringBuilder b = new StringBuilder();
        String paramType = this.getParamType();
        String paramName = this.getParamName();
        if (StringUtils.isBlank(paramType) || StringUtils.isBlank(paramName)) {
            throw new IllegalStateException("This include does not contain a value in the format [ResourceType]:[paramName]");
        }
        b.append(paramType);
        b.append(":");
        b.append(paramName);
        if (StringUtils.isNotBlank(theResourceType)) {
            b.append(':');
            b.append(theResourceType);
        }
        Include retVal = new Include(b.toString(), this.myIterate, this.myImmutable);
        return retVal;
    }
}

