/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.model;

import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class RequestPartitionId {
    private static final RequestPartitionId ALL_PARTITIONS = new RequestPartitionId();
    private final LocalDate myPartitionDate;
    private final boolean myAllPartitions;
    private final Integer myPartitionId;
    private final String myPartitionName;

    private RequestPartitionId(@Nullable String thePartitionName, @Nullable Integer thePartitionId, @Nullable LocalDate thePartitionDate) {
        this.myPartitionId = thePartitionId;
        this.myPartitionName = thePartitionName;
        this.myPartitionDate = thePartitionDate;
        this.myAllPartitions = false;
    }

    private RequestPartitionId() {
        this.myPartitionDate = null;
        this.myPartitionName = null;
        this.myPartitionId = null;
        this.myAllPartitions = true;
    }

    public boolean isAllPartitions() {
        return this.myAllPartitions;
    }

    @Nullable
    public LocalDate getPartitionDate() {
        return this.myPartitionDate;
    }

    @Nullable
    public String getPartitionName() {
        return this.myPartitionName;
    }

    @Nullable
    public Integer getPartitionId() {
        return this.myPartitionId;
    }

    public String toString() {
        return "RequestPartitionId[id=" + this.getPartitionId() + ", name=" + this.getPartitionName() + "]";
    }

    public String getPartitionIdStringOrNullString() {
        if (this.myPartitionId == null) {
            return "null";
        }
        return this.myPartitionId.toString();
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        RequestPartitionId that = (RequestPartitionId)theO;
        return new EqualsBuilder().append(this.myAllPartitions, that.myAllPartitions).append(this.myPartitionDate, that.myPartitionDate).append(this.myPartitionId, that.myPartitionId).append(this.myPartitionName, that.myPartitionName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.myPartitionDate).append(this.myAllPartitions).append(this.myPartitionId).append(this.myPartitionName).toHashCode();
    }

    @Nonnull
    public static RequestPartitionId allPartitions() {
        return ALL_PARTITIONS;
    }

    @Nonnull
    public static RequestPartitionId defaultPartition() {
        return RequestPartitionId.fromPartitionId(null);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionId(@Nullable Integer thePartitionId) {
        return RequestPartitionId.fromPartitionId(thePartitionId, null);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionId(@Nullable Integer thePartitionId, @Nullable LocalDate thePartitionDate) {
        return new RequestPartitionId(null, thePartitionId, thePartitionDate);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionName(@Nullable String thePartitionName) {
        return RequestPartitionId.fromPartitionName(thePartitionName, null);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionName(@Nullable String thePartitionName, @Nullable LocalDate thePartitionDate) {
        return new RequestPartitionId(thePartitionName, null, thePartitionDate);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionIdAndName(@Nullable Integer thePartitionId, @Nullable String thePartitionName) {
        return new RequestPartitionId(thePartitionName, thePartitionId, null);
    }

    @Nonnull
    public static RequestPartitionId forPartitionIdAndName(@Nullable Integer thePartitionId, @Nullable String thePartitionName, @Nullable LocalDate thePartitionDate) {
        return new RequestPartitionId(thePartitionName, thePartitionId, thePartitionDate);
    }

    public static String stringifyForKey(RequestPartitionId theRequestPartitionId) {
        String retVal = "(null)";
        if (theRequestPartitionId != null) {
            retVal = theRequestPartitionId.getPartitionIdStringOrNullString();
        }
        return retVal;
    }
}

