/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveEnumerationDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;

public class RuntimeChildDeclaredExtensionDefinition
extends RuntimeChildChoiceDefinition {
    private boolean myDefinedLocally;
    private String myExtensionUrl;
    private boolean myModifier;
    private Map<String, RuntimeChildDeclaredExtensionDefinition> myUrlToChildExtension;
    private volatile Object myInstanceConstructorArguments;
    private Class<?> myEnumerationType;
    private Class<? extends IBase> myChildType;
    private RuntimeResourceBlockDefinition myChildResourceBlock;
    private BaseRuntimeElementDefinition<?> myChildDef;

    RuntimeChildDeclaredExtensionDefinition(Field theField, Child theChild, Description theDescriptionAnnotation, Extension theExtension, String theElementName, String theExtensionUrl, Class<? extends IBase> theChildType, Object theBoundTypeBinder) throws ConfigurationException {
        super(theField, theElementName, theChild, theDescriptionAnnotation);
        assert (StringUtils.isNotBlank(theExtensionUrl));
        this.myExtensionUrl = theExtensionUrl;
        this.myChildType = theChildType;
        this.myDefinedLocally = theExtension.definedLocally();
        this.myModifier = theExtension.isModifier();
        this.myInstanceConstructorArguments = theBoundTypeBinder;
        ArrayList<Class<? extends IBase>> choiceTypes = new ArrayList<Class<? extends IBase>>();
        for (Class<? extends IElement> next : theChild.type()) {
            choiceTypes.add(next);
        }
        if (!Modifier.isAbstract(theChildType.getModifiers())) {
            choiceTypes.add(theChildType);
        }
        this.setChoiceTypes(choiceTypes);
    }

    @Override
    public String getElementName() {
        return "value";
    }

    @Override
    public Object getInstanceConstructorArguments() {
        Object retVal = this.myInstanceConstructorArguments;
        if (retVal == null && this.myEnumerationType != null) {
            this.myInstanceConstructorArguments = retVal = RuntimeChildPrimitiveEnumerationDatatypeDefinition.toEnumFactory(this.myEnumerationType);
        }
        return retVal;
    }

    public void setEnumerationType(Class<?> theEnumerationType) {
        this.myEnumerationType = theEnumerationType;
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        BaseRuntimeElementDefinition<?> childDef;
        String retVal = super.getChildNameByDatatype(theDatatype);
        if (retVal != null && (childDef = super.getChildElementDefinitionByDatatype(theDatatype)) instanceof RuntimeResourceBlockDefinition) {
            retVal = null;
        }
        if (retVal == null) {
            if (this.myModifier) {
                return "modifierExtension";
            }
            return "extension";
        }
        return retVal;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        String name = theName;
        if ("extension".equals(name) || "modifierExtension".equals(name)) {
            if (this.myChildResourceBlock != null) {
                return this.myChildResourceBlock;
            }
            if (this.myChildDef != null) {
                return this.myChildDef;
            }
        }
        if (!this.getValidChildNames().contains(name)) {
            return null;
        }
        return super.getChildByName(name);
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theDatatype) {
        if (this.myChildResourceBlock != null && this.myChildResourceBlock.getImplementingClass().equals(theDatatype)) {
            return this.myChildResourceBlock;
        }
        return super.getChildElementDefinitionByDatatype(theDatatype);
    }

    public RuntimeChildDeclaredExtensionDefinition getChildExtensionForUrl(String theUrl) {
        return this.myUrlToChildExtension.get(theUrl);
    }

    @Override
    public String getExtensionUrl() {
        return this.myExtensionUrl;
    }

    public boolean isDefinedLocally() {
        return this.myDefinedLocally;
    }

    @Override
    public boolean isModifier() {
        return this.myModifier;
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        this.myUrlToChildExtension = new HashMap<String, RuntimeChildDeclaredExtensionDefinition>();
        BaseRuntimeElementDefinition<?> elementDef = theClassToElementDefinitions.get(this.myChildType);
        if (elementDef == null && !Modifier.isAbstract(this.myChildType.getModifiers())) {
            elementDef = theContext.getElementDefinition(this.myChildType);
        }
        if (elementDef instanceof RuntimePrimitiveDatatypeDefinition || elementDef instanceof RuntimeCompositeDatatypeDefinition) {
            this.myChildDef = elementDef;
        } else if (elementDef instanceof RuntimeResourceBlockDefinition) {
            RuntimeResourceBlockDefinition extDef = (RuntimeResourceBlockDefinition)elementDef;
            for (RuntimeChildDeclaredExtensionDefinition next : extDef.getExtensions()) {
                this.myUrlToChildExtension.put(next.getExtensionUrl(), next);
            }
            this.myChildResourceBlock = (RuntimeResourceBlockDefinition)elementDef;
        }
        this.myUrlToChildExtension = Collections.unmodifiableMap(this.myUrlToChildExtension);
        super.sealAndInitialize(theContext, theClassToElementDefinitions);
    }

    public IBase newInstance() {
        return ReflectionUtil.newInstance(this.myChildType);
    }

    public Class<? extends IBase> getChildType() {
        return this.myChildType;
    }
}

