/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.ghrelease;

import ca.stellardrift.ghrelease.GitHubReleaserExtensionImpl;
import ca.stellardrift.ghrelease.GithubReleaserExtension;
import ca.stellardrift.ghrelease.PublishGitHubRelease;
import ca.stellardrift.ghrelease.ReleaseJobParameters;
import net.kyori.mammoth.ProjectPlugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;

public class GitHubReleaserPlugin
implements ProjectPlugin {
    public static final String GITHUB_RELEASE_EXTENSION_NAME = "githubRelease";
    public static final String GITHUB_RELEASE_TASK_NAME = "publishToGitHub";
    private static final String TAG_REF_PREFIX = "refs/tags/";

    public void apply(@NotNull Project project, @NotNull PluginContainer plugins, @NotNull ExtensionContainer extensions, @NotNull TaskContainer tasks) {
        GithubReleaserExtension extension = (GithubReleaserExtension)extensions.create(GithubReleaserExtension.class, GITHUB_RELEASE_EXTENSION_NAME, GitHubReleaserExtensionImpl.class, new Object[0]);
        this.configureTasks(tasks, extension);
        this.registerPublishTask(tasks, extension);
        extension.getTagName().convention(project.getProviders().environmentVariable("GITHUB_REF").map(ref -> {
            if (!ref.startsWith(TAG_REF_PREFIX)) {
                return null;
            }
            return ref.substring(TAG_REF_PREFIX.length());
        }));
    }

    private void configureTasks(TaskContainer tasks, GithubReleaserExtension extension) {
        tasks.withType(PublishGitHubRelease.class).configureEach(task -> {
            task.getEnterpriseUrl().set(extension.getEnterpriseUrl());
            task.getApiToken().set(extension.getApiToken());
        });
    }

    private void registerPublishTask(TaskContainer tasks, ReleaseJobParameters sourceParameters) {
        tasks.register(GITHUB_RELEASE_TASK_NAME, PublishGitHubRelease.class, task -> {
            task.getReleaseName().set(sourceParameters.getReleaseName());
            task.getReleaseBody().set(sourceParameters.getReleaseBody());
            task.getRepository().set(sourceParameters.getRepository());
            task.getTagName().set(sourceParameters.getTagName());
            task.getSourceBranch().set(sourceParameters.getSourceBranch());
            task.getDraft().set(sourceParameters.getDraft());
            task.getPrerelease().set(sourceParameters.getPrerelease());
            task.getDiscussionCategoryName().set(sourceParameters.getDiscussionCategoryName());
            task.getMakeLatest().set(sourceParameters.getMakeLatest());
            task.getArtifacts().from(new Object[]{sourceParameters.getArtifacts()});
        });
    }
}

