/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.tracing.xray;

import ca.nexapp.tracing.Trace;
import ca.nexapp.tracing.xray.XRay;
import com.amazonaws.xray.entities.Entity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0014\u0010\u0015\u001a\u00020\u00062\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0011H\u00d6\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lca/nexapp/tracing/xray/XRayTrace;", "Lca/nexapp/tracing/Trace;", "xrayEntity", "Lcom/amazonaws/xray/entities/Entity;", "(Lcom/amazonaws/xray/entities/Entity;)V", "close", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "setMetadata", "key", "", "value", "setTag", "name", "signalError", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "toString", "nexapp-tracing"})
public final class XRayTrace
implements Trace {
    private final Entity xrayEntity;

    @Override
    public void signalError(@NotNull Exception error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        try {
            Entity entity = this.xrayEntity;
            if (entity != null) {
                entity.addException((Throwable)error);
            }
        }
        catch (Exception expected) {
            XRay.INSTANCE.suppressXRayException(expected);
        }
    }

    @Override
    public void setTag(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            Entity entity = this.xrayEntity;
            if (entity != null) {
                entity.putAnnotation(name, value);
            }
        }
        catch (Exception expected) {
            XRay.INSTANCE.suppressXRayException(expected);
        }
    }

    @Override
    public void setMetadata(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            Entity entity = this.xrayEntity;
            if (entity != null) {
                entity.putMetadata(key, (Object)value);
            }
        }
        catch (Exception expected) {
            XRay.INSTANCE.suppressXRayException(expected);
        }
    }

    @Override
    public void close() {
        try {
            Entity entity = this.xrayEntity;
            if (entity != null) {
                entity.close();
            }
        }
        catch (Exception expected) {
            XRay.INSTANCE.suppressXRayException(expected);
        }
    }

    public XRayTrace(@Nullable Entity xrayEntity) {
        this.xrayEntity = xrayEntity;
    }

    private final Entity component1() {
        return this.xrayEntity;
    }

    @NotNull
    public final XRayTrace copy(@Nullable Entity xrayEntity) {
        return new XRayTrace(xrayEntity);
    }

    public static /* synthetic */ XRayTrace copy$default(XRayTrace xRayTrace, Entity entity, int n, Object object) {
        if ((n & 1) != 0) {
            entity = xRayTrace.xrayEntity;
        }
        return xRayTrace.copy(entity);
    }

    @NotNull
    public String toString() {
        return "XRayTrace(xrayEntity=" + this.xrayEntity + ")";
    }

    public int hashCode() {
        Entity entity = this.xrayEntity;
        return entity != null ? entity.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof XRayTrace)) break block3;
                XRayTrace xRayTrace = (XRayTrace)object;
                if (!Intrinsics.areEqual((Object)this.xrayEntity, (Object)xRayTrace.xrayEntity)) break block3;
            }
            return true;
        }
        return false;
    }
}

