/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.tracing.sentry;

import ca.nexapp.tracing.Trace;
import ca.nexapp.tracing.Tracer;
import ca.nexapp.tracing.sentry.SentryTrace;
import io.sentry.SentryClient;
import io.sentry.context.Context;
import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lca/nexapp/tracing/sentry/SentryTracer;", "Lca/nexapp/tracing/Tracer;", "clock", "Ljava/time/Clock;", "client", "Lio/sentry/SentryClient;", "(Ljava/time/Clock;Lio/sentry/SentryClient;)V", "openTrace", "Lca/nexapp/tracing/Trace;", "name", "", "nexapp-tracing"})
public final class SentryTracer
implements Tracer {
    private final Clock clock;
    private final SentryClient client;

    @Override
    @NotNull
    public Trace openTrace(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Instant now = this.clock.instant();
        Context context = this.client.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"client.context");
        Instant instant = now;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"now");
        return new SentryTrace(context, name, instant);
    }

    public SentryTracer(@NotNull Clock clock, @NotNull SentryClient client) {
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.clock = clock;
        this.client = client;
    }

    @Override
    public <T> T trace(@NotNull String name, @NotNull Function1<? super Trace, ? extends T> toTrace) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(toTrace, (String)"toTrace");
        return Tracer.DefaultImpls.trace(this, name, toTrace);
    }
}

