/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.util.Log;
import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityWrapper;
import buzz.getcoco.iot.DefaultCreator;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;
import buzz.getcoco.iot.android.AttributeEx;
import buzz.getcoco.iot.android.CapabilityWrapperEx;
import buzz.getcoco.iot.android.DeviceEx;
import buzz.getcoco.iot.android.NetworkEx;
import buzz.getcoco.iot.android.ResourceAdvert;
import buzz.getcoco.iot.android.ResourceEx;
import buzz.getcoco.iot.android.RuleEx;
import buzz.getcoco.iot.android.SceneEx;
import buzz.getcoco.iot.android.ZoneEx;

public class CreatorEx
implements DefaultCreator {
    private static final String TAG = "CreatorEx";

    public Network createNetwork(String id) {
        return new NetworkEx(id);
    }

    public Resource createResource(String eui, Device parentDevice, Zone parentZone) {
        return new ResourceEx(eui, parentDevice, parentZone);
    }

    public Resource createAdvertResource(String eui, Device parentDevice) {
        Log.d((String)TAG, (String)("createAdvertResource: eui: " + eui));
        return new ResourceAdvert(eui, parentDevice);
    }

    public Attribute createAttribute(int id, Capability parent) {
        return new AttributeEx(id, parent);
    }

    public Capability createCapability(int capabilityId, Resource parent) {
        Capability capability = super.createCapability(capabilityId, parent);
        capability.setCapabilityWrapper((CapabilityWrapper)new CapabilityWrapperEx(capability));
        return capability;
    }

    public Device createDevice(long deviceNodeId, Network parent) {
        return new DeviceEx(deviceNodeId, parent);
    }

    public Zone createZone(int zoneId, Network parent) {
        return new ZoneEx(zoneId, parent);
    }

    public Rule createRule(int id, Network parent) {
        return new RuleEx(id, parent);
    }

    public Scene createScene(int sceneId, Network parent) {
        return new SceneEx(sceneId, parent);
    }
}

