/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.ScheduleCondition;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.NetworkEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RuleEx
extends Rule {
    private transient Identifier identifier;
    private transient List<Rule.Condition> conditions;
    private transient MutableLiveData<String> nameObservable;
    private transient MutableLiveData<List<Rule.Condition>> conditionsObservable;
    private transient MutableLiveData<List<ScheduleCondition>> scheduleConditionObservable;

    protected RuleEx(int id, Network parent) {
        super(id, parent);
    }

    protected void internalClearAddSceneActions(Collection<Scene> scenesActions) {
        super.internalClearAddSceneActions(scenesActions);
        this.recompileConditions();
        FactoryUtility.postValue(this.conditionsObservable, this.conditions);
    }

    protected void internalClearAddResourceActions(Collection<ResourceAction> resourceActions) {
        super.internalClearAddResourceActions(resourceActions);
        this.recompileConditions();
        FactoryUtility.postValue(this.conditionsObservable, this.conditions);
        FactoryUtility.postValue(this.scheduleConditionObservable, this.getScheduleConditions());
    }

    protected void internalSetName(String name) {
        super.internalSetName(name);
        NetworkEx parent = (NetworkEx)this.getParent();
        if (null != parent) {
            parent.onRuleNameUpdated(this);
        }
        FactoryUtility.postValue(this.nameObservable, name);
    }

    private void recompileConditions() {
        if (null == this.conditions) {
            return;
        }
        this.conditions.clear();
        this.conditions.addAll(this.getScheduleConditions());
        this.conditions.addAll(this.getResourceConditions());
    }

    public Identifier getIdentifier() {
        return null != this.identifier ? this.identifier : (this.identifier = Identifier.getIdentifier(this));
    }

    public LiveData<String> getNameObservable() {
        return null != this.nameObservable ? this.nameObservable : (this.nameObservable = new MutableLiveData((Object)this.getName()));
    }

    public LiveData<List<Rule.Condition>> getConditionsObservable() {
        return null != this.conditionsObservable ? this.conditionsObservable : (this.conditionsObservable = FactoryUtility.createLiveData(this.getConditions()));
    }

    public LiveData<List<ScheduleCondition>> getScheduleConditionObservable() {
        return null != this.scheduleConditionObservable ? this.scheduleConditionObservable : (this.scheduleConditionObservable = FactoryUtility.createLiveData(this.getScheduleConditions()));
    }

    public List<Rule.Condition> getConditions() {
        if (null == this.conditions) {
            this.conditions = new ArrayList<Rule.Condition>(this.getResourceConditions().size() + this.getScheduleConditions().size());
            this.recompileConditions();
        }
        return this.conditions;
    }

    private void trimMemory() {
        this.conditions = null;
        this.nameObservable = FactoryUtility.nullIfEmpty(this.nameObservable);
        this.conditionsObservable = FactoryUtility.nullIfEmpty(this.conditionsObservable);
    }
}

