/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityHvacControl;
import buzz.getcoco.iot.CapabilityRemoteControl;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.ResourceEx;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AttributeEx
extends Attribute {
    private static final String TAG = "AttributeEx";
    private transient MutableLiveData<String> nameObservable;
    private transient MutableLiveData<Object> minValueObservable;
    private transient MutableLiveData<Object> maxValueObservable;
    private transient MutableLiveData<Object> currentValueObservable;
    private transient MutableLiveData<Object> defaultValueObservable;
    private transient Identifier identifier;
    private transient ApplianceInfo[] applianceInfo;

    protected AttributeEx(int id, Capability parent) {
        super(id, parent);
    }

    protected Network getParentNetwork() {
        ResourceEx resource = this.getParentResource();
        Device device = null == resource ? null : resource.getParent();
        return null == device ? null : device.getParent();
    }

    protected void syncCurrentValue() {
        FactoryUtility.postValue(this.currentValueObservable, this.getCurrentValue());
    }

    @Nullable
    public ResourceEx getParentResource() {
        Capability capability = this.getParent();
        return null == capability ? null : (ResourceEx)capability.getParent();
    }

    protected void internalSetName(String name) {
        super.internalSetName(name);
        FactoryUtility.postValue(this.nameObservable, name);
    }

    protected void internalSetMinValue(Object minValue) {
        Log.d((String)TAG, (String)("internalSetMinValue: minVal: " + minValue));
        super.internalSetMinValue(minValue);
        FactoryUtility.postValue(this.minValueObservable, minValue);
    }

    protected void internalSetMaxValue(Object maxValue) {
        Log.d((String)TAG, (String)("internalSetMaxValue: maxVal: " + maxValue));
        super.internalSetMaxValue(maxValue);
        FactoryUtility.postValue(this.maxValueObservable, maxValue);
    }

    protected void internalSetCurrentValue(Object currentValue) {
        super.internalSetCurrentValue(currentValue);
        Log.d((String)TAG, (String)("internalSetCurrentValue: " + this.getCurrentValue()));
        if (null != this.getParent() && CapabilityRemoteControl.AttributeId.APPLIANCE_LIST == this.getId()) {
            Log.d((String)TAG, (String)"internalSetCurrentValue: updating the appliance info");
            this.reCalApplianceInfo();
            Log.d((String)TAG, (String)("internalSetCurrentValue: updated appliance info: " + Arrays.toString(this.applianceInfo)));
        }
        FactoryUtility.postValue(this.currentValueObservable, this.getCurrentValue());
    }

    protected void internalSetDefaultValue(Object defaultValue) {
        Log.d((String)TAG, (String)("internalSetDefaultValue: defVal: " + defaultValue));
        super.internalSetDefaultValue(defaultValue);
        FactoryUtility.postValue(this.defaultValueObservable, defaultValue);
    }

    protected void internalSetParent(Capability parent) {
        super.internalSetParent(parent);
        this.syncCurrentValue();
    }

    public LiveData<String> getNameObservable() {
        return null != this.nameObservable ? this.nameObservable : (this.nameObservable = FactoryUtility.createLiveData(this.getName()));
    }

    public LiveData<Object> getCurrentValueObservable() {
        return null != this.currentValueObservable ? this.currentValueObservable : (this.currentValueObservable = FactoryUtility.createLiveData(this.getCurrentValue()));
    }

    public LiveData<Object> getDefaultValueObservable() {
        return null != this.defaultValueObservable ? this.defaultValueObservable : (this.defaultValueObservable = FactoryUtility.createLiveData(this.getDefaultValue()));
    }

    public static Capability.AttributeId getAttributeId(int attributeId, int capabilityId) {
        return Capability.CapabilityId.getEnum((int)capabilityId).getAttributeId(attributeId);
    }

    public Identifier getIdentifier() {
        return null != this.identifier ? this.identifier : (this.identifier = Identifier.getIdentifier(this));
    }

    private synchronized void reCalApplianceInfo() {
        ApplianceInfo[] applianceInfo = null;
        try {
            ApplianceInfoContainer container = (ApplianceInfoContainer)new Gson().fromJson(this.getAsString(), ApplianceInfoContainer.class);
            applianceInfo = null == container ? null : container.applianceInfo;
        }
        catch (JsonSyntaxException jse) {
            Log.d((String)TAG, (String)"reCalApplianceInfo: error", (Throwable)jse);
        }
        this.applianceInfo = null != applianceInfo ? applianceInfo : new ApplianceInfo[0];
    }

    public ApplianceInfo[] getAsApplianceInfo() {
        if (CapabilityRemoteControl.AttributeId.APPLIANCE_LIST != this.getId()) {
            throw new IllegalArgumentException("called getAsApplianceInfo on: " + (Object)((Object)this));
        }
        if (null == this.applianceInfo) {
            this.reCalApplianceInfo();
        }
        return this.applianceInfo;
    }

    private void trimMemory() {
        this.nameObservable = FactoryUtility.nullIfEmpty(this.nameObservable);
        this.minValueObservable = FactoryUtility.nullIfEmpty(this.minValueObservable);
        this.maxValueObservable = FactoryUtility.nullIfEmpty(this.maxValueObservable);
        this.currentValueObservable = FactoryUtility.nullIfEmpty(this.currentValueObservable);
        this.defaultValueObservable = FactoryUtility.nullIfEmpty(this.defaultValueObservable);
    }

    public static final class ModesAttributeValue {
        @SerializedName(value="mode")
        private final int mode;
        @SerializedName(value="minTemperatureCelsius")
        private final int minTempCelsius;
        @SerializedName(value="maxTemperatureCelsius")
        private final int maxTempCelsius;
        @SerializedName(value="supportedFanSpeedsArr")
        private final int[] fanSpeeds;

        public ModesAttributeValue(int mode, int minTempCelsius, int maxTempCelsius, int[] fanSpeeds) {
            this.mode = mode;
            this.minTempCelsius = minTempCelsius;
            this.maxTempCelsius = maxTempCelsius;
            this.fanSpeeds = fanSpeeds;
        }

        public int getMode() {
            return this.mode;
        }

        public int getMinTempCelsius() {
            return this.minTempCelsius;
        }

        public int getMaxTempCelsius() {
            return this.maxTempCelsius;
        }

        @NonNull
        public int[] getFanSpeeds() {
            return this.fanSpeeds == null ? new int[]{} : this.fanSpeeds;
        }

        @NonNull
        public String toString() {
            return "ModesAttributeValue{mode=" + this.mode + ", minTempCelsius=" + this.minTempCelsius + ", maxTempCelsius=" + this.maxTempCelsius + ", fanSpeeds=" + Arrays.toString(this.fanSpeeds) + '}';
        }
    }

    public static final class CapabilityAttributes {
        @SerializedName(value="capabilityId")
        private int capId;
        @SerializedName(value="attributeId")
        private int attrId;
        @SerializedName(value="attributeValue")
        public Object attrValue;
        @SerializedName(value="attributeDataType")
        public int dataType;

        public CapabilityAttributes(int capId, int attrId, Object attrValue, int dataType) {
            this.capId = capId;
            this.attrId = attrId;
            this.attrValue = attrValue;
            this.dataType = dataType;
        }

        public CapabilityAttributes() {
        }

        public Capability.AttributeId getAttributeId() {
            return Capability.CapabilityId.getEnum((int)this.capId).getAttributeId(this.attrId);
        }

        public int getAttrId() {
            return this.attrId;
        }

        public int getCapId() {
            return this.capId;
        }

        @NonNull
        public String toString() {
            return "CapabilityAttributes{capId=" + this.capId + ", attrId=" + this.attrId + ", attrValue=" + this.attrValue + ", dataType=" + this.dataType + '}';
        }
    }

    public static final class CapabilityCommands {
        @SerializedName(value="capabilityId")
        public int capId;
        @SerializedName(value="commandIdArray")
        public int[] supportedCmdArr;

        public Capability.CapabilityId getCapabilityId() {
            return Capability.CapabilityId.getEnum((int)this.capId);
        }

        @NonNull
        public String toString() {
            return "CapabilityCommands{capId=" + this.capId + ", supportedCmdArr=" + Arrays.toString(this.supportedCmdArr) + '}';
        }
    }

    public static final class ApplianceInfo {
        @SerializedName(value="applianceId")
        public String applianceId;
        @SerializedName(value="applianceName")
        public String applianceName;
        @SerializedName(value="brandId")
        public int brandId;
        @SerializedName(value="pairingCode")
        public int pairingCode;
        @SerializedName(value="capCommandsArray")
        public CapabilityCommands[] capCommands;
        @SerializedName(value="capAttribValuesArray")
        public CapabilityAttributes[] attrs;

        @Nullable
        public Object getAttributeValue(@NonNull Capability.AttributeId attributeId) {
            int capId = attributeId.getCapabilityId().getInt();
            int attrId = attributeId.getInt();
            if (null == this.attrs) {
                return null;
            }
            for (CapabilityAttributes ca : this.attrs) {
                if (ca.capId != capId || ca.attrId != attrId) continue;
                return ca.attrValue;
            }
            return null;
        }

        @NonNull
        public List<ModesAttributeValue> getAsSupportedModes() {
            Object oModesJson = this.getAttributeValue((Capability.AttributeId)CapabilityHvacControl.AttributeId.SUPPORTED_MODES_ARR);
            try {
                Gson gson = new Gson();
                return Arrays.asList((ModesAttributeValue[])gson.fromJson(gson.toJson(oModesJson), ModesAttributeValue[].class));
            }
            catch (Exception e) {
                Log.d((String)AttributeEx.TAG, (String)"getAsSupportedModes: err", (Throwable)e);
                return Collections.emptyList();
            }
        }

        @NonNull
        public String toString() {
            return "ApplianceInfo{applianceId=" + this.applianceId + ", applianceName='" + this.applianceName + '\'' + ", brandId=" + this.brandId + ", pairingCode=" + this.pairingCode + ", capCommands=" + Arrays.toString(this.capCommands) + ", attrs=" + Arrays.toString(this.attrs) + '}';
        }
    }

    private static final class ApplianceInfoContainer {
        @SerializedName(value="appliances")
        public ApplianceInfo[] applianceInfo;

        private ApplianceInfoContainer() {
        }
    }
}

