/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.os.CountDownTimer;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Resource;

public class ResourceAdvert
extends Resource {
    private static final String TAG = "ResourceAdvert";
    private static final long EXPIRY_TIME = 20000L;
    private static final long TICK_INTERVAL = 1000L;
    private long timeOfAdvert = SystemClock.elapsedRealtime();
    private CountDownTimer timer;
    private MutableLiveData<Long> expiryObservable;

    public ResourceAdvert(String eui, Device parentDevice) {
        super(eui, parentDevice, null);
        Log.d((String)TAG, (String)("ResourceAdvert: advert created: " + eui + ", at: " + this.timeOfAdvert));
    }

    private long millisSinceAdvert() {
        return SystemClock.elapsedRealtime() - this.timeOfAdvert;
    }

    public long millisToExpiry() {
        return 20000L - this.millisSinceAdvert();
    }

    public Status getStatus() {
        return 20000L < this.millisSinceAdvert() ? Status.EXPIRED : Status.ACTIVE;
    }

    public void resetTimers() {
        this.timeOfAdvert = SystemClock.elapsedRealtime();
        if (null != this.timer) {
            this.timer.cancel();
            this.timer.start();
        }
        if (null != this.expiryObservable) {
            this.expiryObservable.postValue((Object)this.millisToExpiry());
        }
    }

    @MainThread
    public LiveData<Long> getExpiryObservable() {
        if (null == this.expiryObservable) {
            long millisToExpiry = this.millisToExpiry();
            this.expiryObservable = new MutableLiveData((Object)millisToExpiry);
            this.timer = new CountDownTimer(millisToExpiry, 1000L){

                public void onTick(long millisUntilFinished) {
                    ResourceAdvert.this.expiryObservable.postValue((Object)ResourceAdvert.this.millisToExpiry());
                }

                public void onFinish() {
                    ResourceAdvert.this.expiryObservable.postValue((Object)ResourceAdvert.this.millisToExpiry());
                }
            }.start();
        }
        return this.expiryObservable;
    }

    @NonNull
    public String toString() {
        return "ResourceAdvert{id: " + this.getId() + ", timeOfAdvert=" + this.timeOfAdvert + ", millisToExpiry=" + this.millisToExpiry() + '}';
    }

    public static enum Status {
        ACTIVE,
        EXPIRED;

    }
}

