/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityWrapper;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.android.AttributeEx;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.ResourceEx;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class CapabilityWrapperEx
implements CapabilityWrapper {
    private final Capability realCapability;
    private MutableLiveData<String> nameObservable;
    private MutableLiveData<Resource> parentResourceObservable;
    private final List<Attribute> attributeList;
    private MutableLiveData<List<Attribute>> attributeObservable;

    protected CapabilityWrapperEx(Capability realCapability) {
        this.realCapability = realCapability;
        this.attributeList = new ArrayList<Attribute>(10);
    }

    public void internalSetName(String name) {
        FactoryUtility.postValue(this.nameObservable, name);
    }

    public void internalSetParent(Resource parent) {
        FactoryUtility.postValue(this.parentResourceObservable, parent);
    }

    public void internalAddAttribute(Attribute attribute) {
        this.attributeList.add(attribute);
        this.postCapabilityChanged();
        FactoryUtility.postValue(this.attributeObservable, this.attributeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalRemoveAttribute(int attributeId) {
        List<Attribute> list = this.attributeList;
        synchronized (list) {
            Attribute attribute;
            ListIterator<Attribute> attributeIterator = this.attributeList.listIterator();
            while (null != (attribute = (Attribute)attributeIterator.next())) {
                if (attribute.getId().getInt() != attributeId) continue;
                attributeIterator.remove();
                return;
            }
        }
        this.postCapabilityChanged();
        FactoryUtility.postValue(this.attributeObservable, this.attributeList);
    }

    private void postCapabilityChanged() {
        ResourceEx resource = (ResourceEx)this.getRealCapability().getParent();
        if (null == resource) {
            return;
        }
        resource.onCapabilitiesChanged(this);
    }

    public void clearAndSetStandardCommandSet(int[] commandsSupported) {
    }

    public void markAsReady() {
        for (Attribute a : this.getRealCapability()) {
            AttributeEx aEx = (AttributeEx)a;
            aEx.syncCurrentValue();
        }
    }

    public Capability getRealCapability() {
        return this.realCapability;
    }

    public LiveData<String> getNameObservable() {
        return null != this.nameObservable ? this.nameObservable : (this.nameObservable = FactoryUtility.createLiveData(this.getRealCapability().getName()));
    }

    public LiveData<Resource> getParentResourceObservable() {
        return null != this.parentResourceObservable ? this.parentResourceObservable : (this.parentResourceObservable = FactoryUtility.createLiveData(this.getRealCapability().getParent()));
    }

    public LiveData<List<Attribute>> getAttributeObservable() {
        return null != this.attributeObservable ? this.attributeObservable : (this.attributeObservable = FactoryUtility.createLiveData(this.attributeList));
    }
}

