package buzz.getcoco.iot.android;

import android.util.Log;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.DefaultCreator;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;

public class CreatorEx implements DefaultCreator {

  private static final String TAG = "CreatorEx";

  @Override
  public Network createNetwork(String id) {
    return new NetworkEx(id);
  }

  @Override
  public Resource createResource(String eui, Device parentDevice, Zone parentZone) {
    return new ResourceEx(eui, parentDevice, parentZone);
  }

  @Override
  public Resource createAdvertResource(String eui, Device parentDevice) {
    Log.d(TAG, "createAdvertResource: eui: " + eui);

    return new ResourceAdvert(eui, parentDevice);
  }

  @Override
  public Attribute createAttribute(int id, Capability parent) {
    return new AttributeEx(id, parent);
  }

  @Override
  public Capability createCapability(int capabilityId, Resource parent) {
    Capability capability = DefaultCreator.super.createCapability(capabilityId, parent);

    capability.setCapabilityWrapper(new CapabilityWrapperEx(capability));

    return capability;
  }

  @Override
  public Device createDevice(long deviceNodeId, Network parent) {
    return new DeviceEx(deviceNodeId, parent);
  }

  @Override
  public Zone createZone(int zoneId, Network parent) {
    return new ZoneEx(zoneId, parent);
  }

  @Override
  public Rule createRule(int id, Network parent) {
    return new RuleEx(id, parent);
  }

  @Override
  public Scene createScene(int sceneId, Network parent) {
    return new SceneEx(sceneId, parent);
  }
}
