/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.ConnectivityStateManager;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.ResourceEx;
import buzz.getcoco.iot.android.SceneEx;
import buzz.getcoco.iot.android.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class BaseNetworkEx<D extends Device, Z extends Zone, S extends Scene, R extends Rule>
extends Network {
    private static final String TAG = "BaseNetworkEx";
    private transient Identifier identifier;
    private transient MutableLiveData<List<D>> deviceListObservable;
    private transient MutableLiveData<List<Z>> zoneListObservable;
    private transient MutableLiveData<List<R>> ruleListObservable;
    private transient MutableLiveData<List<S>> sceneListObservable;
    private transient MutableLiveData<String> networkNameObservable;
    private transient MutableLiveData<Boolean> removeNetworkObservable;
    private transient MutableLiveData<Network.State> stateObservable;
    private transient MutableLiveData<ConnectivityStateManager.State> conStateObservable;
    private transient List<D> deviceList;
    private transient List<Z> zoneList;
    private transient List<R> ruleList;
    private transient List<S> sceneList;
    private transient boolean isRemoved;

    protected BaseNetworkEx(String id) {
        super(id);
    }

    private static <T, U extends T> U castUp(T t) {
        return (U)t;
    }

    protected void internalAddDevice(Device device) {
        super.internalAddDevice(device);
        if (null == this.deviceList) {
            return;
        }
        this.deviceList.add((Device)BaseNetworkEx.castUp(device));
        this.sortDevices();
        FactoryUtility.postValue(this.deviceListObservable, this.deviceList);
    }

    protected void internalRemoveDevice(long deviceNodeId) {
        super.internalRemoveDevice(deviceNodeId);
        if (null == this.deviceList) {
            return;
        }
        for (int i = 0; i < this.deviceList.size(); ++i) {
            if (((Device)this.deviceList.get(i)).getId() != deviceNodeId) continue;
            this.deviceList.remove(i);
            break;
        }
        this.sortDevices();
        FactoryUtility.postValue(this.deviceListObservable, this.deviceList);
    }

    protected void internalAddZone(Zone zone) {
        super.internalAddZone(zone);
        if (null == this.zoneList) {
            return;
        }
        this.zoneList.add((Zone)BaseNetworkEx.castUp(zone));
        this.sortZonesAndCorrectDefaultZoneValidity();
        FactoryUtility.postValue(this.zoneListObservable, this.zoneList);
    }

    protected void internalRemoveZone(int zoneId) {
        super.internalRemoveZone(zoneId);
        if (null == this.zoneList) {
            return;
        }
        for (int i = 0; i < this.zoneList.size(); ++i) {
            if (zoneId != ((Zone)this.zoneList.get(i)).getId()) continue;
            this.zoneList.remove(i);
            break;
        }
        this.sortZonesAndCorrectDefaultZoneValidity();
        FactoryUtility.postValue(this.zoneListObservable, this.zoneList);
    }

    protected void internalAddRule(Rule rule) {
        super.internalAddRule(rule);
        if (null == this.ruleList) {
            return;
        }
        this.ruleList.add((Rule)BaseNetworkEx.castUp(rule));
        this.sortRules();
        FactoryUtility.postValue(this.ruleListObservable, this.ruleList);
    }

    protected void internalRemoveRule(int ruleId) {
        super.internalRemoveRule(ruleId);
        if (null == this.ruleList) {
            return;
        }
        for (int i = 0; i < this.ruleList.size(); ++i) {
            if (((Rule)this.ruleList.get(i)).getId() != ruleId) continue;
            this.ruleList.remove(i);
            break;
        }
        this.sortRules();
        FactoryUtility.postValue(this.ruleListObservable, this.ruleList);
    }

    protected void internalAddScene(Scene scene) {
        Scene sceneEx = (Scene)BaseNetworkEx.castUp(scene);
        super.internalAddScene(scene);
        if (null == this.sceneList) {
            return;
        }
        if (!this.sceneList.contains(sceneEx)) {
            this.sceneList.add(sceneEx);
            this.sortScenes();
        }
        FactoryUtility.postValue(this.sceneListObservable, this.sceneList);
    }

    protected void internalRemoveScene(int sceneId) {
        SceneEx scene = (SceneEx)this.getScene(sceneId);
        super.internalRemoveScene(sceneId);
        if (null != scene) {
            scene.onSceneRemoved();
        }
        if (null == this.sceneList) {
            return;
        }
        for (int i = 0; i < this.sceneList.size(); ++i) {
            if (((Scene)this.sceneList.get(i)).getId() != sceneId) continue;
            this.sceneList.remove(i);
            break;
        }
        FactoryUtility.postValue(this.sceneListObservable, this.sceneList);
    }

    protected void internalSetName(String name) {
        super.internalSetName(name);
        Log.d((String)TAG, (String)("internalSetName: newName: " + name + ", ID: " + this.getId()));
        FactoryUtility.postValue(this.networkNameObservable, name);
    }

    protected void internalSetState(Network.State state) {
        super.internalSetState(state);
        Log.d((String)TAG, (String)("internalSetState: state: " + state));
        FactoryUtility.postValue(this.stateObservable, state);
    }

    protected void internalRemoveNetwork() {
        super.internalRemoveNetwork();
        Log.d((String)TAG, (String)("internalRemoveNetwork: networkName: " + this.getName() + ", isRemoved: " + this.isRemoved));
        this.isRemoved = true;
        FactoryUtility.postValue(this.removeNetworkObservable, true);
    }

    protected void onSceneNameUpdated(Scene scene) {
        Log.d((String)TAG, (String)("onSceneNameUpdated: scene: " + scene));
        this.sortScenes();
        FactoryUtility.postValue(this.sceneListObservable, this.getSceneList());
    }

    protected void onRuleNameUpdated(Rule rule) {
        Log.d((String)TAG, (String)("onRuleNameUpdated: rule: " + rule));
        this.sortRules();
        FactoryUtility.postValue(this.ruleListObservable, this.getRuleList());
    }

    protected void onZoneNameUpdated(Zone zone) {
        Log.d((String)TAG, (String)("onZoneNameUpdated: zone: " + zone));
        this.sortZonesAndCorrectDefaultZoneValidity();
        FactoryUtility.postValue(this.zoneListObservable, this.getZoneList());
    }

    protected void onDeviceNameUpdated(Device device) {
        Log.d((String)TAG, (String)("onDeviceNameUpdated: device: " + device));
        this.sortDevices();
        FactoryUtility.postValue(this.deviceListObservable, this.deviceList);
    }

    protected void internalSetConnectivityState(ConnectivityStateManager.State connectivityState) {
        ConnectivityStateManager.State currentState = this.getConnectivityManagerState();
        super.internalSetConnectivityState(connectivityState);
        if (currentState == connectivityState) {
            return;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Device d = (Device)iterator.next();
            for (Resource r : d) {
                ResourceEx rex = (ResourceEx)r;
                rex.onStateChange();
            }
        }
        FactoryUtility.postValue(this.conStateObservable, connectivityState);
    }

    public Identifier getIdentifier() {
        return null != this.identifier ? this.identifier : (this.identifier = Identifier.getIdentifier(this));
    }

    public List<D> getDeviceList() {
        if (null == this.deviceList) {
            this.deviceList = Collections.synchronizedList(new ArrayList());
            for (Device device : this.getDeviceIterable()) {
                this.deviceList.add((Device)BaseNetworkEx.castUp(device));
            }
            this.sortDevices();
        }
        return this.deviceList;
    }

    public List<Z> getZoneList() {
        if (null == this.zoneList) {
            this.zoneList = Collections.synchronizedList(new ArrayList());
            for (Zone zone : this.getZoneIterable()) {
                this.zoneList.add((Zone)BaseNetworkEx.castUp(zone));
            }
            this.sortZonesAndCorrectDefaultZoneValidity();
        }
        return this.zoneList;
    }

    public List<R> getRuleList() {
        if (null == this.ruleList) {
            this.ruleList = Collections.synchronizedList(new ArrayList());
            for (Rule rule : this.getRuleIterable()) {
                this.ruleList.add((Rule)BaseNetworkEx.castUp(rule));
            }
            this.sortRules();
        }
        return this.ruleList;
    }

    public List<S> getSceneList() {
        if (null == this.sceneList) {
            this.sceneList = Collections.synchronizedList(new ArrayList());
            for (Scene scene : this.getSceneIterable()) {
                this.sceneList.add((Scene)BaseNetworkEx.castUp(scene));
            }
            this.sortScenes();
        }
        return this.sceneList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortZonesAndCorrectDefaultZoneValidity() {
        if (null == this.zoneList) {
            return;
        }
        List<Z> list = this.zoneList;
        synchronized (list) {
            Zone defaultZone = this.getZone(0);
            if (null != defaultZone) {
                boolean containsDefaultZone;
                boolean defaultHasResources = !defaultZone.getResources().isEmpty();
                boolean bl = containsDefaultZone = this.zoneList.lastIndexOf(defaultZone) >= 0;
                if (containsDefaultZone && !defaultHasResources) {
                    this.zoneList.remove(defaultZone);
                }
                if (!containsDefaultZone && defaultHasResources) {
                    this.zoneList.add(defaultZone);
                }
            } else {
                Log.w((String)TAG, (String)"sortZonesAndCorrectDefaultZoneValidity: default zone missing");
            }
            Collections.sort(this.zoneList, Utils.ZONE_COMPARATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortScenes() {
        if (null == this.sceneList) {
            return;
        }
        List<S> list = this.sceneList;
        synchronized (list) {
            Collections.sort(this.sceneList, Utils.SCENE_COMPARATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortRules() {
        if (null == this.ruleList) {
            return;
        }
        List<R> list = this.ruleList;
        synchronized (list) {
            Collections.sort(this.ruleList, Utils.RULE_COMPARATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortDevices() {
        if (null == this.deviceList) {
            return;
        }
        List<D> list = this.deviceList;
        synchronized (list) {
            Collections.sort(this.deviceList, Utils.DEVICE_COMPARATOR);
        }
    }

    public LiveData<List<D>> getDeviceListObservable() {
        return null != this.deviceListObservable ? this.deviceListObservable : (this.deviceListObservable = FactoryUtility.createLiveData(this.getDeviceList()));
    }

    public LiveData<List<Z>> getZoneListObservable() {
        return null != this.zoneListObservable ? this.zoneListObservable : (this.zoneListObservable = FactoryUtility.createLiveData(this.getZoneList()));
    }

    public LiveData<List<R>> getRuleListObservable() {
        return null != this.ruleListObservable ? this.ruleListObservable : (this.ruleListObservable = FactoryUtility.createLiveData(this.getRuleList()));
    }

    public LiveData<List<S>> getSceneListObservable() {
        return null != this.sceneListObservable ? this.sceneListObservable : (this.sceneListObservable = FactoryUtility.createLiveData(this.getSceneList()));
    }

    public LiveData<String> getNetworkNameObservable() {
        return null != this.networkNameObservable ? this.networkNameObservable : (this.networkNameObservable = FactoryUtility.createLiveData(this.getName()));
    }

    public LiveData<Network.State> getStateObservable() {
        return null != this.stateObservable ? this.stateObservable : (this.stateObservable = FactoryUtility.createLiveData(this.getState()));
    }

    public LiveData<Boolean> getRemoveNetworkObservable() {
        return null != this.removeNetworkObservable ? this.removeNetworkObservable : (this.removeNetworkObservable = FactoryUtility.createLiveData(this.isRemoved));
    }

    public LiveData<ConnectivityStateManager.State> getConnectivityManageStateObservable() {
        return null != this.conStateObservable ? this.conStateObservable : (this.conStateObservable = FactoryUtility.createLiveData(this.getConnectivityManagerState()));
    }

    private void trimMemory() {
        this.deviceListObservable = FactoryUtility.nullIfEmpty(this.deviceListObservable);
        this.zoneListObservable = FactoryUtility.nullIfEmpty(this.zoneListObservable);
        this.ruleListObservable = FactoryUtility.nullIfEmpty(this.ruleListObservable);
        this.sceneListObservable = FactoryUtility.nullIfEmpty(this.sceneListObservable);
        this.networkNameObservable = FactoryUtility.nullIfEmpty(this.networkNameObservable);
        this.removeNetworkObservable = FactoryUtility.nullIfEmpty(this.removeNetworkObservable);
        this.stateObservable = FactoryUtility.nullIfEmpty(this.stateObservable);
        this.conStateObservable = FactoryUtility.nullIfEmpty(this.conStateObservable);
    }

    @NonNull
    public String toString() {
        return "NetworkEx{isRemoved=" + this.isRemoved + ", super=" + super.toString() + '}';
    }
}

