/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.TimestampValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import tests.harness.cases.WktTimestamp;

public class WktTimestampValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(WktTimestamp.TimestampNone.class)) {
            return new TimestampNoneValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampRequired.class)) {
            return new TimestampRequiredValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampConst.class)) {
            return new TimestampConstValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampLT.class)) {
            return new TimestampLTValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampLTE.class)) {
            return new TimestampLTEValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampGT.class)) {
            return new TimestampGTValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampGTE.class)) {
            return new TimestampGTEValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampGTLT.class)) {
            return new TimestampGTLTValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampExLTGT.class)) {
            return new TimestampExLTGTValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampGTELTE.class)) {
            return new TimestampGTELTEValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampExGTELTE.class)) {
            return new TimestampExGTELTEValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampLTNow.class)) {
            return new TimestampLTNowValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampGTNow.class)) {
            return new TimestampGTNowValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampWithin.class)) {
            return new TimestampWithinValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampLTNowWithin.class)) {
            return new TimestampLTNowWithinValidator();
        }
        if (clazz.equals(WktTimestamp.TimestampGTNowWithin.class)) {
            return new TimestampGTNowWithinValidator();
        }
        return null;
    }

    public static class TimestampNoneValidator
    implements ValidatorImpl<WktTimestamp.TimestampNone> {
        public void assertValid(WktTimestamp.TimestampNone proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
            }
        }
    }

    public static class TimestampRequiredValidator
    implements ValidatorImpl<WktTimestamp.TimestampRequired> {
        public void assertValid(WktTimestamp.TimestampRequired proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                RequiredValidation.required((String)".tests.harness.cases.TimestampRequired.val", (Message)proto.getVal());
            } else {
                RequiredValidation.required((String)".tests.harness.cases.TimestampRequired.val", null);
            }
        }
    }

    public static class TimestampConstValidator
    implements ValidatorImpl<WktTimestamp.TimestampConst> {
        private final Timestamp VAL__CONST = TimestampValidation.toTimestamp((long)3L, (int)0);

        public void assertValid(WktTimestamp.TimestampConst proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ConstantValidation.constant((String)".tests.harness.cases.TimestampConst.val", (Object)proto.getVal(), (Object)this.VAL__CONST);
            }
        }
    }

    public static class TimestampLTValidator
    implements ValidatorImpl<WktTimestamp.TimestampLT> {
        private final Timestamp VAL__LT = TimestampValidation.toTimestamp((long)0L, (int)0);

        public void assertValid(WktTimestamp.TimestampLT proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.lessThan((String)".tests.harness.cases.TimestampLT.val", (Object)proto.getVal(), (Object)this.VAL__LT, (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampLTEValidator
    implements ValidatorImpl<WktTimestamp.TimestampLTE> {
        private final Timestamp VAL__LTE = TimestampValidation.toTimestamp((long)1L, (int)0);

        public void assertValid(WktTimestamp.TimestampLTE proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.lessThanOrEqual((String)".tests.harness.cases.TimestampLTE.val", (Object)proto.getVal(), (Object)this.VAL__LTE, (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampGTValidator
    implements ValidatorImpl<WktTimestamp.TimestampGT> {
        private final Timestamp VAL__GT = TimestampValidation.toTimestamp((long)0L, (int)1000);

        public void assertValid(WktTimestamp.TimestampGT proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.TimestampGT.val", (Object)proto.getVal(), (Object)this.VAL__GT, (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampGTEValidator
    implements ValidatorImpl<WktTimestamp.TimestampGTE> {
        private final Timestamp VAL__GTE = TimestampValidation.toTimestamp((long)0L, (int)1000000);

        public void assertValid(WktTimestamp.TimestampGTE proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThanOrEqual((String)".tests.harness.cases.TimestampGTE.val", (Object)proto.getVal(), (Object)this.VAL__GTE, (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampGTLTValidator
    implements ValidatorImpl<WktTimestamp.TimestampGTLT> {
        private final Timestamp VAL__LT = TimestampValidation.toTimestamp((long)1L, (int)0);
        private final Timestamp VAL__GT = TimestampValidation.toTimestamp((long)0L, (int)0);

        public void assertValid(WktTimestamp.TimestampGTLT proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.range((String)".tests.harness.cases.TimestampGTLT.val", (Object)proto.getVal(), (Object)this.VAL__LT, null, (Object)this.VAL__GT, null, (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampExLTGTValidator
    implements ValidatorImpl<WktTimestamp.TimestampExLTGT> {
        private final Timestamp VAL__LT = TimestampValidation.toTimestamp((long)0L, (int)0);
        private final Timestamp VAL__GT = TimestampValidation.toTimestamp((long)1L, (int)0);

        public void assertValid(WktTimestamp.TimestampExLTGT proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.range((String)".tests.harness.cases.TimestampExLTGT.val", (Object)proto.getVal(), (Object)this.VAL__LT, null, (Object)this.VAL__GT, null, (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampGTELTEValidator
    implements ValidatorImpl<WktTimestamp.TimestampGTELTE> {
        private final Timestamp VAL__LTE = TimestampValidation.toTimestamp((long)3600L, (int)0);
        private final Timestamp VAL__GTE = TimestampValidation.toTimestamp((long)60L, (int)0);

        public void assertValid(WktTimestamp.TimestampGTELTE proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.range((String)".tests.harness.cases.TimestampGTELTE.val", (Object)proto.getVal(), null, (Object)this.VAL__LTE, null, (Object)this.VAL__GTE, (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampExGTELTEValidator
    implements ValidatorImpl<WktTimestamp.TimestampExGTELTE> {
        private final Timestamp VAL__LTE = TimestampValidation.toTimestamp((long)60L, (int)0);
        private final Timestamp VAL__GTE = TimestampValidation.toTimestamp((long)3600L, (int)0);

        public void assertValid(WktTimestamp.TimestampExGTELTE proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.range((String)".tests.harness.cases.TimestampExGTELTE.val", (Object)proto.getVal(), null, (Object)this.VAL__LTE, null, (Object)this.VAL__GTE, (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampLTNowValidator
    implements ValidatorImpl<WktTimestamp.TimestampLTNow> {
        public void assertValid(WktTimestamp.TimestampLTNow proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.lessThan((String)".tests.harness.cases.TimestampLTNow.val", (Object)proto.getVal(), (Object)TimestampValidation.currentTimestamp(), (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampGTNowValidator
    implements ValidatorImpl<WktTimestamp.TimestampGTNow> {
        public void assertValid(WktTimestamp.TimestampGTNow proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.TimestampGTNow.val", (Object)proto.getVal(), (Object)TimestampValidation.currentTimestamp(), (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class TimestampWithinValidator
    implements ValidatorImpl<WktTimestamp.TimestampWithin> {
        private final Duration VAL__WITHIN = TimestampValidation.toDuration((long)3600L, (long)0L);

        public void assertValid(WktTimestamp.TimestampWithin proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                TimestampValidation.within((String)".tests.harness.cases.TimestampWithin.val", (Timestamp)proto.getVal(), (Duration)this.VAL__WITHIN, (Timestamp)TimestampValidation.currentTimestamp());
            }
        }
    }

    public static class TimestampLTNowWithinValidator
    implements ValidatorImpl<WktTimestamp.TimestampLTNowWithin> {
        private final Duration VAL__WITHIN = TimestampValidation.toDuration((long)3600L, (long)0L);

        public void assertValid(WktTimestamp.TimestampLTNowWithin proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.lessThan((String)".tests.harness.cases.TimestampLTNowWithin.val", (Object)proto.getVal(), (Object)TimestampValidation.currentTimestamp(), (Comparator)Timestamps.comparator());
            }
            if (proto.hasVal()) {
                TimestampValidation.within((String)".tests.harness.cases.TimestampLTNowWithin.val", (Timestamp)proto.getVal(), (Duration)this.VAL__WITHIN, (Timestamp)TimestampValidation.currentTimestamp());
            }
        }
    }

    public static class TimestampGTNowWithinValidator
    implements ValidatorImpl<WktTimestamp.TimestampGTNowWithin> {
        private final Duration VAL__WITHIN = TimestampValidation.toDuration((long)3600L, (long)0L);

        public void assertValid(WktTimestamp.TimestampGTNowWithin proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.TimestampGTNowWithin.val", (Object)proto.getVal(), (Object)TimestampValidation.currentTimestamp(), (Comparator)Timestamps.comparator());
            }
            if (proto.hasVal()) {
                TimestampValidation.within((String)".tests.harness.cases.TimestampGTNowWithin.val", (Timestamp)proto.getVal(), (Duration)this.VAL__WITHIN, (Timestamp)TimestampValidation.currentTimestamp());
            }
        }
    }
}

