/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import io.envoyproxy.pgv.CollectiveValidation;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.TimestampValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import tests.harness.cases.WktDuration;

public class WktDurationValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(WktDuration.DurationNone.class)) {
            return new DurationNoneValidator();
        }
        if (clazz.equals(WktDuration.DurationRequired.class)) {
            return new DurationRequiredValidator();
        }
        if (clazz.equals(WktDuration.DurationConst.class)) {
            return new DurationConstValidator();
        }
        if (clazz.equals(WktDuration.DurationIn.class)) {
            return new DurationInValidator();
        }
        if (clazz.equals(WktDuration.DurationNotIn.class)) {
            return new DurationNotInValidator();
        }
        if (clazz.equals(WktDuration.DurationLT.class)) {
            return new DurationLTValidator();
        }
        if (clazz.equals(WktDuration.DurationLTE.class)) {
            return new DurationLTEValidator();
        }
        if (clazz.equals(WktDuration.DurationGT.class)) {
            return new DurationGTValidator();
        }
        if (clazz.equals(WktDuration.DurationGTE.class)) {
            return new DurationGTEValidator();
        }
        if (clazz.equals(WktDuration.DurationGTLT.class)) {
            return new DurationGTLTValidator();
        }
        if (clazz.equals(WktDuration.DurationExLTGT.class)) {
            return new DurationExLTGTValidator();
        }
        if (clazz.equals(WktDuration.DurationGTELTE.class)) {
            return new DurationGTELTEValidator();
        }
        if (clazz.equals(WktDuration.DurationExGTELTE.class)) {
            return new DurationExGTELTEValidator();
        }
        if (clazz.equals(WktDuration.DurationFieldWithOtherFields.class)) {
            return new DurationFieldWithOtherFieldsValidator();
        }
        return null;
    }

    public static class DurationNoneValidator
    implements ValidatorImpl<WktDuration.DurationNone> {
        public void assertValid(WktDuration.DurationNone proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
            }
        }
    }

    public static class DurationRequiredValidator
    implements ValidatorImpl<WktDuration.DurationRequired> {
        public void assertValid(WktDuration.DurationRequired proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                RequiredValidation.required((String)".tests.harness.cases.DurationRequired.val", (Message)proto.getVal());
            } else {
                RequiredValidation.required((String)".tests.harness.cases.DurationRequired.val", null);
            }
        }
    }

    public static class DurationConstValidator
    implements ValidatorImpl<WktDuration.DurationConst> {
        private final Duration VAL__CONST = TimestampValidation.toDuration((long)3L, (long)0L);

        public void assertValid(WktDuration.DurationConst proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ConstantValidation.constant((String)".tests.harness.cases.DurationConst.val", (Object)proto.getVal(), (Object)this.VAL__CONST);
            }
        }
    }

    public static class DurationInValidator
    implements ValidatorImpl<WktDuration.DurationIn> {
        private final Duration[] VAL__IN = new Duration[]{TimestampValidation.toDuration((long)1L, (long)0L), TimestampValidation.toDuration((long)0L, (long)1000L)};

        public void assertValid(WktDuration.DurationIn proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                CollectiveValidation.in((String)".tests.harness.cases.DurationIn.val", (Object)proto.getVal(), (Object[])this.VAL__IN);
            }
        }
    }

    public static class DurationNotInValidator
    implements ValidatorImpl<WktDuration.DurationNotIn> {
        private final Duration[] VAL__NOT_IN = new Duration[]{TimestampValidation.toDuration((long)0L, (long)0L)};

        public void assertValid(WktDuration.DurationNotIn proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                CollectiveValidation.notIn((String)".tests.harness.cases.DurationNotIn.val", (Object)proto.getVal(), (Object[])this.VAL__NOT_IN);
            }
        }
    }

    public static class DurationLTValidator
    implements ValidatorImpl<WktDuration.DurationLT> {
        private final Duration VAL__LT = TimestampValidation.toDuration((long)0L, (long)0L);

        public void assertValid(WktDuration.DurationLT proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.lessThan((String)".tests.harness.cases.DurationLT.val", (Object)proto.getVal(), (Object)this.VAL__LT, (Comparator)Durations.comparator());
            }
        }
    }

    public static class DurationLTEValidator
    implements ValidatorImpl<WktDuration.DurationLTE> {
        private final Duration VAL__LTE = TimestampValidation.toDuration((long)1L, (long)0L);

        public void assertValid(WktDuration.DurationLTE proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.lessThanOrEqual((String)".tests.harness.cases.DurationLTE.val", (Object)proto.getVal(), (Object)this.VAL__LTE, (Comparator)Durations.comparator());
            }
        }
    }

    public static class DurationGTValidator
    implements ValidatorImpl<WktDuration.DurationGT> {
        private final Duration VAL__GT = TimestampValidation.toDuration((long)0L, (long)1000L);

        public void assertValid(WktDuration.DurationGT proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.DurationGT.val", (Object)proto.getVal(), (Object)this.VAL__GT, (Comparator)Durations.comparator());
            }
        }
    }

    public static class DurationGTEValidator
    implements ValidatorImpl<WktDuration.DurationGTE> {
        private final Duration VAL__GTE = TimestampValidation.toDuration((long)0L, (long)1000000L);

        public void assertValid(WktDuration.DurationGTE proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThanOrEqual((String)".tests.harness.cases.DurationGTE.val", (Object)proto.getVal(), (Object)this.VAL__GTE, (Comparator)Durations.comparator());
            }
        }
    }

    public static class DurationGTLTValidator
    implements ValidatorImpl<WktDuration.DurationGTLT> {
        private final Duration VAL__LT = TimestampValidation.toDuration((long)1L, (long)0L);
        private final Duration VAL__GT = TimestampValidation.toDuration((long)0L, (long)0L);

        public void assertValid(WktDuration.DurationGTLT proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.range((String)".tests.harness.cases.DurationGTLT.val", (Object)proto.getVal(), (Object)this.VAL__LT, null, (Object)this.VAL__GT, null, (Comparator)Durations.comparator());
            }
        }
    }

    public static class DurationExLTGTValidator
    implements ValidatorImpl<WktDuration.DurationExLTGT> {
        private final Duration VAL__LT = TimestampValidation.toDuration((long)0L, (long)0L);
        private final Duration VAL__GT = TimestampValidation.toDuration((long)1L, (long)0L);

        public void assertValid(WktDuration.DurationExLTGT proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.range((String)".tests.harness.cases.DurationExLTGT.val", (Object)proto.getVal(), (Object)this.VAL__LT, null, (Object)this.VAL__GT, null, (Comparator)Durations.comparator());
            }
        }
    }

    public static class DurationGTELTEValidator
    implements ValidatorImpl<WktDuration.DurationGTELTE> {
        private final Duration VAL__LTE = TimestampValidation.toDuration((long)3600L, (long)0L);
        private final Duration VAL__GTE = TimestampValidation.toDuration((long)60L, (long)0L);

        public void assertValid(WktDuration.DurationGTELTE proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.range((String)".tests.harness.cases.DurationGTELTE.val", (Object)proto.getVal(), null, (Object)this.VAL__LTE, null, (Object)this.VAL__GTE, (Comparator)Durations.comparator());
            }
        }
    }

    public static class DurationExGTELTEValidator
    implements ValidatorImpl<WktDuration.DurationExGTELTE> {
        private final Duration VAL__LTE = TimestampValidation.toDuration((long)60L, (long)0L);
        private final Duration VAL__GTE = TimestampValidation.toDuration((long)3600L, (long)0L);

        public void assertValid(WktDuration.DurationExGTELTE proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.range((String)".tests.harness.cases.DurationExGTELTE.val", (Object)proto.getVal(), null, (Object)this.VAL__LTE, null, (Object)this.VAL__GTE, (Comparator)Durations.comparator());
            }
        }
    }

    public static class DurationFieldWithOtherFieldsValidator
    implements ValidatorImpl<WktDuration.DurationFieldWithOtherFields> {
        private final Duration DURATION_VAL__LTE = TimestampValidation.toDuration((long)1L, (long)0L);
        private final Integer INT_VAL__GT = 16;

        public void assertValid(WktDuration.DurationFieldWithOtherFields proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasDurationVal()) {
                ComparativeValidation.lessThanOrEqual((String)".tests.harness.cases.DurationFieldWithOtherFields.duration_val", (Object)proto.getDurationVal(), (Object)this.DURATION_VAL__LTE, (Comparator)Durations.comparator());
            }
            ComparativeValidation.greaterThan((String)".tests.harness.cases.DurationFieldWithOtherFields.int_val", (Object)proto.getIntVal(), (Object)this.INT_VAL__GT, Comparator.naturalOrder());
        }
    }
}

