/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.constants.ActionOnDuplicate;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkTables;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.TestSuite;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestSuiteService
extends BaseService {
    public TestSuiteService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected TestSuite createTestSuite(Integer testProjectId, String name, String details, Integer parentId, Integer order, Boolean checkDuplicatedName, ActionOnDuplicate actionOnDuplicatedName) throws TestLinkAPIException {
        TestSuite testSuite = null;
        Integer id = 0;
        testSuite = new TestSuite(id, testProjectId, name, details, parentId, order, checkDuplicatedName, actionOnDuplicatedName);
        try {
            Map<String, Object> executionData = Util.getTestSuiteMap(testSuite);
            Object response = this.executeXmlRpcCall(TestLinkMethods.CREATE_TEST_SUITE.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            testSuite.setId(id);
            testSuite.setName(name);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error creating test suite: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuite;
    }

    protected TestSuite[] getTestSuiteByID(List<Integer> testSuiteIds) throws TestLinkAPIException {
        TestSuite[] testSuites = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_SUITE_ID.toString(), testSuiteIds);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_SUITE_BY_ID.toString(), executionData);
            if (response instanceof Object[]) {
                Object[] responseArray = Util.castToArray(response);
                testSuites = new TestSuite[responseArray.length];
                for (int i = 0; i < responseArray.length; ++i) {
                    Map responseMap = (Map)responseArray[i];
                    testSuites[i] = Util.getTestSuite(responseMap);
                }
            } else if (response instanceof Map) {
                testSuites = new TestSuite[1];
                Map responseMap = (Map)response;
                testSuites[0] = Util.getTestSuite(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test suites by id: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuites;
    }

    protected Attachment uploadTestSuiteAttachment(Integer testSuiteId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, testSuiteId, TestLinkTables.NODES_HIERARCHY.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getTestSuiteAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPLOAD_TEST_SUITE_ATTACHMENT.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for test suite: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected TestSuite[] getTestSuitesForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        TestSuite[] testSuites = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_SUITES_FOR_TEST_PLAN.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            testSuites = new TestSuite[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                Map responseMap = (Map)responseArray[i];
                testSuites[i] = Util.getTestSuite(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test suites by Test Plan ID: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuites;
    }

    protected TestSuite[] getTestSuitesForTestSuite(Integer testSuiteId) throws TestLinkAPIException {
        TestSuite[] testSuites = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_SUITE_ID.toString(), testSuiteId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_SUITES_FOR_TEST_SUITE.toString(), executionData);
            Map<String, Object> responseMap = Util.castToMap(response);
            Set<Map.Entry<String, Object>> entrySet = responseMap.entrySet();
            testSuites = new TestSuite[entrySet.size()];
            boolean singleElement = false;
            int index = 0;
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = entry.getKey();
                Object o = entry.getValue();
                if (o instanceof String) {
                    singleElement = true;
                    break;
                }
                Map testSuiteMap = (Map)entry.getValue();
                testSuiteMap.put(TestLinkResponseParams.ID.toString(), key);
                testSuites[index] = Util.getTestSuite(testSuiteMap);
                ++index;
            }
            if (singleElement) {
                testSuites = new TestSuite[]{Util.getTestSuite(responseMap)};
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test suites which are DIRECT children of a given TestSuite: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuites;
    }

    protected TestSuite[] getFirstLevelTestSuitesForTestProject(Integer testProjectId) throws TestLinkAPIException {
        TestSuite[] testSuites = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_FIRST_LEVEL_TEST_SUITES_FOR_TEST_PROJECT.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            testSuites = new TestSuite[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                Map responseMap = (Map)responseArray[i];
                testSuites[i] = Util.getTestSuite(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test suites AT TOP LEVEL of tree on a Test Project: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testSuites;
    }
}

