/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkTables;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Platform;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

class TestProjectService
extends BaseService {
    TestProjectService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected TestProject createTestProject(String testProjectName, String testProjectPrefix, String notes, Boolean enableRequirements, Boolean enableTestPriority, Boolean enableAutomation, Boolean enableInventory, Boolean isActive, Boolean isPublic) throws TestLinkAPIException {
        Integer id = 0;
        TestProject testProject = new TestProject(id, testProjectName, testProjectPrefix, notes, enableRequirements, enableTestPriority, enableAutomation, enableInventory, isActive, isPublic);
        try {
            Map<String, Object> executionData = Util.getTestProjectMap(testProject);
            Object response = this.executeXmlRpcCall(TestLinkMethods.CREATE_TEST_PROJECT.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            testProject.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error creating test project: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testProject;
    }

    protected TestProject getTestProjectByName(String projectName) throws TestLinkAPIException {
        TestProject testProject;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PROJECT_NAME.toString(), projectName);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_PROJECT_BY_NAME.toString(), executionData);
            Map<String, Object> responseMap = Util.castToMap(response);
            testProject = Util.getTestProject(responseMap);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test project: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testProject;
    }

    protected TestProject[] getProjects() throws TestLinkAPIException {
        TestProject[] projects;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_PROJECTS.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            projects = new TestProject[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                TestProject testProject;
                Map projectMap = (Map)responseArray[i];
                projects[i] = testProject = Util.getTestProject(projectMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test projects: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return projects;
    }

    protected TestPlan[] getProjectTestPlans(Integer projectId) throws TestLinkAPIException {
        TestPlan[] testPlans;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), projectId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_PROJECT_TEST_PLANS.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            testPlans = new TestPlan[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                TestPlan testPlan;
                Map planMap = (Map)responseArray[i];
                testPlans[i] = testPlan = Util.getTestPlan(planMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test plans: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testPlans;
    }

    protected Attachment uploadTestProjectAttachment(Integer testProjectId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Integer id = 0;
        Attachment attachment = new Attachment(id, testProjectId, TestLinkTables.NODES_HIERARCHY.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getTestProjectAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPLOAD_TEST_PROJECT_ATTACHMENT.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for test project: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected Platform[] getProjectPlatforms(Integer testProjectId) throws TestLinkAPIException {
        try {
            Platform[] platforms;
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_PROJECT_PLATFORMS.toString(), executionData);
            Map<String, Object> responseMap = Util.castToMap(response);
            if (responseMap.size() == 2 && responseMap.get("id") != null && responseMap.get("name") != null && responseMap.get("name") instanceof String) {
                Platform platform = Util.getPlatform(responseMap);
                platforms = new Platform[]{platform};
            } else {
                platforms = new Platform[responseMap.size()];
                Collection<Object> list = responseMap.values();
                int index = 0;
                for (Object o : list) {
                    Platform platform;
                    platforms[index] = platform = Util.getPlatform((Map)o);
                    ++index;
                }
            }
            return platforms;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error getting project platform: " + xmlrpcex.getMessage(), xmlrpcex);
        }
    }

    public static void main(String[] args) throws MalformedURLException {
        Platform[] platforms;
        XmlRpcClient xmlRpcClient = new XmlRpcClient();
        XmlRpcClientConfigImpl pConfig = new XmlRpcClientConfigImpl();
        pConfig.setServerURL(new URL("http://localhost:3300/testlink-1.9.6/lib/api/xmlrpc.php"));
        xmlRpcClient.setConfig((XmlRpcClientConfig)pConfig);
        TestProjectService service = new TestProjectService(xmlRpcClient, "09b83b6813a55ef6f7e2d7d63cb6f65c");
        for (Platform platform : platforms = service.getProjectPlatforms(2)) {
            System.out.println(platform);
        }
    }
}

